/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

public class NumberUtil {
    public static double DOUBLE_EPSILON = 1.0E-9;

    public static boolean doubleGreaterThanZero(double val) {
        return val > 0.0 && !NumberUtil.doubleEqualsZero(val);
    }

    public static boolean doubleLessThanZero(double val) {
        return val < 0.0 && !NumberUtil.doubleEqualsZero(val);
    }

    public static boolean doubleEqualsZero(double val) {
        return Math.abs(val) < DOUBLE_EPSILON;
    }

    public static boolean floatEqualsZero(float val) {
        return (double)Math.abs(val) < DOUBLE_EPSILON;
    }

    public static boolean floatEqualsFloat(float val1, float val2) {
        return (double)Math.abs(Math.abs(val1) - Math.abs(val2)) < DOUBLE_EPSILON;
    }

    public static boolean doubleEqualsDouble(double val1, double val2) {
        return Math.abs(Math.abs(val1) - Math.abs(val2)) < DOUBLE_EPSILON;
    }

    public static boolean doubleEqualsDouble(double val1, double val2, int precision) {
        return NumberUtil.doubleEqualsDouble(NumberUtil.roundDouble(val1, precision), NumberUtil.roundDouble(val2, precision));
    }

    public static boolean floatEqualsFloat(float val1, float val2, int precision) {
        return NumberUtil.floatEqualsFloat(NumberUtil.roundFloat(val1, precision), NumberUtil.roundFloat(val2, precision));
    }

    public static int roundDouble(double val) {
        return (int)Math.round(val);
    }

    public static double roundDouble(double val, int precision) {
        double factor = Math.pow(10.0, precision);
        return (double)Math.round(val * factor) / factor;
    }

    public static float roundFloat(float val, int precision) {
        float factor = (float)Math.pow(10.0, precision);
        return (float)Math.round(val * factor) / factor;
    }

    public static double nullToZero(Double val) {
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public static String doubleToString(double val) {
        if (NumberUtil.doubleEqualsZero(val - (double)Math.round(val))) {
            return String.valueOf((long)val);
        }
        return String.valueOf(val);
    }

    public static boolean isDoubleValid(Double value, int precision, int scale) {
        return value == null || !(value >= Math.pow(10.0, precision - scale));
    }
}

