/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.MeteoImageMesh;
import main.java.guru.vfrflight.core.transform.ImageToMapTransform;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;

public class MeteoUtil {
    private static final Logger log = Logger.getLogger(MeteoUtil.class);

    public static MeteoImageMesh[] createImageArray(JXMapViewer map, String imagePath) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(imagePath));
        }
        catch (IOException e) {
            log.error(e);
            return null;
        }
        log.info("Loaded image: " + img.getWidth() + "x" + img.getHeight());
        GpsPlace place1 = new GpsPlace(53.80726096965735, 14.337661606987275);
        GpsPlace place2 = new GpsPlace(49.00402426608697, 22.871828419884004);
        ImageToMapTransform transform = new ImageToMapTransform(place1, 169, 431, place2, 345, 592);
        MeteoImageMesh[] result = new MeteoImageMesh[img.getWidth() * img.getHeight()];
        int i = 0;
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                result[i] = new MeteoImageMesh(transform.getCellArea(x, y), MeteoUtil.getColor(img.getRGB(x, y)));
                ++i;
            }
        }
        log.info("Done.");
        return result;
    }

    private static Color getColor(int color) {
        float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        return new Color(red, green, blue, alpha / 2.0f);
    }
}

