/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectTraffic;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.MouseCursorInfo;
import main.java.guru.vfrflight.core.comparator.AirspaceAreaAltitudeComparator;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.AirportTaxiDTO;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.dto.IfrRouteDTO;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.dto.ObstacleDTO;
import main.java.guru.vfrflight.core.dto.RadialFromVorDTO;
import main.java.guru.vfrflight.core.dto.RunwayExtensionDTO;
import main.java.guru.vfrflight.core.dto.TaxiwayPathDTO;
import main.java.guru.vfrflight.core.dto.UserPointDTO;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.pdf.util.PdfUtil;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.weather.core.Station;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class MapUtil {
    public static GpsPoint getMapPosition(JXMapViewer map, GpsPlace place) {
        return MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(place.geoPosition(), map.getZoom()));
    }

    public static GpsPoint getMapPosition(JXMapViewer map, Point2D point) {
        return MapUtil.getMapPosition(map, point.getX(), point.getY());
    }

    public static GpsPoint getMapPosition(JXMapViewer map, double x, double y) {
        Point2D center = map.getTileFactory().geoToPixel(map.getCenterPosition(), map.getZoom());
        double dx = x - center.getX();
        double dy = y - center.getY();
        return new GpsPoint(map.getBounds().getCenterX() + dx, map.getBounds().getCenterY() + dy);
    }

    public static Point2D getPointPostionFromGpsPlace(JXMapViewer map, GpsPlace place) {
        Point2D e = map.getTileFactory().geoToPixel(place.geoPosition(), map.getZoom());
        Point2D center = map.getTileFactory().geoToPixel(map.getCenterPosition(), map.getZoom());
        int dx = (int)e.getX() - (int)center.getX();
        int dy = (int)e.getY() - (int)center.getY();
        return new GpsPoint(dx + (int)map.getBounds().getCenterX(), dy + (int)map.getBounds().getCenterY());
    }

    public static GpsPlace getPointOnSegment(JXMapViewer map, LineSegment segment, double distance) {
        if (segment != null && segment.getCourse() != null) {
            double distanceRatio = distance / segment.getDistance();
            Point2D from = map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom());
            Point2D to = map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom());
            GpsPoint delta = GpsUtil.getVectorCoords(from.distance(to) * distanceRatio, segment.getCourse());
            double cx = from.getX() + delta.getX();
            double cy = from.getY() + delta.getY();
            GpsPoint closestPoint = GpsUtil.getPointOnSegment(from, to, new GpsPoint(cx, cy), false);
            return map.getTileFactory().pixelToGeo(closestPoint, map.getZoom()).gpsPlace();
        }
        return null;
    }

    public static double calculateRadiusToPixels(JXMapViewer map, GpsPlace center, double radiusNm) {
        Point2D pointToTopLeft = map.getTileFactory().geoToPixel(GpsUtil.getPointPositionByDistanceAndBearing(center, 315.0, radiusNm).geoPosition(), map.getZoom());
        Point2D pointToBottomRight = map.getTileFactory().geoToPixel(GpsUtil.getPointPositionByDistanceAndBearing(center, 135.0, radiusNm).geoPosition(), map.getZoom());
        return pointToTopLeft.distance(pointToBottomRight) / 2.0;
    }

    public static Map<Integer, Dimension> calculateRegionDimensionsToPixels(JXMapViewer map, GpsArea region) {
        HashMap<Integer, Dimension> result = new HashMap<Integer, Dimension>();
        TileFactoryInfo info = map.getTileFactory().getInfo();
        for (int zoom = info.getMinimumZoomLevel(); zoom < info.getMaximumZoomLevel(); ++zoom) {
            result.put(zoom, MapUtil.calculateRegionDimensionsToPixels(map, region, zoom));
        }
        return result;
    }

    public static Dimension calculateRegionDimensionsToPixels(JXMapViewer map, GpsArea region, int zoom) {
        Point2D topLeftPt = map.getTileFactory().geoToPixel(region.getTopLeft().geoPosition(), zoom);
        Point2D bottomRightPt = map.getTileFactory().geoToPixel(region.getBottomRight().geoPosition(), zoom);
        int width = (int)Math.round(bottomRightPt.getX() - topLeftPt.getX());
        int height = (int)Math.round(bottomRightPt.getY() - topLeftPt.getY());
        return new Dimension(width, height);
    }

    public static boolean isPlaceOnSegment(JXMapViewer map, GpsPlace place, LineSegment segment) {
        GpsPoint point = new GpsPoint(map.getTileFactory().geoToPixel(place.geoPosition(), map.getZoom()));
        Double diff = MapUtil.getDiffPointOnSegment(map, point, segment);
        return diff != null && diff <= 10.0;
    }

    public static Integer getSegmentIndexWithPoint(JXMapViewer map, GpsPoint point, List<LineSegment> segments) {
        Integer index = null;
        double smallestDiff = Double.MAX_VALUE;
        for (int i = 0; i < segments.size(); ++i) {
            LineSegment segment = segments.get(i);
            Double diff = MapUtil.getDiffPointOnSegment(map, point, segment);
            if (diff == null || !(diff <= 10.0) || !(diff < smallestDiff)) continue;
            index = i;
            smallestDiff = diff;
        }
        return index;
    }

    public static Double getDistanceInNmFromSegment(JXMapViewer map, GpsPlace place, LineSegment segment) {
        GpsPlace placeOnSegment = GpsUtil.getGpsPlaceOnSegment(map, segment, place);
        return GpsUtil.getDistance(place, placeOnSegment);
    }

    public static Double getDiffPointOnSegment(JXMapViewer map, GpsPoint point, LineSegment segment) {
        return MapUtil.getDiffPointOnSegment(map, point, segment, true);
    }

    public static Double getDiffPointOnSegment(JXMapViewer map, GpsPoint point, LineSegment segment, boolean checkIfBetween) {
        Point2D wp1 = map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom());
        Point2D wp2 = map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom());
        if (!checkIfBetween || point.isBetween(wp1, wp2, 3.0)) {
            double x = wp1.getX();
            double y = wp1.getY();
            double ax = wp2.getX();
            double ay = wp2.getY();
            double diff = 0.0;
            if (ax != x) {
                double a = (ay - y) / (ax - x);
                double b = y - a * x;
                diff = a < 10.0 ? Math.abs(point.getY() - (a * point.getX() + b)) : Math.abs((ax + x) / 2.0 - point.getX());
            } else {
                diff = Math.abs(point.getX() - x);
            }
            return diff;
        }
        return null;
    }

    public static int calculateFontSize(double sizeModificator) {
        return (int)Math.round((sizeModificator - 1.0) * 10.0);
    }

    public static double calculateZoomRatio(Dimension regionSize) {
        double heightRatio;
        double widthRatio = regionSize.getWidth() / 1080.0;
        double ratio = Math.max(widthRatio, heightRatio = regionSize.getHeight() / 768.0) / 1.25;
        return ratio > 1.0 ? ratio : 1.0;
    }

    public static GpsPoint getPixelPositionOnMap(JXMapViewer map, double x, double y) {
        double dx = x - map.getBounds().getCenterX();
        double dy = y - map.getBounds().getCenterY();
        Point2D center = map.getCenter();
        return new GpsPoint(center.getX() + dx, center.getY() + dy);
    }

    public static Point2D getPointOnLine(Point2D point, Point2D prevVertexPoint, Point2D nextVertexPoint) {
        Double[] eff = VfrUtil.getLinearEquation(prevVertexPoint, nextVertexPoint);
        if (eff != null) {
            GpsPoint middleVertexPoint = new GpsPoint((prevVertexPoint.getX() + nextVertexPoint.getX()) / 2.0, (prevVertexPoint.getY() + nextVertexPoint.getY()) / 2.0);
            Double[] effPerp = VfrUtil.getPerpendicularLine(middleVertexPoint, eff[0], eff[1]);
            return GpsUtil.getPointOnLine(point, effPerp[0], effPerp[1]);
        }
        return null;
    }

    public static boolean isSegmentInsideArea(JXMapViewer map, LineSegment segment, GpsArea area) {
        return segment.getFrom().isInside(area) || segment.getTo().isInside(area) || MapUtil.isSegmentIntersectsArea(map, segment, area);
    }

    public static boolean isAirspaceInsideArea(JXMapViewer map, AirspaceArea airspaceArea, GpsArea area) {
        if (!airspaceArea.isInside(area)) {
            return false;
        }
        if (airspaceArea.isPoly()) {
            for (AirspaceAreaVertex v : airspaceArea.getVertices()) {
                if (!v.isVertex() || !v.isInside(area)) continue;
                return true;
            }
        }
        LineSegment[] segments = new LineSegment[]{new LineSegment(area.getTopLeft(), area.getTopRight()), new LineSegment(area.getTopRight(), area.getBottomRight()), new LineSegment(area.getBottomRight(), area.getBottomLeft()), new LineSegment(area.getBottomLeft(), area.getTopLeft())};
        for (LineSegment s : segments) {
            if (!MapUtil.isSegmentInsideArea(map, s, area)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSegmentIntersectsArea(JXMapViewer map, LineSegment segment, GpsArea area) {
        if (!segment.isInside(area)) {
            return false;
        }
        GpsPlace[] vertices = new GpsPlace[]{area.getTopLeft(), area.getTopRight(), area.getBottomRight(), area.getBottomLeft()};
        for (int i = 0; i < vertices.length; ++i) {
            int prevIdx = i > 0 ? i - 1 : vertices.length - 1;
            LineSegment seg = new LineSegment(vertices[prevIdx], vertices[i]);
            if (!MapUtil.intersectsLineSegments(map, segment, seg)) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllSegmentsIsInsideAirspaceArea(JXMapViewer map, List<LineSegment> segments, AirspaceAreaDTO area) {
        for (LineSegment segment : segments) {
            if (MapUtil.isSegmentIsInsideAirspaceArea(map, segment, area)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSegmentIsInsideAirspaceArea(JXMapViewer map, LineSegment segment, AirspaceAreaDTO area) {
        if (!segment.isInside(area.getRectangleOver())) {
            return false;
        }
        MapShapeVertex[] vertices = null;
        vertices = area.isCircle() ? AirspacesUtil.convertCircleAirspaceToPolygon(area, 1) : (area.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(map, area.getVertices(), 1) : area.getVertices());
        if (vertices != null && vertices.length > 1) {
            Polygon polygon = new Polygon();
            for (int q = 0; q < vertices.length; ++q) {
                Point2D pt = map.getTileFactory().geoToPixel(vertices[q].getGpsPlace().geoPosition(), map.getZoom());
                polygon.addPoint((int)Math.round(pt.getX()), (int)Math.round(pt.getY()));
            }
            Point2D segFrom = map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom());
            Point2D segTo = map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom());
            if (polygon.contains(segFrom) || polygon.contains(segTo)) {
                return true;
            }
            List<GpsPlace> points = MapUtil.getIntersectionPoints(map, segment, area);
            if (points.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public static List<GpsPlace> getIntersectionPoints(JXMapViewer map, LineSegment segment, AirspaceAreaDTO area) {
        ArrayList<GpsPlace> result = new ArrayList<GpsPlace>();
        if (!segment.isInside(area.getRectangleOver())) {
            return result;
        }
        MapShapeVertex[] vertices = null;
        vertices = area.isCircle() ? AirspacesUtil.convertCircleAirspaceToPolygon(area, 1) : (area.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(map, area.getVertices(), 1) : area.getVertices());
        if (vertices != null && vertices.length > 1) {
            for (int i = 0; i < vertices.length; ++i) {
                int prevIdx = i > 0 ? i - 1 : vertices.length - 1;
                LineSegment seg = new LineSegment(vertices[prevIdx].getGpsPlace(), vertices[i].getGpsPlace());
                GpsPlace intersectionPlace = MapUtil.getLineSegmentsIntersection(map, segment, seg);
                if (intersectionPlace == null) continue;
                result.add(intersectionPlace);
            }
        }
        return result;
    }

    public static boolean getLineSegmentAndAirspaceAreaIntersections(JXMapViewer map, LineSegment segment, AirspaceAreaDTO area) {
        if (!segment.isInside(area.getRectangleOver())) {
            return false;
        }
        MapShapeVertex[] vertices = null;
        vertices = area.isCircle() ? AirspacesUtil.convertCircleAirspaceToPolygon(area, 1) : (area.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(map, area.getVertices(), 1) : area.getVertices());
        if (vertices != null && vertices.length > 1) {
            ArrayList<LineSegment> intersectsSegments = new ArrayList<LineSegment>(vertices.length - 1);
            for (int i = 1; i < vertices.length; ++i) {
                LineSegment seg = new LineSegment(vertices[i - 1].getGpsPlace(), vertices[i].getGpsPlace());
                if (!MapUtil.intersectsLineSegments(map, segment, seg)) continue;
                intersectsSegments.add(seg);
            }
            if (intersectsSegments.size() == 0) {
                Polygon polygon = new Polygon();
                for (int i = 0; i < vertices.length; ++i) {
                    Point2D pt = map.getTileFactory().geoToPixel(vertices[i].getGpsPlace().geoPosition(), map.getZoom());
                    polygon.addPoint((int)Math.round(pt.getX()), (int)Math.round(pt.getY()));
                }
                Point2D segFrom = map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom());
                Point2D segTo = map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom());
                if (!polygon.contains(segFrom) && !polygon.contains(segTo)) {
                    return false;
                }
            }
            if (area.isUnlimited()) {
                return true;
            }
            if (area.getBottomAltitude() != null) {
                for (LineSegment seg : intersectsSegments) {
                    if (!MapUtil.intersectsLineSegmentAndAltitude(map, segment, seg, area.getBottomAltitude())) continue;
                    return true;
                }
            }
            if (area.getTopAltitude() != null) {
                for (LineSegment seg : intersectsSegments) {
                    if (!MapUtil.intersectsLineSegmentAndAltitude(map, segment, seg, area.getTopAltitude())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean intersectsLineSegmentAndAltitude(JXMapViewer map, LineSegment segment, LineSegment areaSegment, int areaAltitude) {
        if (segment.getFrom().getAlt() != null && segment.getTo().getAlt() != null) {
            Point2D segFrom = map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom());
            Point2D segTo = map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom());
            Point2D areaSegFrom = map.getTileFactory().geoToPixel(areaSegment.getFrom().geoPosition(), map.getZoom());
            Point2D areaSegTo = map.getTileFactory().geoToPixel(areaSegment.getTo().geoPosition(), map.getZoom());
            GpsPoint lineFrom1 = new GpsPoint(segFrom.getX(), segment.getFrom().getAlt());
            GpsPoint lineTo1 = new GpsPoint(segTo.getX(), segment.getTo().getAlt());
            GpsPoint lineFrom2 = new GpsPoint(areaSegFrom.getX(), areaAltitude);
            GpsPoint lineTo2 = new GpsPoint(areaSegTo.getX(), areaAltitude);
            Line2D.Double line1 = new Line2D.Double();
            line1.setLine(((Point2D)lineFrom1).getX(), ((Point2D)lineFrom1).getY(), ((Point2D)lineTo1).getX(), ((Point2D)lineTo1).getY());
            Line2D.Double line2 = new Line2D.Double();
            line2.setLine(((Point2D)lineFrom2).getX(), ((Point2D)lineFrom2).getY(), ((Point2D)lineTo2).getX(), ((Point2D)lineTo2).getY());
            if (line1.intersectsLine(line2)) {
                Point2D latIntersection = MapUtil.getIntersection(line1, line2);
                double min = Math.min(areaSegFrom.getX(), areaSegTo.getX());
                double max = Math.max(areaSegFrom.getX(), areaSegTo.getX());
                if (latIntersection.getX() >= min && latIntersection.getX() <= max) {
                    lineFrom1 = new GpsPoint(segment.getFrom().getAlt(), segFrom.getY());
                    lineTo1 = new GpsPoint(segment.getTo().getAlt(), segTo.getY());
                    lineFrom2 = new GpsPoint(areaAltitude, areaSegFrom.getY());
                    lineTo2 = new GpsPoint(areaAltitude, areaSegTo.getY());
                    line1 = new Line2D.Double();
                    line1.setLine(((Point2D)lineFrom1).getX(), ((Point2D)lineFrom1).getY(), ((Point2D)lineTo1).getX(), ((Point2D)lineTo1).getY());
                    line2 = new Line2D.Double();
                    line2.setLine(((Point2D)lineFrom2).getX(), ((Point2D)lineFrom2).getY(), ((Point2D)lineTo2).getX(), ((Point2D)lineTo2).getY());
                    if (line1.intersectsLine(line2)) {
                        Point2D lonIntersection = MapUtil.getIntersection(line1, line2);
                        min = Math.min(areaSegFrom.getY(), areaSegTo.getY());
                        max = Math.max(areaSegFrom.getY(), areaSegTo.getY());
                        if (lonIntersection.getY() >= min && lonIntersection.getY() <= max) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean intersectsLineSegments(JXMapViewer map, LineSegment segment1, LineSegment segment2) {
        Point2D from1 = map.getTileFactory().geoToPixel(segment1.getFrom().geoPosition(), map.getZoom());
        Point2D to1 = map.getTileFactory().geoToPixel(segment1.getTo().geoPosition(), map.getZoom());
        Point2D from2 = map.getTileFactory().geoToPixel(segment2.getFrom().geoPosition(), map.getZoom());
        Point2D to2 = map.getTileFactory().geoToPixel(segment2.getTo().geoPosition(), map.getZoom());
        Line2D.Double line1 = new Line2D.Double();
        line1.setLine(from1.getX(), from1.getY(), to1.getX(), to1.getY());
        Line2D.Double line2 = new Line2D.Double();
        line2.setLine(from2.getX(), from2.getY(), to2.getX(), to2.getY());
        return line1.intersectsLine(line2);
    }

    public static GpsPlace getLineSegmentsIntersection(JXMapViewer map, LineSegment segment1, LineSegment segment2) {
        Point2D from1 = map.getTileFactory().geoToPixel(segment1.getFrom().geoPosition(), map.getZoom());
        Point2D to1 = map.getTileFactory().geoToPixel(segment1.getTo().geoPosition(), map.getZoom());
        Point2D from2 = map.getTileFactory().geoToPixel(segment2.getFrom().geoPosition(), map.getZoom());
        Point2D to2 = map.getTileFactory().geoToPixel(segment2.getTo().geoPosition(), map.getZoom());
        Line2D.Double line1 = new Line2D.Double();
        line1.setLine(from1.getX(), from1.getY(), to1.getX(), to1.getY());
        Line2D.Double line2 = new Line2D.Double();
        line2.setLine(from2.getX(), from2.getY(), to2.getX(), to2.getY());
        if (line1.intersectsLine(line2)) {
            return map.getTileFactory().pixelToGeo(MapUtil.getIntersection(line1, line2), map.getZoom()).gpsPlace();
        }
        return null;
    }

    private static Point2D getIntersection(Line2D.Double line1, Line2D.Double line2) {
        double x1 = line1.x1;
        double y1 = line1.y1;
        double x2 = line1.x2;
        double y2 = line1.y2;
        double x3 = line2.x1;
        double y3 = line2.y1;
        double x4 = line2.x2;
        double y4 = line2.y2;
        double x = ((x2 - x1) * (x3 * y4 - x4 * y3) - (x4 - x3) * (x1 * y2 - x2 * y1)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        double y = ((y3 - y4) * (x1 * y2 - x2 * y1) - (y1 - y2) * (x3 * y4 - x4 * y3)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        return new Point2D.Double(x, y);
    }

    public static Rectangle transformToPixel(JXMapViewer map, GpsArea area) {
        Point2D topLeft = map.getTileFactory().geoToPixel(area.getTopLeft().geoPosition(), map.getZoom());
        Point2D bottomRight = map.getTileFactory().geoToPixel(area.getBottomRight().geoPosition(), map.getZoom());
        return new Rectangle((int)topLeft.getX(), (int)topLeft.getY(), (int)(bottomRight.getX() - topLeft.getX()), (int)(bottomRight.getY() - topLeft.getY()));
    }

    /*
     * WARNING - void declaration
     */
    public static void updateTextUnderCursor(VfrMapViewer map, int mouseX, int mouseY) {
        GpsPlace pos;
        TerrainMesh elevationAtMouse;
        MapObjectsBean.getInstance().getTextUnderCursor().clear();
        if (MapObjectsBean.getInstance().getTerrainMesh() != null && (elevationAtMouse = MapUtil.getElevationAt(pos = map.getGeoPositionAtPos(mouseX, mouseY).gpsPlace())) != null) {
            MapObjectsBean.getInstance().getTextUnderCursor().add(new MouseCursorInfo(elevationAtMouse.getRectangleOver().getCenter().geoPosition(), null, MapObjectType.ELEVATION, elevationAtMouse.getValue() + UnitUtil.getAltitudeUnit(), Color.WHITE, elevationAtMouse.getColor()));
        }
        if (SettingsBean.getInstance().isDrawMapObjectsListUnderCursor()) {
            String txt;
            ArrayList<MouseCursorInfo> info = new ArrayList<MouseCursorInfo>();
            int delta = (int)Math.round(Math.sqrt(map.getZoom()) * 7.0);
            GpsPlace topLeft = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX - delta, mouseY - delta), map.getZoom()).gpsPlace();
            GpsPlace bottomRight = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX + delta, mouseY + delta), map.getZoom()).gpsPlace();
            GpsArea mouseArea = new GpsArea(topLeft, bottomRight);
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawUserTrack() && !SettingsBean.getInstance().isConnectedToSimAndHasData() && SimConnectUtil.getInstance().getUserTrack().size() > 0) {
                topLeft = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX - delta * 3, mouseY - delta * 3), map.getZoom()).gpsPlace();
                bottomRight = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX + delta * 3, mouseY + delta * 3), map.getZoom()).gpsPlace();
                GpsArea userTrackMouseArea = new GpsArea(topLeft, bottomRight);
                GpsPlace gpsPlace = map.getGeoPositionAtPos(mouseX, mouseY).gpsPlace();
                LinkedList<ExtConnectBean> pointsList = new LinkedList<ExtConnectBean>();
                int i = 0;
                int idx = -1;
                double minDist = 1000000.0;
                int q = 0;
                int selectedIndex = 0;
                for (ExtConnectBean bean : SimConnectUtil.getInstance().getUserTrack()) {
                    if (bean.isInside(userTrackMouseArea)) {
                        double dist = GpsUtil.getDistance(gpsPlace, new GpsPlace(bean.getUserLat().floatValue(), bean.getUserLon().floatValue()));
                        if (dist < minDist) {
                            idx = i;
                            selectedIndex = q;
                            minDist = dist;
                        }
                        pointsList.add(bean);
                        ++i;
                    }
                    ++q;
                }
                if (idx > 0) {
                    info.add(new MouseCursorInfo(SimConnectUtil.getInstance().getUserTrack().get(selectedIndex).getGpsPlace().geoPosition(), null, MapObjectType.USER_PLANE_POS, SimConnectUtil.getBeanInfo((ExtConnectBean)pointsList.get(idx)), Color.BLACK));
                    SimConnectUtil.getInstance().setSelectedUserTrackPoint(selectedIndex);
                } else {
                    SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().getSimConnectConfigBean().isTraceTraffic() && SimConnectUtil.getInstance().getTraffic().size() > 0) {
                ArrayList<SimConnectTraffic> trafficList = new ArrayList<SimConnectTraffic>(SimConnectUtil.getInstance().getTraffic());
                Iterator iterator = trafficList.iterator();
                while (iterator.hasNext()) {
                    SimConnectTraffic traffic = (SimConnectTraffic)iterator.next();
                    if (!traffic.isInside(mouseArea)) continue;
                    info.add(new MouseCursorInfo(traffic.getPos(), null, MapObjectType.AI_TRAFFIC, traffic.getInfo(), SettingsBean.getInstance().getColorTheme().getAiTrafficColor(), SettingsBean.getInstance().getColorTheme().getAiTrafficStrokeColor()));
                }
            }
            if (SettingsBean.getInstance().isDrawAllAirports()) {
                for (AirportDTO airportDTO : MapObjectsBean.getInstance().getAirports(mouseArea)) {
                    if (!MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(airportDTO) || !airportDTO.isInside(mouseArea)) continue;
                    info.add(new MouseCursorInfo(airportDTO.getGpsPlace().geoPosition(), null, MapObjectType.AIRPORT, airportDTO.getInfo(), SettingsBean.getInstance().getColorTheme().getAirportColorOnMap(airportDTO.isHardened())));
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllUserPoints()) {
                for (UserPointDTO userPointDTO : MapObjectsBean.getInstance().getUserPoints(mouseArea)) {
                    if (!userPointDTO.isInside(mouseArea) || !MapObjectsBean.getInstance().getUserPointsFilter().checkDisplayUserPoint(userPointDTO)) continue;
                    txt = StringUtil.nullToEmpty(userPointDTO.getName());
                    if (txt.length() > 0 && !StringUtil.isEmpty(userPointDTO.getTags())) {
                        txt = txt + " - " + userPointDTO.getParsedTags();
                    }
                    info.add(new MouseCursorInfo(userPointDTO.getPosition(), null, MapObjectType.USER_POINT, txt, Color.BLACK));
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllIls() && MapObjectsBean.getInstance().getIls() != null) {
                for (IlsDTO ils : MapObjectsBean.getInstance().getIls()) {
                    if (!ils.getBoundary().isInside(mouseArea) && !mouseArea.isInside(ils.getBoundary()) || ils.getAirport() != null && !MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(ils.getAirport())) continue;
                    info.add(new MouseCursorInfo(ils.getPosition(), null, MapObjectType.ILS, ils.getAirportCode() + " " + ils.getInfo(), Color.BLACK, SettingsBean.getInstance().getColorTheme().getIlsColorOnMap()));
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawRunwayExtensions() && MapObjectsBean.getInstance().getRunwayExtensions() != null) {
                block5: for (RunwayExtensionDTO ext : MapObjectsBean.getInstance().getRunwayExtensions()) {
                    if (!ext.isInside(mouseArea)) continue;
                    List<LineSegment> segments = ext.getSegments();
                    for (LineSegment s : segments) {
                        if (!s.isInside(mouseArea)) continue;
                        info.add(new MouseCursorInfo(s.getCenter().geoPosition(), null, MapObjectType.RUNWAY_EXTENSION, ext.getName(), Color.BLACK, null));
                        continue block5;
                    }
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllVors()) {
                for (NavaidDTO navaidDTO : MapObjectsBean.getInstance().getVors(mouseArea)) {
                    if (!navaidDTO.isInside(mouseArea)) continue;
                    txt = navaidDTO.getType() + " " + navaidDTO.getInfo();
                    if (navaidDTO.getRemark() != null) {
                        txt = txt + " ***" + navaidDTO.getRemark() + "***";
                    }
                    info.add(new MouseCursorInfo(navaidDTO.getPosition(), null, MapObjectType.VORDME, txt, SettingsBean.getInstance().getColorTheme().getVorColorOnMap()));
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllNdbs()) {
                for (NavaidDTO navaidDTO : MapObjectsBean.getInstance().getNdbs(mouseArea)) {
                    if (!navaidDTO.isInside(mouseArea)) continue;
                    txt = "NDB " + navaidDTO.getInfo();
                    if (navaidDTO.getRemark() != null) {
                        txt = txt + " ***" + navaidDTO.getRemark() + "***";
                    }
                    info.add(new MouseCursorInfo(navaidDTO.getPosition(), null, MapObjectType.NDB, txt, SettingsBean.getInstance().getColorTheme().getNdbColorOnMap()));
                }
            }
            if (SettingsBean.getInstance().isDrawVfrPoints() && map.getZoom() <= 10) {
                for (VfrPointDTO vfrPointDTO : MapObjectsBean.getInstance().getVfrPoints(mouseArea)) {
                    if (!vfrPointDTO.isInside(mouseArea)) continue;
                    txt = vfrPointDTO.getName();
                    if (vfrPointDTO.getRemark() != null) {
                        txt = txt + " ***" + vfrPointDTO.getRemark() + "***";
                    }
                    info.add(new MouseCursorInfo(vfrPointDTO.getPosition(), null, MapObjectType.VFR_POINT, txt, SettingsBean.getInstance().getColorTheme().getAirspacePointColor()));
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllIfrPoints()) {
                for (NamedWaypoint namedWaypoint : MapObjectsBean.getInstance().getIfrPoints(mouseArea)) {
                    if (!namedWaypoint.isInside(mouseArea)) continue;
                    info.add(new MouseCursorInfo(namedWaypoint.getPosition(), null, MapObjectType.IFR_POINT, namedWaypoint.getName(), SettingsBean.getInstance().getColorTheme().getIfrPointColor()));
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllIfrRoutes() && MapObjectsBean.getInstance().getIfrRoutes() != null) {
                for (IfrRouteDTO r : MapObjectsBean.getInstance().getIfrRoutes()) {
                    if (!r.isInside(mouseArea)) continue;
                    String txt2 = r.getName();
                    if (r.getRemark() != null) {
                        txt2 = txt2 + " ***" + r.getRemark() + "***";
                    }
                    info.add(new MouseCursorInfo(r.getRectangleOver().getCenter().geoPosition(), null, MapObjectType.IFR_ROUTE, txt2, SettingsBean.getInstance().getColorTheme().getIfrRouteColor()));
                }
            }
            if (SettingsBean.getInstance().isDrawCities() && map.getZoom() <= 10) {
                for (CityDTO cityDTO : MapObjectsBean.getInstance().getCities(mouseArea)) {
                    if (!cityDTO.isInside(mouseArea)) continue;
                    txt = cityDTO.getName();
                    if (cityDTO.getAltName() != null) {
                        txt = txt + " (" + cityDTO.getAltName() + ")";
                    }
                    info.add(new MouseCursorInfo(cityDTO.getPosition(), null, MapObjectType.CITY, txt, SettingsBean.getInstance().getColorTheme().getCityColor()));
                }
            }
            if (SettingsBean.getInstance().isDrawAirportTaxiways() && map.getZoom() <= 6 && MapObjectsBean.getInstance().getAirportTaxis() != null) {
                for (AirportTaxiDTO a : MapObjectsBean.getInstance().getAirportTaxis()) {
                    if (!a.isInside(mouseArea)) continue;
                    if (a.hasStarts()) {
                        for (NamedWaypoint n : a.getStarts()) {
                            if (!n.isInside(mouseArea)) continue;
                            info.add(new MouseCursorInfo(n.getPosition(), null, MapObjectType.AIRPORT_START, n.getName(), Color.BLACK));
                        }
                    }
                    if (!a.hasTaxiwayPaths()) continue;
                    ArrayList<MouseCursorInfo> taxiways = new ArrayList<MouseCursorInfo>();
                    TaxiwayPathDTO[] minDist = a.getTaxiwayPaths();
                    int s = minDist.length;
                    for (int i = 0; i < s; ++i) {
                        TaxiwayPathDTO t = minDist[i];
                        if (!t.isInside(mouseArea) || StringUtil.isEmpty(t.getName())) continue;
                        taxiways.add(new MouseCursorInfo(t.getRectangleOver().getCenter().geoPosition(), null, MapObjectType.AIRPORT_TAXIWAY, t.getName(), Color.BLACK));
                    }
                    if (taxiways.size() <= 0) continue;
                    Collections.sort(taxiways, new Comparator<MouseCursorInfo>(){

                        @Override
                        public int compare(MouseCursorInfo m1, MouseCursorInfo m2) {
                            return m1.getText().compareTo(m2.getText());
                        }
                    });
                    info.addAll(taxiways);
                }
            }
            if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawWeather() && MapObjectsBean.getInstance().getStations() != null && MapObjectsBean.getInstance().getStations().size() > 0) {
                for (Station station : MapObjectsBean.getInstance().getStations()) {
                    if (station.getReport() == null || !station.isInside(mouseArea)) continue;
                    if (station.getReport().getMetar() != null) {
                        info.add(new MouseCursorInfo(station.getGpsPlace().geoPosition(), null, MapObjectType.METAR, station.getReport().getMetar(), SettingsBean.getInstance().getColorTheme().getStationInsideColor()));
                    }
                    if (station.getReport().getTaf() == null) continue;
                    info.add(new MouseCursorInfo(station.getGpsPlace().geoPosition(), null, MapObjectType.TAF, station.getReport().getTaf(), SettingsBean.getInstance().getColorTheme().getStationInsideColor()));
                }
            }
            if (SettingsBean.getInstance().isDrawRadialsFromVors() && MapObjectsBean.getInstance().getRadialsFromVorsIntersections() != null) {
                void var9_33;
                ArrayList<RadialFromVorDTO> finalRadials = new ArrayList<RadialFromVorDTO>();
                Object var9_32 = null;
                double closestDiff = 1000000.0;
                GpsPoint mousePos = MapUtil.getPixelPositionOnMap(map, mouseX, mouseY);
                for (GpsPlace place : MapObjectsBean.getInstance().getRadialsFromVorsIntersections()) {
                    Point2D pt;
                    double diff;
                    if (!place.isInside(mouseArea) || !((diff = (pt = map.getTileFactory().geoToPixel(place.geoPosition(), map.getZoom())).distance(mousePos)) < closestDiff)) continue;
                    GpsPlace gpsPlace = place;
                    closestDiff = diff;
                }
                if (var9_33 != null) {
                    String[] ids = var9_33.getName().split(";");
                    for (RadialFromVorDTO radial : MapObjectsBean.getInstance().getRadialsFromVors()) {
                        if (!radial.getUniqueId().equals(ids[0]) && !radial.getUniqueId().equals(ids[1])) continue;
                        finalRadials.add(radial);
                        double dist = GpsUtil.getDistance(radial.getFrom().gpsPlace(), (GpsPlace)var9_33);
                        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                            dist = UnitUtil.recalculateDistance(dist, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
                        }
                        info.add(new MouseCursorInfo(var9_33.geoPosition(), null, MapObjectType.RADIAL_FROM_VOR, radial.getDesc() + " / " + NumberUtil.roundDouble(dist, 1) + SettingsBean.getInstance().getParamUnitsDistance(), radial.getColor(), Color.BLACK));
                        if (finalRadials.size() < 2) {
                            continue;
                        }
                        break;
                    }
                } else {
                    GpsPoint point = MapUtil.getPixelPositionOnMap(map, mouseX, mouseY);
                    HashMap inArea = new HashMap();
                    for (RadialFromVorDTO radial : MapObjectsBean.getInstance().getRadialsFromVors()) {
                        Double diff;
                        if (!radial.isInside(mouseArea) || (diff = MapUtil.getDiffPointOnSegment(map, point, radial.getLineSegment())) == null || !(diff < 50.0)) continue;
                        List<RadialFromVorDTO> r = null;
                        r = inArea.get(radial.getVorId()) == null ? new ArrayList<RadialFromVorDTO>() : (List)inArea.get(radial.getVorId());
                        r.add(radial);
                        inArea.put(radial.getVorId(), r);
                    }
                    if (inArea.size() > 0) {
                        for (String vorId : inArea.keySet()) {
                            RadialFromVorDTO closestRadial = null;
                            if (((List)inArea.get(vorId)).size() > 1) {
                                double diff = 1000000.0;
                                for (RadialFromVorDTO radial : (List)inArea.get(vorId)) {
                                    Double d = MapUtil.getDiffPointOnSegment(map, point, radial.getLineSegment());
                                    if (d == null || !(d < diff)) continue;
                                    closestRadial = radial;
                                    diff = d;
                                }
                            } else {
                                closestRadial = (RadialFromVorDTO)((List)inArea.get(vorId)).get(0);
                            }
                            finalRadials.add(closestRadial);
                            info.add(new MouseCursorInfo(closestRadial.getRectangleOver().getCenter().geoPosition(), null, MapObjectType.RADIAL_FROM_VOR, closestRadial.getDesc(), closestRadial.getColor(), Color.BLACK));
                        }
                    }
                }
                MapObjectsBean.getInstance().selectRadialsFromVors(finalRadials);
            }
            if (map.getZoom() <= 8 && SettingsBean.getInstance().isDrawObstacles()) {
                ArrayList<ObstacleDTO> obstacles = new ArrayList<ObstacleDTO>();
                for (ObstacleDTO obs : MapObjectsBean.getInstance().getObstacles(mouseArea)) {
                    if (!obs.isInside(mouseArea) || !MapObjectsBean.getInstance().getObstacleFilter().checkDisplayObstacle(obs)) continue;
                    obstacles.add(obs);
                }
                Collections.sort(obstacles);
                for (ObstacleDTO obs : obstacles) {
                    MapObjectsBean.getInstance().getTextUnderCursor().add(new MouseCursorInfo(obs.getPosition(), null, MapObjectType.OBSTACLE, obs.getInfo(), Color.RED));
                }
            }
            if (SettingsBean.getInstance().isDrawMapGrid()) {
                GpsPlace place = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX, mouseY), map.getZoom()).gpsPlace();
                info.add(new MouseCursorInfo(null, null, MapObjectType.HGT_FILENAME, FormatUtil.getHgtFilename(place.getLat().getValue(), place.getLon().getValue()), Color.BLUE));
                String string = ElevationsUtil.getZipHgtFilenameForPlace(place, SettingsBean.getInstance().getHgtZipFilesMappings());
                if (!StringUtil.isEmpty(string)) {
                    info.add(new MouseCursorInfo(null, null, MapObjectType.HGT_ZIP_FILENAMES, string, Color.BLUE));
                }
            }
            Collections.sort(info);
            MapObjectsBean.getInstance().getTextUnderCursor().addAll(info);
        }
        if (map.isPaintAirspacesList() && SettingsBean.getInstance().isDrawAirspaces()) {
            GeoPosition posGeo = map.getGeoPositionAtPos(mouseX, mouseY);
            GpsPlace pos3 = posGeo.gpsPlace();
            List<AirspaceAreaDTO> areas = AirspacesUtil.findAirspacesUnderPosition(map, pos3);
            Collections.sort(areas, new AirspaceAreaAltitudeComparator());
            if (areas.size() > 0 && MapObjectsBean.getInstance().getTextUnderCursor().size() > 0) {
                MapObjectsBean.getInstance().getTextUnderCursor().add(MouseCursorInfo.BREAK_LINE);
            }
            for (int i = 0; i < areas.size(); ++i) {
                AirspaceAreaDTO ar = areas.get(i);
                String txt = AirspacesUtil.formatAirspaceAreaName(ar, SettingsBean.getInstance().isDrawAirspacesIds());
                if (ar.getRemark() != null) {
                    txt = txt + " ***" + ar.getRemark() + "***";
                }
                Color color = ColorUtil.COLOR_SET[i % ColorUtil.COLOR_SET.length];
                MapObjectsBean.getInstance().getTextUnderCursor().add(new MouseCursorInfo(null, ar.clone(), MapObjectType.AIRSPACE_AREA, txt, ColorUtil.newColorInverted(color), color));
            }
        }
        ArrayList<MouseCursorInfo> wrappedTextUnderCursor = new ArrayList<MouseCursorInfo>();
        for (MouseCursorInfo cursorInfo : MapObjectsBean.getInstance().getTextUnderCursor()) {
            if (cursorInfo.getText() != null && cursorInfo.getText().length() > 80) {
                List<String> wrappedLines = FormatUtil.wrap(cursorInfo.getText(), 80, "          ");
                for (String line : wrappedLines) {
                    MouseCursorInfo mouseCursorInfo = cursorInfo.clone();
                    mouseCursorInfo.setText(line);
                    wrappedTextUnderCursor.add(mouseCursorInfo);
                }
                continue;
            }
            wrappedTextUnderCursor.add(cursorInfo);
        }
        int maxLen = 0;
        for (MouseCursorInfo i : wrappedTextUnderCursor) {
            if (i.getText() == null || i.getText().length() <= maxLen) continue;
            maxLen = i.getText().length();
        }
        for (MouseCursorInfo i : wrappedTextUnderCursor) {
            if (!MapObjectType.RADIAL_FROM_VOR.equals((Object)i.getType())) continue;
            i.setText(StringUtil.createSpaces(maxLen - i.getText().length()) + i.getText());
        }
        MapObjectsBean.getInstance().setTextUnderCursor(wrappedTextUnderCursor);
    }

    private static TerrainMesh getElevationAt(GpsPlace pos) {
        if (MapObjectsBean.getInstance().getTerrainMesh() != null && MapObjectsBean.getInstance().getTerrainMeshArea().contains(pos)) {
            for (int i = 0; i < MapObjectsBean.getInstance().getTerrainMesh().length; ++i) {
                if (!pos.isInside(MapObjectsBean.getInstance().getTerrainMesh()[i].getRectangleOver())) continue;
                TerrainMesh elev = MapObjectsBean.getInstance().getTerrainMesh()[i].clone();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    elev.setValue((short)Math.round(UnitUtil.recalculateAltitude(elev.getValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                }
                return elev;
            }
        }
        return null;
    }

    public static BufferedImage getMapAreaRotatedByBearing(VfrMapViewer map, GpsPlace center, double bearing, double sizeInNm, int zoom) {
        GpsPlace topLeft = GpsUtil.getPointPositionByDistanceAndBearing(center, bearing - 45.0, sizeInNm);
        GpsPlace topRight = GpsUtil.getPointPositionByDistanceAndBearing(center, bearing + 45.0, sizeInNm);
        GpsPlace bottomRight = GpsUtil.getPointPositionByDistanceAndBearing(center, bearing + 135.0, sizeInNm);
        GpsPlace bottomLeft = GpsUtil.getPointPositionByDistanceAndBearing(center, bearing + 225.0, sizeInNm);
        RotatedGpsArea area = new RotatedGpsArea(topLeft, topRight, bottomLeft, bottomRight, bearing);
        return PdfUtil.getMapRegionImage(map, area, zoom, false, null, null, false);
    }

    public static Point2D rotate(Point2D point, Point2D origin, double angle) {
        double x1 = point.getX() - origin.getX();
        double y1 = point.getY() - origin.getY();
        x1 = x1 * Math.cos(angle) - y1 * Math.sin(angle);
        y1 = x1 * Math.sin(angle) + y1 * Math.cos(angle);
        return new GpsPoint((double)((int)Math.ceil(x1)) + origin.getX(), (double)((int)Math.ceil(y1)) + origin.getY());
    }
}

