/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.kml.Kml;
import org.apache.log4j.Logger;

public class KmlUtil {
    private static final Logger log = Logger.getLogger(KmlUtil.class);
    private static final String NEW_LINE = "\n";

    public static boolean loadKml(File file) {
        log.info("loading KML file ...");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Kml.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Kml xml = (Kml)jaxbUnmarshaller.unmarshal(file);
            Route route = KmlUtil.getRouteFromKml(xml);
            if (route.getPoints().size() <= 0) {
                return false;
            }
            FlightPlanBean.getInstance().setRoute(route);
            MapFrame.getInstance().getUIPanel().updateData();
            MapFrame.getInstance().updateMap();
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public static Route getRouteFromKml(Kml xml) {
        Route route = new Route();
        if (xml.getDocument() != null && xml.getDocument().getFolder() != null) {
            Kml.Document.Folder folder = xml.getDocument().getFolder();
            route.setName(folder.getName());
            route.setDescription(folder.getDescription());
            for (Kml.Document.Folder.Placemark pm : folder.getPlacemark()) {
                GpsPlace wp;
                if (pm.getPoint() != null && (wp = KmlUtil.getGpsPlaceFromPoint(pm.getPoint())) != null) {
                    wp.setName(pm.getName());
                    route.getPoints().add(new RoutePlace(wp));
                }
                if (pm.getLineString() == null) continue;
                route.getPoints().addAll(KmlUtil.getGpsPlaceFromLineString(pm.getLineString(), pm.getName()));
            }
        } else {
            log.error("Invalid kml file (no folder)");
        }
        return route;
    }

    private static GpsPlace getGpsPlaceFromPoint(Kml.Document.Folder.Placemark.Point point) {
        if (point.getCoordinates() != null) {
            return KmlUtil.getGpsPlaceFromCoords(point.getCoordinates());
        }
        return null;
    }

    private static RoutePlace getGpsPlaceFromCoords(String coords) {
        String[] split = coords.split(",");
        if (split.length < 2) {
            log.error("Not enough coordinates: " + coords);
            return null;
        }
        try {
            RoutePlace place = new RoutePlace();
            place.setLon(new GpsCoord(Double.parseDouble(split[0])));
            place.setLat(new GpsCoord(Double.parseDouble(split[1])));
            if (split.length > 2) {
                double alt = UnitUtil.recalculateAltitude(Double.parseDouble(split[2]), "m", SettingsBean.getInstance().getParamUnitsAltitude(), false);
                place.setAlt(alt);
            }
            return place;
        }
        catch (NumberFormatException e) {
            log.debug("Problem with parsing coordinates: " + coords);
            return null;
        }
    }

    private static List<RoutePlace> getGpsPlaceFromLineString(Kml.Document.Folder.Placemark.LineString lineString, String name) {
        ArrayList<RoutePlace> result = new ArrayList<RoutePlace>();
        if (lineString.getCoordinates() != null) {
            String coords = lineString.getCoordinates().replace(NEW_LINE, " ").trim();
            String[] points = coords.split(" ");
            for (int i = 0; i < points.length; ++i) {
                RoutePlace point = KmlUtil.getGpsPlaceFromCoords(points[i]);
                if (point == null) continue;
                point.setName(name + i);
                result.add(point);
            }
        }
        return result;
    }

    public static boolean saveKml(Route route, String file) {
        Kml xml = KmlUtil.getKml(route);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Kml.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public static boolean saveKml(List<ExtConnectBean> userTrack, String file) {
        log.info("Saving to " + file);
        Kml xml = KmlUtil.getKml(userTrack);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Kml.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public static Kml getKml(Route route) {
        Kml kml = new Kml();
        kml.setDocument(new Kml.Document());
        kml.getDocument().setName(route.getName());
        Kml.Document.Style style = new Kml.Document.Style();
        style.setId("yellowLineGreenPoly");
        style.setLineStyle(new Kml.Document.Style.LineStyle());
        style.getLineStyle().setColor("7f00ffff");
        style.getLineStyle().setWidth(4);
        style.setPolyStyle(new Kml.Document.Style.PolyStyle());
        style.getPolyStyle().setColor("7f00ff00");
        kml.getDocument().getStyle().add(style);
        Kml.Document.Folder folder = new Kml.Document.Folder();
        folder.setName(route.getName());
        folder.setDescription(route.getDescription());
        folder.setOpen(1);
        Kml.Document.Folder.Placemark polyline = new Kml.Document.Folder.Placemark();
        polyline.setName(route.getName());
        polyline.setStyleUrl("#yellowLineGreenPoly");
        polyline.setLineString(new Kml.Document.Folder.Placemark.LineString());
        polyline.getLineString().setExtrude(1);
        polyline.getLineString().setTessellate(1);
        polyline.getLineString().setAltitudeMode(SettingsBean.getInstance().isParamGEExportStickyToTerrain() ? "clampToGround" : "absolute");
        StringBuilder polylineCoords = new StringBuilder();
        for (GpsPlace gpsPlace : route.getPoints()) {
            Kml.Document.Folder.Placemark pm = new Kml.Document.Folder.Placemark();
            pm.setName(gpsPlace.getName());
            pm.setStyleUrl("#msn_ltblu-pushpin4");
            pm.setPoint(new Kml.Document.Folder.Placemark.Point());
            pm.getPoint().setAltitudeMode(SettingsBean.getInstance().isParamGEExportStickyToTerrain() ? "clampToGround" : "absolute");
            pm.getPoint().setCoordinates(KmlUtil.getCoordinates(gpsPlace));
            folder.getPlacemark().add(pm);
            polylineCoords.append(KmlUtil.getCoordinates(gpsPlace) + NEW_LINE);
        }
        polyline.getLineString().setCoordinates(polylineCoords.toString());
        folder.getPlacemark().add(polyline);
        kml.getDocument().setFolder(folder);
        return kml;
    }

    public static Kml getKml(List<ExtConnectBean> userTrack) {
        Kml kml = new Kml();
        kml.setDocument(new Kml.Document());
        kml.getDocument().setName("User track");
        Kml.Document.Folder folder = new Kml.Document.Folder();
        folder.setName("User track");
        folder.setDescription("User track on ... ");
        folder.setOpen(1);
        Kml.Document.Folder.Placemark polyline = new Kml.Document.Folder.Placemark();
        polyline.setName("User track");
        polyline.setStyleUrl("#yellowLineGreenPoly");
        polyline.setLineString(new Kml.Document.Folder.Placemark.LineString());
        polyline.getLineString().setExtrude(1);
        polyline.getLineString().setTessellate(1);
        polyline.getLineString().setAltitudeMode("absolute");
        StringBuilder polylineCoords = new StringBuilder();
        for (ExtConnectBean b : userTrack) {
            polylineCoords.append(KmlUtil.getCoordinates(b) + NEW_LINE);
        }
        polyline.getLineString().setCoordinates(polylineCoords.toString());
        folder.getPlacemark().add(polyline);
        kml.getDocument().setFolder(folder);
        return kml;
    }

    private static String getCoordinates(ExtConnectBean b) {
        StringBuilder sb = new StringBuilder();
        sb.append(b.getUserLon());
        sb.append(",");
        sb.append(b.getUserLat());
        double alt = UnitUtil.recalculateAltitude(b.getUserAlt().floatValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
        sb.append(",");
        sb.append(alt);
        return sb.toString();
    }

    private static String getCoordinates(GpsPlace place) {
        StringBuilder sb = new StringBuilder();
        sb.append(place.getLon().getValue());
        sb.append(",");
        sb.append(place.getLat().getValue());
        if (place.getAlt() != null) {
            double alt = UnitUtil.recalculateAltitude(place.getAlt(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
            sb.append(",");
            sb.append(alt);
        }
        return sb.toString();
    }
}

