/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.IO;

import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import main.java.guru.vfrflight.bean.constants.Constants;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.log4j.Logger;

public class IOUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger log = Logger.getLogger(IOUtil.class);

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(Closeable output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException ioe) {
            log.error(ioe);
        }
    }

    public static void deleteQuietly(String file) {
        try {
            Files.delete(Paths.get(file, new String[0]));
        }
        catch (FileSystemException fileSystemException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveTextFile(String content, String file) {
        boolean res = false;
        PrintWriter out = null;
        try {
            out = new PrintWriter(file);
            out.write(content);
            res = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
        }
        IOUtil.closeQuietly(out);
        return res;
    }

    public static void downloadFile(String from, String to) throws IOException {
        FileOutputStream fos = null;
        try {
            URL website = new URL(from);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            fos = new FileOutputStream(to);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (UnknownHostException e) {
            try {
                throw new IOException("Couldn't connect to host " + from);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(fos);
    }

    public static void unZipFile(String filename, String outputFolder) throws IOException {
        File folder = new File(outputFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        log.debug("Unzipping " + filename + " into " + outputFolder);
        try {
            ZipFile zipFile = new ZipFile(filename);
            zipFile.extractAll(outputFolder);
        }
        catch (ZipException e) {
            log.error((Object)e, e);
            throw new IOException(e);
        }
        log.debug("Unzipping done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String loadTextFile(String file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(Constants.EOL);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't load html template " + file, e);
            String string = null;
            IOUtil.closeQuietly(br);
            return string;
        }
        catch (IOException e2) {
            log.error("Couldn't load html template " + file, e2);
            String string = null;
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
            return string;
        }
        IOUtil.closeQuietly(br);
        return sb.toString();
    }

    public static List<String> loadTextFileAsRows(String file) {
        return IOUtil.loadTextFileAsRows(file, null);
    }

    public static List<String> loadTextFileAsRows(String file, String encoding) {
        try {
            if (encoding == null) {
                return Files.readAllLines(Paths.get(file, new String[0]));
            }
            return Files.readAllLines(Paths.get(file, new String[0]), Charset.forName(encoding));
        }
        catch (IOException e) {
            log.error("Couldn't read file " + file, e);
            return null;
        }
    }

    public static String addExtension(File file, String ext) {
        String name = file.getAbsolutePath();
        if (!IOUtil.hasExtension(name, ext = ext.toLowerCase())) {
            name = name + "." + ext;
        }
        return name;
    }

    public static boolean hasExtension(String name, String ext) {
        return name.length() - ext.length() - 1 >= 0 && name.substring(name.length() - ext.length() - 1, name.length()).equalsIgnoreCase("." + ext);
    }

    public static String addExtensionToName(File file, String ext) {
        String name = file.getName();
        ext = ext.toLowerCase();
        boolean hasExt = false;
        if (name.length() - ext.length() - 1 >= 0 && name.substring(name.length() - ext.length() - 1, name.length()).equalsIgnoreCase("." + ext)) {
            hasExt = true;
        }
        if (!hasExt) {
            name = name + "." + ext;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveBytesInFile(byte[] bytes, String fileName) {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(fileName));
            bos.write(bytes);
            bos.flush();
        }
        catch (FileNotFoundException e) {
            log.error("saveBytesInFile: error saving " + fileName, e);
            IOUtil.closeQuietly(bos);
        }
        catch (IOException e2) {
            log.error("saveBytesInFile: error saving " + fileName, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(bos);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(bos);
        }
        IOUtil.closeQuietly(bos);
    }

    public static boolean deleteFile(String file) {
        File f = new File(file);
        return f.delete();
    }

    public static String execute(String path, boolean withOutput) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(path);
        }
        catch (IOException e) {
            log.error(e, e);
            return null;
        }
        if (withOutput) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line = "";
            try {
                while ((line = reader.readLine()) != null) {
                    sb.append(line + "\n");
                }
            }
            catch (IOException e) {
                log.error(e, e);
                return null;
            }
            return sb.toString();
        }
        return "";
    }

    public static boolean isPathAbsolute(String path) {
        return path.indexOf(":") >= 0;
    }

    public static String getNameFromPath(String path) {
        if (path != null) {
            String[] pcs = (path = path.replace("\\", "/")).split("/");
            if (pcs.length > 1) {
                return pcs[pcs.length - 1];
            }
            return path;
        }
        log.error("path is null");
        return "";
    }

    public static void openFileInDesktop(String file) {
        Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        File pdfFile = new File(file);
        if (desktop != null && pdfFile.exists()) {
            try {
                desktop.open(new File(file));
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }
}

