/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static final Logger log = Logger.getLogger(HibernateUtil.class);
    private static volatile HibernateUtil instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HibernateUtil getInstance() {
        if (instance != null) return instance;
        Class<HibernateUtil> clazz = HibernateUtil.class;
        synchronized (HibernateUtil.class) {
            if (instance != null) return instance;
            instance = new HibernateUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HibernateUtil() {
    }

    public static void checkAvailableMemory() {
        long freemem = VfrUtil.getFreeHeapSpace();
        if (freemem < 8L) {
            int runs = 0;
            do {
                log.info("Invoking GC (freemem= " + freemem + " MB)");
                System.gc();
                SqlConnector.getInstance().stopServer();
                SqlConnector.getInstance().startServer();
                try {
                    Thread.sleep(1000 * runs);
                }
                catch (InterruptedException e) {
                    log.error(e, e);
                }
            } while ((freemem = VfrUtil.getFreeHeapSpace()) < 32L && ++runs < 5);
        }
    }

    public static Configuration getHibernateConfig() {
        return HibernateUtil.getHibernateConfig(null);
    }

    public static Configuration getHibernateConfig(String fileName) {
        if (fileName == null) {
            return new Configuration().configure();
        }
        return new Configuration().configure(new File(fileName));
    }
}

