/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Component;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import org.apache.log4j.Logger;

public class GuiUtil {
    private static final Logger log = Logger.getLogger(GuiUtil.class);

    public static boolean showConfirmationDialog(Component component, String title, String msg) {
        int dialogResult = JOptionPane.showOptionDialog(component, msg, title, 0, 3, null, new String[]{Messages.getInstance().get("yes"), Messages.getInstance().get("no")}, Messages.getInstance().get("no"));
        return dialogResult == 0;
    }

    public static JFileChooser getFileChooser(String title, String buttonText) {
        return GuiUtil.getFileChooser(title, buttonText, SettingsBean.getInstance().getFileOpenPath());
    }

    public static JFileChooser getFileChooser(String title, String buttonText, String defaultPath) {
        JFileChooser chooser = new JFileChooser(defaultPath);
        UIManager.put("FileChooser.openDialogTitleText", title);
        UIManager.put("FileChooser.openButtonText", buttonText);
        UIManager.put("FileChooser.cancelButtonText", Messages.getInstance().get("cancel_button"));
        UIManager.put("FileChooser.fileNameLabelText", Messages.getInstance().get("filename"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Messages.getInstance().get("filetype"));
        SwingUtilities.updateComponentTreeUI(chooser);
        return chooser;
    }
}

