/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.ResourcesBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.MouseCursorInfo;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.util.GraphicsUtilities;

public class GraphicsUtil {
    private static final Font VOR_RADIAL_WITH_DISTANCES_LABEL_FONT = new Font("SansSerif", 1, 18);
    public static final int RENDERING_HINTS_NORMAL = 0;
    public static final int RENDERING_HINTS_TEXT_ANTIALIAS = 1;
    public static final int RENDERING_HINTS_SPEED = 2;
    public static final int RENDERING_HINTS_QUALITY = 3;
    private static final Font RADIAL_FONT = new Font("SansSerif", 1, 12);
    private static final Font MEASURMENT_LINE_DIST_LABEL_FONT = new Font("SansSerif", 1, 16);
    private static final Font MEASURMENT_LINE_CRS_LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Font MEASURMENT_LINE_TIME_FUEL_LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Color SELECTION_FILL_COLOR = new Color(0.75f, 0.6f, 1.0f, 0.15f);
    private static final Color SELECTION_LABEL_BACKGROUND_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private static final Font SELECTION_LABEL_FONT = new Font("Monospaced", 1, 12);
    public static final Color SELECTION_STROKE_COLOR = new Color(0.2f, 0.6f, 1.0f, 1.0f);
    private static final Font SCALE_FONT = new Font("SansSerif", 1, 12);
    private static final int SCALE_WIDTH = 250;
    private static final int SCALE_HEIGHT = 10;
    private static final int SCALE_MIN_STEP = 50;
    public static final int TOP_LEFT_CORNER = 0;
    public static final int TOP_RIGHT_CORNER = 1;
    public static final int BOTTOM_LEFT_CORNER = 2;
    public static final int BOTTOM_RIGHT_CORNER = 3;
    private static final Font ILS_LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Font HELIPAD_FONT = new Font("SansSerif", 1, 12);
    public static final int TOUCH_SCREEN_CURSOR_HALF_SIZE = 19;
    public static final int TOUCH_SCREEN_CURSOR_CONTEXT_MENU_SX = 19;
    public static final int TOUCH_SCREEN_CURSOR_CONTEXT_MENU_SY = -55;
    public static final int TOUCH_SCREEN_CURSOR_CONTEXT_MENU_EX = 51;
    public static final int TOUCH_SCREEN_CURSOR_CONTEXT_MENU_EY = -23;
    private static final Font MAP_SHAPE_INDEX_FONT = new Font("SansSerif", 1, 11);
    private static final Font ELEVATION_LABEL_FONT = new Font("Monospaced", 1, 24);
    private static final Font ELEVATION_LABEL_FONT2 = new Font("Monospaced", 1, 17);
    private static final Font ELEVATION_LABEL_SMALL_FONT = new Font("Monospaced", 1, 15);
    private static final Font ELEVATION_LABEL_SMALL_FONT2 = new Font("Monospaced", 1, 11);

    public static void drawSimpleMarker(Graphics2D g, int x, int y, int size, Color color, Color borderColor) {
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(borderColor);
        g.drawLine(x - size, y, x + size, y);
        g.drawLine(x, y - size, x, y + size);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(color);
        g.drawLine(x - size, y, x + size, y);
        g.drawLine(x, y - size, x, y + size);
    }

    public static void drawTouchScreenModeCursor(Graphics2D g, int x, int y, Color color, Color borderColor) {
        int halfSize = 19;
        int quaterSize = (int)Math.round(9.5);
        int doubleSize = 38;
        int size = 39;
        g.setColor(borderColor);
        g.setStroke(new BasicStroke(7.0f));
        g.drawOval(x - 19, y - 19, 39, 39);
        g.setColor(color);
        g.setStroke(new BasicStroke(3.0f));
        g.drawOval(x - 19, y - 19, 39, 39);
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(borderColor);
        g.drawLine(x - 38, y, x - quaterSize, y);
        g.drawLine(x + quaterSize, y, x + 38, y);
        g.drawLine(x, y - 38, x, y - quaterSize);
        g.drawLine(x, y + quaterSize, x, y + 38);
        g.drawImage((Image)ResourcesBean.getInstance().getContextMenuIcon(), x + 19, y - 39, null);
    }

    public static void drawMarker(Graphics2D g, int x, int y, int w, int h, Color color, Color borderColor) {
        g.setColor(color);
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = x - w;
        py[0] = y - h;
        px[1] = x;
        py[1] = y;
        px[2] = x + w;
        py[2] = y - h;
        g.fillPolygon(new Polygon(px, py, 3));
        px[0] = x - h;
        py[0] = y + w;
        px[1] = x;
        py[1] = y;
        px[2] = x - h;
        py[2] = y - w;
        g.fillPolygon(new Polygon(px, py, 3));
        px[0] = x - w;
        py[0] = y + h;
        px[1] = x;
        py[1] = y;
        px[2] = x + w;
        py[2] = y + h;
        g.fillPolygon(new Polygon(px, py, 3));
        px[0] = x + h;
        py[0] = y + w;
        px[1] = x;
        py[1] = y;
        px[2] = x + h;
        py[2] = y - w;
        g.fillPolygon(new Polygon(px, py, 3));
        g.setColor(borderColor);
        g.drawLine(x - w, y - h, x, y);
        g.drawLine(x, y, x + w, y - h);
        g.drawLine(x + w, y - h, x - w, y - h);
        g.drawLine(x - h, y + w, x, y);
        g.drawLine(x, y, x - h, y - w);
        g.drawLine(x - h, y - w, x - h, y + w);
        g.drawLine(x - w, y + h, x, y);
        g.drawLine(x, y, x + w, y + h);
        g.drawLine(x + w, y + h, x - w, y + h);
        g.drawLine(x + h, y + w, x, y);
        g.drawLine(x, y, x + h, y - w);
        g.drawLine(x + h, y - w, x + h, y + w);
    }

    public static void drawHalfTriangle(Graphics2D g, int x, int y, int sizeX, int sizeY) {
        g.drawLine(x, y - sizeY, x, y + sizeY);
        g.drawLine(x, y + sizeY, x - sizeX, y + sizeY);
        g.drawLine(x - sizeX, y + sizeY, x, y - sizeY);
    }

    public static void drawTriangle(Graphics2D g, int x, int y, int sizeX, int sizeY) {
        g.drawLine(x, y - sizeY, x + sizeX, y + sizeY);
        g.drawLine(x + sizeX, y + sizeY, x - sizeX, y + sizeY);
        g.drawLine(x - sizeX, y + sizeY, x, y - sizeY);
    }

    public static void drawFilledPin(Graphics2D g, int x, int y, int sizeX, int sizeY) {
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = x;
        py[0] = y;
        px[1] = x - sizeX;
        py[1] = y - sizeY;
        px[2] = x + sizeX;
        py[2] = y - sizeY;
        g.fillPolygon(new Polygon(px, py, 3));
        g.fillOval(x - sizeX, y - sizeY - sizeX, sizeX * 2, sizeX * 2);
    }

    public static void drawObstacle(Graphics2D g, int x, int y, int size, boolean group, boolean lightenUp) {
        int offset;
        int diagsize = (int)Math.round((double)size * 0.75);
        int quatersize = Math.round(size / 4);
        int height = size * 4;
        int n = offset = group ? Math.round(size / 2) : 0;
        if (lightenUp) {
            g.drawLine(x, y - height, x - size, y - height);
            g.drawLine(x, y - height, x, y - height - size);
            g.drawLine(x, y - height, x - diagsize, y - height - diagsize);
            if (group) {
                g.drawLine(x + offset, y - height, x + offset, y - height - size);
            }
            g.drawLine(x + offset, y - height, x + diagsize + offset, y - height - diagsize);
            g.drawLine(x + offset, y - height, x + size + offset, y - height);
        }
        g.drawLine(x, y - height, x + size, y);
        g.drawLine(x - size, y, x, y - height);
        if (group) {
            g.drawLine(x + offset, y - height, x + size + offset, y);
        }
        g.drawOval(x - quatersize, y - quatersize, quatersize * 2 + 1, quatersize * 2 + 1);
    }

    public static void drawHighObstacle(Graphics2D g, int x, int y, int size, boolean lightenUp) {
        int diagsize = (int)Math.round((double)size * 0.75);
        int quatersize = Math.round(size / 4);
        int height = size * 4;
        int mainlineheight = (int)Math.round((double)size * 2.5);
        if (lightenUp) {
            g.drawLine(x, y - height, x, y - height - size);
            g.drawLine(x, y - height, x - diagsize, y - height - diagsize);
            g.drawLine(x, y - height, x + diagsize, y - height - diagsize);
            g.drawLine(x, y - height, x + diagsize, y - height + diagsize);
            g.drawLine(x, y - height, x - diagsize, y - height + diagsize);
        }
        g.drawLine(x, y - height, x, y - height + mainlineheight);
        g.drawLine(x, y - height + mainlineheight, x + size, y);
        g.drawLine(x - size, y, x, y - height + mainlineheight);
        g.drawOval(x - quatersize, y - quatersize, quatersize * 2 + 1, quatersize * 2 + 1);
    }

    public static void drawIfrRoutePoint(Graphics2D g, int x, int y, int size) {
        g.drawOval(x - size, y - size, size * 2, size * 2);
        int wingsSize = (int)Math.ceil((double)size * 2.0);
        int quaterSize = (int)Math.round((double)size / 4.0);
        g.drawLine(x - wingsSize, y, x - size, y + quaterSize);
        g.drawLine(x - wingsSize, y, x - size, y - quaterSize);
        g.drawLine(x + wingsSize, y, x + size, y + quaterSize);
        g.drawLine(x + wingsSize, y, x + size, y - quaterSize);
        g.drawLine(x, y + wingsSize, x + quaterSize, y + size);
        g.drawLine(x, y + wingsSize, x - quaterSize, y + size);
        g.drawLine(x, y - wingsSize, x + quaterSize, y - size);
        g.drawLine(x, y - wingsSize, x - quaterSize, y - size);
    }

    public static void drawTriangle(Graphics2D g, int x, int y, int size) {
        g.drawLine(x, y - size, x + size, y + size);
        g.drawLine(x + size, y + size, x - size, y + size);
        g.drawLine(x - size, y + size, x, y - size);
    }

    public static void fillHalfTriangle(Graphics2D g, int x, int y, int sizeX, int sizeY) {
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = x;
        py[0] = y - sizeY;
        px[1] = x;
        py[1] = y + sizeY;
        px[2] = x - sizeX;
        py[2] = y + sizeY;
        g.fillPolygon(new Polygon(px, py, 3));
    }

    public static void fillTriangle(Graphics2D g, int x, int y, int sizeX, int sizeY) {
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = x;
        py[0] = y - sizeY;
        px[1] = x + sizeX + 1;
        py[1] = y + sizeY + 1;
        px[2] = x - sizeX;
        py[2] = y + sizeY + 1;
        g.fillPolygon(new Polygon(px, py, 3));
    }

    public static void fillTriangle(Graphics2D g, int x, int y, int size) {
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = x;
        py[0] = y - size;
        px[1] = x + size + 1;
        py[1] = y + size + 1;
        px[2] = x - size;
        py[2] = y + size + 1;
        g.fillPolygon(new Polygon(px, py, 3));
    }

    public static void drawOutlinedCenteredString(Graphics2D g, String txt, int x, int y, Font font, Color textColor, Color strokeColor, float strokeSize) {
        g.setFont(font);
        GraphicsUtil.drawOutlinedString(g, x - (int)Math.round(g.getFontMetrics().getStringBounds(txt, g).getWidth() / 2.0), y, txt, font, textColor, strokeColor, strokeSize);
    }

    public static void drawBoxedCenteredString(Graphics2D g, String txt, int x, int y, Font font, Color textColor, Color backgroundColor, int margin) {
        GraphicsUtil.drawBoxedCenteredString(g, txt, x, y, font, textColor, backgroundColor, margin, null);
    }

    public static void drawBoxedCenteredString(Graphics2D g, String txt, int x, int y, Font font, Color textColor, Color backgroundColor, int margin, Color strokeColor) {
        g.setFont(font);
        GraphicsUtil.drawBoxedString(g, x - (int)Math.round(g.getFontMetrics().getStringBounds(txt, g).getWidth() / 2.0), y, txt, font, textColor, backgroundColor, margin, strokeColor);
    }

    public static void drawBoxedString(Graphics2D g, int x, int y, String txt, Font font, Color textColor, Color backgroundColor, int margin) {
        GraphicsUtil.drawBoxedString(g, x, y, txt, font, textColor, backgroundColor, margin, null);
    }

    public static void drawBoxedString(Graphics2D g, int x, int y, String txt, Font font, Color textColor, Color backgroundColor, int margin, Color strokeColor) {
        Color prevColor = g.getColor();
        g.setFont(font);
        if (backgroundColor != null) {
            g.setColor(backgroundColor);
            Rectangle2D rect = g.getFontMetrics().getStringBounds(txt, g);
            int w = (int)Math.round(rect.getWidth());
            int h = Math.round(g.getFontMetrics().getAscent());
            g.fillRect(x - margin - 1, y - h + 2 - margin, w + margin * 2 + 1, h + margin * 2);
            if (strokeColor != null) {
                g.setColor(strokeColor);
                g.drawRect(x - margin - 2, y - h + 2 - margin - 1, w + margin * 2 + 2, h + margin * 2 + 1);
            }
        }
        g.setColor(textColor);
        g.drawString(txt, x, y);
        g.setColor(prevColor);
    }

    public static void drawOutlinedString(Graphics2D g, int x, int y, String txt, Font font, Color textColor, Color strokeColor, float strokeSize) {
        Color prevColor = g.getColor();
        g.setFont(font);
        if (strokeColor != null) {
            GlyphVector gv = font.createGlyphVector(g.getFontRenderContext(), txt);
            Shape shape = gv.getOutline();
            g.setColor(strokeColor);
            g.setStroke(new BasicStroke(strokeSize));
            int s = (int)Math.floor((double)strokeSize / 2.0) - 1;
            if (s < 0) {
                s = 0;
            }
            g.translate(x - s, y - s);
            g.draw(shape);
            g.translate(-x + s, -y + s);
        }
        g.setColor(textColor);
        g.drawString(txt, x, y);
        g.setColor(prevColor);
    }

    public static void drawCenteredString(Graphics g, String txt, int y, int width) {
        g.drawString(txt, (int)Math.round(((double)width - g.getFontMetrics().getStringBounds(txt, g).getWidth()) / 2.0), y);
    }

    public static int getStringWidth(Graphics g, String txt) {
        return (int)Math.round(g.getFontMetrics().getStringBounds(txt, g).getWidth());
    }

    public static int getStringHeight(Graphics g, String txt) {
        return (int)Math.round(g.getFontMetrics().getStringBounds(txt, g).getHeight());
    }

    public static void drawNdb(Graphics2D g, int x, int y, Color color, Color strokeColor) {
        if (strokeColor != null) {
            g.setColor(strokeColor);
            g.fillOval(x - 17, y - 17, 35, 35);
        }
        g.setColor(color);
        GraphicsUtil.drawNdbShape(g, x, y);
    }

    public static void drawNdbShape(Graphics2D g, int x, int y) {
        GpsPoint diff;
        int angle;
        g.fillOval(x - 1, y - 1, 3, 3);
        g.setStroke(new BasicStroke(3.0f));
        g.drawOval(x - 4, y - 4, 8, 8);
        int radius = 8;
        for (angle = 0; angle < 360; angle += 30) {
            diff = GpsUtil.getVectorCoords(radius, angle);
            g.fillOval((int)Math.round((double)x + diff.getX()) - 1, (int)Math.round((double)y + diff.getY()) - 1, 3, 3);
        }
        radius = 12;
        for (angle = -15; angle <= 345; angle += 20) {
            diff = GpsUtil.getVectorCoords(radius, angle);
            g.fillOval((int)Math.round((double)x + diff.getX()) - 1, (int)Math.round((double)y + diff.getY()) - 1, 3, 3);
        }
        radius = 16;
        for (angle = 0; angle < 360; angle += 15) {
            diff = GpsUtil.getVectorCoords(radius, angle);
            g.fillOval((int)Math.round((double)x + diff.getX()) - 1, (int)Math.round((double)y + diff.getY()) - 1, 3, 3);
        }
    }

    public static void drawVorDme(Graphics2D g, int x, int y, int size, boolean nav, boolean dme, Color color, Color strokeColor) {
        if (strokeColor != null) {
            g.setStroke(new BasicStroke(4.0f));
            g.setColor(strokeColor);
            if (nav) {
                GraphicsUtil.drawVorShape(g, x, y, 6);
            }
            if (dme) {
                GraphicsUtil.drawDmeShape(g, x, y, 6);
            }
        }
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(color);
        if (nav) {
            GraphicsUtil.drawVorShape(g, x, y, 6);
        }
        if (dme) {
            GraphicsUtil.drawDmeShape(g, x, y, 6);
        }
    }

    public static void drawVorShape(Graphics2D g, int x, int y, int size) {
        g.drawLine(x - size * 2, y, x - size, y - size * 2);
        g.drawLine(x - size, y - size * 2, x + size, y - size * 2);
        g.drawLine(x + size, y - size * 2, x + size * 2, y);
        g.drawLine(x + size * 2, y, x + size, y + size * 2);
        g.drawLine(x + size, y + size * 2, x - size, y + size * 2);
        g.drawLine(x - size, y + size * 2, x - size * 2, y);
        g.fillOval(x - 1, y - 1, Math.round(size / 2), Math.round(size / 2));
    }

    public static void drawArrowAtCenter(Graphics2D g, int x, int y, int arrowLength, int triangleSize) {
        int halfArrowLength = (int)Math.round((double)arrowLength / 2.0);
        g.drawLine(x, y + halfArrowLength, x, y - halfArrowLength);
        GraphicsUtil.fillTriangle(g, x, y - halfArrowLength - triangleSize, triangleSize);
    }

    public static void drawArrow2(Graphics2D g, int x, int y, int arrowLength, int triangleSize) {
        g.drawLine(x, y, x, y - arrowLength);
        GraphicsUtil.fillTriangle(g, x, y - arrowLength - triangleSize, triangleSize);
    }

    public static void drawVorCircle(Graphics2D g, int x, int y, int radius, double magVar) {
        GraphicsUtil.drawVorCircle(g, x, y, radius, magVar, false, false);
    }

    public static void drawVorCircle(Graphics2D g, int x, int y, int radius, double magVar, boolean with15DegreeHands, boolean withTextLabels) {
        double rotation = Math.toRadians(magVar);
        double rotation2 = Math.toRadians(-magVar);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
            g.drawOval(x - radius, y - radius, radius * 2 + 1, radius * 2 + 1);
            GraphicsUtil.drawArrow2(g, x, y, radius, 3);
            int withTextLabelRadius = (int)Math.floor((double)radius * 1.075);
            int with15DegRadius = (int)Math.floor((double)radius * 0.1);
            int startRadius30 = (int)Math.floor((double)radius * 0.85);
            int startRadius10 = (int)Math.floor((double)radius * 0.9);
            int startRadius5 = (int)Math.floor((double)radius * 0.95);
            for (int angle = 0; angle < 360; angle += 5) {
                GpsPoint diffStart = null;
                GpsPoint diffEnd = GpsUtil.getVectorCoords(radius, angle);
                if (with15DegreeHands && angle % 30 == 0) {
                    diffStart = GpsUtil.getVectorCoords(with15DegRadius, angle);
                } else if (angle % 30 == 0) {
                    diffStart = GpsUtil.getVectorCoords(startRadius30, angle);
                    if (withTextLabels) {
                        GpsPoint diffTextLabel = GpsUtil.getVectorCoords(withTextLabelRadius, angle);
                        int tx = (int)Math.round((double)x + diffTextLabel.getX());
                        int ty = (int)Math.round((double)y + diffTextLabel.getY());
                        g.translate(tx, ty);
                        g.rotate(rotation2);
                        g.translate(-tx, -ty);
                        GraphicsUtil.drawBoxedCenteredString(g, FormatUtil.formattedCourse(Double.valueOf(angle), false), tx, ty, MEASURMENT_LINE_CRS_LABEL_FONT, Color.BLACK, Color.YELLOW, 2);
                        g.translate(tx, ty);
                        g.rotate(rotation);
                        g.translate(-tx, -ty);
                    }
                } else {
                    diffStart = angle % 10 == 0 ? GpsUtil.getVectorCoords(startRadius10, angle) : GpsUtil.getVectorCoords(startRadius5, angle);
                }
                g.drawLine((int)Math.round((double)x + diffStart.getX()), (int)Math.round((double)y + diffStart.getY()), (int)Math.round((double)x + diffEnd.getX()), (int)Math.round((double)y + diffEnd.getY()));
            }
            g.translate(x, y);
            g.rotate(rotation2);
            g.translate(-x, -y);
        }
    }

    public static void drawUserPoint(Graphics2D g, int x, int y, Color color, Color strokeColor) {
        int size = 5;
        if (strokeColor != null) {
            g.setColor(strokeColor);
            GraphicsUtil.drawFilledPin(g, x, y + 4, size + 2, size * 3 + 4);
        }
        g.setColor(color);
        GraphicsUtil.drawFilledPin(g, x, y, size, size * 3);
    }

    public static void drawIls(Graphics2D g, int x, int y, float size, double heading, double width, int length, Color color, Color backgroundColor) {
        GraphicsUtil.drawIls(g, x, y, size, heading, width, length, color, backgroundColor, null, null);
    }

    public static void drawIls(Graphics2D g, int x, int y, float size, double heading, double width, int length, Color color, Color backgroundColor, String text, Color textStrokeColor) {
        double rotation = Math.toRadians(heading);
        double rotation2 = Math.toRadians(-heading);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            g.setStroke(new BasicStroke(size));
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
            GpsPoint diff = GpsUtil.getVectorCoords(length, width / 2.0);
            int[] px = new int[4];
            int[] py = new int[4];
            px[0] = x;
            py[0] = y;
            px[1] = x + (int)Math.round(diff.getX());
            py[1] = y - (int)Math.round(diff.getY());
            px[2] = x;
            py[2] = y + (int)Math.round((double)length * 0.9);
            px[3] = x - (int)Math.round(diff.getX());
            py[3] = py[1];
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
                g.fillPolygon(new Polygon(px, py, 4));
            }
            g.setColor(color);
            for (int i = 0; i < 4; ++i) {
                int e = i < 3 ? i + 1 : 0;
                g.drawLine(px[i], py[i], px[e], py[e]);
            }
            if (text != null) {
                boolean useOffset = heading >= 0.0 && heading < 180.0;
                int offset = useOffset ? 180 : 0;
                double rotation3 = Math.toRadians(90 + offset);
                double rotation4 = Math.toRadians(-90 - offset);
                if (!Double.isNaN(rotation3) && !Double.isNaN(rotation4)) {
                    int tx = x;
                    int ty = y + (int)Math.round((double)length * 0.9);
                    g.translate(tx, ty);
                    g.rotate(rotation3);
                    g.translate(-tx, -ty);
                    g.setFont(ILS_LABEL_FONT);
                    g.setColor(color);
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D rect = fm.getStringBounds(text, g);
                    if (textStrokeColor == null) {
                        if (useOffset) {
                            g.drawString(text, tx + 10, Math.round(ty + g.getFontMetrics().getAscent() / 2));
                        } else {
                            g.drawString(text, (int)Math.round((double)tx - rect.getWidth() - 10.0), Math.round(ty + g.getFontMetrics().getAscent() / 2));
                        }
                    } else {
                        GraphicsUtil.drawBoxedString(g, useOffset ? tx + 10 : (int)Math.round((double)tx - rect.getWidth() - 10.0), Math.round(ty + g.getFontMetrics().getAscent() / 2), text, ILS_LABEL_FONT, color, textStrokeColor, 1);
                    }
                    g.translate(tx, ty);
                    g.rotate(rotation4);
                    g.translate(-tx, -ty);
                }
            }
            g.translate(x, y);
            g.rotate(rotation2);
            g.translate(-x, -y);
        }
    }

    public static void drawDmeShape(Graphics2D g, int x, int y, int size) {
        g.drawRect(x - size * 2, y - size * 2, size * 4, size * 4);
        g.fillOval(x - 1, y - 1, Math.round(size / 2), Math.round(size / 2));
    }

    public static void drawArrow(Graphics2D g, int x, int y, int size) {
        g.drawLine(x - size, y, x + size - Math.round(size / 2), y);
        int[] ax = new int[3];
        int[] ay = new int[3];
        ax[0] = x + size;
        ay[0] = y;
        ax[1] = x + Math.round(size / 2);
        ay[1] = y + Math.round(size / 6);
        ax[2] = x + Math.round(size / 2);
        ay[2] = y - Math.round(size / 6);
        g.fillPolygon(new Polygon(ax, ay, 3));
    }

    public static void drawVorRadial(Graphics2D g, int x, int y, LineSegment segment, int wpRad, boolean paintVorDistance, boolean drawBackground, boolean isSelected, Double magvar) {
        GraphicsUtil.drawVorRadial(g, x, y, segment, wpRad, paintVorDistance, null, false, drawBackground, isSelected, magvar);
    }

    public static void drawVorRadial(Graphics2D g, int x, int y, LineSegment segment, int wpRad, boolean paintVorDistance, String prefix, boolean includeOval, boolean drawBackground, boolean isSelected, Double magvar) {
        GraphicsUtil.drawVorRadial(g, x, y, segment, wpRad, paintVorDistance, prefix, includeOval, drawBackground, isSelected, null, null, magvar);
    }

    public static void drawVorRadial(Graphics2D g, int x, int y, LineSegment segment, int wpRad, boolean paintVorDistance, String prefix, boolean includeOval, boolean drawBackground, boolean isSelected, Point2D vorPosition, Double sizeModificator, Double magvar) {
        if (vorPosition != null) {
            g.setStroke(new BasicStroke(3.0f, 0, 0, 3.0f, new float[]{5.0f}, 0.0f));
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            g.drawLine(x, y, (int)Math.round(vorPosition.getX()), (int)Math.round(vorPosition.getY()));
        }
        int lineWidth = 0;
        Font vorRadialLabelFont = null;
        if (sizeModificator == null) {
            vorRadialLabelFont = new Font("SansSerif", 1, 20);
            int n = lineWidth = paintVorDistance ? 100 : 50;
            if (prefix != null) {
                lineWidth += prefix.length() * 20;
            }
        } else {
            int fontSize = (int)Math.round(20.0 * sizeModificator);
            vorRadialLabelFont = new Font("SansSerif", 1, fontSize);
            int n = lineWidth = paintVorDistance ? (int)Math.round(110.0 * sizeModificator) : (int)Math.round(60.0 * sizeModificator);
            if (prefix != null) {
                lineWidth += prefix.length() * fontSize;
            }
        }
        double crs = segment.getCourse() != null ? segment.getCourse() : 0.0;
        GpsPoint from = GpsUtil.getVectorCoords(wpRad + 2, crs);
        GpsPoint to = GpsUtil.getVectorCoords(wpRad + lineWidth, crs);
        g.setColor(SettingsBean.getInstance().getColorTheme().getVorRadialStrokeColor(isSelected, segment.getDiagonalDistance() != null));
        g.setStroke(new BasicStroke(5.0f));
        g.drawLine(x + (int)Math.round(from.getX()), y + (int)Math.round(from.getY()), (int)Math.round((double)x + to.getX()), (int)Math.round((double)y + to.getY()));
        if (includeOval) {
            g.fillOval(x - 5, y - 5, 11, 11);
        }
        g.setColor(SettingsBean.getInstance().getColorTheme().getVorRadialColor(isSelected, segment.getDiagonalDistance() != null));
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(x + (int)Math.round(from.getX()), y + (int)Math.round(from.getY()), (int)Math.round((double)x + to.getX()), (int)Math.round((double)y + to.getY()));
        if (includeOval) {
            g.fillOval(x - 5, y - 5, 11, 11);
        }
        double rotationAngle = crs >= 0.0 && crs <= 180.0 ? crs - 90.0 : crs - 270.0;
        double rotation = Math.toRadians(rotationAngle);
        double rotation2 = Math.toRadians(-rotationAngle);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            long dx;
            String txt;
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
            String string = txt = prefix != null ? prefix : "";
            if (segment.getCourse() != null) {
                double magRad = segment.getCourse();
                if (magvar != null && (magRad -= magvar.doubleValue()) < 0.0) {
                    magRad += 360.0;
                }
                txt = txt + FormatUtil.formattedCourse(magRad, false);
            } else {
                txt = txt + FormatUtil.formattedCourse(null, false);
            }
            if (paintVorDistance) {
                g.setFont(VOR_RADIAL_WITH_DISTANCES_LABEL_FONT);
                double distance = segment.getDiagonalDistance() != null ? segment.getDiagonalDistance() : segment.getDistance();
                if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                    distance = UnitUtil.recalculateDistance(distance, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
                }
                txt = txt + "/" + (double)Math.round(distance * 10.0) / 10.0;
            } else {
                g.setFont(vorRadialLabelFont);
            }
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(txt, g);
            long l = dx = crs >= 0.0 && crs <= 180.0 ? (long)x + Math.round((double)(lineWidth - (int)rect.getWidth()) / 2.0) + (long)wpRad : (long)(x - (int)rect.getWidth()) - Math.round((double)(lineWidth - (int)rect.getWidth()) / 2.0) - (long)wpRad;
            if (drawBackground) {
                int h = (int)Math.round(rect.getHeight());
                g.setColor(Color.YELLOW);
                g.fillRect(x, y - h, lineWidth, h);
            }
            GraphicsUtil.drawOutlinedString(g, (int)dx, y - 4, txt, vorRadialLabelFont, SettingsBean.getInstance().getColorTheme().getVorRadialColor(isSelected, segment.getDiagonalDistance() != null), SettingsBean.getInstance().getColorTheme().getVorRadialStrokeColor(isSelected, segment.getDiagonalDistance() != null), 3.0f);
            g.translate(x, y);
            g.rotate(rotation2);
            g.translate(-x, -y);
        }
    }

    public static void drawWaypoint(Graphics2D g, int x, int y, Color color, Color strokeColor) {
        if (strokeColor != null) {
            g.setColor(strokeColor);
            g.setStroke(new BasicStroke(5.0f));
            g.drawOval(x - 12, y - 12, 23, 23);
        }
        g.setColor(color);
        g.setStroke(new BasicStroke(3.0f));
        g.drawOval(x - 12, y - 12, 23, 23);
    }

    public static void drawHelipad(Graphics2D g, int x, int y, int size, Color color, Color strokeColor) {
        if (strokeColor != null) {
            g.setStroke(new BasicStroke(4.0f));
            g.setColor(strokeColor);
            GraphicsUtil.drawAirportShape(g, x, y, 9, null);
        }
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(color);
        GraphicsUtil.drawAirportShape(g, x, y, 9, null);
        GraphicsUtil.drawOutlinedCenteredString(g, "H", x, y + (int)Math.round((double)size / 2.0) - 1, HELIPAD_FONT, color, strokeColor, 2.0f);
    }

    public static void drawAirport(Graphics2D g, int x, int y, int size, Integer mainRwy, Color color, Color strokeColor) {
        if (strokeColor != null) {
            g.setStroke(new BasicStroke(4.0f));
            g.setColor(strokeColor);
            GraphicsUtil.drawAirportShape(g, x, y, size, mainRwy);
        }
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(color);
        GraphicsUtil.drawAirportShape(g, x, y, size, mainRwy);
    }

    public static void drawAirportShape(Graphics2D g, int x, int y, int size, Integer mainRwy) {
        if (mainRwy == null) {
            g.drawOval(x - size, y - size, size * 2 - 1, size * 2 - 1);
        } else {
            double rotation = Math.toRadians(mainRwy - 90);
            double rotation2 = Math.toRadians(-mainRwy.intValue() + 90);
            if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
                g.translate(x, y);
                g.rotate(rotation);
                g.translate(-x, -y);
                g.drawOval(x - size, y - size, size * 2 - 1, size * 2 - 1);
                int s = (int)Math.round((double)size * 1.25);
                g.drawLine(x - s, y, x + s - 1, y);
                g.translate(x, y);
                g.rotate(rotation2);
                g.translate(-x, -y);
            } else {
                g.drawOval(x - size, y - size, size * 2 - 1, size * 2 - 1);
            }
        }
    }

    public static BufferedImage createAnalyzerFrame(List<ExtConnectBean> userTrack, int maxHeight, int border) {
        return GraphicsUtil.createAnalyzerFrame(userTrack, maxHeight, border, 1);
    }

    public static BufferedImage createAnalyzerFrame(List<ExtConnectBean> userTrack, int maxHeight, int border, int zoomX) {
        if (userTrack.size() > 0) {
            int minHeight = Integer.MAX_VALUE;
            int height = Integer.MIN_VALUE;
            int gnd = 0;
            for (ExtConnectBean bean : userTrack) {
                gnd = bean.getUserAlt() != null ? Math.round(Math.max(bean.getGroundLevel(), bean.getUserAlt().floatValue())) : Math.round(bean.getGroundLevel());
                if (gnd < minHeight) {
                    minHeight = gnd;
                }
                if (gnd <= height) continue;
                height = gnd;
            }
            if (minHeight < 0) {
                height = -minHeight + height;
                minHeight = -minHeight;
            } else {
                minHeight = 0;
            }
            height = (int)Math.round((double)height * 1.25) + 1;
            int[] samples = new int[userTrack.size()];
            if (height > maxHeight) {
                double ratio = (double)height / (double)maxHeight;
                for (int i = 0; i < userTrack.size(); ++i) {
                    samples[i] = (short)Math.round(((double)userTrack.get(i).getGroundLevel() + (double)minHeight) / ratio);
                }
                height = (int)Math.round((double)height / ratio);
            } else {
                for (int i = 0; i < userTrack.size(); ++i) {
                    samples[i] = (short)Math.round(userTrack.get(i).getGroundLevel());
                }
            }
            int width = samples.length * zoomX;
            BufferedImage img = new BufferedImage(width + border * 2, height + border * 2, 13);
            Graphics2D g2d = img.createGraphics();
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.fillRect(0, 0, width + border * 2, height + border * 2);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(border, border, width, height);
            g2d.setColor(Color.BLACK);
            int idx = 0;
            int q = 0;
            for (int i = 0; i < samples.length * zoomX; i += zoomX) {
                for (q = 0; q < zoomX; ++q) {
                    g2d.drawLine(border + i + q, border + height, border + i + q, border + height - samples[idx]);
                }
                ++idx;
            }
            g2d.dispose();
            return img;
        }
        return null;
    }

    public static BufferedImage createImageFromSamples(short[] samples, int height, int border) {
        return GraphicsUtil.createImageFromSamples(samples, height, border, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage createImageFromSamples(short[] samples, int maxHeight, int border, int zoomX) {
        if (samples.length > 0) {
            short s;
            int i;
            int n = Integer.MAX_VALUE;
            int height = Integer.MIN_VALUE;
            for (i = 0; i < samples.length; ++i) {
                if (samples[i] < s) {
                    s = samples[i];
                }
                if (samples[i] <= height) continue;
                height = samples[i];
            }
            for (i = 0; i < FlightPlanBean.getInstance().getRoute().getPoints().size(); ++i) {
                GpsPlace point = FlightPlanBean.getInstance().getRoute().getPoints().get(i);
                if (point.getAlt() == null || !(point.getAlt() > (double)height)) continue;
                height = (int)Math.round(point.getAlt());
            }
            if (s < 0) {
                height = -s + height;
                short s2 = -s;
            } else {
                boolean bl = false;
            }
            height = (int)Math.round((double)height * 1.25) + 1;
            if (height > maxHeight) {
                double ratio = (double)height / (double)maxHeight;
                for (int i2 = 0; i2 < samples.length; ++i2) {
                    void var4_8;
                    samples[i2] = (short)Math.round((double)(samples[i2] + var4_8) / ratio);
                }
                height = (int)Math.round((double)height / ratio);
            } else if (height < maxHeight) {
                height = maxHeight;
            }
            int width = samples.length * zoomX;
            BufferedImage img = new BufferedImage(width + border * 2, height + border * 2, 13);
            Graphics2D g2d = img.createGraphics();
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.fillRect(0, 0, width + border * 2, height + border * 2);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(border, border, width, height);
            g2d.setColor(Color.BLACK);
            int idx = 0;
            int q = 0;
            for (int i3 = 0; i3 < samples.length * zoomX; i3 += zoomX) {
                for (q = 0; q < zoomX; ++q) {
                    g2d.drawLine(border + i3 + q, border + height, border + i3 + q, border + height - samples[idx]);
                }
                ++idx;
            }
            g2d.dispose();
            return img;
        }
        return null;
    }

    private static void drawMapShapeIndex(Graphics2D g, int i, int x, int y) {
        GraphicsUtil.drawBoxedString(g, x, y - 5, String.valueOf(i), MAP_SHAPE_INDEX_FONT, Color.BLACK, Color.WHITE, 2);
    }

    public static void drawMapShape(Graphics2D g, JXMapViewer map, MapShape area, boolean withIndices, Color color, Color backgroundColor, Stroke stroke, GpsArea visibleArea) {
        if (area.isPoly()) {
            GpsArea rectangleOver;
            int i;
            Point2D pt;
            if (backgroundColor != null) {
                MapShapeVertex[] vertices = null;
                vertices = area.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(map, area.getVertices(), 2) : area.getVertices();
                int fillSize = 0;
                for (int i2 = 0; i2 < vertices.length; ++i2) {
                    if (!vertices[i2].isVertex()) continue;
                    ++fillSize;
                }
                int[] px = new int[fillSize];
                int[] py = new int[fillSize];
                int q = 0;
                for (int i3 = 0; i3 < vertices.length; ++i3) {
                    if (!vertices[i3].isVertex()) continue;
                    GeoPosition gp = vertices[i3].getGeoPosition();
                    pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
                    px[q] = (int)pt.getX();
                    py[q] = (int)pt.getY();
                    ++q;
                }
                g.setColor(backgroundColor);
                g.fillPolygon(new Polygon(px, py, fillSize));
            }
            g.setFont(MAP_SHAPE_INDEX_FONT);
            for (i = 0; i < area.getVertices().length; ++i) {
                int nextIndex;
                MapShapeVertex vertex = area.getVertices()[i];
                int prevIndex = i - 1;
                if (prevIndex < 0) {
                    prevIndex = area.getVertices().length - 1;
                }
                if ((nextIndex = i + 1) > area.getVertices().length - 1) {
                    nextIndex = 0;
                }
                GeoPosition lastGp = area.getVertices()[prevIndex].getGeoPosition();
                GeoPosition gp = vertex.getGeoPosition();
                rectangleOver = new GpsArea(lastGp, gp);
                if (vertex.isVertex() && visibleArea != null && !rectangleOver.isInside(visibleArea) && !visibleArea.isInside(rectangleOver)) continue;
                Point2D lastPt = map.getTileFactory().geoToPixel(lastGp, map.getZoom());
                Point2D pt2 = map.getTileFactory().geoToPixel(gp, map.getZoom());
                int x0 = (int)pt2.getX();
                int y0 = (int)pt2.getY();
                int lastX = (int)lastPt.getX();
                int lastY = (int)lastPt.getY();
                g.setStroke(stroke);
                if (vertex.isVertex()) {
                    g.setColor(color);
                    g.drawLine(lastX, lastY, x0, y0);
                    continue;
                }
                if (vertex.isVertex()) continue;
                Point2D nextVertexPt = map.getTileFactory().geoToPixel(new GeoPosition(area.getVertices()[nextIndex].getLat(), area.getVertices()[nextIndex].getLon()), map.getZoom());
                int x2 = (int)nextVertexPt.getX();
                int y2 = (int)nextVertexPt.getY();
                double r1 = Math.sqrt((lastX - x0) * (lastX - x0) + (lastY - y0) * (lastY - y0));
                double r2 = Math.sqrt((x2 - x0) * (x2 - x0) + (y2 - y0) * (y2 - y0));
                double r = (r1 + r2) / 2.0;
                double x = (double)x0 - r;
                double y = (double)y0 - r;
                double[] arcInfo = AirspacesUtil.getArcInfo(area.getVertices()[prevIndex], vertex, area.getVertices()[nextIndex]);
                if (arcInfo == null) continue;
                Arc2D.Double arc2D = new Arc2D.Double(x, y, 2.0 * r, 2.0 * r, arcInfo[0], arcInfo[1], 0);
                g.setColor(color);
                g.draw(arc2D);
                if (withIndices && i < area.getVertices().length - 1) {
                    pt2 = map.getTileFactory().geoToPixel(area.getVertices()[i + 1].getGeoPosition(), map.getZoom());
                    GraphicsUtil.drawMapShapeIndex(g, i + 1, (int)pt2.getX(), (int)pt2.getY());
                }
                ++i;
            }
            if (withIndices) {
                for (i = 0; i < area.getVertices().length; ++i) {
                    int nextIndex;
                    MapShapeVertex vertex = area.getVertices()[i];
                    int prevIndex = i - 1;
                    if (prevIndex < 0) {
                        prevIndex = area.getVertices().length - 1;
                    }
                    if ((nextIndex = i + 1) > area.getVertices().length - 1) {
                        nextIndex = 0;
                    }
                    GeoPosition lastGp = area.getVertices()[prevIndex].getGeoPosition();
                    GeoPosition gp = vertex.getGeoPosition();
                    rectangleOver = new GpsArea(lastGp, gp);
                    if (vertex.isVertex() && visibleArea != null && !rectangleOver.isInside(visibleArea) && !visibleArea.isInside(rectangleOver)) continue;
                    pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
                    int x0 = (int)pt.getX();
                    int y0 = (int)pt.getY();
                    GraphicsUtil.drawMapShapeIndex(g, i + 1, x0, y0);
                }
            }
        } else if (area.isCircle()) {
            Point2D pt = map.getTileFactory().geoToPixel(area.getCircleCenter().geoPosition(), map.getZoom());
            double rad = MapUtil.calculateRadiusToPixels(map, area.getCircleCenter(), area.getRadius());
            Ellipse2D.Double shape = new Ellipse2D.Double(pt.getX() - rad + 1.0, pt.getY() - rad + 1.0, rad * 2.0 + 1.0, rad * 2.0 + 1.0);
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
                g.fill(shape);
            }
            g.setColor(color);
            g.setStroke(stroke);
            g.draw(shape);
        }
    }

    public static void drawUserPlaneTop(Graphics2D g, int x, int y, Float heading, int size, boolean withCross) {
        GraphicsUtil.drawUserPlaneTop(g, x, y, heading, size, withCross, Color.RED, Color.WHITE);
    }

    public static void drawUserPlaneTop(Graphics2D g, int x, int y, Float heading, int size, boolean withCross, Color color, Color strokeColor) {
        if (heading != null) {
            double rotation = Math.toRadians(heading.floatValue());
            double rotation2 = Math.toRadians(-heading.floatValue());
            if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
                g.setStroke(new BasicStroke(1.0f));
                g.translate(x, y);
                g.rotate(rotation);
                g.translate(-x, -y);
                g.setColor(color);
                GraphicsUtil.fillTriangle(g, x, y, size * 2 + 1, size * 3 + 1);
                g.setColor(strokeColor);
                GraphicsUtil.drawTriangle(g, x, y, size * 2 + 1, size * 3 + 1);
                g.translate(x, y);
                g.rotate(rotation2);
                g.translate(-x, -y);
            }
        } else {
            g.setColor(strokeColor);
            g.fillOval(x - size - 1, y - size - 1, size * 2 + 3, size * 2 + 3);
            g.setColor(color);
            g.fillOval(x - size, y - size, size * 2 + 1, size * 2 + 1);
        }
        if (withCross) {
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            g.drawLine(x - 2, y, x + 2, y);
            g.drawLine(x, y - 2, x, y + 2);
        }
    }

    public static void drawUserPlaneSide(Graphics2D g, int x, int y, Float pt, int size, boolean withCross) {
        double pitch = pt != null ? (double)pt.floatValue() : 0.0;
        double rotation = Math.toRadians(pitch + 90.0);
        double rotation2 = Math.toRadians(-(pitch + 90.0));
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            g.setStroke(new BasicStroke(1.0f));
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
            g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.65f));
            GraphicsUtil.fillHalfTriangle(g, x, y, size * 2 + 1, size * 3 + 1);
            g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.65f));
            GraphicsUtil.drawHalfTriangle(g, x, y, size * 2 + 1, size * 3 + 1);
            g.translate(x, y);
            g.rotate(rotation2);
            g.translate(-x, -y);
            if (withCross) {
                g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
                g.drawLine(x - 2, y, x + 2, y);
                g.drawLine(x, y - 2, x, y + 2);
            }
        }
    }

    public static void drawWindSymbol(Graphics2D g2d, int cx, int cy, double dir, short speedKt, int size, Color color, Color strokeColor) {
        GraphicsUtil.drawWindShape(g2d, cx, cy, dir, speedKt, size, 5, strokeColor);
        GraphicsUtil.drawWindShape(g2d, cx, cy, dir, speedKt, size, 3, color);
    }

    public static void drawWindShape(Graphics2D g2d, int cx, int cy, double dir, short speedKt, int size, int strokeSize, Color color) {
        dir = (dir %= 360.0) <= 180.0 ? (dir -= 180.0) : (dir += 180.0);
        double rotation = Math.toRadians(dir);
        double rotation2 = Math.toRadians(-dir);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            int halfSize = (int)Math.round((double)size / 2.0);
            int speedSize = (int)Math.round((double)size / 9.0);
            int speedStep = (int)Math.round((double)size / 12.0);
            g2d.translate(cx, cy);
            g2d.rotate(rotation);
            g2d.translate(-cx, -cy);
            g2d.setColor(color);
            g2d.setStroke(new BasicStroke(strokeSize));
            g2d.drawLine(cx, cy + halfSize, cx, cy - halfSize);
            if (speedKt > 5) {
                g2d.drawLine(cx, cy + halfSize, cx + speedSize * 2, cy + halfSize);
            }
            if (speedKt > 0 && speedKt <= 5 || speedKt > 10 && speedKt <= 15) {
                g2d.drawLine(cx, cy + halfSize - speedStep, cx + speedSize, cy + halfSize - speedStep);
            } else if (speedKt >= 20) {
                g2d.drawLine(cx, cy + halfSize - speedStep, cx + speedSize * 2, cy + halfSize - speedStep);
            }
            if (speedKt > 20) {
                for (int i = 2; i < 10; ++i) {
                    if (speedKt > i * 10 && speedKt <= i * 10 + 5) {
                        g2d.drawLine(cx, cy + halfSize - speedStep * i, cx + speedSize, cy + halfSize - speedStep * i);
                        continue;
                    }
                    if (speedKt <= i * 10 + 5) continue;
                    g2d.drawLine(cx, cy + halfSize - speedStep * i, cx + speedSize * 2, cy + halfSize - speedStep * i);
                }
            }
            g2d.translate(cx, cy);
            g2d.rotate(-rotation);
            g2d.translate(-cx, -cy);
        }
    }

    public static void drawWindArrow(Graphics2D g2d, int cx, int cy, int height, double dir, int size, Color color) {
        dir = (dir %= 360.0) <= 180.0 ? (dir -= 180.0) : (dir += 180.0);
        double rotation = Math.toRadians(dir);
        double rotation2 = Math.toRadians(-dir);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            g2d.translate(cx, cy);
            g2d.rotate(rotation);
            g2d.translate(-cx, -cy);
            g2d.setColor(color);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawLine(cx, height - 1 - size, cx, Math.round(cy / 2));
            int[] x = new int[3];
            int[] y = new int[3];
            x[0] = cx;
            y[0] = 1 + size;
            x[1] = (int)Math.round(1.125 * (double)cx);
            y[1] = Math.round(cy / 2) + size;
            x[2] = (int)Math.round(0.875 * (double)cx);
            y[2] = Math.round(cy / 2) + size;
            g2d.fillPolygon(new Polygon(x, y, 3));
            g2d.translate(cx, cy);
            g2d.rotate(-rotation);
            g2d.translate(-cx, -cy);
        }
    }

    public static void drawHintPopupWith(Graphics2D g, int posX, int posY, List<MouseCursorInfo> text, Color backgroundColor, Color borderColor) {
        int idx = 0;
        int maxSize = 0;
        for (int i = 0; i < text.size(); ++i) {
            if (text.get(i).getText().length() <= maxSize) continue;
            maxSize = text.get(i).getText().length();
            idx = i;
        }
        g.setStroke(new BasicStroke(1.0f));
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(text.get(idx).getText(), g);
        int height = (int)rect.getHeight() * text.size() + 8;
        GraphicsUtil.fillRectWithBorder(g, posX, posY, (int)rect.getWidth() + 10, height, backgroundColor, borderColor);
        for (int i = 0; i < text.size(); ++i) {
            if (text.get(i).getBackgroundColor() != null) {
                g.setColor(text.get(i).getBackgroundColor());
                g.fillRect(posX, posY + i * (int)rect.getHeight() + 5, (int)rect.getWidth() + 10, (int)rect.getHeight());
            }
            g.setColor(text.get(i).getColor());
            g.drawString(text.get(i).getText(), posX + 5, posY + (i + 1) * (int)rect.getHeight());
        }
    }

    public static void drawMagnifyingGlass(Graphics2D g, int mouseX, int mouseY, BufferedImage img, double containerWidth, double containerHeight) {
        int posX = mouseX + 30;
        int posY = mouseY;
        int height = img.getHeight();
        if ((double)(posX + img.getWidth() + 45) > containerWidth) {
            posX = mouseX - 30 - img.getWidth();
        }
        if (posX < 0) {
            posX = mouseX - Math.round(img.getWidth() / 2);
        }
        if ((double)(posY + height + 30) < containerHeight - 45.0) {
            posY = mouseY + 30;
        } else {
            posY = mouseY - height - 30;
            if (posY < 0) {
                posY = mouseY - Math.round(height / 2);
            }
        }
        g.setColor(Color.RED);
        g.drawRect(posX, posY, img.getWidth(), img.getHeight());
        g.drawImage((Image)img, posX, posY, null);
    }

    public static void drawHintPopupWithPosCorrection(Graphics2D g, int mouseX, int mouseY, List<MouseCursorInfo> text, Color backgroundColor, Color borderColor, double containerWidth, double containerHeight) {
        int idx = -1;
        int maxSize = 0;
        for (int i = 0; i < text.size(); ++i) {
            if (text.get(i).getText() == null || text.get(i).getText().length() <= maxSize) continue;
            maxSize = text.get(i).getText().length();
            idx = i;
        }
        if (idx >= 0) {
            g.setStroke(new BasicStroke(1.0f));
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(text.get(idx).getText(), g);
            int posX = mouseX + 20;
            int posY = mouseY;
            int height = (int)rect.getHeight() * text.size() + 8;
            if ((double)posX + rect.getWidth() + 35.0 > containerWidth) {
                posX = mouseX - 20 - (int)rect.getWidth();
            }
            if (posX < 0) {
                posX = mouseX - (int)Math.round(rect.getWidth() / 2.0);
            }
            if ((double)(posY + height + 20) < containerHeight - 35.0) {
                posY = mouseY + 20;
            } else {
                posY = mouseY - height - 20;
                if (posY < 0) {
                    posY = mouseY - Math.round(height / 2);
                }
            }
            GraphicsUtil.fillRectWithBorder(g, posX, posY, (int)rect.getWidth() + 10, height, backgroundColor, borderColor);
            for (int i = 0; i < text.size(); ++i) {
                if (text.get(i).getText() == null) continue;
                if (text.get(i).isBreakLine()) {
                    g.setColor(borderColor);
                    g.drawLine(posX, posY + i * (int)rect.getHeight() + 13, posX + (int)rect.getWidth() + 10, posY + i * (int)rect.getHeight() + 13);
                    continue;
                }
                if (text.get(i).getBackgroundColor() != null) {
                    g.setColor(text.get(i).getBackgroundColor());
                    g.fillRect(posX, posY + i * (int)rect.getHeight() + 5, (int)rect.getWidth() + 10, (int)rect.getHeight());
                }
                g.setColor(text.get(i).getColor());
                g.drawString(text.get(i).getText(), posX + 5, posY + (i + 1) * (int)rect.getHeight());
            }
        }
    }

    public static void fillRectWithBorder(Graphics2D g2d, int x, int y, int width, int height, Color color, Color borderColor) {
        g2d.setColor(borderColor);
        g2d.drawRect(x - 1, y - 1, width + 2, height + 2);
        g2d.setColor(color);
        g2d.fillRect(x, y, width, height);
    }

    public static void setRenderingHints(Graphics2D g2d, int level) {
        if (level == 2) {
            GraphicsUtil.setRenderingHintsLowQuality(g2d);
        } else if (level == 3) {
            GraphicsUtil.setRenderingHintsHighQuality(g2d);
        } else if (level == 1) {
            GraphicsUtil.setRenderingHintsTextAntialiasQuality(g2d);
        } else {
            GraphicsUtil.setRenderingHintsNormalQuality(g2d);
        }
    }

    public static void setRenderingHintsTextAntialiasQuality(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static void setRenderingHintsNormalQuality(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static void setRenderingHintsLowQuality(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public static void setRenderingHintsHighQuality(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static void fillOvalWithBorder(Graphics2D g2d, int x, int y, int width, int height, Color color, Color borderColor) {
        g2d.setColor(borderColor);
        g2d.fillOval(x - 1, y - 1, width + 2, height + 2);
        g2d.setColor(color);
        g2d.fillOval(x, y, width, height);
    }

    public static void drawRuler(Graphics2D g, JXMapViewer map, LineSegment segment) {
        GraphicsUtil.drawRuler(g, map, segment, true);
    }

    public static void drawRuler(Graphics2D g, JXMapViewer map, LineSegment segment, boolean withCircle) {
        if (segment.getCourse() != null) {
            double cruiseSpeed;
            GpsPoint from = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom()));
            GpsPoint to = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom()));
            g.setStroke(new BasicStroke(3.0f));
            g.setColor(SettingsBean.getInstance().getColorTheme().getMeasurmentLineBorderColor());
            g.drawLine((int)((Point2D)from).getX(), (int)((Point2D)from).getY(), (int)((Point2D)to).getX(), (int)((Point2D)to).getY());
            if (withCircle) {
                g.setStroke(new BasicStroke(1.0f, 0, 0, 3.0f, new float[]{5.0f}, 0.0f));
                int rad = (int)Math.round(Math.sqrt(Math.pow(((Point2D)from).getX() - ((Point2D)to).getX(), 2.0) + Math.pow(((Point2D)from).getY() - ((Point2D)to).getY(), 2.0)) / 2.0);
                int ox = (int)Math.round(((Point2D)from).getX() - (double)(rad * 2));
                int oy = (int)Math.round(((Point2D)from).getY() - (double)(rad * 2));
                g.drawOval(ox, oy, rad * 4, rad * 4);
            }
            g.setColor(SettingsBean.getInstance().getColorTheme().getMeasurmentLineColor());
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine((int)((Point2D)from).getX(), (int)((Point2D)from).getY(), (int)((Point2D)to).getX(), (int)((Point2D)to).getY());
            int cx = (int)Math.round(((Point2D)from).getX() + (((Point2D)to).getX() - ((Point2D)from).getX()) / 2.0);
            int cy = (int)Math.round(((Point2D)from).getY() + (((Point2D)to).getY() - ((Point2D)from).getY()) / 2.0);
            int rotOffset = segment.getCourse() >= 180.0 && segment.getCourse() < 360.0 ? 0 : 180;
            String unit = SettingsBean.getInstance().getMeasurementLineDistanceUnit();
            double distCalc = UnitUtil.recalculateDistance(segment.getDistance(), "nm", unit, false);
            String distCalcTxt = null;
            distCalcTxt = distCalc < 10.0 ? Double.toString((double)Math.round(distCalc * 1000.0) / 1000.0) : (distCalc < 100.0 ? Double.toString((double)Math.round(distCalc * 10.0) / 10.0) : Long.toString(Math.round(distCalc)));
            String distTxt = " " + distCalcTxt + unit;
            String crsTxt = "";
            double magCrs = GpsUtil.normalizeCourse(segment.getCourse() - VfrUtil.getMagneticDeclination(segment));
            crsTxt = crsTxt + SettingsBean.getInstance().getMagTrackPrefix() + FormatUtil.formattedCourse(magCrs, true) + " ";
            crsTxt = crsTxt + SettingsBean.getInstance().getTrueTrackPrefix() + FormatUtil.formattedCourse(segment.getCourse(), true);
            String timeTxt = null;
            String fuelTxt = null;
            if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null && (cruiseSpeed = FlightPlanBean.getInstance().getRoute().getCruiseSpeed().doubleValue()) > 0.0) {
                if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                    cruiseSpeed = UnitUtil.recalculateSpeed(cruiseSpeed, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
                }
                if (SettingsBean.getInstance().isCalculateRouteInRealTime() && FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null && FlightPlanBean.getInstance().getRoute().getWindDirection() != null && FlightPlanBean.getInstance().getRoute().getWindSpeed() != null) {
                    double windSpeed = FlightPlanBean.getInstance().getRoute().getWindSpeed();
                    if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                        windSpeed = UnitUtil.recalculateWindSpeed(windSpeed, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
                    }
                    cruiseSpeed = VfrUtil.calculateGSForWind(cruiseSpeed, segment.getCourse(), windSpeed, FlightPlanBean.getInstance().getRoute().getWindDirection());
                }
                long sec = Math.round(segment.getDistance() / cruiseSpeed * 3600.0);
                timeTxt = FormatUtil.formatTimeLandmark(sec);
                if (FlightPlanBean.getInstance().getRoute().getFuelBurn() != null) {
                    double fuelBurn = (double)Math.round(segment.getDistance() / cruiseSpeed * FlightPlanBean.getInstance().getRoute().getFuelBurn() * 10.0) / 10.0;
                    fuelTxt = fuelBurn >= 0.0 ? fuelBurn + SettingsBean.getInstance().getParamUnitsFuel() : "--";
                }
            }
            double rotation = Math.toRadians(segment.getCourse() + 90.0 + (double)rotOffset);
            double rotation2 = Math.toRadians(-segment.getCourse().doubleValue() - 90.0 - (double)rotOffset);
            if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
                g.translate(cx, cy);
                g.rotate(rotation);
                g.translate(-cx, -cy);
                g.setFont(MEASURMENT_LINE_CRS_LABEL_FONT);
                FontMetrics fm = g.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(crsTxt + distTxt, g);
                g.setFont(MEASURMENT_LINE_DIST_LABEL_FONT);
                Rectangle2D crsRect = fm.getStringBounds(crsTxt, g);
                g.setFont(MEASURMENT_LINE_CRS_LABEL_FONT);
                GraphicsUtil.drawBoxedString(g, cx - (int)Math.round(rect.getWidth() / 2.0) - 3, cy - 10, crsTxt, MEASURMENT_LINE_CRS_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getMeasurmentLineCrsLabelColor(), SettingsBean.getInstance().getColorTheme().getMeasurmentLineTextStrokeColor(), 2);
                g.setFont(MEASURMENT_LINE_CRS_LABEL_FONT);
                GraphicsUtil.drawBoxedString(g, cx + (int)crsRect.getWidth() - (int)Math.round(rect.getWidth() / 2.0) + 3, cy - 8, distTxt, MEASURMENT_LINE_DIST_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getMeasurmentLineDistLabelColor(), SettingsBean.getInstance().getColorTheme().getMeasurmentLineTextStrokeColor(), 2);
                if (timeTxt != null) {
                    String txt = timeTxt;
                    if (fuelTxt != null) {
                        txt = txt + "  " + fuelTxt;
                    }
                    g.setFont(MEASURMENT_LINE_TIME_FUEL_LABEL_FONT);
                    rect = fm.getStringBounds(txt, g);
                    GraphicsUtil.drawBoxedString(g, cx - (int)Math.round(rect.getWidth() / 2.0), cy + fm.getHeight() + 2, txt, MEASURMENT_LINE_TIME_FUEL_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getMeasurmentLineTimeFuelLabelColor(), SettingsBean.getInstance().getColorTheme().getMeasurmentLineTextStrokeColor(), 2);
                }
                g.translate(cx, cy);
                g.rotate(rotation2);
                g.translate(-cx, -cy);
            }
        }
    }

    public static void drawVectorInfo(Graphics2D g, JXMapViewer map, GpsPlace pos, RouteSegment segment) {
        if (segment != null && segment.getCourse() != null) {
            double cruiseSpeed;
            String timeTxt = null;
            String climbTxt = null;
            String targetAlt = null;
            if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null && (cruiseSpeed = FlightPlanBean.getInstance().getRoute().getCruiseSpeed().doubleValue()) > 0.0) {
                if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                    cruiseSpeed = UnitUtil.recalculateSpeed(cruiseSpeed, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
                }
                if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null && FlightPlanBean.getInstance().getRoute().getWindDirection() != null && FlightPlanBean.getInstance().getRoute().getWindSpeed() != null) {
                    double windSpeed = FlightPlanBean.getInstance().getRoute().getWindSpeed();
                    if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                        windSpeed = UnitUtil.recalculateWindSpeed(windSpeed, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
                    }
                    segment.setKz(VfrUtil.calculateWindCorectionAngle(cruiseSpeed, segment.getCourse(), windSpeed, FlightPlanBean.getInstance().getRoute().getWindDirection()));
                    cruiseSpeed = VfrUtil.calculateGSForWind(cruiseSpeed, segment.getCourse(), windSpeed, FlightPlanBean.getInstance().getRoute().getWindDirection());
                }
                long sec = Math.round(segment.getDistance() / cruiseSpeed * 3600.0);
                timeTxt = FormatUtil.formatTimeLandmark(sec);
                if (sec > 0L && segment.getFrom().getAlt() != null && segment.getTo().getAlt() != null) {
                    double min = segment.getDistance() / cruiseSpeed * 60.0;
                    double verticalSpeed = (segment.getTo().getAlt() - segment.getFrom().getAlt()) / min;
                    String string = climbTxt = verticalSpeed >= 0.0 ? "+" : "-";
                    if ("m".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                        verticalSpeed = UnitUtil.recalculateVerticalSpeed(verticalSpeed, "fpm", "m/s", false);
                        climbTxt = climbTxt + String.valueOf(NumberUtil.roundDouble(Math.abs(verticalSpeed), 1)) + "m/s";
                    } else {
                        climbTxt = climbTxt + String.valueOf(NumberUtil.roundDouble(Math.abs(verticalSpeed))) + "fpm";
                    }
                    int alt = NumberUtil.roundDouble(UnitUtil.recalculateAltitude(segment.getTo().getAlt(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
                    targetAlt = "(" + Messages.getInstance().get("sim_connect_vector_fpm_to_altitude") + " " + alt + SettingsBean.getInstance().getParamUnitsAltitude() + ")";
                }
            }
            double distCalc = UnitUtil.recalculateDistance(segment.getDistance(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            String distCalcTxt = Double.toString(NumberUtil.roundDouble(distCalc, 1));
            String distTxt = distCalcTxt + SettingsBean.getInstance().getParamUnitsDistance();
            String crsTxt = "";
            double magCrs = GpsUtil.normalizeCourse(segment.getCourse() - VfrUtil.getMagneticDeclination(segment));
            segment.setMagneticCourse(magCrs);
            Double km = segment.getKm();
            String prefix = SettingsBean.getInstance().getMagTrackPrefix();
            if (km != null) {
                magCrs = km;
                prefix = SettingsBean.getInstance().getMagHdgPrefix() + " ";
            }
            crsTxt = crsTxt + prefix + FormatUtil.formattedCourse(magCrs, true);
            ArrayList<MouseCursorInfo> text = new ArrayList<MouseCursorInfo>();
            if (!StringUtil.isEmpty(crsTxt)) {
                text.add(new MouseCursorInfo(null, null, crsTxt, Color.RED));
            }
            if (!StringUtil.isEmpty(distTxt)) {
                text.add(new MouseCursorInfo(null, null, distTxt, Color.BLUE));
            }
            if (!StringUtil.isEmpty(timeTxt)) {
                text.add(new MouseCursorInfo(null, null, timeTxt, Color.MAGENTA));
            }
            if (!StringUtil.isEmpty(climbTxt)) {
                text.add(new MouseCursorInfo(null, null, StringUtil.nullToEmpty(climbTxt), Color.BLACK));
                text.add(new MouseCursorInfo(null, null, StringUtil.nullToEmpty(targetAlt), Color.PINK));
            }
            GpsPoint center = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(pos.geoPosition(), map.getZoom()));
            int x = (int)Math.round(((Point2D)center).getX());
            int y = (int)Math.round(((Point2D)center).getY());
            g.setFont(new Font("SansSerif", 1, 14));
            GraphicsUtil.drawHintPopupWith(g, x, y, text, Color.YELLOW, Color.BLACK);
            GraphicsUtil.fillOvalWithBorder(g, x - 7, y - 7, 13, 13, Color.ORANGE, Color.BLACK);
        }
    }

    public static void drawVector(Graphics2D g, JXMapViewer map, LineSegment segment) {
        if (segment.getCourse() != null) {
            GpsPoint from = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom()));
            GpsPoint to = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom()));
            int toX = (int)((Point2D)to).getX();
            int toY = (int)((Point2D)to).getY();
            g.setStroke(new BasicStroke(3.0f, 0, 0, 3.0f, new float[]{5.0f}, 0.0f));
            g.setColor(SettingsBean.getInstance().getColorTheme().getVectorBorderColor());
            g.drawLine((int)((Point2D)from).getX(), (int)((Point2D)from).getY(), toX, toY);
            g.setColor(SettingsBean.getInstance().getColorTheme().getVectorColor());
            g.setStroke(new BasicStroke(1.0f, 0, 0, 3.0f, new float[]{5.0f}, 0.0f));
            g.drawLine((int)((Point2D)from).getX(), (int)((Point2D)from).getY(), toX, toY);
            double rotation = Math.toRadians(segment.getCourse());
            double rotation2 = Math.toRadians(-segment.getCourse().doubleValue());
            if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
                g.translate(toX, toY);
                g.rotate(rotation);
                g.translate(-toX, -toY);
                g.setStroke(new BasicStroke(1.0f));
                GraphicsUtil.fillTriangle(g, toX, toY + 7, 7);
                g.translate(toX, toY);
                g.rotate(rotation2);
                g.translate(-toX, -toY);
            }
        }
    }

    public static void drawGpsArea(Graphics2D g, JXMapViewer map, GpsArea area) {
        Point2D topLeft = map.getTileFactory().geoToPixel(area.getTopLeft().geoPosition(), map.getZoom());
        int tlX = (int)Math.round(topLeft.getX());
        int tlY = (int)Math.round(topLeft.getY());
        Point2D bottomRight = map.getTileFactory().geoToPixel(area.getBottomRight().geoPosition(), map.getZoom());
        int brX = (int)Math.round(bottomRight.getX());
        int brY = (int)Math.round(bottomRight.getY());
        g.fillRect(tlX, tlY, brX - tlX, brY - tlY);
    }

    public static void paintRotatedSelectionRectangle(Graphics2D g, JXMapViewer map, RotatedGpsArea selectionArea) {
        int i;
        Point2D[] points = new Point2D[]{MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(selectionArea.getTopLeft().geoPosition(), map.getZoom())), MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(selectionArea.getTopRight().geoPosition(), map.getZoom())), MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(selectionArea.getBottomRight().geoPosition(), map.getZoom())), MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(selectionArea.getBottomLeft().geoPosition(), map.getZoom()))};
        int[] px = new int[4];
        int[] py = new int[4];
        for (i = 0; i < 4; ++i) {
            px[i] = (int)Math.round(points[i].getX());
            py[i] = (int)Math.round(points[i].getY());
        }
        g.setColor(SELECTION_FILL_COLOR);
        g.fillPolygon(new Polygon(px, py, 4));
        g.setColor(SELECTION_STROKE_COLOR);
        g.setStroke(new BasicStroke(3.0f));
        for (i = 1; i < 4; ++i) {
            g.drawLine(px[i - 1], py[i - 1], px[i], py[i]);
        }
        g.drawLine(px[3], py[3], px[0], py[0]);
    }

    public static void paintSelectionRectangle(Graphics2D g, JXMapViewer map, GpsArea selectionArea, boolean withTextInfo) {
        GpsPoint from = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(selectionArea.getTopLeft().geoPosition(), map.getZoom()));
        GpsPoint to = MapUtil.getMapPosition(map, map.getTileFactory().geoToPixel(selectionArea.getBottomRight().geoPosition(), map.getZoom()));
        g.setColor(SELECTION_FILL_COLOR);
        g.fillRect((int)((Point2D)from).getX() + 3, (int)((Point2D)from).getY() + 3, (int)(((Point2D)to).getX() - ((Point2D)from).getX() - 5.0), (int)(((Point2D)to).getY() - ((Point2D)from).getY() - 5.0));
        g.setColor(SELECTION_STROKE_COLOR);
        g.setStroke(new BasicStroke(3.0f));
        g.drawRect((int)((Point2D)from).getX() + 1, (int)((Point2D)from).getY() + 1, (int)(((Point2D)to).getX() - ((Point2D)from).getX() - 1.0), (int)(((Point2D)to).getY() - ((Point2D)from).getY() - 1.0));
        if (withTextInfo) {
            double width = (GpsUtil.getDistance(selectionArea.getTopLeft(), selectionArea.getTopRight()) + GpsUtil.getDistance(selectionArea.getBottomLeft(), selectionArea.getBottomRight())) / 2.0;
            double height = (GpsUtil.getDistance(selectionArea.getTopLeft(), selectionArea.getBottomLeft()) + GpsUtil.getDistance(selectionArea.getTopRight(), selectionArea.getBottomRight())) / 2.0;
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                width = UnitUtil.recalculateDistance(width, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
                height = UnitUtil.recalculateDistance(height, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            }
            String txt = NumberUtil.roundDouble(width, 1) + SettingsBean.getInstance().getParamUnitsDistance() + " x " + NumberUtil.roundDouble(height, 1) + SettingsBean.getInstance().getParamUnitsDistance();
            g.setFont(SELECTION_LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D fontRect = fm.getStringBounds(txt, g);
            int ax = (int)Math.round((((Point2D)from).getX() + ((Point2D)to).getX()) / 2.0 - fontRect.getWidth() / 2.0);
            int ay = (int)Math.round((((Point2D)from).getY() + ((Point2D)to).getY()) / 2.0);
            g.setColor(SELECTION_LABEL_BACKGROUND_COLOR);
            g.fillRect(ax - 5, ay - 5, (int)fontRect.getWidth() + 10, (int)fontRect.getHeight() + 5);
            g.setColor(Color.WHITE);
            g.drawString(txt, ax, ay + (int)Math.round(fontRect.getHeight() / 2.0));
        }
    }

    public static BufferedImage rotateImage(BufferedImage img, double angle) {
        BufferedImage rotImg = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = rotImg.createGraphics();
        GraphicsUtil.setRenderingHintsHighQuality(g2d);
        AffineTransform old = g2d.getTransform();
        g2d.translate((double)img.getWidth() / 2.0, (double)img.getHeight() / 2.0);
        g2d.rotate(Math.toRadians(angle));
        g2d.translate((double)(-img.getWidth()) / 2.0, (double)(-img.getHeight()) / 2.0);
        g2d.drawImage(img, old, null);
        g2d.dispose();
        return rotImg;
    }

    public static void paintCompassRose(BufferedImage img, double rotationAngle, Double magneticDeclination, double sizeModificator, int location) {
        Graphics2D g = img.createGraphics();
        GraphicsUtil.setRenderingHintsHighQuality(g);
        if (sizeModificator < 0.5) {
            sizeModificator = 0.5;
        }
        int x = 0;
        int y = 0;
        if (1 == location) {
            x = (int)Math.round((double)img.getWidth() - 90.0 * sizeModificator);
            y = (int)Math.round(90.0 * sizeModificator);
        } else if (3 == location) {
            x = (int)Math.round((double)img.getWidth() - 90.0 * sizeModificator);
            y = (int)Math.round((double)img.getHeight() - 90.0 * sizeModificator);
        } else if (2 == location) {
            x = (int)Math.round(90.0 * sizeModificator);
            y = (int)Math.round((double)img.getHeight() - 90.0 * sizeModificator);
        } else {
            x = (int)Math.round(90.0 * sizeModificator);
            y = (int)Math.round(90.0 * sizeModificator);
        }
        int size = (int)Math.round(50.0 * sizeModificator);
        int thickness = (int)Math.ceil(2.0 * sizeModificator);
        g.setStroke(new BasicStroke(thickness));
        int fontSize = (int)Math.round(8.0 * sizeModificator);
        g.setFont(new Font("SansSerif", 1, fontSize));
        if (magneticDeclination != null) {
            double rotation = Math.toRadians(rotationAngle);
            double rotation3 = Math.toRadians(magneticDeclination);
            double rotation4 = Math.toRadians(90.0);
            double rotation2 = Math.toRadians(-rotationAngle - magneticDeclination - 90.0);
            if (!(Double.isNaN(rotation) || Double.isNaN(rotation2) || Double.isNaN(rotation3) || Double.isNaN(rotation4))) {
                g.translate(x, y);
                g.rotate(rotation);
                g.translate(-x, -y);
                g.setColor(Color.RED);
                GraphicsUtil.drawArrowAtCenter(g, x, y, size, Math.round(size / 15));
                g.drawString("N", (int)Math.round((double)x - g.getFontMetrics().getStringBounds("N", g).getWidth() / 2.0), (int)Math.round((double)y - (double)size / 2.0 - (double)fontSize));
                g.translate(x + fontSize * 2, y);
                g.rotate(rotation3);
                g.translate(-x - fontSize * 2, -y);
                g.setColor(Color.GRAY);
                GraphicsUtil.drawArrowAtCenter(g, x + fontSize * 2, y, size, Math.round(size / 15));
                g.translate(x + fontSize * 2, y);
                g.rotate(rotation4);
                g.translate(-x - fontSize * 2, -y);
                String txt = "VAR " + NumberUtil.roundDouble(magneticDeclination, 1) + "\u00b0";
                g.drawString(txt, x + fontSize * 2 - (int)Math.round(g.getFontMetrics().getStringBounds(txt, g).getWidth() / 2.0), magneticDeclination < 0.0 ? y + fontSize + thickness : y - thickness);
                g.translate(x + fontSize * 2, y);
                g.rotate(rotation2);
                g.translate(-x - fontSize * 2, -y);
            }
        } else {
            double rotation = Math.toRadians(rotationAngle);
            double rotation2 = Math.toRadians(-rotationAngle);
            if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
                g.translate(x, y);
                g.rotate(rotation);
                g.translate(-x, -y);
                g.setColor(Color.RED);
                GraphicsUtil.drawArrowAtCenter(g, x, y, size, Math.round(size / 15));
                g.drawString("N", (int)Math.round((double)x - g.getFontMetrics().getStringBounds("N", g).getWidth() / 2.0), (int)Math.round((double)y - (double)size / 2.0 - (double)fontSize));
                g.translate(x, y);
                g.rotate(rotation2);
                g.translate(-x, -y);
            }
        }
        g.dispose();
    }

    public static void paintScale(Graphics2D g, VfrMapViewer map) {
        int pos;
        double scaleStepPrec;
        double scaleStep;
        GpsPlace scEndPlace;
        Rectangle bounds = map.getViewportBounds();
        GpsPoint scStart = new GpsPoint(50.0, bounds.getHeight() - 50.0);
        GpsPoint scEnd = new GpsPoint(300.0, bounds.getHeight() - 50.0);
        GpsPlace scStartPlace = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, scStart.getX(), scStart.getY()), map.getZoom()).gpsPlace();
        double scaleDistance = UnitUtil.recalculateDistance(GpsUtil.getDistance(scStartPlace, scEndPlace = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, scEnd.getX(), scEnd.getY()), map.getZoom()).gpsPlace()), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
        if (scaleDistance > 200.0) {
            scaleStep = 100.0;
            scaleStepPrec = 1.0;
        } else if (scaleDistance > 20.0) {
            scaleStep = 10.0;
            scaleStepPrec = 1.0;
        } else if (scaleDistance > 2.0) {
            scaleStep = 1.0;
            scaleStepPrec = 1.0;
        } else if (scaleDistance > 0.2) {
            scaleStep = 0.1;
            scaleStepPrec = 10.0;
        } else if (scaleDistance > 0.02) {
            scaleStep = 0.01;
            scaleStepPrec = 100.0;
        } else {
            scaleStep = 0.001;
            scaleStepPrec = 1000.0;
        }
        double scaleStepsNum = (int)Math.floor(scaleDistance / scaleStep);
        double scaleStepWidth = 250.0 / scaleDistance * scaleStep;
        if (scaleStepWidth < 50.0) {
            int multiplier = (int)Math.ceil(50.0 / scaleStepWidth);
            scaleStepWidth *= (double)multiplier;
            scaleStep *= (double)multiplier;
            scaleStepsNum = (int)Math.ceil(scaleStepsNum / (double)multiplier);
        }
        g.setFont(SCALE_FONT);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(SettingsBean.getInstance().getColorTheme().getMapScaleBorderColor());
        g.setStroke(new BasicStroke(4.0f));
        g.drawLine((int)scStart.getX(), (int)scStart.getY(), (int)Math.round(scStart.getX() + scaleStepWidth * scaleStepsNum), (int)scEnd.getY());
        int i = 0;
        while ((double)i <= scaleStepsNum) {
            pos = (int)Math.round(scStart.getX() + (double)i * scaleStepWidth);
            g.drawLine(pos, (int)scStart.getY() - 10, pos, (int)scStart.getY());
            ++i;
        }
        g.setColor(SettingsBean.getInstance().getColorTheme().getMapScaleColor());
        g.setStroke(new BasicStroke(2.0f));
        i = 0;
        while ((double)i <= scaleStepsNum) {
            pos = (int)Math.round(scStart.getX() + (double)i * scaleStepWidth);
            g.drawLine(pos, (int)scStart.getY() - 10, pos, (int)scStart.getY());
            if (i == 0 || (double)i == scaleStepsNum) {
                String txt = null;
                txt = scaleStepPrec > 1.0 ? String.valueOf((double)Math.round((double)i * scaleStep * scaleStepPrec) / scaleStepPrec) + SettingsBean.getInstance().getParamUnitsDistance() : String.valueOf(Math.round((double)i * scaleStep)) + SettingsBean.getInstance().getParamUnitsDistance();
                Rectangle2D rect = fm.getStringBounds(txt, g);
                g.drawString(txt, (int)((double)pos - rect.getWidth() / 2.0), (int)scStart.getY() - 10 - 10);
            }
            ++i;
        }
        g.drawLine((int)scStart.getX(), (int)scStart.getY(), (int)Math.round(scStart.getX() + scaleStepWidth * scaleStepsNum), (int)scEnd.getY());
    }

    public static Cursor createCursorFromImage(BufferedImage img) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (img != null) {
            return toolkit.createCustomCursor(img, new Point(Math.round(img.getWidth() / 2), Math.round(img.getHeight() / 2)), null);
        }
        return null;
    }

    public static BufferedImage enlargeImage(BufferedImage img, double ratio) {
        return GraphicsUtilities.convertToBufferedImage(img.getScaledInstance((int)Math.round((double)img.getWidth() * ratio), (int)Math.round((double)img.getHeight() * ratio), 2));
    }

    public static BufferedImage drawCrossOnImage(BufferedImage img) {
        int w = (int)Math.floor((double)img.getWidth() / 2.0) + 1;
        int h = (int)Math.floor((double)img.getHeight() / 2.0) + 1;
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.75f));
        g.drawLine(w, 0, w, h * 2 + 1);
        g.drawLine(0, h, w * 2 + 1, h);
        g.dispose();
        return bi;
    }

    public static Color getColorAt(JPanel panel, int x, int y) {
        Dimension d = panel.getSize();
        int sx = x - 1;
        int sy = y - 1;
        if (sx < 0 || sy < 0 || (double)(sx + 2 + 1) > d.getWidth() || (double)(sy + 2 + 1) > d.getHeight()) {
            return null;
        }
        BufferedImage bi = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
        Graphics2D g = bi.createGraphics();
        panel.paint(g);
        g.dispose();
        int clr = bi.getRGB(x, y);
        int red = (clr & 0xFF0000) >> 16;
        int green = (clr & 0xFF00) >> 8;
        int blue = clr & 0xFF;
        return new Color(red, green, blue);
    }

    public static BufferedImage createImageFromPanel(JPanel panel, int x, int y, int w, int h) {
        Dimension d = panel.getSize();
        int sx = x - w;
        int sy = y - h;
        if (sx < 0 || sy < 0 || (double)(sx + w * 2 + 1) > d.getWidth() || (double)(sy + h * 2 + 1) > d.getHeight()) {
            return null;
        }
        BufferedImage bi = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
        Graphics2D g = bi.createGraphics();
        panel.paint(g);
        g.dispose();
        BufferedImage img = bi.getSubimage(sx, sy, w * 2 + 1, h * 2 + 1);
        BufferedImage copyOfImage = new BufferedImage(w * 2 + 1, h * 2 + 1, 2);
        Graphics2D g2 = copyOfImage.createGraphics();
        g2.drawImage((Image)img, 0, 0, null);
        g2.dispose();
        return copyOfImage;
    }

    public static Cursor getCursor(String path) {
        return GraphicsUtil.createCursorFromImage(UrlUtil.readImageFromDisk(path));
    }

    public static Cursor getRotatedCursor(String path, double angle) {
        BufferedImage img = UrlUtil.readImageFromDisk(path);
        if (img != null) {
            return GraphicsUtil.createCursorFromImage(GraphicsUtil.rotateImage(img, angle));
        }
        return null;
    }

    public static void drawPolygon(Graphics2D g, JXMapViewer map, GeoPosition[] points, Color color) {
        int[] px = new int[points.length];
        int[] py = new int[points.length];
        int q = 0;
        for (int i = 0; i < points.length; ++i) {
            Point2D pt = map.getTileFactory().geoToPixel(points[i], map.getZoom());
            px[q] = (int)pt.getX();
            py[q] = (int)pt.getY();
            ++q;
        }
        g.setColor(color);
        g.fillPolygon(new Polygon(px, py, points.length));
    }

    public static void drawMSA(Graphics2D g, int x, int y, String txt, Color elevColor, Color elevStrokeColor, boolean smallFont) {
        g.setFont(smallFont ? ELEVATION_LABEL_SMALL_FONT : ELEVATION_LABEL_FONT);
        FontMetrics fm = g.getFontMetrics();
        String prefix = txt.substring(0, txt.length() - 1);
        String lastChar = String.valueOf(txt.charAt(txt.length() - 1));
        Rectangle2D rect = fm.getStringBounds(prefix, g);
        if (elevStrokeColor == null) {
            g.setColor(elevColor);
            g.drawString(prefix, (int)((double)x - rect.getWidth()), y);
            g.setFont(smallFont ? ELEVATION_LABEL_SMALL_FONT2 : ELEVATION_LABEL_FONT2);
            g.drawString(lastChar, x, y - 5);
        } else {
            GraphicsUtil.drawOutlinedString(g, (int)Math.round((double)x - rect.getWidth()), y, prefix, smallFont ? ELEVATION_LABEL_SMALL_FONT : ELEVATION_LABEL_FONT, elevColor, elevStrokeColor, 3.0f);
            GraphicsUtil.drawOutlinedString(g, x, y - 5, lastChar, smallFont ? ELEVATION_LABEL_SMALL_FONT2 : ELEVATION_LABEL_FONT2, elevColor, elevStrokeColor, 2.5f);
        }
    }

    public static ImageIcon getResizedIcon(String iconPath, double ratio) {
        Image img = new ImageIcon(iconPath).getImage();
        Image newimg = img.getScaledInstance((int)Math.round((double)img.getWidth(null) * ratio), (int)Math.round((double)img.getHeight(null) * ratio), 4);
        return new ImageIcon(newimg);
    }

    public static void drawVorLineRadial(Graphics2D g, JXMapViewer map, LineSegment r, boolean drawInvertedRadial) {
        GpsPlace vor = r.getFrom();
        Point2D point = MapUtil.getPointPostionFromGpsPlace(map, r.getTo());
        int x = (int)point.getX();
        int y = (int)point.getY();
        Point2D v = MapUtil.getPointPostionFromGpsPlace(map, vor);
        int vx = (int)v.getX();
        int vy = (int)v.getY();
        int sx = (int)Math.round((double)vx - 2.5 * (double)(x - vx));
        int sy = (int)Math.round((double)vy - 2.5 * (double)(y - vy));
        int ex = (int)Math.round((double)x - 2.0 * (double)(vx - x));
        int ey = (int)Math.round((double)y - 2.0 * (double)(vy - y));
        g.setStroke(new BasicStroke(5.0f));
        g.setColor(new Color(0.0f, 1.0f, 0.0f, 0.5f));
        g.drawLine(sx, sy, ex, ey);
        int rotOffset = r.getCourse() >= 180.0 && r.getCourse() < 360.0 ? 0 : 180;
        double rotation = Math.toRadians(r.getCourse() + 90.0 + (double)rotOffset);
        double rotation2 = Math.toRadians(-r.getCourse().doubleValue() - 90.0 - (double)rotOffset);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            String str = vor.getName() + " " + FormatUtil.formatRadial(r, true);
            Rectangle2D rect = g.getFontMetrics().getStringBounds(str, g);
            GpsPoint delta = GpsUtil.getVectorCoords(25.0 + rect.getWidth(), r.getCourse());
            int cx = (int)Math.round((double)x - delta.getX());
            int cy = (int)Math.round((double)y - delta.getY());
            g.translate(cx, cy);
            g.rotate(rotation);
            g.translate(-cx, -cy);
            GraphicsUtil.drawBoxedString(g, cx - (int)Math.round(rect.getWidth() / 2.0), cy + 5, str, RADIAL_FONT, Color.BLACK, Color.WHITE, 2, Color.BLACK);
            g.translate(cx, cy);
            g.rotate(rotation2);
            g.translate(-cx, -cy);
        }
    }
}

