/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.util.List;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;

public class GpxUtil {
    private static final Logger log = Logger.getLogger(GpxUtil.class);

    public static boolean saveGpxFile(List<ExtConnectBean> userTrack, String destinationFile) {
        String plan = GpxUtil.getGpxFlightPlan(userTrack);
        if (plan != null) {
            return IOUtil.saveTextFile(plan, destinationFile);
        }
        return plan != null;
    }

    private static String getGpxFlightPlan(List<ExtConnectBean> userTrack) {
        if (userTrack == null || userTrack.size() == 0 || userTrack.get(0).getTimestamp() == null) {
            log.error("Invalid userTrack data");
            return null;
        }
        long startMillis = userTrack.get(0).getTimestamp();
        StringBuilder result = new StringBuilder();
        result.append("<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:gpxx=\"http://www.garmin.com/xmlschemas/GpxExtensions/v3\" xmlns:gpxtpx=\"http://www.garmin.com/xmlschemas/TrackPointExtension/v1\" creator=\"VfrFlight\" version=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd http://www.garmin.com/xmlschemas/GpxExtensions/v3 http://www.garmin.com/xmlschemas/GpxExtensionsv3.xsd http://www.garmin.com/xmlschemas/TrackPointExtension/v1 http://www.garmin.com/xmlschemas/TrackPointExtensionv1.xsd\">" + Constants.EOL);
        result.append("<metadata>" + Constants.EOL);
        result.append("<link href=\"http://www.garmin.com\">" + Constants.EOL);
        result.append("<text>Garmin International</text>" + Constants.EOL);
        result.append("</link>" + Constants.EOL);
        result.append("<time>" + FormatUtil.formatIso8601Date(startMillis) + "</time>" + Constants.EOL);
        result.append("</metadata>" + Constants.EOL);
        result.append("<trk>" + Constants.EOL);
        result.append("<name>VfrFlight GPX export</name>" + Constants.EOL);
        result.append("<trkseg>" + Constants.EOL);
        for (ExtConnectBean bean : userTrack) {
            if (bean.getUserAlt() == null) continue;
            double elevInM = UnitUtil.recalculateAltitude(bean.getUserAlt().doubleValue(), "ft", "m", false);
            result.append("<trkpt lat=\"" + bean.getUserLat() + "\" lon=\"" + bean.getUserLon() + "\">" + Constants.EOL);
            result.append("<ele>" + elevInM + "</ele>" + Constants.EOL);
            result.append("<time>" + FormatUtil.formatIso8601Date(bean.getTimestamp()) + "</time>" + Constants.EOL);
            result.append("</trkpt>" + Constants.EOL);
        }
        result.append("</trkseg>" + Constants.EOL);
        result.append("</trk>" + Constants.EOL);
        result.append("</gpx>" + Constants.EOL);
        return result.toString();
    }
}

