/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import com.grum.geocalc.Coordinate;
import com.grum.geocalc.DegreeCoordinate;
import com.grum.geocalc.EarthCalc;
import com.grum.geocalc.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.comparator.EnRouteDistanceComparator;
import main.java.guru.vfrflight.core.gps.GpsArc;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class GpsUtil {
    private static final double NM_to_ft = 6076.11549;

    public static LineSegment getLineSegment(GpsPlace from, GpsPlace to) {
        return GpsUtil.getLineSegment(from, to, false);
    }

    public static LineSegment getLineSegment(GpsPlace from, GpsPlace to, boolean diagonal) {
        Point pointFrom = new Point((Coordinate)new DegreeCoordinate(from.getLat().getValue()), (Coordinate)new DegreeCoordinate(from.getLon().getValue()));
        Point pointTo = new Point((Coordinate)new DegreeCoordinate(to.getLat().getValue()), (Coordinate)new DegreeCoordinate(to.getLon().getValue()));
        double distance = UnitUtil.recalculateDistance(EarthCalc.getVincentyDistance((Point)pointFrom, (Point)pointTo), "m", "nm", false);
        Double course = null;
        if (distance > 0.0) {
            course = (EarthCalc.getVincentyBearing((Point)pointFrom, (Point)pointTo) + EarthCalc.getVincentyFinalBearing((Point)pointFrom, (Point)pointTo)) / 2.0;
        }
        LineSegment segment = new LineSegment(from, to, distance, course);
        if (diagonal && from.getAlt() != null && to.getAlt() != null) {
            double altNM = Math.abs(to.getAlt() - from.getAlt()) / 6076.11549;
            segment.setDiagonalDistance(Math.sqrt(Math.pow(distance, 2.0) + Math.pow(altNM, 2.0)));
        }
        return segment;
    }

    public static double getInitialVincentyCourse(GpsPlace from, GpsPlace to) {
        Point pointFrom = new Point((Coordinate)new DegreeCoordinate(from.getLat().getValue()), (Coordinate)new DegreeCoordinate(from.getLon().getValue()));
        Point pointTo = new Point((Coordinate)new DegreeCoordinate(to.getLat().getValue()), (Coordinate)new DegreeCoordinate(to.getLon().getValue()));
        return EarthCalc.getVincentyBearing((Point)pointFrom, (Point)pointTo);
    }

    public static double getFinalVincentyCourse(GpsPlace from, GpsPlace to) {
        Point pointFrom = new Point((Coordinate)new DegreeCoordinate(from.getLat().getValue()), (Coordinate)new DegreeCoordinate(from.getLon().getValue()));
        Point pointTo = new Point((Coordinate)new DegreeCoordinate(to.getLat().getValue()), (Coordinate)new DegreeCoordinate(to.getLon().getValue()));
        return EarthCalc.getVincentyFinalBearing((Point)pointFrom, (Point)pointTo);
    }

    public static double getCourse(GpsPlace from, GpsPlace to) {
        Point pointFrom = new Point((Coordinate)new DegreeCoordinate(from.getLat().getValue()), (Coordinate)new DegreeCoordinate(from.getLon().getValue()));
        Point pointTo = new Point((Coordinate)new DegreeCoordinate(to.getLat().getValue()), (Coordinate)new DegreeCoordinate(to.getLon().getValue()));
        return (EarthCalc.getVincentyBearing((Point)pointFrom, (Point)pointTo) + EarthCalc.getVincentyFinalBearing((Point)pointFrom, (Point)pointTo)) / 2.0;
    }

    public static GpsPlace getPointPositionByDistanceAndBearing(GpsPlace from, double bearing, double distanceNm) {
        Point pointFrom = new Point((Coordinate)new DegreeCoordinate(from.getLat().getValue()), (Coordinate)new DegreeCoordinate(from.getLon().getValue()));
        Point resultPoint = EarthCalc.pointRadialDistance((Point)pointFrom, (double)bearing, (double)UnitUtil.recalculateDistance(distanceNm, "nm", "m", false));
        return new GpsPlace(resultPoint.getLatitude(), resultPoint.getLongitude());
    }

    public static double getDistance(GpsPlace from, GpsPlace to) {
        Point pointFrom = new Point((Coordinate)new DegreeCoordinate(from.getLat().getValue()), (Coordinate)new DegreeCoordinate(from.getLon().getValue()));
        Point pointTo = new Point((Coordinate)new DegreeCoordinate(to.getLat().getValue()), (Coordinate)new DegreeCoordinate(to.getLon().getValue()));
        try {
            return UnitUtil.recalculateDistance(EarthCalc.getVincentyDistance((Point)pointFrom, (Point)pointTo), "m", "nm", false);
        }
        catch (IllegalStateException e) {
            return UnitUtil.recalculateDistance(EarthCalc.getHarvesineDistance((Point)pointFrom, (Point)pointTo), "m", "nm", false);
        }
    }

    public static double getGreatCircleDistance(GpsPlace from, GpsPlace to) {
        double dist = Math.toDegrees(Math.acos(Math.sin(from.getLat().getRadians()) * Math.sin(to.getLat().getRadians()) + Math.cos(from.getLat().getRadians()) * Math.cos(to.getLat().getRadians()) * Math.cos(Math.abs(from.getLon().getRadians() - to.getLon().getRadians())))) * 60.0;
        return Double.isNaN(dist) ? 0.0 : dist;
    }

    public static double getTotalDistance(List<LineSegment> segments) {
        double totalDistance = 0.0;
        for (LineSegment segment : segments) {
            totalDistance += segment.getOrCalculateDistance();
        }
        return totalDistance;
    }

    public static double getTotalPointsDistance(List<GpsPlace> points) {
        double totalDistance = 0.0;
        for (int i = 1; i < points.size(); ++i) {
            totalDistance += GpsUtil.getDistance(points.get(i - 1), points.get(i));
        }
        return totalDistance;
    }

    public static double nmToKm(double nm) {
        return nm * 1.852;
    }

    public static GpsCoord parseStringCoord(String value) {
        if (value == null) {
            return null;
        }
        Integer deg = null;
        Integer min = null;
        Double sec = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\u00b0') {
                try {
                    deg = Integer.parseInt(sb.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sb = new StringBuilder();
                continue;
            }
            if (value.charAt(i) == '\'') {
                try {
                    min = Integer.parseInt(sb.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sb = new StringBuilder();
                continue;
            }
            if (value.charAt(i) == '\"') {
                try {
                    sec = Double.parseDouble(sb.toString());
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            sb.append(value.charAt(i));
        }
        if (deg != null && (value.indexOf("S") >= 0 || value.indexOf("W") >= 0)) {
            deg = -deg.intValue();
        }
        return deg != null && min != null && sec != null ? new GpsCoord(deg, min, sec) : null;
    }

    public static GpsArea getCircleArea(GpsPlace center, double radius) {
        ArrayList<GpsVertex> points = new ArrayList<GpsVertex>();
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(center, 0.0, radius));
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(center, 90.0, radius));
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(center, 180.0, radius));
        points.add(GpsUtil.getPointPositionByDistanceAndBearing(center, 270.0, radius));
        return GpsUtil.getRectangleOverVertices(points);
    }

    public static GpsPlace[] convertArcToPolygon(JXMapViewer map, MapShapeVertex vertex, double crsStart, double crsEnd, int segments) {
        GpsPlace arcMiddle = vertex.getGpsPlace();
        double radiusInNm = vertex.getRadius();
        Point2D arcMiddlePt = map.getTileFactory().geoToPixel(arcMiddle.geoPosition(), map.getZoom());
        double radiusInPixels = MapUtil.calculateRadiusToPixels(map, arcMiddle, radiusInNm);
        double crsStep = 0.0;
        crsStep = vertex.isClockwise() ? (crsEnd > crsStart ? (crsEnd - crsStart) / (double)segments : (crsEnd + 360.0 - crsStart) / (double)segments) : (crsEnd > crsStart ? -(crsStart + 360.0 - crsEnd) / (double)segments : -(crsStart - crsEnd) / (double)segments);
        GpsPlace[] result = new GpsPlace[segments + 1];
        for (int i = 0; i <= segments; ++i) {
            double deltaCrs = crsStart + crsStep * (double)i;
            if (deltaCrs < 0.0) {
                deltaCrs += 360.0;
            } else if (deltaCrs > 360.0) {
                deltaCrs -= 360.0;
            }
            GpsPoint vectorCoordsPt = GpsUtil.getVectorCoords(radiusInPixels, deltaCrs);
            result[i] = map.getTileFactory().pixelToGeo(new GpsPoint(arcMiddlePt.getX() + vectorCoordsPt.getX(), arcMiddlePt.getY() + vectorCoordsPt.getY()), map.getZoom()).gpsPlace();
        }
        return result;
    }

    public static GpsPoint getVectorCoords(double r, double crs) {
        double gamma = Math.toRadians(crs % 90.0);
        double dx = 0.0;
        double dy = 0.0;
        if (crs >= 0.0 && crs < 90.0) {
            dx = r * Math.sin(gamma);
            dy = -r * Math.cos(gamma);
        } else if (crs >= 90.0 && crs < 180.0) {
            dx = r * Math.cos(gamma);
            dy = r * Math.sin(gamma);
        } else if (crs >= 180.0 && crs < 270.0) {
            dx = -r * Math.sin(gamma);
            dy = r * Math.cos(gamma);
        } else if (crs >= 270.0 && crs < 360.0) {
            dx = -r * Math.cos(gamma);
            dy = -r * Math.sin(gamma);
        }
        return new GpsPoint(dx, dy);
    }

    public static GpsPoint getPointOnSegment(Point2D wp1, Point2D wp2, GpsPoint point) {
        return GpsUtil.getPointOnSegment(wp1, wp2, point, true);
    }

    public static GpsPlace getGpsPlaceOnSegment(JXMapViewer map, LineSegment segment, GpsPlace point) {
        return GpsUtil.getGpsPlaceOnSegment(map, segment.getFrom(), segment.getTo(), point, false);
    }

    public static GpsPlace getGpsPlaceOnSegment(JXMapViewer map, GpsPlace from, GpsPlace to, GpsPlace meshCenter, boolean checkIsBetween) {
        Point2D wp1 = map.getTileFactory().geoToPixel(from.geoPosition(), map.getZoom());
        Point2D wp2 = map.getTileFactory().geoToPixel(to.geoPosition(), map.getZoom());
        Point2D point = map.getTileFactory().geoToPixel(meshCenter.geoPosition(), map.getZoom());
        GpsPoint closestPoint = GpsUtil.getPointOnSegment(wp1, wp2, new GpsPoint(point.getX(), point.getY()), checkIsBetween);
        return map.getTileFactory().pixelToGeo(closestPoint, map.getZoom()).gpsPlace();
    }

    public static GpsPoint getPointOnSegment(Point2D wp1, Point2D wp2, GpsPoint point, boolean checkIsBetween) {
        double px = point.getX();
        double py = point.getY();
        if (!checkIsBetween || point.isBetween(wp1, wp2)) {
            double ax = wp1.getX();
            double ay = wp1.getY();
            double bx = wp2.getX();
            double by = wp2.getY();
            if (by != ay && bx != ax) {
                double a = (by - ay) / (bx - ax);
                double b = ay - a * ax;
                double a2 = -1.0 / a;
                double b2 = py - a2 * px;
                double x = (b2 - b) / (a - a2);
                double y = a * x + b;
                return new GpsPoint(x, y);
            }
            if (by == ay && bx != ax) {
                return new GpsPoint(px, ay);
            }
            if (by != ay && bx == ax) {
                return new GpsPoint(ax, py);
            }
        }
        return null;
    }

    public static GpsPoint getPointOnLine(Point2D point, double a, double b) {
        double a2 = -1.0 / a;
        double b2 = point.getY() - a2 * point.getX();
        double x = (b2 - b) / (a - a2);
        double y = a * x + b;
        return new GpsPoint(x, y);
    }

    public static LineSegment getVorRadial(GpsPlace vor, GpsPlace place) {
        LineSegment segment = GpsUtil.getLineSegment(vor, place, true);
        if (vor.getMagvar() != null && segment.getCourse() != null) {
            segment.setMagneticCourse(GpsUtil.normalizeCourse(Math.round(segment.getCourse() - vor.getMagvar())));
        }
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            segment.setDistance(UnitUtil.recalculateDistance(segment.getDistance(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            if (segment.getDiagonalDistance() != null) {
                segment.setDiagonalDistance(UnitUtil.recalculateDistance(segment.getDiagonalDistance(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            }
        }
        return segment;
    }

    public static List<GpsPlace> getPointsEnRoute(LineSegment segment, boolean atWPs, boolean middleSements, Double stepDistance) {
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>();
        segments.add(segment);
        return GpsUtil.getPointsEnRoute(segments, atWPs, middleSements, stepDistance);
    }

    public static List<GpsPlace> getPointsEnRoute(List<LineSegment> segments, int num) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        double dist = 0.0;
        for (LineSegment segment : segments) {
            dist += GpsUtil.getDistance(segment.getFrom(), segment.getTo());
        }
        double stepDistance = dist / (double)(num - 1);
        results.add(segments.get(0).getFrom());
        double distCountForStep = 0.0;
        for (int i = 0; i < segments.size(); ++i) {
            LineSegment segment = segments.get(i);
            if (!((distCountForStep += segment.getDistance().doubleValue()) >= stepDistance)) continue;
            int loops = (int)Math.floor(distCountForStep / stepDistance);
            double offset = stepDistance - distCountForStep + segment.getDistance();
            for (int q = 0; q < loops; ++q) {
                double distNM = offset + (double)q * stepDistance;
                GpsPlace place = MapFrame.getInstance().getPointOnSegment(segment, distNM);
                results.add(place);
                distCountForStep -= stepDistance;
            }
        }
        if (results.size() - 1 == num) {
            results.add(segments.get(segments.size() - 1).getTo());
        }
        return results;
    }

    public static List<GpsPlace> getPointsEnRoute(List<LineSegment> segments, boolean atWPs, boolean middleSements, Double stepDistance) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        double totalDistance = 0.0;
        if (stepDistance != null) {
            double distCountForStep = 0.0;
            if (!atWPs) {
                GpsPlace place = segments.get(0).getFrom();
                place.setDataDouble("dist", 0.0);
                results.add(place);
            }
            for (int i = 0; i < segments.size(); ++i) {
                LineSegment segment = segments.get(i);
                if ((distCountForStep += segment.getDistance().doubleValue()) >= stepDistance) {
                    int loops = (int)Math.floor(distCountForStep / stepDistance);
                    double offset = stepDistance - distCountForStep + segment.getDistance();
                    for (int q = 0; q < loops; ++q) {
                        double distNM = offset + (double)q * stepDistance;
                        GpsPlace place = MapFrame.getInstance().getPointOnSegment(segment, distNM);
                        place.setDataDouble("dist", distNM + totalDistance);
                        results.add(place);
                        distCountForStep -= stepDistance.doubleValue();
                    }
                }
                totalDistance += segment.getDistance().doubleValue();
            }
            if (!atWPs) {
                GpsPlace place = segments.get(segments.size() - 1).getTo();
                place.setDataDouble("dist", totalDistance);
                results.add(place);
            }
        }
        if (atWPs || middleSements) {
            if (atWPs) {
                GpsPlace place = segments.get(0).getFrom();
                place.setDataDouble("dist", 0.0);
                results.add(place);
            }
            totalDistance = 0.0;
            for (LineSegment segment : segments) {
                GpsPlace middle;
                if (middleSements && (middle = MapFrame.getInstance().getPointOnSegment(segment, segment.getDistance() / 2.0)) != null) {
                    middle.setDataDouble("dist", totalDistance + segment.getDistance() / 2.0);
                    results.add(middle);
                }
                if (atWPs) {
                    GpsPlace place = segment.getTo();
                    place.setDataDouble("dist", totalDistance + segment.getDistance());
                    results.add(place);
                }
                totalDistance += segment.getDistance().doubleValue();
            }
        }
        Collections.sort(results, new EnRouteDistanceComparator());
        return results;
    }

    public static GpsArea getRectangleOverVertices(List<GpsVertex> vertices) {
        double minLat = 500.0;
        double minLon = 500.0;
        double maxLat = -500.0;
        double maxLon = -500.0;
        for (GpsVertex vertex : vertices) {
            if (vertex.isVertex()) {
                if (vertex.getLat().getValue() <= minLat) {
                    minLat = vertex.getLat().getValue();
                }
                if (vertex.getLon().getValue() <= minLon) {
                    minLon = vertex.getLon().getValue();
                }
                if (vertex.getLat().getValue() >= maxLat) {
                    maxLat = vertex.getLat().getValue();
                }
                if (!(vertex.getLon().getValue() >= maxLon)) continue;
                maxLon = vertex.getLon().getValue();
                continue;
            }
            if (!vertex.isArc()) continue;
            GpsArc arc = (GpsArc)vertex;
            GpsArea rectOver = GpsUtil.getCircleArea(arc.getCenter(), arc.getRadius());
            if (rectOver.getMinLat() <= minLat) {
                minLat = rectOver.getMinLat();
            }
            if (rectOver.getMinLon() <= minLon) {
                minLon = rectOver.getMinLon();
            }
            if (rectOver.getMaxLat() >= maxLat) {
                maxLat = rectOver.getMaxLat();
            }
            if (!(rectOver.getMaxLon() >= maxLon)) continue;
            maxLon = rectOver.getMaxLon();
        }
        return new GpsArea(maxLat, minLon, minLat, maxLon);
    }

    public static List<GpsVertex> getPointsFromSegments(List<LineSegment> segments) {
        ArrayList<GpsVertex> points = new ArrayList<GpsVertex>();
        points.add(segments.get(0).getFrom());
        for (int i = 0; i < segments.size(); ++i) {
            points.add(segments.get(i).getTo());
        }
        return points;
    }

    public static GpsArea getRectangleOverSegments(List<LineSegment> segments) {
        return GpsUtil.getRectangleOverVertices(GpsUtil.getPointsFromSegments(segments));
    }

    public static List<GpsArea> divideSegmentToAreas(LineSegment segment, int count) {
        return GpsUtil.divideSegmentToAreas(segment, count, null);
    }

    public static List<GpsArea> divideSegmentToAreas(LineSegment segment, int count, Double expandValue) {
        LinkedList<GpsArea> areaList = new LinkedList<GpsArea>();
        List<LineSegment> segments = GpsUtil.divideSegment(segment, count);
        for (int i = 0; i < segments.size(); ++i) {
            if (expandValue == null) {
                areaList.add(segments.get(i).getRectangleOver());
                continue;
            }
            GpsArea area = segments.get(i).getRectangleOver();
            area.expand(expandValue);
            areaList.add(area);
        }
        return areaList;
    }

    public static List<LineSegment> divideSegment(LineSegment segment, int count) {
        LinkedList<LineSegment> segments = new LinkedList<LineSegment>();
        List<GpsPlace> points = GpsUtil.divideSegmentToPoints(segment, count + 1);
        for (int i = 0; i < points.size() - 1; ++i) {
            segments.add(new LineSegment(points.get(i), points.get(i + 1)));
        }
        return segments;
    }

    public static List<GpsPlace> divideSegmentsListToPoints(List<LineSegment> segments, int count) {
        if (segments == null) {
            return null;
        }
        ArrayList<GpsPlace> result = new ArrayList<GpsPlace>(count);
        double totalLength = GpsUtil.getTotalDistance(segments);
        for (int i = 0; i < segments.size() - 1; ++i) {
            LineSegment segment = segments.get(i);
            int num = (int)Math.round(segment.getOrCalculateDistance() / totalLength);
            result.addAll(GpsUtil.divideSegmentToPoints(segment, num));
        }
        result.addAll(GpsUtil.divideSegmentToPoints(segments.get(segments.size() - 1), count - result.size()));
        return result;
    }

    public static List<GpsPlace> divideSegmentToPoints(LineSegment segment, int count) {
        ArrayList<GpsPlace> points = new ArrayList<GpsPlace>();
        double latStep = (segment.getTo().getLat().getValue() - segment.getFrom().getLat().getValue()) / (double)(count - 1);
        double lonStep = (segment.getTo().getLon().getValue() - segment.getFrom().getLon().getValue()) / (double)(count - 1);
        VfrMapViewer mapViewer = MapFrame.getInstance().getMapViewer();
        points.add(segment.getFrom().clone());
        for (int i = 1; i < count; ++i) {
            double lat = segment.getFrom().getLat().getValue() + latStep * (double)i;
            double lon = segment.getFrom().getLon().getValue() + lonStep * (double)i;
            GpsPlace place = new GpsPlace(new GpsCoord(lat), new GpsCoord(lon));
            Point2D point = mapViewer.getTileFactory().geoToPixel(place.geoPosition(), mapViewer.getZoom());
            GpsPoint p = mapViewer.getPointOnSegment(segment, new GpsPoint(point.getX(), point.getY()));
            place = mapViewer.getTileFactory().pixelToGeo(p, mapViewer.getZoom()).gpsPlace();
            mapViewer.getTileFactory().geoToPixel(place.geoPosition(), mapViewer.getZoom());
            points.add(place);
        }
        return points;
    }

    public static double increaseLat(double lat, double val) {
        double result = lat + val;
        if (result > 90.0) {
            result -= 90.0;
        } else if (result < -90.0) {
            result += 180.0;
        }
        return result;
    }

    public static double increaseLon(double lon, double val) {
        double result = lon + val;
        if (result > 180.0) {
            result -= 180.0;
        } else if (result < -180.0) {
            result += 360.0;
        }
        return result;
    }

    public static Double calculateClimbRate(GpsPlace from, GpsPlace to, Double gs, boolean inFpm) {
        if (from.getAlt() == null || to.getAlt() == null || gs == null) {
            return null;
        }
        double dist = GpsUtil.getDistance(from, to);
        double eta = dist / gs * 60.0;
        double altDiff = to.getAlt() - from.getAlt();
        if (!inFpm) {
            eta *= 60.0;
        }
        return altDiff / eta;
    }

    public static Double calculateClimbAngle(GpsPlace from, GpsPlace to) {
        return GpsUtil.calculateClimbAngle(from, to, false);
    }

    public static Double calculateClimbAngle(GpsPlace from, GpsPlace to, boolean roundUp) {
        if (from.getAlt() == null || to.getAlt() == null) {
            return null;
        }
        double dist = GpsUtil.getDistance(from, to);
        double altDiff = UnitUtil.recalculateAltitude(to.getAlt() - from.getAlt(), "ft", "nm", false);
        return roundUp ? (double)Math.round(Math.toDegrees(Math.atan(altDiff / dist))) : Math.toDegrees(Math.atan(altDiff / dist));
    }

    public static double getLonDistance(GpsArea area) {
        return (GpsUtil.getDistance(area.getTopLeft(), area.getTopRight()) + GpsUtil.getDistance(area.getBottomLeft(), area.getBottomRight())) / 2.0;
    }

    public static double getLatDistance(GpsArea area) {
        return (GpsUtil.getDistance(area.getTopLeft(), area.getBottomLeft()) + GpsUtil.getDistance(area.getTopRight(), area.getBottomRight())) / 2.0;
    }

    public static double normalizeCourseRelativeToNorth(double crs) {
        if ((crs %= 360.0) > 180.0 && crs < 360.0) {
            return -360.0 + crs;
        }
        return crs;
    }

    public static GpsPlace getCenter(List<GpsPlace> points) {
        if (points.size() == 0) {
            return null;
        }
        if (points.size() == 1) {
            return points.get(0);
        }
        double lat = 0.0;
        double lon = 0.0;
        for (GpsPlace place : points) {
            lat += place.getLat().getValue();
            lon += place.getLon().getValue();
        }
        return new GpsPlace(new GpsCoord(lat / (double)points.size()), new GpsCoord(lon / (double)points.size()));
    }

    public static double normalizeLatitude(double lat) {
        if (lat < 0.0) {
            while ((lat += 360.0) < 0.0) {
            }
        }
        if (lat > 90.0 && (lat = 180.0 - lat % 360.0) < -90.0) {
            lat = GpsUtil.normalizeLatitude(lat);
        }
        return lat;
    }

    public static double normalizeLongitude(double lon) {
        if (lon < 0.0) {
            while ((lon += 360.0) < 0.0) {
            }
        }
        if (lon > 180.0 && (lon = lon % 360.0 - 360.0) < -180.0) {
            lon = GpsUtil.normalizeLongitude(lon);
        }
        return lon;
    }

    public static int normalizeRunwayNumber(int number) {
        if (number > 36) {
            number -= 36;
        } else if (number < 1) {
            number += 36;
        }
        return number;
    }

    public static int getSecondaryRunwayNumber(int primaryNumber) {
        if (primaryNumber == 18) {
            return 36;
        }
        if (primaryNumber == 36 || primaryNumber == 0) {
            return 18;
        }
        return (primaryNumber + 18) % 36;
    }

    public static int getPrimaryRwyNumberFromHeading(double heading) {
        return GpsUtil.normalizeRunwayNumber((int)Math.round(heading / 10.0));
    }

    public static int getSecondaryRwyNumberFromHeading(double heading) {
        return GpsUtil.normalizeRunwayNumber(GpsUtil.getPrimaryRwyNumberFromHeading(heading) + 18);
    }

    public static double normalizeCourse(double crs) {
        if (crs < 0.0) {
            while ((crs += 360.0) < 0.0) {
            }
        } else if (crs >= 360.0) {
            return crs % 360.0;
        }
        return crs;
    }

    public static RotatedGpsArea rotateGpsArea(JXMapViewer map, RotatedGpsArea area, double angle) {
        double rotation = Math.toRadians(angle);
        if (!Double.isNaN(rotation)) {
            Point2D topLeft = map.getTileFactory().geoToPixel(area.getTopLeft().geoPosition(), map.getZoom());
            Point2D topRight = map.getTileFactory().geoToPixel(area.getTopRight().geoPosition(), map.getZoom());
            Point2D bottomLeft = map.getTileFactory().geoToPixel(area.getBottomLeft().geoPosition(), map.getZoom());
            Point2D bottomRight = map.getTileFactory().geoToPixel(area.getBottomRight().geoPosition(), map.getZoom());
            double x = (topLeft.getX() + bottomRight.getX()) / 2.0;
            double y = (topLeft.getY() + bottomRight.getY()) / 2.0;
            Point2D topLeftPt = null;
            Point2D topRightPt = null;
            Point2D bottomLeftPt = null;
            Point2D bottomRightPt = null;
            AffineTransform transform = new AffineTransform();
            transform.translate(x, y);
            transform.rotate(rotation);
            transform.translate(-x, -y);
            topLeftPt = transform.transform(topLeft, topLeftPt);
            topRightPt = transform.transform(topRight, topRightPt);
            bottomLeftPt = transform.transform(bottomLeft, bottomLeftPt);
            bottomRightPt = transform.transform(bottomRight, bottomRightPt);
            GpsPlace topLeftPlace = map.getTileFactory().pixelToGeo(topLeftPt, map.getZoom()).gpsPlace();
            GpsPlace topRightPlace = map.getTileFactory().pixelToGeo(topRightPt, map.getZoom()).gpsPlace();
            GpsPlace bottomLeftPlace = map.getTileFactory().pixelToGeo(bottomLeftPt, map.getZoom()).gpsPlace();
            GpsPlace bottomRightPlace = map.getTileFactory().pixelToGeo(bottomRightPt, map.getZoom()).gpsPlace();
            return new RotatedGpsArea(topLeftPlace, topRightPlace, bottomLeftPlace, bottomRightPlace, area.getAngle() + angle);
        }
        return null;
    }

    public static double getAngleBetweenCourses(double crs1, double crs2) {
        if ((crs1 = GpsUtil.normalizeCourse(crs1)) < (crs2 = GpsUtil.normalizeCourse(crs2))) {
            crs1 += 360.0;
        }
        return crs1 - crs2;
    }

    public static double normalizeDirection(double dir) {
        if ((dir = GpsUtil.normalizeCourse(dir)) >= 180.0) {
            dir -= 360.0;
        }
        return dir;
    }

    public static boolean isClockwise(double a, double b) {
        if ((a = GpsUtil.normalizeCourse(a)) < (b = GpsUtil.normalizeCourse(b))) {
            return true;
        }
        a = GpsUtil.normalizeDirection(a);
        b = GpsUtil.normalizeDirection(b);
        return NumberUtil.doubleGreaterThanZero(b -= a);
    }

    public static double denormalizeDirection(double dir) {
        if (dir < 0.0) {
            dir += 360.0;
        }
        return GpsUtil.normalizeCourse(dir);
    }

    public static GeoPosition[] calculateBoundaryForLineSegment(LineSegment lineSegment, double widthInNm, int stepDegrees) {
        int i;
        LinkedList<GeoPosition> boundary = new LinkedList<GeoPosition>();
        for (i = 90; i <= 270; i += stepDegrees) {
            boundary.add(GpsUtil.getPointPositionByDistanceAndBearing(lineSegment.getFrom(), GpsUtil.normalizeCourse(lineSegment.getCourse() + (double)i), widthInNm).geoPosition());
        }
        for (i = -90; i <= 90; i += stepDegrees) {
            boundary.add(GpsUtil.getPointPositionByDistanceAndBearing(lineSegment.getTo(), GpsUtil.normalizeCourse(lineSegment.getCourse() + (double)i), widthInNm).geoPosition());
        }
        return boundary.toArray(new GeoPosition[boundary.size()]);
    }

    public static Double getNavigationalWindDir(Double windDir) {
        if (windDir == null) {
            return null;
        }
        double navDir = GpsUtil.normalizeCourse(windDir);
        navDir = navDir <= 180.0 ? (navDir += 180.0) : (navDir -= 180.0);
        return navDir;
    }

    public static boolean hasSkewedRunway(double trueHeading, double secondaryTrueHeading, double ilsHeading, boolean singleIls) {
        boolean primary;
        int diffSecondary;
        int diffPrimary = (int)Math.round(GpsUtil.getAngleBetweenCourses(trueHeading, ilsHeading)) % 360;
        if (diffPrimary > 180) {
            diffPrimary = 360 - diffPrimary;
        }
        if ((diffSecondary = (int)Math.round(GpsUtil.getAngleBetweenCourses(secondaryTrueHeading, ilsHeading)) % 360) > 180) {
            diffSecondary = 360 - diffSecondary;
        }
        boolean bl = primary = diffPrimary < diffSecondary;
        if (singleIls) {
            if (primary && diffPrimary >= 5) {
                return true;
            }
            return !primary && diffSecondary >= 5;
        }
        return primary && diffPrimary >= 5 && diffPrimary <= 60 || !primary && diffSecondary >= 5 && diffSecondary <= 60;
    }

    public static Double getInvertedCourse(Double course) {
        if (course == null) {
            return null;
        }
        return GpsUtil.normalizeCourse(course + 180.0);
    }
}

