/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.ElevationArray;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.comparator.AirspaceAreaAltitudeComparator;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.gl.GlAirspace;
import main.java.guru.vfrflight.core.gl.GlAirspaceMesh;
import main.java.guru.vfrflight.core.gl.GlColor;
import main.java.guru.vfrflight.core.gl.GlColorPoint;
import main.java.guru.vfrflight.core.gl.GlColorTriangle;
import main.java.guru.vfrflight.core.gl.GlColorTriangleMesh;
import main.java.guru.vfrflight.core.gl.GlLineStroke;
import main.java.guru.vfrflight.core.gl.GlNamedPoint;
import main.java.guru.vfrflight.core.gl.GlPoint;
import main.java.guru.vfrflight.core.gl.GlPointTransformer;
import main.java.guru.vfrflight.core.gl.GlTriangle;
import main.java.guru.vfrflight.core.gl.GlTriangleMesh;
import main.java.guru.vfrflight.core.gl.GlVector;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.poly2tri.Poly2Tri;
import org.poly2tri.geometry.polygon.Polygon;
import org.poly2tri.geometry.polygon.PolygonPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;

public class GlUtil {
    public static GlNamedPoint[] transformRoute(GlPointTransformer transformer, List<RoutePlace> points) {
        GlNamedPoint[] result = new GlNamedPoint[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            double alt;
            double d = alt = points.get(i).getAlt() != null ? points.get(i).getAlt() : 0.0;
            if (!"m".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                alt = UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
            }
            result[i] = new GlNamedPoint(transformer.getPoint((float)points.get(i).getLon().getValue(), (float)points.get(i).getLat().getValue(), (float)alt), points.get(i).getName());
        }
        return result;
    }

    public static GlColorPoint[] transformUserTrack(GlPointTransformer transformer, GpsArea area, List<ExtConnectBean> userTrack, float groundAltitudeOffset) {
        ArrayList<GlColorPoint> result = new ArrayList<GlColorPoint>();
        for (int i = 0; i < userTrack.size(); ++i) {
            if (!area.contains(userTrack.get(i).getUserLat().floatValue(), userTrack.get(i).getUserLon().floatValue())) continue;
            float alt = (float)UnitUtil.recalculateAltitude(userTrack.get(i).getUserAlt().floatValue(), "ft", "m", false);
            Color color = Color.WHITE;
            if (userTrack.get(i).getUserAltAboveTerrain() != null) {
                color = SettingsBean.getInstance().getColorTheme().getTrackColor(userTrack.get(i).getUserAltAboveTerrain().floatValue() + groundAltitudeOffset);
            }
            result.add(new GlColorPoint(transformer.getPoint(userTrack.get(i).getUserLon().floatValue(), userTrack.get(i).getUserLat().floatValue(), alt), color));
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new GlColorPoint[result.size()]);
    }

    public static GlAirspace[] transformAirspaces(GlPointTransformer transformer, List<AirspaceAreaDTO> airspaces) {
        Collections.sort(airspaces, new AirspaceAreaAltitudeComparator());
        LinkedList<GlAirspace> result = new LinkedList<GlAirspace>();
        for (AirspaceAreaDTO a : airspaces) {
            float bottomAlt = 0.0f;
            float topAlt = 50000.0f;
            if (a.getBottomAltitude() != null) {
                bottomAlt = (float)UnitUtil.recalculateAltitude(a.getBottomAltitude().intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
            }
            if (a.getTopAltitude() != null) {
                topAlt = (float)UnitUtil.recalculateAltitude(a.getTopAltitude().intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
            }
            MapShapeVertex[] vertices = null;
            vertices = a.isCircle() ? AirspacesUtil.convertCircleAirspaceToPolygon(a, 5) : (a.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(MapFrame.getInstance().getMapViewer(), a.getVertices(), 5) : a.getVertices());
            if (vertices == null || vertices.length <= 0) continue;
            GlColor color = new GlColor(SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceColor(a.getType()));
            GlLineStroke lineStroke = SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceGlLineStroke(a.getType());
            GlAirspace airspace = new GlAirspace(color, lineStroke);
            airspace.setTop(new GlPoint[vertices.length]);
            airspace.setBottom(new GlPoint[vertices.length]);
            for (int i = 0; i < vertices.length; ++i) {
                MapShapeVertex v = vertices[i];
                airspace.getTop()[i] = transformer.getPoint(v.getLon().floatValue(), v.getLat().floatValue(), topAlt);
                airspace.getBottom()[i] = transformer.getPoint(v.getLon().floatValue(), v.getLat().floatValue(), bottomAlt);
            }
            airspace.setId(a.getId());
            airspace.setName(AirspacesUtil.formatAirspaceAreaName(a, false));
            airspace.setAirspaceMesh(GlUtil.transformAirspace2Mesh(transformer, a));
            result.add(airspace);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new GlAirspace[result.size()]);
    }

    public static GlAirspaceMesh transformAirspace2Mesh(GlPointTransformer transformer, AirspaceAreaDTO airspace) {
        float bottomAlt = 0.0f;
        float topAlt = 50000.0f;
        if (airspace.getBottomAltitude() != null) {
            bottomAlt = (float)UnitUtil.recalculateAltitude(airspace.getBottomAltitude().intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
        }
        if (airspace.getTopAltitude() != null) {
            topAlt = (float)UnitUtil.recalculateAltitude(airspace.getTopAltitude().intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false);
        }
        MapShapeVertex[] vertices = null;
        vertices = airspace.isCircle() ? AirspacesUtil.convertCircleAirspaceToPolygon(airspace, 5) : (airspace.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(MapFrame.getInstance().getMapViewer(), airspace.getVertices(), 5) : airspace.getVertices());
        if (vertices != null && vertices.length > 0) {
            GlAirspaceMesh mesh = new GlAirspaceMesh();
            mesh.setBottomMesh(GlUtil.createSurfaceMesh(transformer, vertices, bottomAlt));
            mesh.setTopMesh(GlUtil.createSurfaceMesh(transformer, vertices, topAlt));
            mesh.setSidesMesh(GlUtil.createSidesMesh(transformer, vertices, bottomAlt, topAlt));
            return mesh;
        }
        return null;
    }

    private static GlTriangleMesh createSidesMesh(GlPointTransformer transformer, MapShapeVertex[] vertices, float bottomAlt, float topAlt) {
        GlTriangle[] glTriangles = new GlTriangle[vertices.length * 2];
        int prev = vertices.length - 1;
        int idx = 0;
        int i = 0;
        while (i < vertices.length) {
            GlPoint v1 = transformer.getPoint(vertices[prev].getLon().floatValue(), vertices[prev].getLat().floatValue(), topAlt);
            GlPoint v2 = transformer.getPoint(vertices[i].getLon().floatValue(), vertices[i].getLat().floatValue(), topAlt);
            GlPoint v3 = transformer.getPoint(vertices[i].getLon().floatValue(), vertices[i].getLat().floatValue(), bottomAlt);
            GlPoint v4 = transformer.getPoint(vertices[prev].getLon().floatValue(), vertices[prev].getLat().floatValue(), bottomAlt);
            glTriangles[idx++] = new GlTriangle(v1, v2, v3);
            glTriangles[idx++] = new GlTriangle(v1, v3, v4);
            prev = i++;
        }
        GlTriangleMesh triangleMesh = new GlTriangleMesh();
        triangleMesh.setTriangles(glTriangles);
        triangleMesh.calculateNormals(true);
        return triangleMesh;
    }

    private static GlTriangleMesh createSurfaceMesh(GlPointTransformer transformer, MapShapeVertex[] vertices, float altitude) {
        ArrayList<PolygonPoint> polygonPoints = new ArrayList<PolygonPoint>(vertices.length);
        for (MapShapeVertex v : vertices) {
            GlPoint p = transformer.getPoint(v.getLon().floatValue(), v.getLat().floatValue(), altitude);
            polygonPoints.add(new PolygonPoint((double)p.getX(), (double)p.getY(), (double)p.getZ()));
        }
        Polygon polygon = new Polygon(polygonPoints);
        Poly2Tri.triangulate((Polygon)polygon);
        List triangles = polygon.getTriangles();
        GlTriangle[] glTriangles = new GlTriangle[triangles.size()];
        for (int i = 0; i < triangles.size(); ++i) {
            glTriangles[i] = new GlTriangle((DelaunayTriangle)triangles.get(i));
        }
        GlTriangleMesh triangleMesh = new GlTriangleMesh();
        triangleMesh.setTriangles(glTriangles);
        triangleMesh.calculateNormals(true);
        return triangleMesh;
    }

    public static GlColorTriangleMesh triangulate(GlPointTransformer transformer, ElevationArray array, Short userMin, Short userMax) {
        int x;
        int y;
        short min = Short.MAX_VALUE;
        short max = Short.MIN_VALUE;
        for (y = 0; y < array.getRowsCount(); ++y) {
            for (x = 0; x < array.getColsCount(); ++x) {
                if (array.getAt(x, y) == null || array.getAt(x, y).getElev() == null) continue;
                if (array.getAt(x, y).getElev() < min) {
                    min = array.getAt(x, y).getElev();
                }
                if (array.getAt(x, y).getElev() <= max) continue;
                max = array.getAt(x, y).getElev();
            }
        }
        HashSet<GlColorTriangle> triangles = new HashSet<GlColorTriangle>();
        for (y = 0; y < array.getRowsCount() - 1; ++y) {
            for (x = 0; x < array.getColsCount() - 1; ++x) {
                GlColorPoint v1 = array.getAt(x, y) != null && array.getAt(x, y).getElev() != null ? new GlColorPoint(transformer.getPoint(array.getAt(x, y).getLon().floatValue(), array.getAt(x, y).getLat().floatValue(), array.getAt(x, y).getElev().shortValue()), SettingsBean.getInstance().getColorsPalette()[VfrUtil.getColorIndex(array.getAt(x, y).getElev(), min, max, userMin, userMax)]) : null;
                GlColorPoint v2 = array.getAt(x + 1, y) != null && array.getAt(x + 1, y).getElev() != null ? new GlColorPoint(transformer.getPoint(array.getAt(x + 1, y).getLon().floatValue(), array.getAt(x + 1, y).getLat().floatValue(), array.getAt(x + 1, y).getElev().shortValue()), SettingsBean.getInstance().getColorsPalette()[VfrUtil.getColorIndex(array.getAt(x + 1, y).getElev(), min, max, userMin, userMax)]) : null;
                GlColorPoint v3 = array.getAt(x, y + 1) != null && array.getAt(x, y + 1).getElev() != null ? new GlColorPoint(transformer.getPoint(array.getAt(x, y + 1).getLon().floatValue(), array.getAt(x, y + 1).getLat().floatValue(), array.getAt(x, y + 1).getElev().shortValue()), SettingsBean.getInstance().getColorsPalette()[VfrUtil.getColorIndex(array.getAt(x, y + 1).getElev(), min, max, userMin, userMax)]) : null;
                GlColorPoint v4 = array.getAt(x + 1, y + 1) != null && array.getAt(x + 1, y + 1).getElev() != null ? new GlColorPoint(transformer.getPoint(array.getAt(x + 1, y + 1).getLon().floatValue(), array.getAt(x + 1, y + 1).getLat().floatValue(), array.getAt(x + 1, y + 1).getElev().shortValue()), SettingsBean.getInstance().getColorsPalette()[VfrUtil.getColorIndex(array.getAt(x + 1, y + 1).getElev(), min, max, userMin, userMax)]) : null;
                if (v1 != null && v2 != null && v3 != null) {
                    triangles.add(new GlColorTriangle(v1, v2, v3));
                } else if (v1 != null && v2 != null && v4 != null) {
                    triangles.add(new GlColorTriangle(v1, v2, v4));
                }
                if (v3 != null && v2 != null && v4 != null) {
                    triangles.add(new GlColorTriangle(v3, v2, v4));
                    continue;
                }
                if (v1 == null || v4 == null || v3 == null) continue;
                triangles.add(new GlColorTriangle(v1, v4, v3));
            }
        }
        GlColorTriangleMesh mesh = new GlColorTriangleMesh();
        mesh.setTriangles(triangles.toArray(new GlColorTriangle[triangles.size()]));
        GlUtil.calculateNormals(mesh);
        return mesh;
    }

    public static void calculateNormals(GlColorTriangleMesh mesh) {
        GlVector[] normals = new GlVector[mesh.getTriangles().length];
        for (int i = 0; i < mesh.getTriangles().length; ++i) {
            normals[i] = mesh.getTriangles()[i].getNormal();
        }
        mesh.setNormals(normals);
    }

    public static GlColorTriangleMesh triangulate(List<GpsPlace> polygonPoints) {
        GlColorTriangleMesh mesh = new GlColorTriangleMesh();
        LineSegment[] segments = new LineSegment[polygonPoints.size() - 1];
        for (int i = 0; i < polygonPoints.size() - 1; ++i) {
            segments[i] = GpsUtil.getLineSegment(polygonPoints.get(i), polygonPoints.get(i + 1));
        }
        return mesh;
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static GlNamedPoint[] transformAirports(GlPointTransformer transformer, List<AirportDTO> airports) {
        ArrayList<GlNamedPoint> result = new ArrayList<GlNamedPoint>(airports.size());
        for (AirportDTO a : airports) {
            GpsPlace p = a.getGpsPlace();
            result.add(new GlNamedPoint(transformer.getPoint((float)p.getLon().getValue(), (float)p.getLat().getValue(), a.getElevation() != null ? (float)a.getElevation().intValue() : 0.0f), a.getName()));
        }
        return result.toArray(new GlNamedPoint[result.size()]);
    }
}

