/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.fsxpln.SimBaseDocument;
import org.apache.log4j.Logger;

public class FsxUtil {
    private static final Logger log = Logger.getLogger(FsxUtil.class);
    private static final String TAB = "\t";
    private static final String APP_VERSION_MAJOR = "10";
    private static final String APP_VERSION_BUILD = "61637";
    private static final Map<String, String> ALTITUDE_TYPE_MAPPINGS;

    public static boolean loadFlightPlan(File file) {
        log.info("loading flight plan ...");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SimBaseDocument.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            SimBaseDocument fsxPlnXml = (SimBaseDocument)jaxbUnmarshaller.unmarshal(file);
            FlightPlanBean.getInstance().setRoute(FsxUtil.getRouteFromXml(fsxPlnXml));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public static Route getRouteFromXml(SimBaseDocument xml) {
        Route route = new Route();
        SimBaseDocument.FlightPlanFlightPlan plan = xml.getFlightPlanFlightPlan();
        route.setName(plan.getTitle());
        route.setDescription(plan.getDescr());
        route.setCruiseAlt(plan.getCruisingAlt());
        for (SimBaseDocument.FlightPlanFlightPlan.ATCWaypoint wp : plan.getATCWaypoint()) {
            log.debug(wp.getId() + " => " + wp.getWorldPosition());
            route.getPoints().add(FsxUtil.getPlaceFromWorldPosition(wp.getId(), wp.getWorldPosition()));
        }
        return route;
    }

    public static RoutePlace getPlaceFromWorldPosition(String name, String txt) {
        String[] parts = txt.split(",");
        String[] latArr = parts[0].split(" ");
        int deg = Integer.valueOf(latArr[0].substring(1, latArr[0].length() - 1));
        int min = Integer.valueOf(latArr[1].substring(0, latArr[1].length() - 1));
        double sec = Double.valueOf(latArr[2].substring(0, latArr[2].length() - 1));
        GpsCoord lat = new GpsCoord(deg, min, sec);
        lat.setMinusValue(latArr[0].startsWith("S"));
        String[] lonArr = parts[1].split(" ");
        deg = Integer.valueOf(lonArr[0].substring(1, lonArr[0].length() - 1));
        min = Integer.valueOf(lonArr[1].substring(0, lonArr[1].length() - 1));
        sec = Double.valueOf(lonArr[2].substring(0, lonArr[2].length() - 1));
        GpsCoord lon = new GpsCoord(deg, min, sec);
        lon.setMinusValue(lonArr[0].startsWith("W"));
        return new RoutePlace(lat, lon, name, Double.valueOf(parts[2]));
    }

    public static boolean saveFlightPlan(Route route, String destinationFile) {
        String plan = FsxUtil.getFsxFlightPlan(route);
        if (plan != null) {
            return IOUtil.saveTextFile(plan, destinationFile);
        }
        return plan != null;
    }

    public static String getFsxFlightPlan(Route route) {
        if (route == null || route.getSegments().size() < 1) {
            log.error("Invalid route data (null or has less than 2 points)");
            return null;
        }
        if (route.getCruiseAlt() == null) {
            log.error("Invalid cruise altitude (null)");
            return null;
        }
        GpsPlace departAirport = route.getSegments().get(0).getFrom();
        GpsPlace destinationAirport = route.getSegments().get(route.getSegments().size() - 1).getTo();
        double cruiseAlt = route.getCruiseAlt();
        StringBuilder result = new StringBuilder();
        String EOL = Constants.EOL;
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + EOL + EOL);
        result.append("<SimBase.Document Type=\"AceXML\" version=\"1,0\">" + EOL);
        result.append("\t<Descr>AceXML Document</Descr>" + EOL);
        result.append("\t<FlightPlan.FlightPlan>" + EOL);
        result.append("\t\t<Title>");
        result.append(FsxUtil.removeInvalidXmlCharacters(route.getName()));
        result.append("</Title>" + EOL);
        result.append("\t\t<FPType>" + (route.isVfr() ? "VFR" : "IFR") + "</FPType>" + EOL);
        result.append("\t\t<CruisingAlt>");
        result.append(route.getCruiseAlt());
        result.append("</CruisingAlt>" + EOL);
        result.append("\t\t<DepartureID>");
        result.append(FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(departAirport.getName())));
        result.append("</DepartureID>" + EOL);
        result.append("\t\t<DepartureLLA>" + FsxUtil.getCoords(departAirport, cruiseAlt));
        result.append("</DepartureLLA>" + EOL);
        result.append("\t\t<DestinationID>");
        result.append(FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(destinationAirport.getName())));
        result.append("</DestinationID>" + EOL);
        result.append("\t\t<DestinationLLA>" + FsxUtil.getCoords(destinationAirport, cruiseAlt));
        result.append("</DestinationLLA>" + EOL);
        result.append("\t\t<Descr>");
        if (StringUtil.isEmpty(route.getDescription())) {
            result.append(FsxUtil.removeInvalidXmlCharacters(departAirport.getName()));
            result.append(", ");
            result.append(FsxUtil.removeInvalidXmlCharacters(destinationAirport.getName()));
        } else {
            result.append(FsxUtil.removeInvalidXmlCharacters(route.getDescription()));
        }
        result.append("</Descr>" + EOL);
        result.append("\t\t<DeparturePosition>");
        if (route.getDeparturePosition() == null) {
            result.append(route.getDepartureRwy() != null ? route.getDepartureRwy() : "36");
        } else {
            result.append(route.getDeparturePosition().getDeparturePosition());
        }
        result.append("</DeparturePosition>" + EOL);
        result.append("\t\t<DepartureName>");
        result.append(FsxUtil.removeInvalidXmlCharacters(departAirport.getName()));
        result.append("</DepartureName>" + EOL);
        result.append("\t\t<DestinationName>");
        result.append(FsxUtil.removeInvalidXmlCharacters(destinationAirport.getName()));
        result.append("</DestinationName>" + EOL);
        result.append("\t\t<AppVersion>" + EOL);
        result.append("\t\t\t<AppVersionMajor>");
        result.append(APP_VERSION_MAJOR);
        result.append("</AppVersionMajor>" + EOL);
        result.append("\t\t\t<AppVersionBuild>");
        result.append(APP_VERSION_BUILD);
        result.append("</AppVersionBuild>" + EOL);
        result.append("\t\t</AppVersion>" + EOL);
        result.append("\t\t<ATCWaypoint id=\"" + FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(departAirport.getName())) + "\">" + EOL);
        result.append("\t\t\t<ATCWaypointType>Airport</ATCWaypointType>" + EOL);
        result.append("\t\t\t<WorldPosition>" + FsxUtil.getCoords(departAirport, cruiseAlt) + "</WorldPosition>" + EOL);
        result.append("\t\t\t<ICAO>" + EOL);
        result.append("\t\t\t\t<ICAOIdent>" + FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(departAirport.getName())) + "</ICAOIdent>" + EOL);
        result.append("\t\t\t</ICAO>" + EOL);
        result.append("\t\t</ATCWaypoint>" + EOL);
        for (int i = 0; i < route.getSegments().size() - 1; ++i) {
            LineSegment segment = route.getSegments().get(i);
            result.append("\t\t<ATCWaypoint id=\"" + FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(segment.getTo().getName())) + "\">" + EOL);
            result.append("\t\t\t<ATCWaypointType>User</ATCWaypointType>" + EOL);
            result.append("\t\t\t<WorldPosition>" + FsxUtil.getCoords(segment.getTo(), cruiseAlt) + "</WorldPosition>" + EOL);
            result.append("\t\t</ATCWaypoint>" + EOL);
        }
        result.append("\t\t<ATCWaypoint id=\"" + FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(destinationAirport.getName())) + "\">" + EOL);
        result.append("\t\t\t<ATCWaypointType>Airport</ATCWaypointType>" + EOL);
        result.append("\t\t\t<WorldPosition>" + FsxUtil.getCoords(destinationAirport, cruiseAlt) + "</WorldPosition>" + EOL);
        result.append("\t\t\t<ICAO>" + EOL);
        result.append("\t\t\t\t<ICAOIdent>" + FsxUtil.removeInvalidXmlCharacters(FsxUtil.getWptName(destinationAirport.getName())) + "</ICAOIdent>" + EOL);
        result.append("\t\t\t</ICAO>" + EOL);
        result.append("\t\t</ATCWaypoint>" + EOL);
        result.append("\t</FlightPlan.FlightPlan>" + EOL);
        result.append("</SimBase.Document>" + EOL);
        return result.toString();
    }

    public static String getWptName(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.toUpperCase().replaceAll("\\s+", "")).length() > 10) {
            name = name.substring(0, 10);
        }
        return name;
    }

    public static String getCoords(GpsPlace point, double cruiseAlt) {
        StringBuilder result = new StringBuilder();
        result.append(point.getLatHemisphere());
        result.append(point.getLat().getDeg());
        result.append("\u00b0 ");
        result.append(point.getLat().getMin());
        result.append("' ");
        result.append((double)Math.round(point.getLat().getSec() * 100.0) / 100.0);
        result.append("\",");
        result.append(point.getLonHemisphere());
        result.append(point.getLon().getDeg());
        result.append("\u00b0 ");
        result.append(point.getLon().getMin());
        result.append("' ");
        result.append((double)Math.round(point.getLon().getSec() * 100.0) / 100.0);
        result.append("\",");
        if (point.getAlt() != null) {
            result.append(FsxUtil.formatAlt(point.getAlt()));
        } else {
            result.append(FsxUtil.formatAlt(cruiseAlt));
        }
        return result.toString();
    }

    public static String formatAlt(double alt) {
        DecimalFormat df2 = new DecimalFormat("000000.00");
        String res = df2.format(alt).replace(",", ".");
        if (alt >= 0.0) {
            res = "+" + res;
        }
        return res;
    }

    public static String formatLatLon(double value) {
        DecimalFormat df2 = new DecimalFormat("00.000000");
        return df2.format(value).replace(",", ".");
    }

    public static String formatBoundaryAlt(Integer altitude) {
        if (altitude == null) {
            altitude = 0;
        }
        double alt = altitude.intValue();
        DecimalFormat df2 = new DecimalFormat("0.00");
        alt = UnitUtil.recalculateAltitude(alt, "ft", "m", false);
        String res = df2.format(alt).replace(",", ".");
        return res;
    }

    public static String formatRadius(double radius) {
        DecimalFormat df2 = new DecimalFormat("00000.00");
        radius = UnitUtil.recalculateDistance(radius, "nm", "km", false) * 1000.0;
        return df2.format(radius).replace(",", ".");
    }

    private static String removeInvalidXmlCharacters(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("&", "").replace(">", "").replace("<", "").trim();
    }

    public static String getGeopol(AirspaceAreaDTO area) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Geopol type=\"BOUNDARY\">");
        if (area.getVertices() != null) {
            for (int i = 0; i < area.getVertices().length; ++i) {
                sb.append("<Vertex");
                FsxUtil.parseBoundaryVertexCoords(sb, area.getVertices()[i]);
                sb.append(" />");
            }
        }
        sb.append("</Geopol>");
        return sb.toString();
    }

    public static String getBoundary(AirspaceAreaDTO area) {
        StringBuilder sb = new StringBuilder();
        String name = area.getName();
        name = name == null ? "" : name.replace("'", "''");
        sb.append("<Boundary type=\"" + area.getType().toString() + "\" name=\"" + name + "\">");
        if (area.isCircle()) {
            sb.append("<Origin lat=\"" + FsxUtil.formatLatLon(area.getCircleCenterLat()) + "\" lon=\"" + FsxUtil.formatLatLon(area.getCircleCenterLon()) + "\" />");
            sb.append("<Circle");
            FsxUtil.parseBoundaryAltitudes(sb, area);
            sb.append(" index=\"0\" radius=\"" + FsxUtil.formatRadius(area.getRadius()) + "\" />");
        } else if (area.isPoly()) {
            sb.append("<BoundaryStart");
            FsxUtil.parseBoundaryAltitudes(sb, area);
            FsxUtil.parseBoundaryVertexCoords(sb, area.getVertices()[0]);
            sb.append(" />");
            int originCount = 0;
            for (int i = 1; i < area.getVertices().length; ++i) {
                MapShapeVertex vertex = area.getVertices()[i];
                if (vertex.isVertex()) {
                    sb.append("<Line");
                    FsxUtil.parseBoundaryVertexCoords(sb, vertex);
                    sb.append(" />");
                    continue;
                }
                sb.append("<Origin");
                FsxUtil.parseBoundaryVertexCoords(sb, vertex);
                sb.append(" />");
                sb.append("<Arc type=\"");
                sb.append(vertex.isClockwise() ? "CLOCKWISE" : "COUNTER_CLOCKWISE");
                sb.append("\" index=\"");
                sb.append(originCount);
                sb.append("\"");
                if (i < area.getVertices().length - 1) {
                    FsxUtil.parseBoundaryVertexCoords(sb, area.getVertices()[++i]);
                } else {
                    FsxUtil.parseBoundaryVertexCoords(sb, area.getVertices()[0]);
                }
                sb.append(" />");
                ++originCount;
            }
            MapShapeVertex firstVertex = area.getVertices()[0];
            MapShapeVertex lastVertex = area.getVertices()[area.getVertices().length - 1];
            if (firstVertex.isVertex() && lastVertex.isVertex() && (!NumberUtil.doubleEqualsDouble(firstVertex.getLat(), lastVertex.getLat(), 6) || !NumberUtil.doubleEqualsDouble(firstVertex.getLon(), lastVertex.getLon(), 6))) {
                sb.append("<Line");
                FsxUtil.parseBoundaryVertexCoords(sb, firstVertex);
                sb.append(" />");
            }
        }
        sb.append("</Boundary>");
        return sb.toString();
    }

    private static void parseBoundaryVertexCoords(StringBuilder sb, MapShapeVertex vertex) {
        sb.append(" lat=\"" + FsxUtil.formatLatLon(vertex.getLat()) + "\" lon=\"" + FsxUtil.formatLatLon(vertex.getLon()) + "\"");
    }

    private static void parseBoundaryAltitudes(StringBuilder sb, AirspaceAreaDTO area) {
        String bottomAltType;
        String topAltType = area.getTopAltitudeType().toString();
        if (ALTITUDE_TYPE_MAPPINGS.get(topAltType) != null) {
            topAltType = ALTITUDE_TYPE_MAPPINGS.get(topAltType);
        }
        if (ALTITUDE_TYPE_MAPPINGS.get(bottomAltType = area.getBottomAltitudeType().toString()) != null) {
            bottomAltType = ALTITUDE_TYPE_MAPPINGS.get(bottomAltType);
        }
        sb.append(" maximumAltitudeType=\"" + topAltType + "\"");
        sb.append(" minimumAltitudeType=\"" + bottomAltType + "\"");
        sb.append(" altitudeMinimum=\"" + FsxUtil.formatBoundaryAlt(area.getBottomAltitude()) + "\"");
        sb.append(" altitudeMaximum=\"" + FsxUtil.formatBoundaryAlt(area.getTopAltitude()) + "\"");
    }

    public static void exportAirspacesToXmlAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("fsx_export"), Messages.getInstance().get("save"));
        chooser.setFileFilter(new ExtensionFileFilter("PLIKI XML", new String[]{"XML"}));
        chooser.setSelectedFile(new File("BNXWorld.xml"));
        int returnVal = chooser.showOpenDialog(MapFrame.getInstance());
        if (returnVal == 0) {
            SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "xml");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("fsx_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                if (FsxUtil.exportAirspacesToXml(MapObjectsBean.getInstance().getAirspaces(), fileName)) {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("fsx_plan_export_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("fsx_plan_export_error"), "", 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportAirspacesToXml(AirspaceAreaDTO[] airspaces, String fileName) {
        boolean bl;
        String EOL = Constants.EOL;
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File(fileName));
            out.write("<FSData version=\"9.0\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:noNamespaceSchemaLocation=\"bglcomp.xsd\" >" + EOL + EOL);
            for (AirspaceAreaDTO area : airspaces) {
                if (AirspaceType.GEOPOL.equals((Object)area.getType())) {
                    out.write(FsxUtil.getGeopol(area) + EOL + EOL);
                    continue;
                }
                out.write(FsxUtil.getBoundary(area) + EOL + EOL);
            }
            out.write("</FSData>");
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    static {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("AGL", "ABOVE_GROUND_LEVEL");
        mp.put("MSL", "MEAN_SEA_LEVEL");
        ALTITUDE_TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

