/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsArc;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;

public class FormatUtil {
    private static final Logger log = Logger.getLogger(FormatUtil.class);
    private static final BigDecimal BIGDECIMAL_1000 = new BigDecimal("1000");
    private static final String ZERO = "0";
    private static final String GPS_POS_DELIMITER = " ";
    private static final String EOL = "\n";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");

    public static String formatTime(long sec) {
        return FormatUtil.formatTime(sec, SettingsBean.getInstance().isParamIncludeSecondsInTimeCalculations());
    }

    public static String formatTime(long sec, boolean withSeconds) {
        if (sec < 0L) {
            return "--";
        }
        int min = 0;
        min = withSeconds ? (int)Math.floor((double)sec / 60.0) : (int)Math.round((double)sec / 60.0);
        int hr = 0;
        if (min >= 60) {
            hr = (int)Math.floor((double)min / 60.0);
            min -= hr * 60;
        }
        String result = "";
        if (withSeconds) {
            sec = sec - (long)(hr * 3600) - (long)(min * 60);
            result = (hr > 0 ? hr + ":" : "") + (min < 10 ? ZERO : "") + min + ":" + (sec < 10L ? ZERO : "") + sec;
        } else {
            result = hr + ":" + (min < 10 ? ZERO : "") + min;
        }
        return result;
    }

    public static String formatTimeLandmark(double sec) {
        return FormatUtil.formatTimeLandmark(sec, SettingsBean.getInstance().isParamIncludeSecondsInTimeCalculations());
    }

    public static String formatTimeLandmark(double sec, boolean withSeconds) {
        String result;
        if (sec < 0.0) {
            return "--";
        }
        int min = 0;
        min = withSeconds ? (int)Math.floor(sec / 60.0) : (int)Math.round(sec / 60.0);
        int hr = 0;
        if (min >= 60) {
            hr = (int)Math.floor((double)min / 60.0);
            min -= hr * 60;
        }
        String string = result = hr > 0 ? hr + "h" + min + "m" : min + "m";
        if (withSeconds) {
            int s = (int)Math.round(sec);
            s = s - hr * 3600 - min * 60;
            result = result + (s < 10 ? ZERO : "") + s + "s";
        }
        return result;
    }

    public static String formatVorFrequency(Integer freq) {
        if (freq != null) {
            BigDecimal f = new BigDecimal(String.valueOf(freq)).setScale(3).divide(BIGDECIMAL_1000);
            String res = f.toString();
            int cnt = 0;
            for (int i = res.length() - 1; i >= 0 && res.charAt(i) == '0'; --i) {
                ++cnt;
            }
            if (cnt == 3) {
                ++cnt;
            }
            if (cnt > 0) {
                res = res.substring(0, res.length() - cnt);
            }
            return res;
        }
        return null;
    }

    public static String formatNdbFrequency(Integer freq) {
        if (freq != null) {
            if (freq < 1000) {
                return String.valueOf(freq);
            }
            if (freq % 10 == 0) {
                return String.valueOf(Math.round(freq / 10));
            }
            return String.valueOf((double)freq.intValue() / 10.0);
        }
        return null;
    }

    public static String formattedCourse(Double course, boolean degrees) {
        if (course != null) {
            int crs = (int)Math.round(GpsUtil.normalizeCourse(course));
            String out = String.valueOf(crs);
            if (crs < 10) {
                out = "00" + out;
            } else if (crs < 100) {
                out = ZERO + out;
            }
            return degrees ? out + "\u00b0" : out;
        }
        return "---";
    }

    public static String formattedWindString(Route route) {
        String speed = String.valueOf(Math.round(route.getWindSpeed()));
        return FormatUtil.formattedCourse(route.getWindDirection(), false) + "/" + speed;
    }

    public static String formatRadial(LineSegment radial) {
        return FormatUtil.formatRadial(radial, true);
    }

    public static String formatRadial(LineSegment radial, boolean includeDistance) {
        return FormatUtil.formatRadial(radial, includeDistance, false);
    }

    public static String formatRadial(LineSegment radial, boolean includeDistance, boolean shortVersion) {
        StringBuilder result = new StringBuilder();
        if (radial.getMagneticCourse() == null) {
            result.append(FormatUtil.formattedCourse(null, false));
        } else {
            result.append("R");
            result.append(FormatUtil.formattedCourse(radial.getMagneticCourse(), false));
            if (!shortVersion) {
                result.append("\u00b0");
            }
        }
        if (includeDistance) {
            result.append(GPS_POS_DELIMITER);
            if (!shortVersion) {
                result.append("/ ");
            }
            if (radial.getDiagonalDistance() == null) {
                result.append((double)Math.round(radial.getDistance() * 10.0) / 10.0 + SettingsBean.getInstance().getParamUnitsDistance());
            } else {
                result.append((double)Math.round(radial.getDiagonalDistance() * 10.0) / 10.0 + SettingsBean.getInstance().getParamUnitsDistance());
            }
        }
        return result.toString();
    }

    public static String formatGpsPos(GpsPlace place, boolean decimalformat) {
        StringBuilder sb = new StringBuilder();
        if (decimalformat) {
            sb.append(NumberUtil.roundDouble(place.getLat().getValue(), 5));
            sb.append(GPS_POS_DELIMITER);
            sb.append(NumberUtil.roundDouble(place.getLon().getValue(), 5));
        } else {
            sb.append(place.getLatHemisphere());
            sb.append(FormatUtil.formatGpsCoord(place.getLat(), false));
            sb.append(GPS_POS_DELIMITER);
            sb.append(place.getLonHemisphere());
            sb.append(FormatUtil.formatGpsCoord(place.getLon(), true));
        }
        return sb.toString();
    }

    public static String formatGpsCoordFlightPlan(GpsCoord coord) {
        StringBuilder builder = new StringBuilder();
        int deg = coord.getDeg();
        int min = coord.getMin();
        if (coord.getSec() > 30.0 && ++min >= 60) {
            min -= 60;
            ++deg;
        }
        if (deg < 10) {
            builder.append(ZERO);
        }
        builder.append(deg);
        if (min < 10) {
            builder.append(ZERO);
        }
        builder.append(min);
        return builder.toString();
    }

    public static String formatGpsPlaceFlightPlan(GpsPlace place) {
        return FormatUtil.formatGpsCoordFlightPlan(place.getLat()) + place.getLatHemisphere() + FormatUtil.formatGpsCoordFlightPlan(place.getLon()) + place.getLonHemisphere();
    }

    public static String formatGpsCoord(GpsCoord coord, boolean extraZero) {
        return FormatUtil.formatGpsCoord(coord, extraZero, false, 1);
    }

    public static String formatGpsCoord(GpsCoord coord, boolean extraZero, boolean shorten) {
        return FormatUtil.formatGpsCoord(coord, extraZero, shorten, 0);
    }

    public static String formatGpsCoord(GpsCoord coord, boolean extraZero, boolean shorten, int roundingPrecision) {
        StringBuilder builder = new StringBuilder();
        if (coord.getDeg() < 10) {
            builder.append(ZERO);
        }
        if (extraZero && coord.getDeg() < 100) {
            builder.append(ZERO);
        }
        builder.append(coord.getDeg());
        builder.append("\u00b0");
        if (!shorten || coord.getMin() > 0 || NumberUtil.doubleGreaterThanZero(coord.getSec())) {
            double roundedSec;
            if (coord.getMin() < 10) {
                builder.append(ZERO);
            }
            builder.append(coord.getMin());
            builder.append("'");
            double d = roundedSec = roundingPrecision > 0 ? NumberUtil.roundDouble(coord.getSec(), roundingPrecision) : (double)Math.round(coord.getSec());
            if (!shorten || roundedSec > 0.0) {
                if (roundedSec < 10.0) {
                    builder.append(ZERO);
                }
                builder.append(roundingPrecision == 0 ? NumberUtil.doubleToString(roundedSec) : Double.valueOf(roundedSec));
                builder.append("\"");
            }
        }
        return builder.toString();
    }

    public static GpsPlace getGpsPlaceFromString(String coords) {
        if (coords == null) {
            return null;
        }
        String[] split = coords.trim().replaceAll(",", ".").split(GPS_POS_DELIMITER);
        if (split.length != 6) {
            log.error("parseCoordsFromString: Illegal number of tokens for " + coords);
            return null;
        }
        try {
            GpsCoord lat = new GpsCoord(Integer.valueOf(split[0]), Integer.valueOf(split[1]), Double.valueOf(split[2]));
            GpsCoord lon = new GpsCoord(Integer.valueOf(split[3]), Integer.valueOf(split[4]), Double.valueOf(split[5]));
            return new GpsPlace(lat, lon);
        }
        catch (NumberFormatException e) {
            log.error("parseCoordsFromString: " + coords, e);
            return null;
        }
    }

    public static String formatFileSizeToGBs(long size, int precision) {
        double res = NumberUtil.roundDouble((double)size / 1024.0 / 1024.0 / 1024.0, precision);
        return precision == 0 ? String.valueOf((int)res) : String.valueOf(res);
    }

    public static String formatTimestamp(long timeStamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeStamp);
        return TIME_FORMAT.format(calendar.getTime());
    }

    public static String formatClouds(short altitude) {
        if (altitude < 10) {
            return "00" + altitude;
        }
        if (altitude < 100) {
            return ZERO + altitude;
        }
        return String.valueOf(altitude);
    }

    public static boolean needWrap(String txt, int length) {
        return txt.length() > length;
    }

    public static List<String> wrap(String txt, int length, String linePrefix) {
        LinkedList<String> res = new LinkedList<String>();
        String[] token = txt.split(GPS_POS_DELIMITER);
        if (token.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : token) {
                if (sb.length() + s.length() < length) {
                    sb.append(s);
                    sb.append(GPS_POS_DELIMITER);
                    continue;
                }
                String t = sb.toString().trim();
                if (res.size() > 0) {
                    t = linePrefix + t;
                }
                res.add(t);
                sb = new StringBuilder(s + GPS_POS_DELIMITER);
            }
            if (sb.toString().trim().length() > 0) {
                String t = sb.toString().trim();
                if (res.size() > 0) {
                    t = linePrefix + t;
                }
                res.add(t);
            }
            return res;
        }
        return null;
    }

    public static AirspaceArea coordsListToCircleArea(String txt) {
        if (txt == null || !txt.trim().startsWith("CIRCLE") || txt.length() < 7) {
            return null;
        }
        int pos = (txt = txt.trim().substring(6)).indexOf("RADIUS");
        if (pos < 0) {
            return null;
        }
        GpsPlace center = FormatUtil.stringToGpsPlace(txt.substring(0, pos));
        if (center == null) {
            return null;
        }
        Double rad = null;
        try {
            rad = Double.valueOf(txt.substring(pos + 6, txt.length()));
        }
        catch (NumberFormatException e) {
            return null;
        }
        AirspaceArea a = new AirspaceArea();
        a.setCenter(center.geoPosition());
        a.setRadius(UnitUtil.recalculateDistance(rad, "km", "nm", false));
        return a;
    }

    public static List<GpsVertex> coordsListToGpsPlaces(String txt) {
        String[] split;
        if (txt == null) {
            return null;
        }
        ArrayList<GpsVertex> places = new ArrayList<GpsVertex>();
        for (String s : split = txt.trim().split(EOL)) {
            if (s.startsWith("ARC")) {
                GpsArc arc = FormatUtil.stringToArc(s);
                if (arc != null) {
                    places.add(arc);
                    continue;
                }
                log.error("coordsListToGpsPlaces1: couldn't parse arc " + s);
                continue;
            }
            GpsPlace place = FormatUtil.stringToGpsPlace(s);
            if (place != null) {
                places.add(place);
                continue;
            }
            log.error("coordsListToGpsPlaces2: couldn't parse place " + s);
        }
        return places;
    }

    public static GpsArc stringToArc(String txt) {
        if (!txt.startsWith("ARC") || txt.length() < 4) {
            return null;
        }
        int pos = (txt = txt.substring(3)).indexOf("RADIUS");
        if (pos < 0) {
            return null;
        }
        GpsPlace center = FormatUtil.stringToGpsPlace(txt.substring(0, pos));
        if (center == null) {
            return null;
        }
        Double rad = null;
        try {
            rad = Double.valueOf(txt.substring(pos + 6, txt.length()));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new GpsArc(center, UnitUtil.recalculateDistance(rad, "km", "nm", false));
    }

    public static GpsPlace stringToGpsPlace(String txt) {
        if (StringUtil.isEmpty(txt)) {
            return null;
        }
        if ((txt = txt.trim()).matches("^((-){0,1}[0-9]+(\\.){1}[0-9]+(\\s)+(-){0,1}[0-9]+(\\.){1}[0-9]+)$")) {
            String[] coords = txt.split(GPS_POS_DELIMITER);
            try {
                return new GpsPlace(Double.valueOf(coords[0]), Double.valueOf(coords[coords.length - 1]));
            }
            catch (NumberFormatException e) {
                log.error(e, e);
                return null;
            }
        }
        if (txt.matches("^([0-9]{6}(\\.){0,1}[0-9]{0,1}(N|S){1}(\\s)+[0-9]{7}(\\.){0,1}[0-9]{0,1}(E|W){1})$")) {
            String[] coords = txt.split(GPS_POS_DELIMITER);
            String latStr = coords[0];
            if (latStr.length() != 7 && latStr.length() != 9) {
                log.error("Error parsing NOTAM lat " + latStr);
                return null;
            }
            String lonStr = coords[coords.length - 1];
            if (lonStr.length() != 8 && lonStr.length() != 10) {
                log.error("Error parsing NOTAM lon " + lonStr);
                return null;
            }
            try {
                int latDeg = Integer.valueOf(latStr.substring(0, 2));
                int latMin = Integer.valueOf(latStr.substring(2, 4));
                double latSec = Double.valueOf(latStr.substring(4, latStr.length() - 1));
                GpsCoord lat = new GpsCoord(latDeg, latMin, latSec);
                lat.setMinusValue(latStr.endsWith("S"));
                int lonDeg = Integer.valueOf(lonStr.substring(0, 3));
                int lonMin = Integer.valueOf(lonStr.substring(3, 5));
                double lonSec = Double.valueOf(lonStr.substring(5, lonStr.length() - 1));
                GpsCoord lon = new GpsCoord(lonDeg, lonMin, lonSec);
                lon.setMinusValue(lonStr.endsWith("W"));
                return new GpsPlace(lat, lon);
            }
            catch (NumberFormatException e) {
                log.error(e, e);
                return null;
            }
        }
        txt = txt.replaceAll("\\s", "");
        StringBuilder sb = new StringBuilder();
        char[] chars = txt.toCharArray();
        for (int i = 0; i < chars.length && (chars[i] < '0' || chars[i] > '9'); ++i) {
            sb.append(chars[i]);
        }
        String name = sb.toString();
        if (name.length() > 0) {
            txt = txt.substring(name.length());
        }
        int splitNpos = txt.indexOf("N");
        int splitSpos = txt.indexOf("S");
        if (splitNpos <= 0 && splitSpos <= 0) {
            log.error("stringToGpsPlace1");
            return null;
        }
        String splitChar = splitNpos > 0 ? "N" : "S";
        String[] coords = txt.split(splitChar);
        if (coords.length < 2) {
            log.error("stringToGpsPlace2");
            return null;
        }
        coords[0] = coords[0] + splitChar;
        int idx = 0;
        if (coords.length > 2) {
            idx = 1;
        }
        GpsCoord lat = FormatUtil.stringToGpsCoord(coords[idx]);
        GpsCoord lon = FormatUtil.stringToGpsCoord(coords[idx + 1]);
        if (lat == null || lon == null) {
            log.error("stringToGpsPlace: lat or lon is null: " + lat + "; " + lon);
            return null;
        }
        return new GpsPlace(lat, lon, name.length() > 0 ? name : null);
    }

    public static GpsCoord stringToGpsCoord(String txt) {
        if (StringUtil.isEmpty(txt)) {
            return null;
        }
        txt = txt.trim();
        txt = txt.replace(",", ".");
        int degPos = -1;
        for (int i = 0; i < Constants.CHAR_ARRAY_DEGREE.length && (degPos = txt.indexOf(Constants.CHAR_ARRAY_DEGREE[i])) < 0; ++i) {
        }
        int minPos = -1;
        for (int i = 0; i < Constants.CHAR_ARRAY_MINUTE.length && (minPos = txt.indexOf(Constants.CHAR_ARRAY_MINUTE[i])) < 0; ++i) {
        }
        int secPos = -1;
        for (int i = 0; i < Constants.CHAR_ARRAY_SECOND.length && (secPos = txt.indexOf(Constants.CHAR_ARRAY_SECOND[i])) < 0; ++i) {
        }
        if (degPos < 0 || minPos < 0 || secPos < 0) {
            return null;
        }
        try {
            int deg = Integer.valueOf(txt.substring(0, degPos));
            int min = Integer.valueOf(txt.substring(degPos + 1, minPos));
            double sec = Double.valueOf(txt.substring(minPos + 1, secPos));
            GpsCoord coord = new GpsCoord(deg, min, sec);
            String hem = txt.substring(txt.length() - 1);
            if ("W".equals(hem) || "S".equals(hem)) {
                coord.setMinusValue(true);
            } else if ("E".equals(hem) || "N".equals(hem)) {
                coord.setMinusValue(false);
            } else {
                return null;
            }
            return coord;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static GpsPlace getAixmDecimalGpsFromString(String latString, String lonString) {
        if (latString == null || !latString.matches("^([0-9]{1,2}(\\.)[0-9]+{1}(N|S){1})$")) {
            log.error("Invalid format: " + latString + "; " + lonString);
            return null;
        }
        if (lonString == null || !lonString.matches("^([0-9]{1,3}(\\.)[0-9]+{1}(E|W){1})$")) {
            log.error("Invalid format: " + latString + "; " + lonString);
            return null;
        }
        try {
            double lat = Double.valueOf(latString.substring(0, latString.length() - 1));
            if (latString.charAt(latString.length() - 1) == 'S') {
                lat = -lat;
            }
            double lon = Double.valueOf(lonString.substring(0, lonString.length() - 1));
            if (lonString.charAt(lonString.length() - 1) == 'W') {
                lon = -lon;
            }
            return new GpsPlace(lat, lon);
        }
        catch (NumberFormatException e) {
            log.error("getAixmDecimalGpsFromString: [" + latString + "; " + lonString + "]", e);
            return null;
        }
    }

    public static GpsPlace getAixmGpsFromString(String latString, String lonString) {
        if (latString == null || !latString.matches("^([0-9]{6}(\\.){1}[0-9]{4}(N|S){1})$")) {
            return FormatUtil.getAixmDecimalGpsFromString(latString, lonString);
        }
        if (lonString == null || !lonString.matches("^([0-9]{7}(\\.){1}[0-9]{4}(E|W){1})$")) {
            return FormatUtil.getAixmDecimalGpsFromString(latString, lonString);
        }
        try {
            int latDeg = Integer.valueOf(latString.substring(0, 2));
            int latMin = Integer.valueOf(latString.substring(2, 4));
            double latSec = Double.valueOf(latString.substring(4, latString.length() - 1));
            double lat = (double)latDeg + (double)latMin / 60.0 + latSec / 3600.0;
            if (latString.charAt(latString.length() - 1) == 'S') {
                lat = -lat;
            }
            int lonDeg = Integer.valueOf(lonString.substring(0, 3));
            int lonMin = Integer.valueOf(lonString.substring(3, 5));
            double lonSec = Double.valueOf(lonString.substring(5, lonString.length() - 1));
            double lon = (double)lonDeg + (double)lonMin / 60.0 + lonSec / 3600.0;
            if (lonString.charAt(lonString.length() - 1) == 'W') {
                lon = -lon;
            }
            return new GpsPlace(lat, lon);
        }
        catch (NumberFormatException e) {
            log.error("getAixmGpsFromString: [" + latString + "; " + lonString + "]", e);
            return null;
        }
    }

    public static String formatAixmGpsLat(Double lat) {
        if (lat == null) {
            return null;
        }
        GpsCoord coord = new GpsCoord(lat);
        String sec = (int)Math.floor(NumberUtil.roundDouble(coord.getSec(), 4)) < 10 ? ZERO : "";
        return String.format("%02d", coord.getDeg()) + String.format("%02d", coord.getMin()) + sec + String.format("%.4f", coord.getSec()).replaceAll(",", ".") + (NumberUtil.doubleLessThanZero(lat) ? "S" : "N");
    }

    public static String formatAixmGpsLon(Double lon) {
        if (lon == null) {
            return null;
        }
        GpsCoord coord = new GpsCoord(lon);
        String sec = (int)Math.floor(NumberUtil.roundDouble(coord.getSec(), 4)) < 10 ? ZERO : "";
        return String.format("%03d", coord.getDeg()) + String.format("%02d", coord.getMin()) + sec + String.format("%.4f", coord.getSec()).replaceAll(",", ".") + (NumberUtil.doubleLessThanZero(lon) ? "W" : "E");
    }

    public static String formatDecimalGps(GpsPlace pos) {
        if (pos == null) {
            return null;
        }
        return NumberUtil.roundDouble(pos.getLat().getValue(), 6) + GPS_POS_DELIMITER + NumberUtil.roundDouble(pos.getLon().getValue(), 6);
    }

    public static String formatCoord(GpsCoord coord) {
        StringBuilder builder = new StringBuilder();
        builder.append(coord.getDeg());
        builder.append("\u00b0");
        builder.append(coord.getMin());
        builder.append("'");
        builder.append(NumberUtil.roundDouble(coord.getSec(), 1));
        builder.append("\"");
        return builder.toString();
    }

    public static String formatGps(GpsPlace pos) {
        if (pos == null) {
            return null;
        }
        return FormatUtil.formatCoord(pos.getLat()) + pos.getLatHemisphere() + GPS_POS_DELIMITER + FormatUtil.formatCoord(pos.getLon()) + pos.getLonHemisphere();
    }

    public static String formatClimbAndAngle(double climbRate, double climbAngle, boolean inFpm) {
        StringBuilder sb = new StringBuilder();
        if (NumberUtil.doubleGreaterThanZero(climbRate)) {
            sb.append("+");
        }
        if (inFpm) {
            sb.append((int)Math.round(climbRate));
            sb.append("fpm");
        } else {
            sb.append(NumberUtil.roundDouble(climbRate, 1));
            sb.append("m/s");
        }
        sb.append("  ");
        if (NumberUtil.doubleGreaterThanZero(climbAngle)) {
            sb.append("+");
        }
        sb.append((int)Math.round(climbAngle));
        sb.append("\u00b0");
        return sb.toString();
    }

    public static String getHgtFilename(double lat, double lon) {
        StringBuilder sb = new StringBuilder();
        sb.append(NumberUtil.doubleLessThanZero(lat) ? "S" : "N");
        sb.append(String.format("%02d", (int)Math.abs(Math.floor(lat))));
        sb.append(NumberUtil.doubleLessThanZero(lon) ? "W" : "E");
        sb.append(String.format("%03d", (int)Math.abs(Math.floor(lon))));
        sb.append(".hgt");
        return sb.toString();
    }

    public static String formatIso8601Date(long millis) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(millis);
        return FormatUtil.formatIso8601Date(cal);
    }

    public static String formatIso8601Date(Calendar calendar) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        df.setTimeZone(tz);
        return df.format(calendar.getTime()) + "Z";
    }
}

