/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.dto.ObstacleDTO;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;

public class FlyingAppUtil {
    private static final Logger log = Logger.getLogger(FlyingAppUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportUserTrack(List<ExtConnectBean> beanList, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(beanList.size() + Constants.EOL);
            for (ExtConnectBean bean : beanList) {
                out.write(bean.getTimestamp() + Constants.EOL);
                out.write(bean.getUserLat() + Constants.EOL);
                out.write(bean.getUserLon() + Constants.EOL);
                if (bean.getUserAlt() == null) {
                    out.write(Constants.EOL);
                } else {
                    out.write(bean.getUserAlt() + Constants.EOL);
                }
                out.write("ft" + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportAirports(Set<AirportDTO> airports, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(airports.size() + Constants.EOL);
            for (AirportDTO airport : airports) {
                out.write(airport.getIdentOrName() + Constants.EOL);
                out.write(airport.getLat() + Constants.EOL);
                out.write(airport.getLon() + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportNavaids(Set<NavaidDTO> navaids, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(navaids.size() + Constants.EOL);
            for (NavaidDTO navaid : navaids) {
                out.write(navaid.getName() + Constants.EOL);
                out.write(navaid.getType() + Constants.EOL);
                out.write(navaid.getInfoFrequency() + Constants.EOL);
                out.write(navaid.getLat() + Constants.EOL);
                out.write(navaid.getLon() + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportTerrain(Set<TerrainMesh> terrainMesh, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(terrainMesh.size() + Constants.EOL);
            for (TerrainMesh t : terrainMesh) {
                out.write(t.getRectangleOver().getMaxLat().floatValue() + Constants.EOL);
                out.write(t.getRectangleOver().getMinLon().floatValue() + Constants.EOL);
                out.write(t.getRectangleOver().getMinLat().floatValue() + Constants.EOL);
                out.write(t.getRectangleOver().getMaxLon().floatValue() + Constants.EOL);
                out.write(t.getValue() + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportVfrPoints(Set<VfrPointDTO> points, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(points.size() + Constants.EOL);
            for (VfrPointDTO point : points) {
                out.write(point.getName() + Constants.EOL);
                out.write(point.getLat() + Constants.EOL);
                out.write(point.getLon() + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportAirspaces(Set<AirspaceAreaDTO> airspaces, JXMapViewer map, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(airspaces.size() + Constants.EOL);
            for (AirspaceAreaDTO area : airspaces) {
                out.write(area.getName() + Constants.EOL);
                out.write((Object)((Object)area.getType()) + Constants.EOL);
                out.write(area.getBottomAltitude() + Constants.EOL);
                out.write((Object)((Object)(area.getBottomAltitudeType() == null ? AltitudeType.MSL : area.getBottomAltitudeType())) + Constants.EOL);
                out.write(area.getTopAltitude() + Constants.EOL);
                out.write((Object)((Object)(area.getTopAltitudeType() == null ? AltitudeType.MSL : area.getTopAltitudeType())) + Constants.EOL);
                MapShapeVertex[] vertices = null;
                if (area.isPoly()) {
                    vertices = AirspacesUtil.convertArcAirspaceToPolygon(map, area.getVertices(), 5);
                } else if (area.isCircle()) {
                    vertices = AirspacesUtil.convertCircleAirspaceToPolygon(area, 5);
                }
                out.write(vertices.length + Constants.EOL);
                for (MapShapeVertex v : vertices) {
                    out.write(v.getLat() + Constants.EOL);
                    out.write(v.getLon() + Constants.EOL);
                }
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportCities(Set<CityDTO> cities, String fileName) {
        boolean bl;
        HashSet<CityDTO> majorCities = new HashSet<CityDTO>();
        for (CityDTO cityDTO : cities) {
            if (cityDTO.isVillage()) continue;
            majorCities.add(cityDTO);
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(majorCities.size() + Constants.EOL);
            for (CityDTO city3 : majorCities) {
                out.write(city3.getName() + Constants.EOL);
                out.write(city3.getLat() + Constants.EOL);
                out.write(city3.getLon() + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                log.error(fileNotFoundException);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    public static boolean exportFlightPlan(String filename, Route route) {
        if (route.getPoints().size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(FlyingAppUtil.createHeader(route));
            sb.append(FlyingAppUtil.createRoutePoints(route));
            return IOUtil.saveTextFile(sb.toString(), filename);
        }
        return false;
    }

    private static String createHeader(Route route) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sb.append(df.format(Calendar.getInstance().getTime()));
        sb.append(Constants.EOL);
        sb.append(StringUtil.nullToEmpty(route.getName()));
        sb.append(Constants.EOL);
        return sb.toString();
    }

    private static String createRoutePoints(Route route) {
        StringBuilder sb = new StringBuilder();
        sb.append(route.getPoints().size());
        sb.append(Constants.EOL);
        for (RoutePlace point : route.getPoints()) {
            sb.append(FlyingAppUtil.formatWpName(point.getName(), 5));
            sb.append(Constants.EOL);
            sb.append(point.getLatVal());
            sb.append(Constants.EOL);
            sb.append(point.getLonVal());
            sb.append(Constants.EOL);
            if (point.getAlt() == null) {
                sb.append("0");
            } else {
                sb.append(point.getAlt());
            }
            sb.append(Constants.EOL);
            sb.append(SettingsBean.getInstance().getParamUnitsAltitude().toUpperCase());
            sb.append(Constants.EOL);
        }
        return sb.toString();
    }

    private static String formatWpName(String name, int maxLength) {
        if (name == null) {
            return "";
        }
        if ((name = name.replaceAll("\\s+", "").toUpperCase()).length() > maxLength) {
            return name.substring(0, maxLength);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportObstacles(Set<ObstacleDTO> obstacles, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(obstacles.size() + Constants.EOL);
            for (ObstacleDTO o : obstacles) {
                out.write(o.getAmsl() + Constants.EOL);
                out.write((o.isGrp() ? "1" : "0") + Constants.EOL);
                out.write((o.isLgt() ? "1" : "0") + Constants.EOL);
                out.write((o.isHigh() ? "1" : "0") + Constants.EOL);
                out.write(o.getLat() + Constants.EOL);
                out.write(o.getLon() + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }
}

