/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.route.Route;
import org.apache.log4j.Logger;

public class FlightPlanUtil {
    private static final Logger log = Logger.getLogger(FlightPlanUtil.class);

    public static boolean save(main.java.guru.vfrflight.core.Route route, String file) {
        Route xml = FlightPlanUtil.getXmlFromRoute(route);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Route.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e, e);
            return false;
        }
        return true;
    }

    public static main.java.guru.vfrflight.core.Route load(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Route.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Route routeXml = (Route)jaxbUnmarshaller.unmarshal(new File(file));
            return FlightPlanUtil.getRouteFromXml(routeXml);
        }
        catch (JAXBException e) {
            log.error((Object)e, e);
            return null;
        }
    }

    public static main.java.guru.vfrflight.core.Route getRouteFromXml(Route xml) {
        RoutePlace place;
        Double alt;
        GpsCoord lon;
        GpsCoord lat;
        main.java.guru.vfrflight.core.Route route = new main.java.guru.vfrflight.core.Route();
        route.setName(xml.getName());
        route.setDescription(xml.getDescription());
        Double cruiseSpeed = xml.getCruisespeed();
        if (cruiseSpeed != null && !xml.getUnits().getSpeed().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            cruiseSpeed = UnitUtil.recalculateSpeed(cruiseSpeed, xml.getUnits().getSpeed(), SettingsBean.getInstance().getParamUnitsSpeed(), true);
        }
        route.setCruiseSpeed(cruiseSpeed);
        Double climbingSpeed = xml.getClimbingspeed();
        if (climbingSpeed != null && !xml.getUnits().getSpeed().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            climbingSpeed = UnitUtil.recalculateSpeed(climbingSpeed, xml.getUnits().getSpeed(), SettingsBean.getInstance().getParamUnitsSpeed(), true);
        }
        route.setClimbingSpeed(climbingSpeed);
        Double descendingSpeed = xml.getDescendingspeed();
        if (descendingSpeed != null && !xml.getUnits().getSpeed().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            descendingSpeed = UnitUtil.recalculateSpeed(descendingSpeed, xml.getUnits().getSpeed(), SettingsBean.getInstance().getParamUnitsSpeed(), true);
        }
        route.setDescendingSpeed(descendingSpeed);
        Double cruiseAlt = xml.getCruisealt();
        if (cruiseAlt != null && !xml.getUnits().getAltitude().equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            cruiseAlt = UnitUtil.recalculateAltitude(cruiseAlt, xml.getUnits().getAltitude(), SettingsBean.getInstance().getParamUnitsAltitude(), true);
        }
        route.setCruiseAlt(cruiseAlt);
        if (xml.getFuel() != null) {
            Double fuelBurn = xml.getFuel().getBurnrate();
            Double qM = xml.getFuel().getQm();
            Double qMax = xml.getFuel().getQmax();
            route.setNavFuelReserveMin(xml.getFuel().getNavFuelReserveMin());
            if (!xml.getUnits().getFuel().equals(SettingsBean.getInstance().getParamUnitsFuel())) {
                if (fuelBurn != null) {
                    fuelBurn = UnitUtil.recalculateFuel(fuelBurn, xml.getUnits().getFuel(), SettingsBean.getInstance().getParamUnitsFuel(), true);
                }
                if (qM != null) {
                    qM = UnitUtil.recalculateFuel(qM, xml.getUnits().getFuel(), SettingsBean.getInstance().getParamUnitsFuel(), true);
                }
                if (qMax != null) {
                    qMax = UnitUtil.recalculateFuel(qMax, xml.getUnits().getFuel(), SettingsBean.getInstance().getParamUnitsFuel(), true);
                }
            }
            route.setFuelBurn(fuelBurn);
            route.setQm(qM);
            route.setQmax(qMax);
        }
        if (xml.getWind() != null) {
            route.setWindDirection(xml.getWind().getDirection());
        }
        if (xml.getWind() != null) {
            Double windSpeed = xml.getWind().getSpeed();
            if (windSpeed != null && !xml.getUnits().getWindSpeed().equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                windSpeed = UnitUtil.recalculateWindSpeed(windSpeed, xml.getUnits().getWindSpeed(), SettingsBean.getInstance().getParamUnitsWindSpeed(), true);
            }
            route.setWindSpeed(windSpeed);
        }
        if (xml.getWind().getWindsock() != null) {
            route.getWindSock().setDiffLat(xml.getWind().getWindsock().getDifflat());
            route.getWindSock().setDiffLon(xml.getWind().getWindsock().getDifflon());
        }
        for (Route.Vors.Gpsplace vorXml : xml.getVors().getGpsplace()) {
            lat = new GpsCoord(vorXml.getLatitude().getDeg(), vorXml.getLatitude().getMin(), vorXml.getLatitude().getSec());
            lon = new GpsCoord(vorXml.getLongitude().getDeg(), vorXml.getLongitude().getMin(), vorXml.getLongitude().getSec());
            alt = vorXml.getAlt();
            if (alt != null && !xml.getUnits().getAltitude().equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                alt = UnitUtil.recalculateAltitude(alt, xml.getUnits().getAltitude(), SettingsBean.getInstance().getParamUnitsAltitude(), true);
            }
            place = new RoutePlace(lat, lon, vorXml.getName(), alt);
            place.setLatHemisphere(vorXml.getLatitude().getHem());
            place.setLonHemisphere(vorXml.getLongitude().getHem());
            place.setType(vorXml.getType() != null ? vorXml.getType() : "VOR");
            if (vorXml.getFreq() != null) {
                place.setDataInt("freq", vorXml.getFreq());
            }
            if (vorXml.getMagvar() != null) {
                place.setDataDouble("magvar", vorXml.getMagvar());
            }
            route.getVors().add(place);
        }
        for (Route.Points.Gpsplace pointXml : xml.getPoints().getGpsplace()) {
            lat = new GpsCoord(pointXml.getLatitude().getDeg(), pointXml.getLatitude().getMin(), pointXml.getLatitude().getSec());
            lon = new GpsCoord(pointXml.getLongitude().getDeg(), pointXml.getLongitude().getMin(), pointXml.getLongitude().getSec());
            alt = pointXml.getAlt();
            if (alt != null && !xml.getUnits().getAltitude().equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                alt = UnitUtil.recalculateAltitude(alt, xml.getUnits().getAltitude(), SettingsBean.getInstance().getParamUnitsAltitude(), false);
            }
            place = new RoutePlace(lat, lon, pointXml.getName(), alt);
            place.setLatHemisphere(pointXml.getLatitude().getHem());
            place.setLonHemisphere(pointXml.getLongitude().getHem());
            route.getPoints().add(place);
        }
        for (Route.Landmarks.Landmark landmarkXml : xml.getLandmarks().getLandmark()) {
            route.getLandmarks().add(new SegmentLandmark(landmarkXml.getSegmentIndex(), landmarkXml.getPosition(), landmarkXml.getDesc()));
        }
        if (xml.getMapradials() != null) {
            for (Route.Mapradials.Mapradial mapRadialsXml : xml.getMapradials().getMapradial()) {
                GpsPlace place2 = new GpsPlace(new GpsCoord(mapRadialsXml.getLatitude().getDeg(), mapRadialsXml.getLatitude().getMin(), mapRadialsXml.getLatitude().getSec()), new GpsCoord(mapRadialsXml.getLongitude().getDeg(), mapRadialsXml.getLongitude().getMin(), mapRadialsXml.getLongitude().getSec()), null, mapRadialsXml.getAlt());
                if (!StringUtil.isEmpty(mapRadialsXml.getLatitude().getHem())) {
                    place2.setLatHemisphere(mapRadialsXml.getLatitude().getHem());
                }
                if (!StringUtil.isEmpty(mapRadialsXml.getLongitude().getHem())) {
                    place2.setLonHemisphere(mapRadialsXml.getLongitude().getHem());
                }
                MapRadials mapRadials = new MapRadials(place2);
                mapRadials.getVorIdxs().addAll(mapRadialsXml.getVorindexes().get(0).getVorindex());
                mapRadials.setIncludeDistance(mapRadialsXml.isIncludedistance());
                if (mapRadialsXml.isDrawradial() != null) {
                    mapRadials.setDrawRadial(mapRadialsXml.isDrawradial());
                }
                mapRadials.setName(mapRadialsXml.getName());
                route.getMapRadials().add(mapRadials);
            }
        }
        if (xml.getAlternates() != null) {
            for (Route.Alternates.Alternate alternateXml : xml.getAlternates().getAlternate()) {
                if (alternateXml.getLatitude() == null || alternateXml.getLongitude() == null) continue;
                AlternateAirport a = new AlternateAirport();
                if (alternateXml.getElev() != null) {
                    int elev = alternateXml.getElev();
                    if (!xml.getUnits().getAltitude().equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                        elev = (int)UnitUtil.recalculateAltitude(elev, xml.getUnits().getAltitude(), SettingsBean.getInstance().getParamUnitsAltitude(), true);
                    }
                    a.setElev(elev);
                }
                a.setFrequency(alternateXml.getFreq());
                a.setIdent(alternateXml.getIdent());
                GpsCoord lat2 = new GpsCoord(alternateXml.getLatitude().getDeg(), alternateXml.getLatitude().getMin(), alternateXml.getLatitude().getSec());
                if (!StringUtil.isEmpty(alternateXml.getLatitude().getHem())) {
                    lat2.setMinusValue("S".equals(alternateXml.getLatitude().getHem()));
                }
                a.setLat(lat2.getValue());
                GpsCoord lon2 = new GpsCoord(alternateXml.getLongitude().getDeg(), alternateXml.getLongitude().getMin(), alternateXml.getLongitude().getSec());
                if (!StringUtil.isEmpty(alternateXml.getLongitude().getHem())) {
                    lon2.setMinusValue("W".equals(alternateXml.getLongitude().getHem()));
                }
                a.setLon(lon2.getValue());
                route.getAlternateAirports().add(a);
            }
        }
        return route;
    }

    public static Route getXmlFromRoute(main.java.guru.vfrflight.core.Route route) {
        Route routeXml = new Route();
        routeXml.setVersion("1.0");
        routeXml.setName(route.getName());
        routeXml.setDescription(route.getDescription());
        if (route.getCruiseSpeed() != null) {
            routeXml.setCruisespeed(route.getCruiseSpeed());
        }
        if (route.getClimbingSpeed() != null) {
            routeXml.setClimbingspeed(route.getClimbingSpeed());
        }
        if (route.getDescendingSpeed() != null) {
            routeXml.setDescendingspeed(route.getDescendingSpeed());
        }
        if (route.getCruiseAlt() != null) {
            routeXml.setCruisealt(route.getCruiseAlt());
        }
        Route.Fuel fuel = new Route.Fuel();
        if (route.getFuelBurn() != null) {
            fuel.setBurnrate(route.getFuelBurn());
        }
        if (route.getQm() != null) {
            fuel.setQm(route.getQm());
        }
        if (route.getQmax() != null) {
            fuel.setQmax(route.getQmax());
        }
        if (route.getNavFuelReserveMin() != null) {
            fuel.setNavFuelReserveMin(route.getNavFuelReserveMin());
        }
        routeXml.setFuel(fuel);
        Route.Wind wind = new Route.Wind();
        if (route.getWindDirection() != null) {
            wind.setDirection(route.getWindDirection());
        }
        if (route.getWindSpeed() != null) {
            wind.setSpeed(route.getWindSpeed());
        }
        Route.Wind.Windsock windSock = new Route.Wind.Windsock();
        windSock.setDifflat(route.getWindSock().getDiffLat());
        windSock.setDifflon(route.getWindSock().getDiffLon());
        wind.setWindsock(windSock);
        routeXml.setWind(wind);
        ArrayList<Object> vorsGpsplace = new ArrayList<Object>();
        for (GpsPlace gpsPlace : route.getVors()) {
            Route.Vors.Gpsplace vorXml = new Route.Vors.Gpsplace();
            Route.Vors.Gpsplace.Latitude latitude = new Route.Vors.Gpsplace.Latitude();
            latitude.setDeg(gpsPlace.getLat().getDeg());
            latitude.setMin(gpsPlace.getLat().getMin());
            latitude.setSec(gpsPlace.getLat().getSec());
            latitude.setHem(gpsPlace.getLatHemisphere());
            vorXml.setLatitude(latitude);
            Route.Vors.Gpsplace.Longitude lon = new Route.Vors.Gpsplace.Longitude();
            lon.setDeg(gpsPlace.getLon().getDeg());
            lon.setMin(gpsPlace.getLon().getMin());
            lon.setSec(gpsPlace.getLon().getSec());
            lon.setHem(gpsPlace.getLonHemisphere());
            vorXml.setLongitude(lon);
            vorXml.setName(gpsPlace.getName());
            vorXml.setAlt(gpsPlace.getAlt());
            vorXml.setFreq(gpsPlace.getDataInt("freq"));
            vorXml.setMagvar(gpsPlace.getDataDouble("magvar"));
            vorXml.setType(gpsPlace.getType());
            vorsGpsplace.add(vorXml);
        }
        Route.Vors vors = new Route.Vors();
        vors.getGpsplace().addAll(vorsGpsplace);
        routeXml.setVors(vors);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (GpsPlace gpsPlace : route.getPoints()) {
            Route.Points.Gpsplace vorXml = new Route.Points.Gpsplace();
            Route.Points.Gpsplace.Latitude lat = new Route.Points.Gpsplace.Latitude();
            lat.setDeg(gpsPlace.getLat().getDeg());
            lat.setMin(gpsPlace.getLat().getMin());
            lat.setSec(gpsPlace.getLat().getSec());
            lat.setHem(gpsPlace.getLatHemisphere());
            vorXml.setLatitude(lat);
            Route.Points.Gpsplace.Longitude lon = new Route.Points.Gpsplace.Longitude();
            lon.setDeg(gpsPlace.getLon().getDeg());
            lon.setMin(gpsPlace.getLon().getMin());
            lon.setSec(gpsPlace.getLon().getSec());
            lon.setHem(gpsPlace.getLonHemisphere());
            vorXml.setLongitude(lon);
            vorXml.setName(gpsPlace.getName());
            vorXml.setAlt(gpsPlace.getAlt());
            arrayList.add(vorXml);
        }
        Route.Points points = new Route.Points();
        points.getGpsplace().addAll(arrayList);
        routeXml.setPoints(points);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (AlternateAirport a : route.getAlternateAirports()) {
            Route.Alternates.Alternate alternate = new Route.Alternates.Alternate();
            alternate.setIdent(a.getIdent());
            alternate.setElev(a.getElev());
            alternate.setFreq(a.getFrequency());
            GpsPlace place = a.getGpsPlace();
            Route.Alternates.Alternate.Latitude lat = new Route.Alternates.Alternate.Latitude();
            lat.setDeg(place.getLat().getDeg());
            lat.setMin(place.getLat().getMin());
            lat.setSec(place.getLat().getSec());
            lat.setHem(place.getLatHemisphere());
            alternate.setLatitude(lat);
            Route.Alternates.Alternate.Longitude lon = new Route.Alternates.Alternate.Longitude();
            lon.setDeg(place.getLon().getDeg());
            lon.setMin(place.getLon().getMin());
            lon.setSec(place.getLon().getSec());
            lon.setHem(place.getLonHemisphere());
            alternate.setLongitude(lon);
            arrayList2.add(alternate);
        }
        Route.Alternates alternatesXml = new Route.Alternates();
        alternatesXml.getAlternate().addAll(arrayList2);
        routeXml.setAlternates(alternatesXml);
        ArrayList<Object> landmarks = new ArrayList<Object>();
        for (SegmentLandmark landmark : route.getLandmarks()) {
            Route.Landmarks.Landmark landmarksXml = new Route.Landmarks.Landmark();
            landmarksXml.setPosition(landmark.getPosition());
            landmarksXml.setSegmentIndex(landmark.getSegmentIndex());
            landmarksXml.setDesc(landmark.getDescription());
            landmarks.add(landmarksXml);
        }
        Route.Landmarks lmXml = new Route.Landmarks();
        lmXml.getLandmark().addAll(landmarks);
        routeXml.setLandmarks(lmXml);
        ArrayList<Route.Mapradials.Mapradial> mapradials = new ArrayList<Route.Mapradials.Mapradial>();
        for (MapRadials mapRadials : route.getMapRadials()) {
            Route.Mapradials.Mapradial mapRadialsXml = new Route.Mapradials.Mapradial();
            if (mapRadials.getPos().getAlt() != null) {
                mapRadialsXml.setAlt(mapRadials.getPos().getAlt());
            }
            mapRadialsXml.setDrawradial(mapRadials.isDrawRadial());
            mapRadialsXml.setIncludedistance(mapRadials.isIncludeDistance());
            mapRadialsXml.setName(mapRadials.getName());
            Route.Mapradials.Mapradial.Latitude lat = new Route.Mapradials.Mapradial.Latitude();
            lat.setDeg(mapRadials.getPos().getLat().getDeg());
            lat.setMin(mapRadials.getPos().getLat().getMin());
            lat.setSec(mapRadials.getPos().getLat().getSec());
            lat.setHem(mapRadials.getPos().getLatHemisphere());
            mapRadialsXml.setLatitude(lat);
            Route.Mapradials.Mapradial.Longitude lon = new Route.Mapradials.Mapradial.Longitude();
            lon.setDeg(mapRadials.getPos().getLon().getDeg());
            lon.setMin(mapRadials.getPos().getLon().getMin());
            lon.setSec(mapRadials.getPos().getLon().getSec());
            lon.setHem(mapRadials.getPos().getLonHemisphere());
            mapRadialsXml.setLongitude(lon);
            Route.Mapradials.Mapradial.Vorindexes vorIndexesXml = new Route.Mapradials.Mapradial.Vorindexes();
            vorIndexesXml.getVorindex().addAll(mapRadials.getVorIdxs());
            mapRadialsXml.getVorindexes().add(vorIndexesXml);
            mapradials.add(mapRadialsXml);
        }
        Route.Mapradials mrXml = new Route.Mapradials();
        mrXml.getMapradial().addAll(mapradials);
        routeXml.setMapradials(mrXml);
        Route.Units units = new Route.Units();
        units.setAltitude(SettingsBean.getInstance().getParamUnitsAltitude());
        units.setSpeed(SettingsBean.getInstance().getParamUnitsSpeed());
        units.setWindSpeed(SettingsBean.getInstance().getParamUnitsWindSpeed());
        units.setFuel(SettingsBean.getInstance().getParamUnitsFuel());
        units.setDistance(SettingsBean.getInstance().getParamUnitsDistance());
        routeXml.setUnits(units);
        return routeXml;
    }
}

