/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.LineSegmentWithIndex;
import main.java.guru.vfrflight.core.comparator.TerrainMeshDistanceComparator;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.gui.callable.EngineLossSampleCallable;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;

public class EngineLoss {
    private static final Logger log = Logger.getLogger(EngineLoss.class);
    private final int samplesNum;
    private final double liftToDragRatio;
    private final Double iasOfBestGlideInKt;
    private final Double windSpeed;
    private final Double windDirection;

    public EngineLoss(int samplesNum, double liftToDragRatio, Double iasOfBestGlideInKt, Double windSpeed, Double windDirection) {
        this.samplesNum = samplesNum;
        this.liftToDragRatio = liftToDragRatio;
        this.iasOfBestGlideInKt = iasOfBestGlideInKt;
        this.windSpeed = windSpeed;
        this.windDirection = windDirection;
    }

    public int getSamplesNum() {
        return this.samplesNum;
    }

    public double getLiftToDragRatio() {
        return this.liftToDragRatio;
    }

    public Double getIasOfBestGlideInKt() {
        return this.iasOfBestGlideInKt;
    }

    public Double getWindSpeed() {
        return this.windSpeed;
    }

    public Double getWindDirection() {
        return this.windDirection;
    }

    public static double getMaximumEngineLossRange(double altInFt, double liftToDragRatio) {
        return UnitUtil.recalculateDistance(altInFt, "ft", "nm", false) * liftToDragRatio;
    }

    private GpsPlace calculateMaximumEngineLossRangeWithWindForPlace(GpsPlace place, double maxRangeWithoutWind, double bearing) {
        if (this.iasOfBestGlideInKt != null && this.windSpeed != null && this.windDirection != null) {
            double gs = VfrUtil.calculateGSForWind(this.iasOfBestGlideInKt, bearing, this.windSpeed, this.windDirection);
            double timeWithNoWind = maxRangeWithoutWind / this.iasOfBestGlideInKt;
            maxRangeWithoutWind = timeWithNoWind * gs;
        }
        return GpsUtil.getPointPositionByDistanceAndBearing(place, bearing, maxRangeWithoutWind);
    }

    public List<LineSegment> calculateOutlineForEngineLossRange(List<LineSegment> segments, TerrainMesh[] terrainMesh) {
        MapShapeVertex v;
        LineSegment segment;
        MapShape currentShape;
        int i;
        if (segments == null) {
            return null;
        }
        ArrayList<RouteSample> routeSamples = new ArrayList<RouteSample>(this.samplesNum);
        double totalLength = GpsUtil.getTotalDistance(segments);
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            LineSegment segment2 = segments.get(i2);
            int num = i2 < segments.size() - 1 ? (int)Math.round((double)this.samplesNum * segment2.getOrCalculateDistance() / totalLength) : this.samplesNum - routeSamples.size();
            int q = 0;
            List<GpsPlace> points = GpsUtil.divideSegmentToPoints(segment2, num);
            for (GpsPlace s : points) {
                double alt = segment2.getFrom().getAlt() + (segment2.getTo().getAlt() - segment2.getFrom().getAlt()) / (double)num * (double)(++q);
                s.setAlt(alt);
                routeSamples.add(new RouteSample(s, segment2.getCourse(), i2));
            }
        }
        ArrayList<MapShapeVertex> currentShapeVertices = new ArrayList<MapShapeVertex>();
        ArrayList<MapShape> shapes = new ArrayList<MapShape>();
        ArrayList<MapShapeVertex> rangeShapeVertices = new ArrayList<MapShapeVertex>(this.samplesNum * 2);
        ArrayList<LineSegment> result = new ArrayList<LineSegment>(this.samplesNum * 2);
        for (i = 0; i < routeSamples.size(); ++i) {
            if (i < routeSamples.size() - 1 && ((RouteSample)routeSamples.get(i)).getSegmentIndex() != ((RouteSample)routeSamples.get(i + 1)).getSegmentIndex() && ((RouteSample)routeSamples.get(i)).getSegmentIndex() < segments.size() - 1) {
                currentShapeVertices.add(new MapShapeVertex(segments.get(((RouteSample)routeSamples.get(i)).getSegmentIndex()).getTo()));
                currentShapeVertices.add(new MapShapeVertex(segments.get(((RouteSample)routeSamples.get(i)).getSegmentIndex()).getFrom()));
                currentShape = new MapShape();
                currentShape.setVertices(currentShapeVertices.toArray(new MapShapeVertex[currentShapeVertices.size()]));
                shapes.add(currentShape);
                currentShapeVertices = new ArrayList();
            }
            if ((segment = this.calculateSample(i, -90.0, routeSamples, terrainMesh)) == null) continue;
            v = new MapShapeVertex(segment.getTo());
            rangeShapeVertices.add(v);
            currentShapeVertices.add(v);
            result.add(segment);
        }
        for (i = routeSamples.size() - 1; i >= 0; --i) {
            if (i > 0 && ((RouteSample)routeSamples.get(i)).getSegmentIndex() != ((RouteSample)routeSamples.get(i - 1)).getSegmentIndex() && ((RouteSample)routeSamples.get(i)).getSegmentIndex() > 0) {
                currentShapeVertices.add(new MapShapeVertex(segments.get(((RouteSample)routeSamples.get(i)).getSegmentIndex()).getFrom()));
                currentShapeVertices.add(new MapShapeVertex(segments.get(((RouteSample)routeSamples.get(i)).getSegmentIndex()).getTo()));
                currentShape = new MapShape();
                currentShape.setVertices(currentShapeVertices.toArray(new MapShapeVertex[currentShapeVertices.size()]));
                shapes.add(currentShape);
                currentShapeVertices = new ArrayList();
            }
            if ((segment = this.calculateSample(i, 90.0, routeSamples, terrainMesh)) == null) continue;
            v = new MapShapeVertex(segment.getTo());
            rangeShapeVertices.add(v);
            currentShapeVertices.add(v);
            result.add(segment);
        }
        Iterator it = rangeShapeVertices.iterator();
        while (it.hasNext()) {
            MapShapeVertex v2 = (MapShapeVertex)it.next();
            GpsPlace pos = v2.getGpsPlace();
            for (MapShape s : shapes) {
                boolean isPartOfShape = false;
                for (MapShapeVertex sv : s.getVertices()) {
                    if (!v2.equals(sv)) continue;
                    isPartOfShape = true;
                    break;
                }
                if (isPartOfShape || !AirspacesUtil.isPlaceInsideShape(MapFrame.getInstance().getMapViewer(), pos, s)) continue;
                it.remove();
            }
        }
        MapShape engineLossRangeShape = new MapShape();
        engineLossRangeShape.setVertices(rangeShapeVertices.toArray(new MapShapeVertex[rangeShapeVertices.size()]));
        MapObjectsBean.getInstance().setHighlightedMapShape(engineLossRangeShape);
        MapFrame.getInstance().updateMap();
        return result;
    }

    private LineSegment calculateSample(int i, double crsDiff, List<RouteSample> routeSamples, TerrainMesh[] terrainMesh) {
        GpsPlace from = routeSamples.get(i).getPlace();
        double maxRangeWithoutWind = EngineLoss.getMaximumEngineLossRange(from.getAlt(), this.liftToDragRatio);
        GpsPlace to = this.calculateMaximumEngineLossRangeWithWindForPlace(routeSamples.get(i).getPlace(), maxRangeWithoutWind, GpsUtil.normalizeCourse(routeSamples.get(i).getSegmentCourse() + crsDiff));
        return EngineLoss.createLineSegmentSample(MapFrame.getInstance().getMapViewer(), from, to, terrainMesh);
    }

    public static LineSegment createLineSegmentSample(JXMapViewer map, GpsPlace from, GpsPlace to, TerrainMesh[] terrainMesh) {
        List<TerrainMesh> mesh = EngineLoss.findIntersectingTerrainMesh(MapFrame.getInstance().getMapViewer(), new LineSegment(from, to), terrainMesh);
        if (mesh.size() > 0) {
            double maxRange = GpsUtil.getDistance(from, to);
            Collections.sort(mesh, new TerrainMeshDistanceComparator(from));
            for (TerrainMesh m : mesh) {
                GpsPlace meshCenter = m.getRectangleOver().getCenter();
                double dist = GpsUtil.getDistance(from, meshCenter);
                int alt = (int)Math.round(from.getAlt() * (1.0 - dist / maxRange));
                if (alt >= m.getValue()) continue;
                return new LineSegment(from.clone(), GpsUtil.getGpsPlaceOnSegment(map, from, to, meshCenter, false));
            }
            return new LineSegment(from.clone(), to.clone());
        }
        log.debug("Couldn't find intesectings for " + from + " -> " + to);
        return null;
    }

    private static List<TerrainMesh> findIntersectingTerrainMesh(JXMapViewer map, LineSegment segment, TerrainMesh[] terrainMesh) {
        LinkedList<TerrainMesh> result = new LinkedList<TerrainMesh>();
        for (TerrainMesh m : terrainMesh) {
            if (!MapUtil.isSegmentInsideArea(map, segment, m.getRectangleOver())) continue;
            result.add(m);
        }
        return result;
    }

    public List<LineSegment> calculateEngineLossRangeForPlace(JXMapViewer map, GpsPlace from, List<TerrainMesh[]> terrainMesh, boolean updatePleaseWaitDialog) {
        log.debug("Creating engine loss range for: " + from.getAlt() + ";" + this.samplesNum + ";" + this.liftToDragRatio + ";" + this.iasOfBestGlideInKt + ";" + this.windSpeed + ";" + this.windDirection + ";");
        ArrayList<LineSegment> result = new ArrayList<LineSegment>(this.samplesNum);
        Double angleStep = 360.0 / (double)this.samplesNum;
        ArrayList<MapShapeVertex> rangeShapeVertices = new ArrayList<MapShapeVertex>(this.samplesNum * 2);
        double maxRange = EngineLoss.getMaximumEngineLossRange(from.getAlt(), this.liftToDragRatio);
        for (int i = 0; i < this.samplesNum; ++i) {
            double bearing = (double)i * angleStep + 0.5 * angleStep;
            GpsPlace to = this.calculateMaximumEngineLossRangeWithWindForPlace(from, maxRange, bearing);
            int quater = (int)Math.floor(bearing / 90.0);
            LineSegment s = EngineLoss.createLineSegmentSample(map, from.clone(), to, terrainMesh.get(quater));
            if (s != null) {
                result.add(s);
                rangeShapeVertices.add(new MapShapeVertex(s.getTo()));
            } else {
                log.error("Error creating sample " + i);
            }
            if (!updatePleaseWaitDialog) continue;
            PleaseWaitDialog.getInstance().setProgress(i + 1);
        }
        MapShape engineLossRangeShape = new MapShape();
        engineLossRangeShape.setVertices(rangeShapeVertices.toArray(new MapShapeVertex[rangeShapeVertices.size()]));
        MapObjectsBean.getInstance().setHighlightedMapShape(engineLossRangeShape);
        MapFrame.getInstance().updateMap();
        return result;
    }

    public List<LineSegment> calculateEngineLossRangeForPlaceMultiCore(JXMapViewer map, GpsPlace from, List<TerrainMesh[]> terrainMesh, boolean updatePleaseWaitDialog) {
        log.info("MULTICORE! Creating engine loss range for: " + from.getAlt() + ";" + this.samplesNum + ";" + this.liftToDragRatio + ";" + this.iasOfBestGlideInKt + ";" + this.windSpeed + ";" + this.windDirection + ";");
        ExecutorService executor = Executors.newFixedThreadPool(Constants.NTHREDS_IO);
        ArrayList<Future<LineSegmentWithIndex>> futureList = new ArrayList<Future<LineSegmentWithIndex>>();
        Double angleStep = 360.0 / (double)this.samplesNum;
        ArrayList<MapShapeVertex> rangeShapeVertices = new ArrayList<MapShapeVertex>(this.samplesNum * 2);
        double maxRange = EngineLoss.getMaximumEngineLossRange(from.getAlt(), this.liftToDragRatio);
        for (int i = 0; i < this.samplesNum; ++i) {
            double bearing = (double)i * angleStep + 0.5 * angleStep;
            GpsPlace to = this.calculateMaximumEngineLossRangeWithWindForPlace(from, maxRange, bearing);
            int quater = (int)Math.floor(bearing / 90.0);
            futureList.add(executor.submit(new EngineLossSampleCallable(i, map, from.clone(), to, terrainMesh.get(quater))));
        }
        ArrayList<LineSegmentWithIndex> result = new ArrayList<LineSegmentWithIndex>(this.samplesNum);
        for (int i = 0; i < this.samplesNum; ++i) {
            Object s = null;
            try {
                s = (LineSegmentWithIndex)((Future)futureList.get(i)).get();
            }
            catch (InterruptedException e) {
                log.error(e, e);
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
            if (s != null) {
                result.add((LineSegmentWithIndex)s);
            } else {
                log.error("Error creating sample " + i);
            }
            if (!updatePleaseWaitDialog) continue;
            PleaseWaitDialog.getInstance().setProgress(i + 1);
        }
        Collections.sort(result, new Comparator<LineSegmentWithIndex>(){

            @Override
            public int compare(LineSegmentWithIndex o1, LineSegmentWithIndex o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getIndex().compareTo(o2.getIndex());
            }
        });
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>(result.size());
        for (LineSegmentWithIndex s : result) {
            segments.add(s.getSegment());
            rangeShapeVertices.add(new MapShapeVertex(s.getSegment().getTo()));
        }
        MapShape engineLossRangeShape = new MapShape();
        engineLossRangeShape.setVertices(rangeShapeVertices.toArray(new MapShapeVertex[rangeShapeVertices.size()]));
        MapObjectsBean.getInstance().setHighlightedMapShape(engineLossRangeShape);
        MapFrame.getInstance().updateMap();
        return segments;
    }

    public GpsArea getMaximumRangeArea(GpsPlace place) {
        double maxRangeInNm = EngineLoss.getMaximumEngineLossRange(place.getAlt(), this.liftToDragRatio);
        ArrayList<GpsVertex> places = new ArrayList<GpsVertex>();
        places.add(GpsUtil.getPointPositionByDistanceAndBearing(place, 0.0, maxRangeInNm));
        places.add(GpsUtil.getPointPositionByDistanceAndBearing(place, 90.0, maxRangeInNm));
        places.add(GpsUtil.getPointPositionByDistanceAndBearing(place, 180.0, maxRangeInNm));
        places.add(GpsUtil.getPointPositionByDistanceAndBearing(place, 270.0, maxRangeInNm));
        return GpsUtil.getRectangleOverVertices(places);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EngineLoss [samplesNum=");
        builder.append(this.samplesNum);
        builder.append(", liftToDragRatio=");
        builder.append(this.liftToDragRatio);
        builder.append(", iasOfBestGlideInKt=");
        builder.append(this.iasOfBestGlideInKt);
        builder.append(", windSpeed=");
        builder.append(this.windSpeed);
        builder.append(", windDirection=");
        builder.append(this.windDirection);
        builder.append("]");
        return builder.toString();
    }

    private class RouteSample {
        private final GpsPlace place;
        private final double segmentCourse;
        private final int segmentIndex;

        public RouteSample(GpsPlace place, double segmentCourse, int segmentIndex) {
            this.place = place;
            this.segmentCourse = segmentCourse;
            this.segmentIndex = segmentIndex;
        }

        public GpsPlace getPlace() {
            return this.place;
        }

        public double getSegmentCourse() {
            return this.segmentCourse;
        }

        public int getSegmentIndex() {
            return this.segmentIndex;
        }
    }
}

