/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import main.java.guru.vfrflight.ElevationArray;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.SrtmFileInfo;
import main.java.guru.vfrflight.core.comparator.ElevationsComparator;
import main.java.guru.vfrflight.core.dto.ElevationDTO;
import main.java.guru.vfrflight.core.dto.TerrainElevationDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.search.SearchParams;
import main.java.guru.vfrflight.core.sql.ImageMesh;
import main.java.guru.vfrflight.core.sql.IntToGpsMap;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.gui.concurrent.ElevationsInAreasTask;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.bean.HgtFile;
import main.java.guru.vfrflight.util.bean.HgtHeader;
import main.java.guru.vfrflight.util.bean.HgtZipFilesMapping;
import main.java.guru.vfrflight.util.bean.HgtZipFilesToDownload;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ElevationsUtil {
    private static final Logger log = Logger.getLogger(ElevationsUtil.class);
    private static final double ELEVATION_ARRAY_DELTA_LON_THRESHOLD = -0.00832639467110741;

    /*
     * Exception decompiling
     */
    public static SrtmFileInfo getSrtmFileInfo(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Elevation[] getElevationsFromFile(String fileName, int scale, boolean findMaxValue, GpsArea overRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Elevation[] loadElevationsFromHgtFilesMultipleRegions(String directoryPath, int scale, boolean findMaxValue, List<GpsArea> regions, boolean inFeet) {
        if (regions == null) {
            return ElevationsUtil.loadElevationsFromHgtFiles(directoryPath, scale, findMaxValue, null, inFeet);
        }
        SearchParams searchParams = new SearchParams("*.hgt");
        Set<DiskObject> files = SearchUtil.getRootList(searchParams, directoryPath);
        ArrayList<Elevation> results = new ArrayList<Elevation>();
        for (DiskObject file : files) {
            String filename = directoryPath + file.getPath();
            results.addAll(ElevationsUtil.loadElevationsFromHgtFileMultipleRegions(filename, scale, findMaxValue, regions, inFeet));
        }
        return results.toArray(new Elevation[results.size()]);
    }

    public static Elevation[] loadElevationsFromHgtFiles(String directoryPath, int scale, boolean findMaxValue, GpsArea overRegion, boolean inFeet) {
        SearchParams searchParams = new SearchParams("*.hgt");
        Set<DiskObject> files = SearchUtil.getRootList(searchParams, directoryPath);
        ArrayList<Elevation> results = new ArrayList<Elevation>();
        for (DiskObject file : files) {
            String filename = directoryPath + file.getPath();
            results.addAll(Arrays.asList(ElevationsUtil.loadElevationsFromHgtFile(filename, scale, findMaxValue, overRegion != null ? overRegion.clone() : null, inFeet)));
        }
        return results.toArray(new Elevation[results.size()]);
    }

    public static List<File> findHgtFilenamesForArea(String directoryPath, GpsArea area) {
        ArrayList<File> results = new ArrayList<File>();
        SearchParams searchParams = new SearchParams("*.hgt");
        Set<DiskObject> files = SearchUtil.getRootList(searchParams, directoryPath);
        for (DiskObject file : files) {
            File f = new File(directoryPath + file.getPath());
            HgtHeader header = new HgtHeader(f.getName());
            if (!header.isInside(area)) continue;
            results.add(f);
        }
        return results;
    }

    public static List<GpsArea> findGpsAreasFromHgtFiles(String directoryPath) {
        ArrayList<GpsArea> results = new ArrayList<GpsArea>();
        SearchParams searchParams = new SearchParams("*.hgt");
        Set<DiskObject> files = SearchUtil.getRootList(searchParams, directoryPath);
        for (DiskObject file : files) {
            File f = new File(directoryPath + file.getPath());
            HgtHeader header = new HgtHeader(f.getName());
            results.add(header.getCoveredRegion());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<Elevation> loadElevationsFromHgtFileMultipleRegions(String hgtFile, int scale, boolean findMaxValue, List<GpsArea> regions, boolean inFeet) {
        block26: {
            if (scale == 1) {
                return ElevationsUtil.loadElevationsFromHgtFileMultipleRegions(hgtFile, regions, inFeet);
            }
            File file = new File(hgtFile);
            if (!file.exists()) break block26;
            ArrayList<Elevation> results = new ArrayList<Elevation>();
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            LinkedList<GpsArea> newRegions = new LinkedList<GpsArea>();
            for (GpsArea overRegion : regions) {
                if (!header.isInside(overRegion)) continue;
                overRegion.expand(cellsize * 2.0);
                newRegions.add(overRegion);
            }
            if (newRegions.size() == 0) {
                return new ArrayList<Elevation>();
            }
            log.debug("Loading elevations from file " + hgtFile);
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                int startingCol = 0;
                int cnt = 0;
                int x = 0;
                int y = 0;
                int width = 0;
                int max = 0;
                short[][] elevs = new short[scale][size];
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elevs[row % scale][col] = elev = VfrUtil.byte2short(bytes);
                        if (row % scale != scale - 1 && row != size - 1 || col != size - 1) continue;
                        for (startingCol = 0; startingCol < size; startingCol += scale) {
                            width = scale;
                            max = Short.MIN_VALUE;
                            if (findMaxValue) {
                                max = Short.MIN_VALUE;
                                for (y = 0; y < scale; ++y) {
                                    for (x = startingCol; x < startingCol + scale; ++x) {
                                        if (x < size) {
                                            if (elevs[y][x] > max) {
                                                max = elevs[y][x];
                                            }
                                            elevs[y][x] = Short.MIN_VALUE;
                                            continue;
                                        }
                                        width = size % scale;
                                    }
                                }
                            } else {
                                max = 0;
                                cnt = 0;
                                for (y = 0; y < scale; ++y) {
                                    for (x = startingCol; x < startingCol + scale; ++x) {
                                        if (x < size) {
                                            if (elevs[y][x] <= Short.MIN_VALUE) continue;
                                            max += elevs[y][x];
                                            ++cnt;
                                            elevs[y][x] = Short.MIN_VALUE;
                                            continue;
                                        }
                                        width = size % scale;
                                    }
                                }
                                max = cnt > 0 ? Math.round(max / cnt) : Short.MIN_VALUE;
                            }
                            if (max <= Short.MIN_VALUE) continue;
                            if (row == size - 1) {
                                if (startingCol <= size - scale) {
                                    width = scale;
                                }
                                lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * ((double)row - (double)(size % scale - 1) / 2.0);
                            } else {
                                lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)(row - (int)Math.floor((double)scale / 2.0));
                            }
                            lon = (double)xllcorner + cellsize * ((double)startingCol + (double)(width - 1) / 2.0);
                            for (GpsArea overRegion : newRegions) {
                                if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                                if (inFeet) {
                                    max = (short)Math.round(UnitUtil.recalculateAltitude(max, "m", "ft", false));
                                }
                                results.add(new Elevation(lat, lon, (short)max));
                            }
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e) {
                log.error(e, e);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return results;
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<Elevation> loadElevationsFromHgtFileMultipleRegions(String hgtFile, List<GpsArea> regions, boolean inFeet) {
        block13: {
            if (regions == null) {
                return null;
            }
            File file = new File(hgtFile);
            if (!file.exists()) break block13;
            ArrayList<Elevation> results = new ArrayList<Elevation>();
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            GpsPlace topLeft = new GpsPlace(new GpsCoord(yllcorner + 1), new GpsCoord(xllcorner));
            GpsPlace bottomRight = new GpsPlace(new GpsCoord(yllcorner), new GpsCoord(xllcorner + 1));
            GpsArea coveredRegion = new GpsArea(topLeft, bottomRight);
            LinkedList<GpsArea> newRegions = new LinkedList<GpsArea>();
            for (GpsArea overRegion : regions) {
                if (!overRegion.isInside(coveredRegion) && !coveredRegion.isInside(overRegion)) continue;
                overRegion.expand(cellsize * 2.0);
                newRegions.add(overRegion);
            }
            if (newRegions.size() == 0) {
                return new ArrayList<Elevation>();
            }
            log.debug("Loading elevations from file " + hgtFile);
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elev = VfrUtil.byte2short(bytes);
                        if (elev <= Short.MIN_VALUE) continue;
                        lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)row;
                        lon = (double)xllcorner + cellsize * (double)col;
                        for (GpsArea overRegion : newRegions) {
                            if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                            if (inFeet) {
                                elev = (short)Math.round(UnitUtil.recalculateAltitude(elev, "m", "ft", false));
                            }
                            results.add(new Elevation(lat, lon, elev));
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e2) {
                log.error(e2, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return results;
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Elevation[] loadElevationsFromHgtFile(String hgtFile, GpsArea overRegion, boolean inFeet) {
        block11: {
            File file = new File(hgtFile);
            if (!file.exists()) break block11;
            ArrayList<Elevation> results = new ArrayList<Elevation>();
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            if (overRegion != null) {
                GpsPlace topLeft = new GpsPlace(new GpsCoord(yllcorner + 1), new GpsCoord(xllcorner));
                GpsPlace bottomRight = new GpsPlace(new GpsCoord(yllcorner), new GpsCoord(xllcorner + 1));
                GpsArea coveredRegion = new GpsArea(topLeft, bottomRight);
                if (!overRegion.isInside(coveredRegion) && !coveredRegion.isInside(overRegion)) {
                    return results.toArray(new Elevation[results.size()]);
                }
                overRegion.expand(cellsize);
            }
            log.debug("Loading elevations from file " + hgtFile);
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elev = VfrUtil.byte2short(bytes);
                        if (elev <= Short.MIN_VALUE) continue;
                        lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)row;
                        lon = (double)xllcorner + cellsize * (double)col;
                        if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                        if (inFeet) {
                            elev = (short)Math.round(UnitUtil.recalculateAltitude(elev, "m", "ft", false));
                        }
                        results.add(new Elevation(lat, lon, elev));
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e2) {
                log.error(e2, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return results.toArray(new Elevation[results.size()]);
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Elevation[] loadElevationsFromHgtFile(String hgtFile, int scale, boolean findMaxValue, GpsArea overRegion, boolean inFeet) {
        block25: {
            if (scale == 1) {
                return ElevationsUtil.loadElevationsFromHgtFile(hgtFile, overRegion, inFeet);
            }
            File file = new File(hgtFile);
            if (!file.exists()) break block25;
            ArrayList<Elevation> results = new ArrayList<Elevation>();
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            if (overRegion != null) {
                GpsPlace topLeft = new GpsPlace(new GpsCoord(yllcorner + 1), new GpsCoord(xllcorner));
                GpsPlace bottomRight = new GpsPlace(new GpsCoord(yllcorner), new GpsCoord(xllcorner + 1));
                GpsArea coveredRegion = new GpsArea(topLeft, bottomRight);
                if (!overRegion.isInside(coveredRegion) && !coveredRegion.isInside(overRegion)) {
                    return results.toArray(new Elevation[results.size()]);
                }
                overRegion.expand((double)scale * cellsize);
            }
            log.debug("Loading elevations from file " + hgtFile);
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                int startingCol = 0;
                int cnt = 0;
                int x = 0;
                int y = 0;
                int width = 0;
                int max = 0;
                short[][] elevs = new short[scale][size];
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elevs[row % scale][col] = elev = VfrUtil.byte2short(bytes);
                        if (row % scale != scale - 1 && row != size - 1 || col != size - 1) continue;
                        for (startingCol = 0; startingCol < size; startingCol += scale) {
                            width = scale;
                            max = Short.MIN_VALUE;
                            if (findMaxValue) {
                                max = Short.MIN_VALUE;
                                for (y = 0; y < scale; ++y) {
                                    for (x = startingCol; x < startingCol + scale; ++x) {
                                        if (x < size) {
                                            if (elevs[y][x] > max) {
                                                max = elevs[y][x];
                                            }
                                            elevs[y][x] = Short.MIN_VALUE;
                                            continue;
                                        }
                                        width = size % scale;
                                    }
                                }
                            } else {
                                max = 0;
                                cnt = 0;
                                for (y = 0; y < scale; ++y) {
                                    for (x = startingCol; x < startingCol + scale; ++x) {
                                        if (x < size) {
                                            if (elevs[y][x] <= Short.MIN_VALUE) continue;
                                            max += elevs[y][x];
                                            ++cnt;
                                            elevs[y][x] = Short.MIN_VALUE;
                                            continue;
                                        }
                                        width = size % scale;
                                    }
                                }
                                max = cnt > 0 ? Math.round(max / cnt) : Short.MIN_VALUE;
                            }
                            if (max <= Short.MIN_VALUE) continue;
                            if (row == size - 1) {
                                if (startingCol <= size - scale) {
                                    width = scale;
                                }
                                lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * ((double)row - (double)(size % scale - 1) / 2.0);
                            } else {
                                lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)(row - (int)Math.floor((double)scale / 2.0));
                            }
                            lon = (double)xllcorner + cellsize * ((double)startingCol + (double)(width - 1) / 2.0);
                            if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                            if (inFeet) {
                                max = (short)Math.round(UnitUtil.recalculateAltitude(max, "m", "ft", false));
                            }
                            results.add(new Elevation(lat, lon, (short)max));
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e) {
                log.error(e, e);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return results.toArray(new Elevation[results.size()]);
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    public static Elevation[] getElevationsInAreas(Elevation[] elevations, GpsArea[] areas) {
        ArrayList<Elevation> result = new ArrayList<Elevation>();
        int i = 0;
        int j = 0;
        block0: for (i = 0; i < elevations.length; ++i) {
            for (j = 0; j < areas.length; ++j) {
                if (!areas[j].contains(elevations[i].getLat(), elevations[i].getLon())) continue;
                result.add(elevations[i]);
                continue block0;
            }
        }
        return result.toArray(new Elevation[result.size()]);
    }

    public static Elevation[] getElevationsInAreasMultiCore(Elevation[] elevations, GpsArea[] areas) {
        if (elevations.length < Constants.NTHREDS * 500) {
            return ElevationsUtil.getElevationsInAreas(elevations, areas);
        }
        log.debug("getElevationsInAreasMultiCore: start");
        int size = (int)Math.floor(elevations.length / Constants.NTHREDS);
        ArrayList<ForkJoinTask<List<Elevation>>> futuresList = new ArrayList<ForkJoinTask<List<Elevation>>>();
        ForkJoinPool fjPool = new ForkJoinPool(Constants.NTHREDS);
        int from = 0;
        int to = 0;
        for (int index = 0; index < Constants.NTHREDS; ++index) {
            from = index * size;
            to = index < Constants.NTHREDS - 1 ? (index + 1) * size - 1 : elevations.length - 1;
            log.debug("getElevationsInAreasMultiCore: starting task " + index + " / " + Constants.NTHREDS);
            futuresList.add(fjPool.submit(new ElevationsInAreasTask(Arrays.copyOfRange(elevations, from, to), areas)));
        }
        ArrayList results = new ArrayList();
        int i = 0;
        for (Future future : futuresList) {
            try {
                log.debug("getElevationsInAreasMultiCore: waiting for task " + ++i + " / " + futuresList.size() + " finished");
                results.addAll((Collection)future.get());
            }
            catch (InterruptedException e) {
                --i;
            }
            catch (ExecutionException e) {
                --i;
            }
        }
        log.debug("getElevationsInAreasMultiCore: all tasks finished");
        return results.toArray(new Elevation[results.size()]);
    }

    public static TerrainMesh[] createTerrainMeshFromHgtFiles(String directoryPath, int scale, boolean findMaxValue, boolean includeZero, GpsArea overRegion) {
        SearchParams searchParams = new SearchParams("*.hgt");
        Set<DiskObject> files = SearchUtil.getRootList(searchParams, directoryPath);
        ArrayList<TerrainMesh> results = new ArrayList<TerrainMesh>();
        for (DiskObject file : files) {
            String filename = directoryPath + file.getPath();
            results.addAll(Arrays.asList(ElevationsUtil.createTerrainMeshFromHgtFile(filename, scale, findMaxValue, includeZero, overRegion != null ? overRegion.clone() : null)));
        }
        return results.toArray(new TerrainMesh[results.size()]);
    }

    public static ElevationArray createElevationArray(Elevation[] elevations, GpsArea area, boolean withZeroValue) {
        List<Elevation> elevationsList = Arrays.asList(elevations);
        Collections.sort(elevationsList, new ElevationsComparator());
        int cols = 0;
        int rows = 0;
        int cnt = 0;
        for (int i = 1; i < elevationsList.size(); ++i) {
            ++cnt;
            if (!(elevationsList.get(i).getLon() - elevationsList.get(i - 1).getLon() < -0.00832639467110741)) continue;
            if (cnt > cols) {
                cols = cnt;
            }
            cnt = 0;
            ++rows;
        }
        Elevation[][] data = new Elevation[++rows][cols];
        int col = 0;
        int row = 0;
        for (int i = 0; i < elevationsList.size(); ++i) {
            if (i > 0 && elevationsList.get(i).getLon() - elevationsList.get(i - 1).getLon() < -0.00832639467110741) {
                ++row;
                col = 0;
            }
            if (withZeroValue || elevationsList.get(i).getElev() != 0) {
                data[row][col] = elevationsList.get(i);
            }
            ++col;
        }
        return new ElevationArray(data, area);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ElevationArray createElevationArrayFromHgtFile(String hgtFile, GpsArea overRegion) {
        block10: {
            GpsPlace bottomRight;
            GpsPlace topLeft;
            GpsArea coveredRegion;
            File file = new File(hgtFile);
            if (!file.exists()) break block10;
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            ElevationArray resultArray = new ElevationArray(size, size);
            if (overRegion != null && !overRegion.isInside(coveredRegion = new GpsArea(topLeft = new GpsPlace(new GpsCoord(yllcorner + 1), new GpsCoord(xllcorner)), bottomRight = new GpsPlace(new GpsCoord(yllcorner), new GpsCoord(xllcorner + 1)))) && !coveredRegion.isInside(overRegion)) {
                return resultArray;
            }
            resultArray.setArea(overRegion);
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elev = VfrUtil.byte2short(bytes);
                        if (elev == Short.MIN_VALUE) {
                            elev = 0;
                        }
                        lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)row;
                        lon = (double)xllcorner + cellsize * (double)col;
                        if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                        resultArray.setAt(col, row, new Elevation(lat, lon, elev));
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e2) {
                log.error(e2, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return resultArray;
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static TerrainMesh[] createTerrainMeshFromHgtFile(String hgtFile, boolean includeZero, GpsArea overRegion) {
        block9: {
            GpsPlace bottomRight;
            GpsPlace topLeft;
            GpsArea coveredRegion;
            File file = new File(hgtFile);
            if (!file.exists()) break block9;
            ArrayList<TerrainMesh> results = new ArrayList<TerrainMesh>();
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            if (overRegion != null && !overRegion.isInside(coveredRegion = new GpsArea(topLeft = new GpsPlace(new GpsCoord(yllcorner + 1), new GpsCoord(xllcorner)), bottomRight = new GpsPlace(new GpsCoord(yllcorner), new GpsCoord(xllcorner + 1)))) && !coveredRegion.isInside(overRegion)) {
                return results.toArray(new TerrainMesh[results.size()]);
            }
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                double cellHalfSize = cellsize / 2.0;
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elev = VfrUtil.byte2short(bytes);
                        if (elev <= Short.MIN_VALUE || !includeZero && elev == 0) continue;
                        lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)row;
                        lon = (double)xllcorner + cellsize * (double)col;
                        if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                        elev = (short)Math.round(UnitUtil.recalculateAltitude(elev, "m", "ft", false));
                        GeoPosition topLeft2 = new GeoPosition(GpsUtil.increaseLat(lat, cellHalfSize), GpsUtil.increaseLon(lon, -cellHalfSize));
                        GeoPosition bottomRight2 = new GeoPosition(GpsUtil.increaseLat(lat, -cellHalfSize), GpsUtil.increaseLon(lon, cellHalfSize));
                        results.add(new TerrainMesh(topLeft2, bottomRight2, elev));
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e2) {
                log.error(e2, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return results.toArray(new TerrainMesh[results.size()]);
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static TerrainMesh[] createTerrainMeshFromHgtFile(String hgtFile, int scale, boolean findMaxValue, boolean includeZero, GpsArea overRegion) {
        block23: {
            GpsPlace bottomRight;
            GpsPlace topLeft;
            GpsArea coveredRegion;
            if (scale == 1) {
                return ElevationsUtil.createTerrainMeshFromHgtFile(hgtFile, includeZero, overRegion);
            }
            File file = new File(hgtFile);
            if (!file.exists()) break block23;
            ArrayList<TerrainMesh> results = new ArrayList<TerrainMesh>();
            HgtHeader header = new HgtHeader(file.getName());
            int xllcorner = header.getXllcorner();
            int yllcorner = header.getYllcorner();
            int size = header.getSize();
            double cellsize = header.getCellsize();
            if (overRegion != null && !overRegion.isInside(coveredRegion = new GpsArea(topLeft = new GpsPlace(new GpsCoord(yllcorner + 1), new GpsCoord(xllcorner)), bottomRight = new GpsPlace(new GpsCoord(yllcorner), new GpsCoord(xllcorner + 1)))) && !coveredRegion.isInside(overRegion)) {
                return results.toArray(new TerrainMesh[results.size()]);
            }
            BufferedInputStream os = null;
            byte[] bytes = new byte[2];
            try {
                os = new BufferedInputStream(new FileInputStream(hgtFile));
                double lat = 0.0;
                double lon = 0.0;
                short elev = 0;
                int startingCol = 0;
                int cnt = 0;
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                int max = 0;
                short[][] elevs = new short[scale][size];
                for (int row = 0; row < size; ++row) {
                    for (int col = 0; col < size; ++col) {
                        os.read(bytes);
                        elevs[row % scale][col] = elev = VfrUtil.byte2short(bytes);
                        if (row % scale != scale - 1 && row != size - 1 || col != size - 1) continue;
                        for (startingCol = 0; startingCol < size; startingCol += scale) {
                            width = scale;
                            max = Short.MIN_VALUE;
                            if (findMaxValue) {
                                max = Short.MIN_VALUE;
                                for (y = 0; y < scale; ++y) {
                                    for (x = startingCol; x < startingCol + scale; ++x) {
                                        if (x < size) {
                                            if (elevs[y][x] > max) {
                                                max = elevs[y][x];
                                            }
                                            elevs[y][x] = Short.MIN_VALUE;
                                            continue;
                                        }
                                        width = size % scale;
                                    }
                                }
                            } else {
                                max = 0;
                                cnt = 0;
                                for (y = 0; y < scale; ++y) {
                                    for (x = startingCol; x < startingCol + scale; ++x) {
                                        if (x < size) {
                                            if (elevs[y][x] <= Short.MIN_VALUE) continue;
                                            max += elevs[y][x];
                                            ++cnt;
                                            elevs[y][x] = Short.MIN_VALUE;
                                            continue;
                                        }
                                        width = size % scale;
                                    }
                                }
                                max = cnt > 0 ? Math.round(max / cnt) : Short.MIN_VALUE;
                            }
                            if (max <= Short.MIN_VALUE || !includeZero && max == 0) continue;
                            if (row == size - 1) {
                                if (startingCol <= size - scale) {
                                    width = scale;
                                }
                                height = size % scale;
                                lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * ((double)row - (double)(height - 1) / 2.0);
                            } else {
                                height = scale;
                                lat = (double)yllcorner + (double)(size - 1) * cellsize - cellsize * (double)(row - (int)Math.floor((double)scale / 2.0));
                            }
                            lon = (double)xllcorner + cellsize * ((double)startingCol + (double)(width - 1) / 2.0);
                            if (overRegion != null && !overRegion.contains(lat, lon)) continue;
                            max = (short)Math.round(UnitUtil.recalculateAltitude(max, "m", "ft", false));
                            double cellHalfHeight = cellsize * (double)height / 2.0;
                            double cellHalfWidth = cellsize * (double)width / 2.0;
                            GeoPosition topLeft2 = new GeoPosition(GpsUtil.increaseLat(lat, cellHalfHeight), GpsUtil.increaseLon(lon, -cellHalfWidth));
                            GeoPosition bottomRight2 = new GeoPosition(GpsUtil.increaseLat(lat, -cellHalfHeight), GpsUtil.increaseLon(lon, cellHalfWidth));
                            results.add(new TerrainMesh(topLeft2, bottomRight2, (short)max));
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e) {
                log.error(e, e);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return results.toArray(new TerrainMesh[results.size()]);
        }
        log.error("File " + hgtFile + " doesn't exist!");
        return null;
    }

    public static ImageMesh[] createImageMesh(String imagePath, List<IntToGpsMap> map) {
        double error;
        if (map == null || map.size() < 2) {
            return null;
        }
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(imagePath));
        }
        catch (IOException e) {
            log.error(e);
            return null;
        }
        log.info("Loaded image: " + img.getWidth() + "x" + img.getHeight());
        double cellWidth = 0.001;
        double cellHeight = 0.001;
        double latStart = map.get(0).getLat();
        double lonStart = map.get(0).getLon();
        double rotation = 0.0;
        double prevError = error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
        double deltaError = 0.0;
        log.info("Starting iterations with error " + error);
        int i = 0;
        do {
            ++i;
            latStart = ElevationsUtil.adjustLatStart(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            lonStart = ElevationsUtil.adjustLonStart(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            cellWidth = ElevationsUtil.adjustCellWidth(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            cellHeight = ElevationsUtil.adjustCellHeight(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        do {
            ++i;
            rotation = ElevationsUtil.adjustRotation(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            latStart = ElevationsUtil.adjustLatStart(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            lonStart = ElevationsUtil.adjustLonStart(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            cellWidth = ElevationsUtil.adjustCellWidth(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            cellHeight = ElevationsUtil.adjustCellHeight(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        do {
            ++i;
            cellWidth = ElevationsUtil.adjustCellWidth(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            cellHeight = ElevationsUtil.adjustCellHeight(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            latStart = ElevationsUtil.adjustLatStart(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            lonStart = ElevationsUtil.adjustLonStart(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        log.info("Finished after " + i + " iterations, with error " + error + ". ROTATION " + rotation);
        return ElevationsUtil.createImageMesh(img, latStart, lonStart, cellWidth, cellHeight, rotation);
    }

    private static double adjustRotation(List<IntToGpsMap> map, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        double error;
        double step = 0.05;
        double prevError = error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
        double deltaError = 0.0;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation += step);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        rotation -= step;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation -= step);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        return rotation += step;
    }

    private static double adjustLatStart(List<IntToGpsMap> map, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        double error;
        double step = 0.001;
        double prevError = error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
        double deltaError = 0.0;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart += step, lonStart, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        latStart -= step;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart -= step, lonStart, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        return latStart += step;
    }

    private static double adjustLonStart(List<IntToGpsMap> map, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        double error;
        double step = 0.001;
        double prevError = error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
        double deltaError = 0.0;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart -= step, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        lonStart += step;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart += step, cellWidth, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        return lonStart -= step;
    }

    private static double adjustCellWidth(List<IntToGpsMap> map, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        double error;
        double prevError = error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
        double deltaError = 0.0;
        double step = cellWidth / 1000.0;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth += step, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        cellWidth -= step;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth -= step, cellHeight, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        return cellWidth += step;
    }

    private static double adjustCellHeight(List<IntToGpsMap> map, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        double error;
        double prevError = error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight, rotation);
        double deltaError = 0.0;
        double step = cellHeight / 1000.0;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight += step, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        cellHeight -= step;
        do {
            error = ElevationsUtil.calculateLeastSquaresError(map, latStart, lonStart, cellWidth, cellHeight -= step, rotation);
            deltaError = error - prevError;
            prevError = error;
        } while (deltaError < 0.0);
        return cellHeight += step;
    }

    private static double calculateLeastSquaresError(List<IntToGpsMap> map, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        double error = 0.0;
        List<IntToGpsMap> newMap = null;
        if (rotation != 0.0) {
            double angle = Math.toRadians(rotation);
            newMap = new ArrayList<IntToGpsMap>();
            double xCenter = 0.0;
            double yCenter = 0.0;
            for (IntToGpsMap val : map) {
                xCenter += val.getX();
                yCenter += val.getY();
            }
            xCenter /= (double)map.size();
            yCenter /= (double)map.size();
            for (IntToGpsMap val : map) {
                double x1 = val.getX() - xCenter;
                double y1 = val.getY() - yCenter;
                x1 = x1 * Math.cos(angle) - y1 * Math.sin(angle);
                y1 = x1 * Math.sin(angle) + y1 * Math.cos(angle);
                IntToGpsMap v = val.clone();
                v.setX(x1 + xCenter);
                v.setY(y1 + yCenter);
                newMap.add(v);
            }
        } else {
            newMap = map;
        }
        for (IntToGpsMap val : newMap) {
            error += Math.pow(val.getLat() - (latStart + val.getY() * cellHeight), 2.0);
            error += Math.pow(val.getLon() - (lonStart + val.getX() * cellWidth), 2.0);
        }
        return error;
    }

    public static ImageMesh[] createImageMesh(BufferedImage img, double latStart, double lonStart, double cellWidth, double cellHeight, double rotation) {
        if (rotation != 0.0) {
            int r = (int)Math.ceil(Math.sqrt(Math.pow(img.getWidth() / 2, 2.0) + Math.pow(img.getHeight() / 2, 2.0))) * 2;
            int dx = (int)Math.round((double)(r - img.getWidth()) / 2.0);
            int dy = (int)Math.round((double)(r - img.getHeight()) / 2.0);
            BufferedImage newImg = new BufferedImage(r, r, 2);
            Graphics2D g = newImg.createGraphics();
            g.drawImage((Image)img, dx, dy, null);
            g.dispose();
            latStart -= (double)dy * cellHeight;
            lonStart -= (double)dx * cellWidth;
            AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(rotation), newImg.getWidth() / 2, newImg.getHeight() / 2);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            img = op.filter(newImg, null);
        }
        ArrayList<ImageMesh> results = new ArrayList<ImageMesh>();
        double cellHalfWidth = cellWidth / 2.0;
        double cellHalfHeight = cellHeight / 2.0;
        for (int row = 0; row < img.getHeight(); ++row) {
            for (int col = 0; col < img.getWidth(); ++col) {
                double centerLat = latStart + (double)row * cellHeight;
                double centerLon = lonStart + (double)col * cellWidth;
                GeoPosition topLeft = new GeoPosition(GpsUtil.increaseLat(centerLat, cellHalfHeight), GpsUtil.increaseLon(centerLon, -cellHalfWidth));
                GeoPosition bottomRight = new GeoPosition(GpsUtil.increaseLat(centerLat, -cellHalfHeight), GpsUtil.increaseLon(centerLon, cellHalfWidth));
                int pixel = img.getRGB(col, row);
                float a = (float)(pixel >> 24 & 0xFF) / 255.0f;
                if (!(a > 0.0f)) continue;
                float r = (float)(pixel >> 16 & 0xFF) / 255.0f;
                float g = (float)(pixel >> 8 & 0xFF) / 255.0f;
                float b = (float)(pixel & 0xFF) / 255.0f;
                results.add(new ImageMesh(topLeft, bottomRight, a, r, g, b));
            }
        }
        log.info(results.size());
        return results.toArray(new ImageMesh[results.size()]);
    }

    public static List<TerrainElevationDTO> calculateTerrainElevations(Elevation[] elevations, double step, double latMin, double latMax, double lonMin, double lonMax) {
        log.error("START");
        LinkedList<TerrainElevationDTO> terrainElevations = new LinkedList<TerrainElevationDTO>();
        LinkedList<Elevation> elevList = new LinkedList<Elevation>();
        for (double lat = latMax; lat >= latMin; lat -= step) {
            log.error(lat + "; " + terrainElevations.size());
            elevList.clear();
            GpsArea area = new GpsArea(lat, lonMin, lat - step, lonMax);
            area.expand(step * 2.0);
            for (Elevation e : elevations) {
                if (!e.isInside(area)) continue;
                elevList.add(e);
            }
            for (double lon = lonMin; lon <= lonMax; lon += step) {
                GpsPlace cen = new GpsPlace(lat - step, lon + step);
                int idx1 = -1;
                int idx2 = -1;
                double minDist = 100000.0;
                for (int i = 0; i < elevList.size(); ++i) {
                    double d;
                    if (!(((Elevation)elevList.get(i)).getLon() >= lon) || !(((Elevation)elevList.get(i)).getLon() <= lon + step) || !((d = GpsUtil.getGreatCircleDistance(((Elevation)elevList.get(i)).getGpsPlace(), cen)) <= 50.0) || !(d <= minDist)) continue;
                    minDist = d;
                    idx2 = idx1;
                    idx1 = i;
                }
                if (idx1 < 0 || idx2 < 0) continue;
                double dist1 = GpsUtil.getDistance(((Elevation)elevList.get(idx1)).getGpsPlace(), cen);
                double dist2 = GpsUtil.getDistance(((Elevation)elevList.get(idx2)).getGpsPlace(), cen);
                double sum = dist1 + dist2;
                short elev = (short)Math.round((1.0 - dist1 / sum) * (double)((Elevation)elevList.get(idx1)).getElev().shortValue() + (1.0 - dist2 / sum) * (double)((Elevation)elevList.get(idx2)).getElev().shortValue());
                area = new GpsArea(new GpsPlace(lat, lon), new GpsPlace(lat - step, lon + step));
                terrainElevations.add(new TerrainElevationDTO(area, elev));
            }
        }
        log.error("END xxx => " + terrainElevations.size());
        return terrainElevations;
    }

    public static List<TerrainElevationDTO> calculateTerrainElevations2(Elevation[] elevations, double step) {
        log.error("START");
        LinkedList<TerrainElevationDTO> terrainElevations = new LinkedList<TerrainElevationDTO>();
        for (Elevation e : elevations) {
            double offset;
            short elev = (short)(e.getElev() - 10);
            if (e.getLat() >= 60.0) {
                offset = -0.004;
                terrainElevations.add(new TerrainElevationDTO(new GpsArea(new GpsPlace(e.getLat() + step + offset, e.getLon() - step - offset), new GpsPlace(e.getLat() - step - offset, e.getLon() + step + offset)), elev));
                continue;
            }
            if (e.getLat() >= -60.0) {
                terrainElevations.add(new TerrainElevationDTO(new GpsArea(new GpsPlace(e.getLat() + step, e.getLon() - step), new GpsPlace(e.getLat() - step, e.getLon() + step)), elev));
                continue;
            }
            offset = 0.039;
            terrainElevations.add(new TerrainElevationDTO(new GpsArea(new GpsPlace(e.getLat() + step + offset, e.getLon() - step - offset), new GpsPlace(e.getLat() - step - offset, e.getLon() + step + offset)), elev));
        }
        log.error("END xxx => " + terrainElevations.size());
        return terrainElevations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dumpTerrainElevationsToFile(String fileName, List<TerrainElevationDTO> terrainElevations) {
        log.info("Dumping " + terrainElevations.size() + " terrain elevations to file " + fileName);
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new FileOutputStream(fileName));
            os.writeInt(terrainElevations.size());
            for (TerrainElevationDTO el : terrainElevations) {
                GpsPlace topLeft = el.getArea().getTopLeft();
                GpsPlace bottomRight = el.getArea().getBottomRight();
                os.writeDouble(topLeft.getLat().getValue());
                os.writeDouble(topLeft.getLon().getValue());
                os.writeDouble(bottomRight.getLat().getValue());
                os.writeDouble(bottomRight.getLon().getValue());
                os.writeShort(el.getElev().shortValue());
            }
        }
        catch (FileNotFoundException e) {
            log.error(e, e);
            IOUtil.closeQuietly(os);
        }
        catch (IOException e2) {
            log.error(e2, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(os);
        }
        IOUtil.closeQuietly(os);
        log.info("Done.");
    }

    public static TerrainElevationDTO[] loadTerrainElevations(GpsArea area) {
        return ElevationsUtil.loadTerrainElevationsTableFromFile(area, "data/terrain.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static TerrainElevationDTO[] loadTerrainElevationsTableFromFile(GpsArea area, String fileName) {
        if (new File(fileName).exists()) {
            TerrainElevationDTO[] terrainElevationDTOArray;
            log.debug("Loading terrain elevations from file " + fileName);
            byte[] twoBytes = new byte[2];
            byte[] fourBytes = new byte[4];
            byte[] eightBytes1 = new byte[8];
            byte[] eightBytes2 = new byte[8];
            ArrayList<TerrainElevationDTO> result = new ArrayList<TerrainElevationDTO>();
            BufferedInputStream os = null;
            GpsArea ar = null;
            try {
                os = new BufferedInputStream(new FileInputStream(fileName));
                os.read(fourBytes);
                int size = VfrUtil.byte2int(fourBytes);
                for (int i = 0; i < size; ++i) {
                    os.read(eightBytes1);
                    os.read(eightBytes2);
                    GpsPlace topLeft = new GpsPlace(VfrUtil.byte2double(eightBytes1), VfrUtil.byte2double(eightBytes2));
                    os.read(eightBytes1);
                    os.read(eightBytes2);
                    GpsPlace bottomRight = new GpsPlace(VfrUtil.byte2double(eightBytes1), VfrUtil.byte2double(eightBytes2));
                    os.read(twoBytes);
                    ar = new GpsArea(topLeft, bottomRight);
                    if (area != null && !ar.isInside(area) && !area.isInside(ar)) continue;
                    result.add(new TerrainElevationDTO(ar, VfrUtil.byte2short(twoBytes)));
                }
                log.debug("Loaded " + result.size() + ". Done.");
                terrainElevationDTOArray = result.toArray(new TerrainElevationDTO[result.size()]);
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(os);
            }
            catch (IOException e2) {
                log.error(e2, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(os);
            }
            IOUtil.closeQuietly(os);
            return terrainElevationDTOArray;
        } else {
            log.error("Couldn't find file " + fileName);
        }
        return null;
    }

    public static void calculateTerrainElevations(String filename, double step, double latMin, double latMax, double lonMin, double lonMax) {
        MapFacade facade = new MapFacade(DBUtil.getDataSource());
        LinkedList<Elevation> elevations = new LinkedList<Elevation>(facade.findElevations(0));
        if (elevations != null && elevations.size() > 0) {
            List<TerrainElevationDTO> terrainElevations = ElevationsUtil.calculateTerrainElevations(elevations.toArray(new Elevation[elevations.size()]), step, latMin, latMax, lonMin, lonMax);
            ElevationsUtil.dumpTerrainElevationsToFile(filename, terrainElevations);
        }
    }

    public static void calculateTerrainElevations2(String filename, double step, double latMin, double latMax, double lonMin, double lonMax) {
        ElevationFacade facade = new ElevationFacade(DBUtil.getDataSource());
        List<Elevation> elevations = facade.findElevationsInArea(new GpsArea(latMax, lonMin, latMin, lonMax));
        if (elevations != null && elevations.size() > 0) {
            List<TerrainElevationDTO> terrainElevations = ElevationsUtil.calculateTerrainElevations2(elevations.toArray(new Elevation[elevations.size()]), step);
            ElevationsUtil.dumpTerrainElevationsToFile(filename, terrainElevations);
        }
    }

    public static void findAndCopyHgtFiles(String directoryPath, GpsArea region, String tempDir) {
        log.info("findAndCompressHgtFiles: " + directoryPath + "; " + region + ";" + tempDir);
        List<File> files = ElevationsUtil.findHgtFilenamesForArea(directoryPath, region);
        if (files.size() > 0) {
            File td = new File(tempDir);
            if (!td.exists() || td.isFile()) {
                td.mkdirs();
            }
            if (SearchUtil.countFiles(tempDir) > 0L) {
                log.fatal(tempDir + " is not empty. Bailing out!");
            } else {
                log.info("Copying " + files.size() + " into " + tempDir);
                for (File f : files) {
                    try {
                        Files.copy(Paths.get(f.getAbsolutePath(), new String[0]), Paths.get(StringUtil.finishWithSlash(tempDir) + f.getName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        log.error(e, e);
                    }
                }
                log.info("All done.");
            }
        }
    }

    public static HgtZipFilesMapping[] readHgtZipFilesMappings() {
        ArrayList<HgtZipFilesMapping> result = new ArrayList<HgtZipFilesMapping>();
        List<String> rows = IOUtil.loadTextFileAsRows("data/hgt.data");
        if (rows == null) {
            return null;
        }
        String filename = null;
        long size = 0L;
        for (int i = 0; i < rows.size(); ++i) {
            if (rows.get(i).startsWith("FILE:")) {
                filename = rows.get(i).substring(5);
                continue;
            }
            if (rows.get(i).startsWith("SIZE:")) {
                try {
                    size = Long.valueOf(rows.get(i).substring(5));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            LinkedList<GpsArea> areas = new LinkedList<GpsArea>();
            do {
                String[] coords;
                if ((coords = rows.get(i).split(":")).length >= 5) {
                    double minLon = Double.valueOf(coords[2]);
                    double minLat = Double.valueOf(coords[1]);
                    areas.add(new GpsArea(Double.valueOf(coords[3]), minLon, minLat, Double.valueOf(coords[4])));
                    continue;
                }
                log.error("Invalid row: " + rows.get(i));
            } while (rows.size() < ++i && rows.get(i).startsWith("AREA:"));
            --i;
            if (areas.size() <= 0) continue;
            result.add(new HgtZipFilesMapping(filename, areas.toArray(new GpsArea[areas.size()]), size));
        }
        return result.toArray(new HgtZipFilesMapping[result.size()]);
    }

    public static String getZipHgtFilenameForPlace(GpsPlace place, HgtZipFilesMapping[] mappings) {
        for (HgtZipFilesMapping mapping : mappings) {
            if (!mapping.contains(place)) continue;
            return mapping.getZipPath();
        }
        return null;
    }

    public static HgtZipFilesToDownload getHgtFilesToDownloadForArea(GpsArea area, String hgtFilesPath, HgtZipFilesMapping[] mappings) {
        ArrayList<String> filesToDownload = new ArrayList<String>();
        List<HgtFile> files = ElevationsUtil.getHgtFilenamesForArea(area, mappings);
        if (files.size() > 0) {
            Set<DiskObject> results = SearchUtil.getRootList("*.hgt", hgtFilesPath);
            ListIterator<HgtFile> it = files.listIterator();
            block0: while (it.hasNext()) {
                HgtFile file = it.next();
                for (DiskObject d : results) {
                    if (!d.getName().equalsIgnoreCase(file.getFilename())) continue;
                    it.remove();
                    continue block0;
                }
            }
            long totalSize = 0L;
            for (HgtFile file : files) {
                if (filesToDownload.contains(file.getZipName())) continue;
                filesToDownload.add(file.getZipName());
                totalSize += file.getSize();
            }
            return new HgtZipFilesToDownload(filesToDownload, totalSize);
        }
        return null;
    }

    private static List<HgtFile> getHgtFilenamesForArea(GpsArea area, HgtZipFilesMapping[] mappings) {
        ArrayList<HgtFile> files = new ArrayList<HgtFile>();
        for (HgtZipFilesMapping mapping : mappings) {
            if (!mapping.contains(area)) continue;
            String name = FormatUtil.getHgtFilename(area.getMinLat(), area.getMinLon());
            files.add(new HgtFile(name, mapping.getZipPath(), mapping.getSize()));
        }
        log.info("Finished with " + files.size() + " for " + area);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean matchZipsWithHgtWithAreas() {
        block17: {
            List<String> links = ElevationsUtil.findZipLinksInPanoramas();
            if (links == null) break block17;
            ArrayList<String> processed = new ArrayList<String>();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader("data/hgt.data"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("FILE:")) continue;
                    processed.add(line.substring(5));
                }
            }
            catch (FileNotFoundException e) {
                log.error("Couldn't load config data/hgt.data", e);
                IOUtil.closeQuietly(br);
            }
            catch (IOException e2) {
                log.error("Couldn't load config data/hgt.data", e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(br);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(br);
            }
            IOUtil.closeQuietly(br);
            ListIterator<String> it = links.listIterator();
            while (it.hasNext()) {
                String link = it.next();
                if (!processed.contains(link)) continue;
                it.remove();
            }
            int i = 0;
            it = links.listIterator();
            while (it.hasNext()) {
                String link = it.next();
                String targetFile = "tmp/" + UrlUtil.getFilenameFromPath(link);
                log.info("[" + ++i + " / " + links.size() + "] Downloading " + link + " into " + targetFile);
                try {
                    IOUtil.downloadFile(link, targetFile);
                    if (new File(targetFile).exists()) {
                        String hgtPath = "tmp/" + UrlUtil.getFilenameFromPath(link) + ".tmp/";
                        IOUtil.unZipFile(targetFile, hgtPath);
                        List<GpsArea> areas = ElevationsUtil.findGpsAreasFromHgtFiles(hgtPath);
                        log.info("Found " + areas.size() + " areas in " + link);
                        StringBuilder fileBody = new StringBuilder();
                        fileBody.append("FILE:");
                        fileBody.append(link + Constants.EOL);
                        fileBody.append("SIZE:");
                        fileBody.append(new File(targetFile).length() + Constants.EOL);
                        for (GpsArea area : areas) {
                            fileBody.append("AREA:");
                            fileBody.append(area.getMinLat() + ":");
                            fileBody.append(area.getMinLon() + ":");
                            fileBody.append(area.getMaxLat() + ":");
                            fileBody.append(area.getMaxLon() + Constants.EOL);
                        }
                        if (!new File("data/hgt.data").exists()) {
                            IOUtil.saveTextFile("", "data/hgt.data");
                        }
                        Files.write(Paths.get("data/hgt.data", new String[0]), fileBody.toString().getBytes(), StandardOpenOption.APPEND);
                        FileUtils.deleteQuietly((File)new File(targetFile));
                        FileUtils.deleteDirectory((File)new File(hgtPath));
                        it.remove();
                        continue;
                    }
                    log.error("Couldn't find downloaded " + link + " as " + targetFile);
                }
                catch (IOException e) {
                    log.error("Error while processing " + link + " as " + targetFile, e);
                }
            }
            if (links.size() > 0) {
                log.error("There are " + links.size() + " failed downloads:");
                for (String link : links) {
                    log.error("FAILED: " + link);
                }
            } else {
                log.info("All downloads successful!");
            }
            return true;
        }
        return false;
    }

    private static List<String> findZipLinksInPanoramas() {
        String body = UrlUtil.readUrl("http://www.viewfinderpanoramas.org/Coverage%20map%20viewfinderpanoramas_org3.htm");
        if (body != null) {
            String beginTag = "<map name=\"LinkMap\">";
            String endTag = "</map>";
            int pos = body.indexOf(beginTag);
            if (pos >= 0 && (pos = (body = body.substring(pos + beginTag.length())).indexOf(endTag)) >= 0) {
                body = body.substring(0, pos);
                String[] tokens = body.split("href=\"");
                ArrayList<String> links = new ArrayList<String>(tokens.length - 1);
                for (int i = 1; i < tokens.length; ++i) {
                    pos = tokens[i].indexOf("\"");
                    if (pos < 0) continue;
                    links.add(tokens[i].substring(0, pos));
                }
                return links;
            }
        }
        return null;
    }

    public static ElevationDTO findMsaInRadius(Set<ElevationDTO> elevations, GpsPlace place, double maxRadiusNm) {
        if (elevations == null || elevations.size() == 0) {
            return null;
        }
        GpsArea area = new GpsArea(place, maxRadiusNm);
        ArrayList<ElevationDTO> results = new ArrayList<ElevationDTO>();
        for (ElevationDTO elev : elevations) {
            if (!elev.isInside(area)) continue;
            results.add(elev);
        }
        if (results.size() > 0) {
            ElevationDTO maximum = null;
            for (int i = 0; i < results.size(); ++i) {
                if (maximum != null && ((ElevationDTO)results.get(i)).getAlt() <= maximum.getAlt() || !(GpsUtil.getDistance(place, ((ElevationDTO)results.get(0)).getGpsPlace()) <= maxRadiusNm)) continue;
                maximum = (ElevationDTO)results.get(i);
            }
            return maximum;
        }
        return null;
    }
}

