/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.util.FlightPlanUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class DropboxUtil {
    private static final Logger log = Logger.getLogger(DropboxUtil.class);

    public static boolean uploadFlightPlan(Route route, String name) {
        if (name != null) {
            if (SettingsBean.getInstance().getDropboxBean().fileExists(name)) {
                SettingsBean.getInstance().getDropboxBean().deleteFile(name);
            }
            name = name.replaceAll("/", "");
            name = name.replaceAll("\\\\", "");
            name = name.replaceAll(":", "");
            String originalName = name = IOUtil.addExtensionToName(new File(name), "vfr");
            name = "tmp/" + name;
            log.debug("Saving temporary file to: " + name);
            if (FlightPlanUtil.save(route, name)) {
                log.debug("Save complete. Uploading file to dropbox.");
                boolean result = SettingsBean.getInstance().getDropboxBean().uploadFile(name, "/" + originalName);
                log.debug("File uploaded with result: " + result);
                IOUtil.deleteFile(name);
                return result;
            }
        }
        return false;
    }

    public static boolean downloadFlightPlan(String filename, String destination) {
        return SettingsBean.getInstance().getDropboxBean().downloadFile(filename, destination);
    }

    public static boolean deleteFile(String filename) {
        return SettingsBean.getInstance().getDropboxBean().deleteFile(filename);
    }
}

