/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    public static String formatUTCToLocal(String datetime, String formatString) {
        return DateUtil.formatUTCToLocalAndBackTime(datetime, formatString, true);
    }

    public static String formatLocalToUTC(String datetime, String formatString) {
        return DateUtil.formatUTCToLocalAndBackTime(datetime, formatString, false);
    }

    private static String formatUTCToLocalAndBackTime(String datetime, String formatString, boolean UTC) {
        DateTime dtUTC = null;
        DateTimeZone timezone = DateTimeZone.getDefault();
        DateTimeFormatter formatDT = DateTimeFormat.forPattern((String)formatString);
        DateTime dateDateTime1 = formatDT.parseDateTime(datetime);
        DateTime now = new DateTime();
        DateTime nowUTC = new LocalDateTime((Object)now).toDateTime(DateTimeZone.UTC);
        long instant = now.getMillis();
        long instantUTC = nowUTC.getMillis();
        long offset = instantUTC - instant;
        if (UTC) {
            dtUTC = dateDateTime1.withZoneRetainFields(DateTimeZone.UTC);
            dtUTC = dtUTC.plusMillis((int)offset);
        } else {
            dtUTC = dateDateTime1.withZoneRetainFields(timezone);
            dtUTC = dtUTC.minusMillis((int)offset);
        }
        return dtUTC.toString(formatDT);
    }
}

