/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Color;

public class ColorUtil {
    public static final Color[] COLOR_SET = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.CYAN, Color.BLACK, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW, Color.WHITE, Color.LIGHT_GRAY, Color.DARK_GRAY};

    public static Color newColorWithOpacity(Color color, float opacity) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        return new Color(r, g, b, opacity);
    }

    public static Color newColorInverted(Color color) {
        float r = 1.0f - (float)color.getRed() / 255.0f;
        float g = 1.0f - (float)color.getGreen() / 255.0f;
        float b = 1.0f - (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        return new Color(r, g, b, a);
    }

    public static Color getDarkerColor(Color color, int mod) {
        int r = color.getRed() - mod;
        int g = color.getGreen() - mod;
        int b = color.getBlue() - mod;
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        return new Color(r, g, b);
    }

    public static Color getLighterColor(Color color, int mod) {
        int r = color.getRed() + mod;
        int g = color.getGreen() + mod;
        int b = color.getBlue() + mod;
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }
}

