/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;

public class CitiesUtil {
    private static final Logger log = Logger.getLogger(CitiesUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCitiesToFile(String fileName, CityDTO[] cities) {
        log.info("Dumping " + cities.length + " cities to file " + fileName);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File(fileName));
            out.write(String.valueOf(cities.length));
            out.write(Constants.EOL);
            for (CityDTO c : cities) {
                out.write(StringUtil.nullToEmpty(c.getName()));
                out.write(Constants.EOL);
                out.write(StringUtil.nullToEmpty(c.getAltName()));
                out.write(Constants.EOL);
                out.write(String.valueOf(c.getPosition().getLatitude()));
                out.write(Constants.EOL);
                out.write(String.valueOf(c.getPosition().getLongitude()));
                out.write(Constants.EOL);
                out.write(String.valueOf(c.getSize() != null ? (int)c.getSize().shortValue() : 0));
                out.write(Constants.EOL);
                out.write(c.isVillage() ? "true" : "false");
                out.write(Constants.EOL);
            }
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
        }
        IOUtil.closeQuietly(out);
        log.info("Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Set<City> loadCitiesTableFromFile(String file) {
        if (new File(file).exists()) {
            HashSet<City> hashSet;
            log.debug("Loading cities from file " + file);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                int num = Integer.valueOf(br.readLine());
                HashSet<City> results = new HashSet<City>();
                for (int i = 0; i < num; ++i) {
                    City c = new City();
                    c.setName(StringUtil.emptyToNull(br.readLine()));
                    c.setAltName(StringUtil.emptyToNull(br.readLine()));
                    c.setLat(Double.valueOf(br.readLine()));
                    c.setLon(Double.valueOf(br.readLine()));
                    c.setSize(Short.valueOf(br.readLine()));
                    c.setVillage("true".equals(br.readLine()));
                    results.add(c);
                }
                hashSet = results;
            }
            catch (FileNotFoundException e) {
                log.error("Couldn't load cities " + file, e);
                IOUtil.closeQuietly(br);
            }
            catch (IOException e2) {
                log.error("Couldn't load cities " + file, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(br);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(br);
            }
            IOUtil.closeQuietly(br);
            return hashSet;
        }
        return null;
    }
}

