/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.core.fsx.BglImportBean;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BglImportUtil {
    private static final Logger log = Logger.getLogger(BglImportUtil.class);
    private static final Pattern CORRECT_XML_LINE_PATTERN1 = Pattern.compile("&([^;&]+(?!(?:\\w|;)))");
    private static final Pattern CORRECT_XML_LINE_PATTERN2 = Pattern.compile("&#");

    public static NodeList getFsDataChildren(Document document) {
        NodeList docNodes = document.getChildNodes();
        Node node = null;
        for (int i = 0; i < docNodes.getLength(); ++i) {
            node = docNodes.item(i);
            if (!"FSData".equalsIgnoreCase(node.getNodeName())) continue;
            return node.getChildNodes();
        }
        return null;
    }

    public static Waypoint findWaypointId(String ident, String region, BglImportBean importBean) {
        if (ident == null || region == null) {
            return null;
        }
        ident = ident.toUpperCase();
        region = region.toUpperCase();
        if (importBean.getWaypoints().get(region) != null) {
            for (Waypoint w : importBean.getWaypoints().get(region)) {
                if (!ident.equals(w.getIdent()) || !region.equals(w.getRegion())) continue;
                return w;
            }
        }
        return null;
    }

    private static String correctXmlLine(String line) {
        line = CORRECT_XML_LINE_PATTERN1.matcher(line).replaceAll(" and $1");
        if (!BglImportUtil.hasCorrectQuotes(line = CORRECT_XML_LINE_PATTERN2.matcher(line).replaceAll(""))) {
            log.debug("BAD LINE: " + line);
            line = BglImportUtil.correctQuotes(line);
            log.debug("CORRECTED TO: " + line);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getXmlFile(String fileName) {
        StringBuilder sb = new StringBuilder(4096);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(BglImportUtil.correctXmlLine(line));
            }
        }
        catch (FileNotFoundException e) {
            log.error("getXmlFile " + fileName, e);
            IOUtil.closeQuietly(br);
        }
        catch (IOException e2) {
            log.error("getXmlFile " + fileName, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void rewriteXmlFile(String fileName, String output) {
        BufferedReader br = null;
        PrintWriter out = null;
        try {
            out = new PrintWriter(output);
            br = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = br.readLine()) != null) {
                out.write(BglImportUtil.correctXmlLine(line));
            }
        }
        catch (FileNotFoundException e) {
            log.error("rewriteXmlFile " + fileName, e);
            IOUtil.closeQuietly(br);
            IOUtil.closeQuietly(out);
        }
        catch (IOException e2) {
            log.error("rewriteXmlFile " + fileName, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    IOUtil.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
            IOUtil.closeQuietly(out);
        }
        IOUtil.closeQuietly(br);
        IOUtil.closeQuietly(out);
    }

    public static String recompileBgl(String bglpath, String xmlpath, String workingDir) {
        String bglxmlExecPath = workingDir + "bglxml.exe \"" + bglpath + "\" \"" + xmlpath + "\"";
        return IOUtil.execute(bglxmlExecPath, true);
    }

    public static List<SceneryConfigEntry> readSceneryAddOnsFile(String path, int layerIndex) {
        ArrayList<SceneryConfigEntry> results = new ArrayList<SceneryConfigEntry>();
        if (new File(path).exists()) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(path);
                doc.getDocumentElement().normalize();
                NodeList components = doc.getChildNodes();
                for (int i = 0; i < components.getLength(); ++i) {
                    if (!"SimBase.Document".equals(components.item(i).getNodeName())) continue;
                    NodeList elements = components.item(i).getChildNodes();
                    for (int q = 0; q < elements.getLength(); ++q) {
                        if (!"AddOn.SceneryComponent".equals(elements.item(q).getNodeName())) continue;
                        NodeList nodes = elements.item(q).getChildNodes();
                        for (int w = 0; w < nodes.getLength(); ++w) {
                            if (!"Path".equals(nodes.item(w).getNodeName())) continue;
                            SceneryConfigEntry entry = new SceneryConfigEntry(nodes.item(w).getFirstChild().getNodeValue() + "/Scenery", ++layerIndex, true);
                            BglImportUtil.countBytesAndBglNumber(entry);
                            results.add(entry);
                        }
                    }
                }
                Collections.sort(results);
            }
            catch (ParserConfigurationException e) {
                log.error(e, e);
            }
            catch (SAXException e) {
                log.error(e, e);
            }
            catch (IOException e) {
                log.error(e, e);
            }
        }
        return results;
    }

    public static List<SceneryConfigEntry> readSceneryConfig(String path, String encoding, String simulatorMainDir) {
        List<String> content = IOUtil.loadTextFileAsRows(path, encoding);
        if (content != null) {
            ArrayList<SceneryConfigEntry> results = new ArrayList<SceneryConfigEntry>();
            for (int i = 0; i < content.size() - 1; ++i) {
                String line = content.get(i).toUpperCase().trim();
                if (!line.startsWith("[AREA.")) continue;
                String l = null;
                Boolean active = null;
                Integer layer = null;
                String sceneryPath = null;
                do {
                    if (++i >= content.size() || (l = content.get(i).toUpperCase().trim()).startsWith("[AREA.")) continue;
                    if (l.startsWith("LAYER=")) {
                        try {
                            layer = Integer.valueOf(l.substring(6));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (l.startsWith("ACTIVE=")) {
                        active = "TRUE".equals(l.substring(7));
                        continue;
                    }
                    if (!l.startsWith("LOCAL=")) continue;
                    sceneryPath = content.get(i).substring(6);
                } while (!l.startsWith("[AREA.") && i < content.size());
                if (active == null || layer == null || sceneryPath == null) {
                    log.error("Incomplete AREA data for " + line);
                } else {
                    if (!IOUtil.isPathAbsolute(sceneryPath)) {
                        sceneryPath = simulatorMainDir + "/" + sceneryPath;
                    }
                    SceneryConfigEntry entry = new SceneryConfigEntry(sceneryPath + "/Scenery", layer, active);
                    BglImportUtil.countBytesAndBglNumber(entry);
                    results.add(entry);
                }
                --i;
            }
            Collections.sort(results);
            return results;
        }
        return null;
    }

    private static void countBytesAndBglNumber(SceneryConfigEntry entry) {
        Set<DiskObject> bgls = SearchUtil.getRootList("*.bgl", entry.getPath());
        entry.setFileCount(bgls.size());
        for (DiskObject obj : bgls) {
            entry.setSize(entry.getSize() + obj.getSize());
        }
    }

    public static boolean hasCorrectQuotes(String line) {
        if (line != null && line.indexOf("\"") >= 0) {
            String[] st = StringUtils.splitPreserveAllTokens((String)line, (String)"\"", (int)0);
            int len = st.length - 1;
            for (int i = 0; i <= len; i += 2) {
                if (i <= 0 || i >= len || st[i].indexOf("=") >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String correctQuotes(String line) {
        String[] st = StringUtils.splitPreserveAllTokens((String)line, (String)"\"", (int)0);
        int len = st.length - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= len; ++i) {
            String el = st[i];
            if (i > 0 && i < len && i % 2 == 0 && el.indexOf("=") < 0) {
                if (i > 0) {
                    sb.append("'");
                }
                sb.append(el);
                sb.append("'");
                continue;
            }
            if (i % 2 == 0) {
                if (i > 0) {
                    sb.append("\"");
                }
                sb.append(el);
                if (i >= len) continue;
                sb.append("\"");
                continue;
            }
            sb.append(el);
        }
        return sb.toString();
    }
}

