/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class AndroidAppUtil {
    private static final String DELIMITER = ";";

    public static boolean export(String filename, Route route) {
        if (route.calculate()) {
            StringBuilder sb = new StringBuilder();
            sb.append(AndroidAppUtil.createRoutePoints(route));
            sb.append(AndroidAppUtil.createAlternatePoints(route));
            return IOUtil.saveTextFile(sb.toString(), filename);
        }
        return false;
    }

    private static String createRoutePoints(Route route) {
        StringBuilder sb = new StringBuilder();
        sb.append(route.getPoints().size());
        sb.append(Constants.EOL);
        if (route.getPoints().size() > 0) {
            for (int i = 0; i < route.getSegments().size(); ++i) {
                sb.append(AndroidAppUtil.createLine(route.getSegments().get(i).getFrom(), route.getSegments().get(i).getDistance(), route.getSegments().get(i).getT()));
            }
            sb.append(AndroidAppUtil.createLine(route.getSegments().get(route.getSegments().size() - 1).getTo(), null, null));
        }
        return sb.toString();
    }

    private static String createAlternatePoints(Route route) {
        StringBuilder sb = new StringBuilder();
        if (route.getAlternateAirports().size() > 0) {
            sb.append(route.getAlternateAirports().size());
            sb.append(Constants.EOL);
            for (int i = 0; i < route.getAlternateAirports().size(); ++i) {
                sb.append(AndroidAppUtil.createAlternateLine(route.getAlternateAirports().get(i).getGpsPlace(), route.getAlternateAirports().get(i).getFrequency()));
            }
        }
        return sb.toString();
    }

    private static String createAlternateLine(GpsPlace point, Double frequency) {
        StringBuilder sb = new StringBuilder();
        sb.append(point.getName());
        sb.append(DELIMITER);
        sb.append(point.getLatVal());
        sb.append(DELIMITER);
        sb.append(point.getLonVal());
        sb.append(DELIMITER);
        double alt = point.getAlt();
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            alt = UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", true);
        }
        sb.append(alt);
        sb.append(DELIMITER);
        sb.append(DELIMITER);
        sb.append(DELIMITER);
        sb.append(frequency != null ? frequency : "0");
        sb.append(Constants.EOL);
        return sb.toString();
    }

    private static String createLine(GpsPlace point, Double dist, Long t) {
        StringBuilder sb = new StringBuilder();
        sb.append(point.getName());
        sb.append(DELIMITER);
        sb.append(point.getLatVal());
        sb.append(DELIMITER);
        sb.append(point.getLonVal());
        sb.append(DELIMITER);
        double alt = point.getAlt();
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            alt = UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", true);
        }
        sb.append(alt);
        sb.append(DELIMITER);
        if (dist != null) {
            sb.append(dist);
        }
        sb.append(DELIMITER);
        if (t != null) {
            sb.append(t);
        }
        sb.append(DELIMITER);
        sb.append("0");
        sb.append(Constants.EOL);
        return sb.toString();
    }
}

