/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.gps.GpsArc;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.airspaces.Airspaces;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;

public class AirspacesUtil {
    private static final Logger log = Logger.getLogger(AirspacesUtil.class);
    private static final String ALTITUDE_TYPE_PREFIX = "altitude_type_";
    private static final String AIRSPACE_TYPE_PREFIX = "airspace_type_";

    public static List<AirspaceArea> loadAirspaces(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Airspaces.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Airspaces xml = (Airspaces)jaxbUnmarshaller.unmarshal(new File(file));
            return AirspacesUtil.getAirspacesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    public static List<AirspaceAreaVertex> getAirspaceAreaVerticesFromString(String coordsList) {
        ArrayList<AirspaceAreaVertex> result = new ArrayList<AirspaceAreaVertex>();
        List<GpsVertex> places = FormatUtil.coordsListToGpsPlaces(coordsList);
        for (GpsVertex p : places) {
            if (p.isVertex()) {
                result.add(new AirspaceAreaVertex(p.getLat().getValue(), (Double)p.getLon().getValue()));
                continue;
            }
            if (!(p instanceof GpsArc)) continue;
            GpsArc arc = (GpsArc)p;
            result.add(new AirspaceAreaVertex(arc.getLat().getValue(), arc.getLon().getValue(), arc.getRadius()));
        }
        return result;
    }

    private static List<AirspaceArea> getAirspacesFromXml(Airspaces xml) {
        ArrayList<AirspaceArea> airspaces = new ArrayList<AirspaceArea>();
        if (xml != null) {
            for (Airspaces.Airspace xmlAirspace : xml.getAirspace()) {
                if (xmlAirspace.getAreas() == null) continue;
                for (Airspaces.Airspace.Areas.Area xmlArea : xmlAirspace.getAreas().getArea()) {
                    AirspaceArea area = new AirspaceArea(xmlArea.getName(), AirspaceType.valueOf(xmlArea.getType()));
                    if (xmlArea.getAltitude() != null) {
                        area.setBottomAltitude(xmlArea.getAltitude().getBottom());
                        area.setTopAltitude(xmlArea.getAltitude().getTop());
                    }
                    if (xmlArea.getCoordsList() != null) {
                        if (xmlArea.getCoordsList().trim().startsWith("CIRCLE")) {
                            AirspaceArea a = FormatUtil.coordsListToCircleArea(xmlArea.getCoordsList());
                            if (a != null) {
                                area.setCircleCenterLat(a.getCenter().getLatitude());
                                area.setCircleCenterLon(a.getCenter().getLongitude());
                                area.setRadius(a.getRadius());
                            } else {
                                log.error("Bad circle area data for " + xmlArea.getCoordsList());
                            }
                        } else {
                            area.getVertices().addAll(AirspacesUtil.getAirspaceAreaVerticesFromString(xmlArea.getCoordsList()));
                        }
                    } else if (xmlArea.getVertices() != null && xmlArea.getVertices().getVertexOrArcOrStrings().size() > 0) {
                        for (Object vertexOrArc : xmlArea.getVertices().getVertexOrArcOrStrings()) {
                            if (vertexOrArc instanceof Airspaces.Airspace.Areas.Area.Vertices.Vertex) {
                                Airspaces.Airspace.Areas.Area.Vertices.Vertex xmlVertex = (Airspaces.Airspace.Areas.Area.Vertices.Vertex)vertexOrArc;
                                area.getVertices().add(new AirspaceAreaVertex(xmlVertex.getLat(), (Double)xmlVertex.getLon()));
                                continue;
                            }
                            if (vertexOrArc instanceof Airspaces.Airspace.Areas.Area.Vertices.Arc) {
                                Airspaces.Airspace.Areas.Area.Vertices.Arc xmlArc = (Airspaces.Airspace.Areas.Area.Vertices.Arc)vertexOrArc;
                                area.getVertices().add(new AirspaceAreaVertex(xmlArc.getLat(), xmlArc.getLon(), xmlArc.getRadius()));
                                continue;
                            }
                            if (!(vertexOrArc instanceof Airspaces.Airspace.Areas.Area.Vertices.Strings)) continue;
                            Airspaces.Airspace.Areas.Area.Vertices.Strings xmlString = (Airspaces.Airspace.Areas.Area.Vertices.Strings)vertexOrArc;
                            for (String coords : xmlString.getVertex()) {
                                GpsPlace place = FormatUtil.getGpsPlaceFromString(coords);
                                if (place != null) {
                                    area.getVertices().add(new AirspaceAreaVertex(place));
                                    continue;
                                }
                                log.error("Bad vertex data for " + coords);
                            }
                        }
                    } else if (xmlArea.getCircle() != null) {
                        area.setCircleCenterLat(xmlArea.getCircle().getLat());
                        area.setCircleCenterLon(xmlArea.getCircle().getLon());
                        area.setRadius(xmlArea.getCircle().getRadius());
                    }
                    airspaces.add(area);
                }
            }
        }
        return airspaces;
    }

    public static boolean saveAirspaces(List<AirspaceArea> airspaces, String file) {
        Airspaces xml = AirspacesUtil.getXml(airspaces);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Airspaces.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    private static Airspaces getXml(List<AirspaceArea> airspaces) {
        Airspaces xml = new Airspaces();
        for (AirspaceArea area : airspaces) {
            Airspaces.Airspace xmlAirspace = new Airspaces.Airspace();
            Airspaces.Airspace.Areas xmlAreas = new Airspaces.Airspace.Areas();
            Airspaces.Airspace.Areas.Area xmlArea = new Airspaces.Airspace.Areas.Area();
            if (area.isCircle()) {
                if (area.getCircleCenter() != null && area.getCircleCenter().getLat() != null && area.getCircleCenter().getLon() != null) {
                    Airspaces.Airspace.Areas.Area.Circle xmlCircle = new Airspaces.Airspace.Areas.Area.Circle();
                    xmlCircle.setLat(area.getCircleCenter().getLat().getValue());
                    xmlCircle.setLon(area.getCircleCenter().getLon().getValue());
                    if (area.getRadius() != null) {
                        xmlCircle.setRadius(area.getRadius());
                    }
                    xmlArea.setCircle(xmlCircle);
                }
            } else if (area.isPoly()) {
                Airspaces.Airspace.Areas.Area.Vertices xmlVertices = new Airspaces.Airspace.Areas.Area.Vertices();
                for (AirspaceAreaVertex vertex : area.getVertices()) {
                    if (vertex.getLat() == null || vertex.getLon() == null) continue;
                    if (vertex.isVertex()) {
                        Airspaces.Airspace.Areas.Area.Vertices.Vertex xmlVertex = new Airspaces.Airspace.Areas.Area.Vertices.Vertex();
                        xmlVertex.setLat(vertex.getLat());
                        xmlVertex.setLon(vertex.getLon());
                        xmlVertices.getVertexOrArcOrStrings().add(xmlVertex);
                        continue;
                    }
                    if (vertex.isVertex()) continue;
                    Airspaces.Airspace.Areas.Area.Vertices.Arc xmlArc = new Airspaces.Airspace.Areas.Area.Vertices.Arc();
                    xmlArc.setLat(vertex.getLat());
                    xmlArc.setLon(vertex.getLon());
                    xmlArc.setRadius(vertex.getRadius());
                    xmlVertices.getVertexOrArcOrStrings().add(xmlArc);
                }
                xmlArea.setVertices(xmlVertices);
            }
            Airspaces.Airspace.Areas.Area.Altitude xmlAltitude = new Airspaces.Airspace.Areas.Area.Altitude();
            xmlAltitude.setBottom(area.getBottomAltitude());
            xmlAltitude.setTop(area.getTopAltitude());
            xmlArea.setAltitude(xmlAltitude);
            if (area.getType() != null) {
                xmlArea.setType(area.getType().toString());
            }
            xmlArea.setName(area.getName());
            xmlAreas.getArea().add(xmlArea);
            xmlAirspace.setAreas(xmlAreas);
            xmlAirspace.setName(xmlArea.getName());
            xml.getAirspace().add(xmlAirspace);
        }
        return xml;
    }

    public static List<AirspaceAreaDTO> findAirspacesUnderPosition(JXMapViewer map, GpsPlace pos) {
        LinkedList<AirspaceAreaDTO> areas = new LinkedList<AirspaceAreaDTO>();
        if (MapObjectsBean.getInstance().getAirspaces() != null) {
            for (AirspaceAreaDTO area : MapObjectsBean.getInstance().getAirspaces()) {
                if (!pos.isInside(area.getRectangleOver()) || !MapObjectsBean.getInstance().getAirspaceFilter().checkDisplayAirspaceArea(area)) continue;
                areas.add(area);
            }
            Iterator iterator = areas.iterator();
            while (iterator.hasNext()) {
                AirspaceAreaDTO area = (AirspaceAreaDTO)iterator.next();
                if (AirspacesUtil.isPlaceInsideShape(map, pos, area)) continue;
                iterator.remove();
            }
        }
        return areas;
    }

    public static boolean isPlaceInsideShape(JXMapViewer map, GpsPlace pos, MapShape area) {
        Polygon polygon = null;
        Point2D point = null;
        Point2D posPt = map.getTileFactory().geoToPixel(pos.geoPosition(), map.getZoom());
        if (area.isPoly()) {
            MapShapeVertex[] vertices = null;
            vertices = area.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(map, area.getVertices(), 2) : area.getVertices();
            polygon = new Polygon();
            for (int i = 0; i < vertices.length; ++i) {
                point = map.getTileFactory().geoToPixel(vertices[i].getGeoPosition(), map.getZoom());
                polygon.addPoint((int)Math.round(point.getX()), (int)Math.round(point.getY()));
            }
            return polygon.contains(posPt);
        }
        if (area.isCircle()) {
            return GpsUtil.getDistance(pos, area.getCircleCenter()) <= area.getRadius();
        }
        return false;
    }

    public static String formatAirspaceAreaName(AirspaceAreaDTO area, boolean withId) {
        StringBuilder txt = new StringBuilder();
        if (withId && area.getId() != null) {
            txt.append("[");
            txt.append(area.getId());
            txt.append("] ");
        }
        if (area.getName() != null) {
            txt.append(area.getName() + " ");
        }
        if (area.getType() != null) {
            txt.append(AirspacesUtil.getMessageString(area.getType()) + " ");
        }
        if (area.getBottomAltitude() == null && area.getTopAltitude() == null) {
            txt.append(AirspacesUtil.getMessageString(AltitudeType.UNLIMITED));
        } else if (AirspaceArea.GND.equals(area.getBottomAltitude()) && area.getTopAltitude() == null) {
            txt.append(AirspacesUtil.getMessageString(AltitudeType.UNLIMITED));
        } else {
            if (area.getBottomAltitude() != null) {
                if (AirspaceArea.GND.equals(area.getBottomAltitude())) {
                    txt.append(AirspacesUtil.getMessageString(AltitudeType.GND));
                } else if (AltitudeType.UNKNOWN.equals((Object)area.getBottomAltitudeType())) {
                    txt.append(AirspacesUtil.getMessageString(AltitudeType.UNKNOWN));
                } else {
                    txt.append(NumberUtil.roundDouble(UnitUtil.recalculateAltitude(area.getBottomAltitude().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                    if (area.getBottomAltitudeType() != null) {
                        txt.append(" " + AirspacesUtil.getMessageString(area.getBottomAltitudeType()));
                    }
                }
            } else {
                txt.append(AirspacesUtil.getMessageString(AltitudeType.GND));
            }
            txt.append(" - ");
            if (area.getTopAltitude() != null) {
                if (AltitudeType.UNKNOWN.equals((Object)area.getTopAltitudeType()) || AltitudeType.UNLIMITED.equals((Object)area.getTopAltitudeType())) {
                    txt.append(AirspacesUtil.getMessageString(area.getTopAltitudeType()));
                } else {
                    txt.append(NumberUtil.roundDouble(UnitUtil.recalculateAltitude(area.getTopAltitude().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                    if (area.getTopAltitudeType() != null) {
                        txt.append(" " + AirspacesUtil.getMessageString(area.getTopAltitudeType()));
                    }
                }
            } else {
                txt.append(AirspacesUtil.getMessageString(AltitudeType.UNLIMITED));
            }
        }
        return txt.toString();
    }

    public static List<AirspaceType> getCurrentAirspacesTypes() {
        LinkedList<AirspaceType> airspacesTypes = new LinkedList<AirspaceType>();
        if (MapObjectsBean.getInstance().getAirspaces() != null) {
            for (AirspaceAreaDTO airspaceArea : MapObjectsBean.getInstance().getAirspaces()) {
                if (airspaceArea.getType() == null || airspacesTypes.contains((Object)airspaceArea.getType())) continue;
                airspacesTypes.add(airspaceArea.getType());
            }
        }
        return airspacesTypes;
    }

    public static String getMessageString(AirspaceType type) {
        if (type == null) {
            return null;
        }
        String msg = Messages.getInstance().getOptional(AIRSPACE_TYPE_PREFIX + type.toString());
        return msg == null ? type.toString() : msg;
    }

    public static String getMessageString(AltitudeType type) {
        if (type == null) {
            return null;
        }
        String msg = Messages.getInstance().getOptional(ALTITUDE_TYPE_PREFIX + type.toString());
        return msg == null ? type.toString() : msg;
    }

    public static double[] getArcInfoInGpsCourse(MapShapeVertex previousVertex, MapShapeVertex arcVertex, MapShapeVertex nextVertex) {
        if (arcVertex.isVertex()) {
            return null;
        }
        double[] result = new double[2];
        GpsPlace arcCenter = arcVertex.getGpsPlace();
        GpsPlace pVertex = previousVertex.getGpsPlace();
        GpsPlace nVertex = nextVertex.getGpsPlace();
        LineSegment pvSegment = GpsUtil.getLineSegment(arcCenter, pVertex);
        LineSegment nvSegment = GpsUtil.getLineSegment(arcCenter, nVertex);
        if (nvSegment == null || pvSegment == null) {
            return null;
        }
        Double angleFrom = pvSegment.getCourse();
        Double angleTo = nvSegment.getCourse();
        if (angleFrom == null || angleTo == null) {
            return null;
        }
        result[0] = angleFrom;
        result[1] = angleTo;
        return result;
    }

    public static double[] getArcInfo(MapShapeVertex previousVertex, MapShapeVertex arcVertex, MapShapeVertex nextVertex) {
        if (arcVertex.isVertex()) {
            return null;
        }
        double[] result = new double[2];
        GpsPlace arcCenter = arcVertex.getGpsPlace();
        GpsPlace pVertex = previousVertex.getGpsPlace();
        GpsPlace nVertex = nextVertex.getGpsPlace();
        LineSegment pvSegment = GpsUtil.getLineSegment(arcCenter, pVertex);
        LineSegment nvSegment = GpsUtil.getLineSegment(arcCenter, nVertex);
        if (nvSegment == null || pvSegment == null) {
            return null;
        }
        Double angleFrom = pvSegment.getCourse();
        Double angleTo = nvSegment.getCourse();
        if (angleFrom == null || angleTo == null) {
            return null;
        }
        double arcAngle = -(angleTo - angleFrom);
        if (angleFrom > angleTo) {
            arcAngle = 360.0 + angleTo - angleFrom;
            double tmp = angleFrom;
            angleFrom = angleTo;
            angleTo = tmp;
        }
        angleFrom = 450.0 - angleFrom;
        if (!arcVertex.isClockwise()) {
            if (arcAngle > 0.0) {
                arcAngle = 360.0 - arcAngle;
                angleFrom = angleFrom - arcAngle;
            } else {
                arcAngle = 360.0 + arcAngle;
            }
        }
        result[0] = angleFrom;
        result[1] = arcAngle;
        return result;
    }

    public static MapShapeVertex[] convertArcAirspaceToPolygon(JXMapViewer map, MapShapeVertex[] inputVertices, int crsStep) {
        LinkedList<MapShapeVertex> outputVertices = new LinkedList<MapShapeVertex>();
        for (int i = 0; i < inputVertices.length; ++i) {
            if (inputVertices[i].isVertex()) {
                outputVertices.add(inputVertices[i]);
                continue;
            }
            if (i <= 0 || i >= inputVertices.length - 1) continue;
            double[] arcInfo = AirspacesUtil.getArcInfoInGpsCourse(inputVertices[i - 1], inputVertices[i], inputVertices[i + 1]);
            if (arcInfo != null) {
                double angleFrom = arcInfo[0];
                double angleTo = arcInfo[1];
                int segments = 0;
                segments = inputVertices[i].isClockwise() ? (angleTo > angleFrom ? (int)Math.ceil((angleTo - angleFrom) / (double)crsStep) : (int)Math.ceil((angleTo + 360.0 - angleFrom) / (double)crsStep)) : (angleTo > angleFrom ? (int)Math.ceil((angleFrom + 360.0 - angleTo) / (double)crsStep) : (int)Math.ceil((angleFrom - angleTo) / (double)crsStep));
                if (segments < 2) {
                    segments = 2;
                }
                GpsPlace[] polygonPoints = GpsUtil.convertArcToPolygon(map, inputVertices[i], arcInfo[0], arcInfo[1], segments);
                for (int q = 1; q < polygonPoints.length - 1; ++q) {
                    outputVertices.add(new MapShapeVertex(polygonPoints[q]));
                }
                continue;
            }
            log.error("convertArcAirspaceToPolygon: getArcInfoInGpsCourse is NULL [" + inputVertices[i] + "]");
            outputVertices.add(inputVertices[i]);
        }
        return outputVertices.toArray(new MapShapeVertex[outputVertices.size()]);
    }

    public static GpsPlace getMapShapeCenter(MapShape mapShape) {
        if (mapShape != null) {
            if (mapShape.isCircle()) {
                return mapShape.getCircleCenter();
            }
            if (mapShape.isPoly()) {
                double lat = 0.0;
                double lon = 0.0;
                for (MapShapeVertex v : mapShape.getVertices()) {
                    GpsPlace place = v.getGpsPlace();
                    lat += place.getLat().getValue();
                    lon += place.getLon().getValue();
                }
                return new GpsPlace(lat /= (double)mapShape.getVertices().length, lon /= (double)mapShape.getVertices().length);
            }
        }
        return null;
    }

    public static MapShapeVertex[] convertCircleAirspaceToPolygon(AirspaceAreaDTO airspaceArea, int stepDegrees) {
        if (airspaceArea.isCircle()) {
            ArrayList<MapShapeVertex> result = new ArrayList<MapShapeVertex>((int)Math.ceil(360.0 / (double)stepDegrees));
            for (int angle = 0; angle < 360; angle += stepDegrees) {
                result.add(new MapShapeVertex(GpsUtil.getPointPositionByDistanceAndBearing(airspaceArea.getCircleCenter(), angle, airspaceArea.getRadius())));
            }
            return result.toArray(new MapShapeVertex[result.size()]);
        }
        return null;
    }

    public static Integer getAltitudeFromString(String str) {
        if (str == null) {
            return null;
        }
        if ("GND".equals(str)) {
            return 0;
        }
        try {
            if (str.startsWith("A") || str.startsWith("F")) {
                return Integer.valueOf(str.substring(1)) * 100;
            }
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse altitude: " + str, e);
            return null;
        }
    }

    public static void convertArcsToVertices(JXMapViewer map, AirspaceArea airspace) {
        MapShapeVertex[] vertices = null;
        AirspaceAreaDTO dto = new AirspaceAreaDTO(airspace);
        vertices = airspace.isCircle() ? AirspacesUtil.convertCircleAirspaceToPolygon(dto, 5) : AirspacesUtil.convertArcAirspaceToPolygon(map, dto.getVertices(), 5);
        airspace.getVertices().clear();
        for (MapShapeVertex v : vertices) {
            airspace.getVertices().add(new AirspaceAreaVertex(v));
        }
    }
}

