/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;

public class AiracHelper {
    private static final Logger log = Logger.getLogger(AiracHelper.class);
    private static final String AIRAC_SCHEDULE_FILE = "data/airacschedule.dat";
    private Map<Long, String> airacSchedule = new TreeMap<Long, String>();

    public AiracHelper() {
        this.buildSchedule();
    }

    private void buildSchedule() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        List<String> rows = IOUtil.loadTextFileAsRows(AIRAC_SCHEDULE_FILE);
        if (rows != null) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            for (String row : rows) {
                String[] cols;
                if (StringUtil.isEmpty(row) || (cols = row.split(";")) == null || row.length() < 2 || StringUtil.isEmpty(cols[0]) || StringUtil.isEmpty(cols[1])) continue;
                try {
                    cal.setTimeInMillis(sdf.parse(cols[0]).getTime());
                    this.airacSchedule.put(cal.getTimeInMillis(), cols[1]);
                }
                catch (ParseException e) {
                    log.error(e, e);
                }
            }
        }
    }

    public String getAirac(Calendar cal) {
        String prevEntry = null;
        for (Map.Entry<Long, String> entry : this.airacSchedule.entrySet()) {
            long time = entry.getKey();
            if (cal.getTimeInMillis() <= time) {
                return prevEntry;
            }
            prevEntry = entry.getValue();
        }
        return null;
    }

    public String getCurrentAirac() {
        return this.getAirac(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    }

    public String getAiracForDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        try {
            cal.setTimeInMillis(sdf.parse(date).getTime());
        }
        catch (ParseException e) {
            log.error(e, e);
        }
        return this.getAirac(cal);
    }
}

