/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.VfrPoint;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class VfrPointService
extends BaseService {
    private static final Logger log = Logger.getLogger(VfrPointService.class);

    public VfrPointService(DataSource dataSource) {
        super(dataSource);
    }

    public void insertVfrPoint(VfrPoint point) {
        this.insertVfrPoint(point, null);
    }

    public void insertVfrPoint(VfrPoint point, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)point);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public List<VfrPoint> findVfrPointsInArea(GpsArea area) {
        ArrayList<VfrPoint> points = new ArrayList<VfrPoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(VfrPoint.class);
        if (area != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
            c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            points.add((VfrPoint)it.next());
        }
        session.close();
        return points;
    }

    public List<VfrPoint> findAllVfrPoints() {
        return this.findVfrPointsInArea(null);
    }

    public List<VfrPoint> findVfrPoints(String txt) {
        ArrayList<VfrPoint> points = new ArrayList<VfrPoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(VfrPoint.class);
        if (txt != null) {
            c.add((Criterion)Restrictions.like((String)"name", (Object)("%" + txt + "%")).ignoreCase());
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            points.add((VfrPoint)it.next());
        }
        session.close();
        return points;
    }

    public void deleteVfrPoints(String name, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(VfrPoint.class);
        if (name != null) {
            c.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        }
        if (minLat != null) {
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)minLat));
        }
        if (maxLat != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)maxLat));
        }
        if (minLon != null) {
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)minLon));
        }
        if (maxLon != null) {
            c.add((Criterion)Restrictions.le((String)"lon", (Object)maxLon));
        }
        for (VfrPoint v : c.list()) {
            log.debug("Deleting " + v);
            session.delete((Object)v);
        }
        session.flush();
        session.close();
    }

    public boolean deleteVfrPointById(int id) {
        return this.deleteVfrPointById(id, null);
    }

    public boolean deleteVfrPointById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = session.createQuery("delete from VfrPoint where id = :id");
        q.setParameter("id", (Object)id);
        int numDeleted = q.executeUpdate();
        if (!withSession) {
            session.close();
        }
        return numDeleted > 0;
    }
}

