/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class UserPointService
extends BaseService {
    public UserPointService(DataSource dataSource) {
        super(dataSource);
    }

    public boolean isUserPointExists(UserPoint place) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(UserPoint.class);
        c.add((Criterion)Restrictions.eq((String)"name", (Object)place.getName()));
        c.add((Criterion)Restrictions.eq((String)"lat", (Object)place.getLat()));
        c.add((Criterion)Restrictions.eq((String)"lon", (Object)place.getLon()));
        Long result = (Long)c.setProjection(Projections.rowCount()).uniqueResult();
        return result != null && result > 0L;
    }

    public boolean insertUserPoint(UserPoint place) {
        return this.insertUserPoint(place, null);
    }

    public boolean insertUserPoint(UserPoint place, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)place);
        if (!withSession) {
            session.flush();
            session.close();
        }
        return place.getId() != null;
    }

    public void updateUserPoint(UserPoint place) {
        Session session = this.dataSource.getHibernateSession();
        session.update((Object)place);
        session.flush();
        session.close();
    }

    public boolean deleteUserPointById(int id) {
        return this.deleteUserPointById(id, null);
    }

    public boolean deleteUserPointById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = session.createQuery("delete from UserPoint where id = :id");
        q.setParameter("id", (Object)id);
        int numDeleted = q.executeUpdate();
        if (!withSession) {
            session.close();
        }
        return numDeleted > 0;
    }

    public List<UserPoint> findUserPointsByName(String name) {
        if (name == null) {
            return null;
        }
        ArrayList<UserPoint> userPoints = new ArrayList<UserPoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(UserPoint.class);
        c.add((Criterion)Restrictions.eq((String)"name", (Object)name).ignoreCase());
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            userPoints.add((UserPoint)it.next());
        }
        session.close();
        return userPoints;
    }

    public UserPoint findUserPointById(int id) {
        Session session = this.dataSource.getHibernateSession();
        UserPoint point = (UserPoint)session.get(UserPoint.class, (Serializable)Integer.valueOf(id));
        session.close();
        return point;
    }

    public List<UserPoint> findUserPointsInArea(GpsArea area) {
        ArrayList<UserPoint> userPoints = new ArrayList<UserPoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(UserPoint.class);
        c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
        c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
        c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
        c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            userPoints.add((UserPoint)it.next());
        }
        session.close();
        return userPoints;
    }

    public List<UserPoint> findUserPoints(String txt, boolean sort) {
        ArrayList<UserPoint> userPoints = new ArrayList<UserPoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(UserPoint.class);
        if (txt != null) {
            c.add((Criterion)Restrictions.like((String)"name", (Object)("%" + txt + "%")).ignoreCase());
        }
        if (sort) {
            c.addOrder(Order.asc((String)"name"));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            userPoints.add((UserPoint)it.next());
        }
        session.close();
        return userPoints;
    }

    public void insertUserPoints(List<UserPoint> userpoints) {
        Session session = this.dataSource.getHibernateSession();
        for (UserPoint point : userpoints) {
            this.insertUserPoint(point, session);
        }
    }
}

