/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.sql.SQLException;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;

public class SqlService
extends BaseService {
    private static final Logger log = Logger.getLogger(SqlService.class);

    public SqlService(DataSource dataSource) {
        super(dataSource);
    }

    public long countRecordsInTable(String entityName) {
        Session session = this.dataSource.getHibernateSession();
        Criteria criteria = session.createCriteria(entityName).setProjection(Projections.rowCount());
        Long result = (Long)criteria.uniqueResult();
        return result != null ? result : -1L;
    }

    public boolean checkDBStructure() {
        boolean result = true;
        if (SqlConnector.getInstance().isServerRunning()) {
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airspace_area");
            }
            catch (SQLException e) {
                log.info("Creating airspace_area table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE airspace_area ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(128), remark VARCHAR(512), bottom_alt INTEGER, bottom_alt_type VARCHAR(9), top_alt INTEGER, top_alt_type VARCHAR(9), radius DECIMAL(18,15), circle_center_lat DECIMAL(18,15), circle_center_lon DECIMAL(18,15), type VARCHAR(13), PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create airspace_area table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airspace_area_vertex");
            }
            catch (SQLException e) {
                log.info("Creating airspace_area_vertex table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE airspace_area_vertex ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), index INTEGER, airspace_area_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), radius DECIMAL(18,15), clockwise BOOLEAN, PRIMARY KEY (id), FOREIGN KEY (airspace_area_id) REFERENCES airspace_area (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create airspace_area_vertex table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM waypoints");
            }
            catch (SQLException e) {
                log.info("Creating waypoints table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE waypoints ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), ident VARCHAR(128), type VARCHAR(9), lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create waypoints table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM routes");
            }
            catch (SQLException e) {
                log.info("Creating routes table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE routes ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(64), from_lat DECIMAL(18,15), from_lon DECIMAL(18,15), to_lat DECIMAL(18,15), to_lon DECIMAL(18,15), remark VARCHAR(512), PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create routes table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM navaids");
            }
            catch (SQLException e) {
                log.info("Creating navaids table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE navaids ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), remark VARCHAR(512), ident VARCHAR(16), name VARCHAR(64), type VARCHAR(7), lat DECIMAL(18,15), lon DECIMAL(18,15), freq INTEGER, alt INTEGER, magvar DECIMAL(5,2), PRIMARY KEY (id), country char(2))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create navaids table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airports");
            }
            catch (SQLException e) {
                log.info("Creating airports table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE airports ( id INTEGER, ident VARCHAR(16), name VARCHAR(128), type VARCHAR(14), lat DECIMAL(18,15), lon DECIMAL(18,15), main_rwy INTEGER, main_length INTEGER, elev INTEGER, magvar DECIMAL(5,2), ils BOOLEAN, mountainous BOOLEAN, skewedIls BOOLEAN, vor BOOLEAN, ndb BOOLEAN, heli BOOLEAN, hardened BOOLEAN, PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create airports table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR airports_id_seq");
            }
            catch (SQLException e) {
                log.info("Creating airports_id_seq sequence ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE SEQUENCE airports_id_seq START WITH 1 INCREMENT BY 1");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create airports_id_seq sequence", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR runways_id_seq");
            }
            catch (SQLException e) {
                log.info("Creating runways_id_seq sequence ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE SEQUENCE runways_id_seq START WITH 1 INCREMENT BY 1");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create runways_id_seq sequence", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airport_freq");
            }
            catch (SQLException e) {
                log.info("Creating airports_freq table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE airport_freq ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, name VARCHAR(100), frequency DECIMAL(6,3), type VARCHAR(30), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create airports_freq table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airport_start");
            }
            catch (SQLException e) {
                log.info("Creating airport_start table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE airport_start ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), number INTEGER, elev INTEGER, designator VARCHAR(10), name VARCHAR(48), heading DECIMAL(5,2), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create airport_start table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM runways");
            }
            catch (SQLException e) {
                log.info("Creating runways table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE runways ( id INTEGER, airport_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), elev INTEGER, surface VARCHAR(24), operations VARCHAR(18), length DECIMAL(10,2), width DECIMAL(10,2), number INTEGER, designator CHAR(1), secondary_designator CHAR(1), heading DECIMAL(5,2), magvar DECIMAL(5,2), desc VARCHAR(32), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create runways table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM taxiways");
            }
            catch (SQLException e) {
                log.info("Creating taxiways table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE taxiways ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, from_lat DECIMAL(18,15), from_lon DECIMAL(18,15), to_lat DECIMAL(18,15), to_lon DECIMAL(18,15), width DECIMAL(10,2), name VARCHAR(16), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create taxiways table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM taxi_names");
            }
            catch (SQLException e) {
                log.info("Creating taxi_names table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE taxi_names ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), airport_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), name VARCHAR(16), PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create taxi_names table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM aprons");
            }
            catch (SQLException e) {
                log.info("Creating aprons table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE aprons ( id INTEGER, airport_id INTEGER, PRIMARY KEY (id), FOREIGN KEY (airport_id) REFERENCES airports (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create aprons table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR aprons_id_seq");
            }
            catch (SQLException e) {
                log.info("Creating aprons_id_seq sequence ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE SEQUENCE aprons_id_seq START WITH 1 INCREMENT BY 1");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create aprons_id_seq sequence", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM apron_vertices");
            }
            catch (SQLException e) {
                log.info("Creating apron_vertices table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE apron_vertices ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), apron_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id), FOREIGN KEY (apron_id) REFERENCES aprons (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create apron_vertices table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM cities");
            }
            catch (SQLException e) {
                log.info("Creating cities table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE cities ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(64), alt_name VARCHAR(128), lat DECIMAL(18,15), lon DECIMAL(18,15), size SMALLINT, village BOOLEAN, PRIMARY KEY (id))");
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE INDEX city_size ON cities (size)");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create cities table", e1);
                }
            }
            try {
                SqlConnector.executeQuery(this.dataSource.getSqlConnection(), "SELECT 1 FROM user_points");
            }
            catch (SQLException e) {
                log.info("Creating user points table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE user_points ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(256), tags VARCHAR(1024), lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create user_points table", e1);
                }
            }
            try {
                SqlConnector.executeQuery(this.dataSource.getSqlConnection(), "SELECT 1 FROM ils");
            }
            catch (SQLException e) {
                log.info("Creating ils table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE ils ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), runway_id INTEGER, lat DECIMAL(18,15), lon DECIMAL(18,15), alt INTEGER, heading DECIMAL(5,2), frequency DECIMAL(6,3), magvar DECIMAL(5,2), width DECIMAL(5,2), pitch DECIMAL(5,2), name VARCHAR(48), ident VARCHAR(5), gs BOOLEAN, dme BOOLEAN, airport_id INTEGER, PRIMARY KEY (id), FOREIGN KEY (runway_id) REFERENCES runways (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create ils table", e1);
                }
            }
            try {
                SqlConnector.executeQuery(this.dataSource.getSqlConnection(), "SELECT 1 FROM elevations");
            }
            catch (SQLException e) {
                log.info("Creating elevations table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE elevations ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), elev SMALLINT, lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create elevations table", e1);
                }
            }
            try {
                SqlConnector.executeQuery(this.dataSource.getSqlConnection(), "SELECT 1 FROM params");
            }
            catch (SQLException e) {
                log.info("Creating params table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE params ( name VARCHAR(48), value VARCHAR(128), UNIQUE (name))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create params table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM obstacles");
            }
            catch (SQLException e) {
                log.info("Creating obstacles table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE obstacles ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(64), desc VARCHAR(128), lat DECIMAL(18,15), lon DECIMAL(18,15), agl INTEGER, amsl INTEGER, grp BOOLEAN, lgt BOOLEAN, PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create obstacles table", e1);
                }
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM vfr_points");
            }
            catch (SQLException e) {
                log.info("Creating vfr_points table ...");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "CREATE CACHED TABLE vfr_points ( id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1), name VARCHAR(128), remark VARCHAR(512), lat DECIMAL(18,15), lon DECIMAL(18,15), PRIMARY KEY (id))");
                    result = false;
                }
                catch (SQLException e1) {
                    log.error("Couldn't create vfr_points table", e1);
                }
            }
        }
        return result;
    }

    public void dropDBStructure() {
        if (SqlConnector.getInstance().isServerRunning()) {
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airspace_area_vertex");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE airspace_area_vertex ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop airspace_area_vertex table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airspace_area");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE airspace_area ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop airspace_area table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM routes");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE routes ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop routes table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM waypoints");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE waypoints ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop waypoints table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM navaids");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE navaids ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop navaids table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM obstacles");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE obstacles ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop obstacles table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR airports_id_seq");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP SEQUENCE airports_id_seq");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop airports_id_seq sequence", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR runways_id_seq");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP SEQUENCE runways_id_seq");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop runways_id_seq sequence", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airport_freq");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE airport_freq");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop airport_freq table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM ils");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE ils ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop ils table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM runways");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE runways ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop runways table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM taxiways");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE taxiways ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop taxiways table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM taxi_names");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE taxiways ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop taxi_names table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR aprons_id_seq");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP SEQUENCE aprons_id_seq");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop aprons_id_seq sequence", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM aprons");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE aprons ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop aprons table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM apron_vertices");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE apron_vertices ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop apron_vertices table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airport_start");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE airport_start ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop airport_start table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM cities");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP INDEX city_size");
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE cities");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop cities table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM user_points");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE user_points");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop user_points table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM elevations");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE elevations ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop elevations table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM params");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE params");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop params table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM vfr_points");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE vfr_points ");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop vfr_points table", e1);
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "SELECT 1 FROM airports");
                try {
                    SqlConnector.execute(this.dataSource.getSqlConnection(), "DROP TABLE airports");
                }
                catch (SQLException e1) {
                    log.error("Couldn't drop airports table", e1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean truncateTable(String table) {
        if (SqlConnector.getInstance().isServerRunning()) {
            try {
                return SqlConnector.execute(this.dataSource.getSqlConnection(), "TRUNCATE TABLE " + table + " AND COMMIT");
            }
            catch (SQLException e) {
                log.error("Couldn't truncate " + table + " table: ", e);
            }
        }
        return false;
    }
}

