/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ObstacleService
extends BaseService {
    private static final Logger log = Logger.getLogger(ObstacleService.class);

    public ObstacleService(DataSource dataSource) {
        super(dataSource);
    }

    public void insertObstacle(Obstacle obstacle) {
        this.insertObstacle(obstacle, null);
    }

    public void insertObstacle(Obstacle obstacle, Session session) {
        boolean withSession;
        if (SettingsBean.getInstance().isLogLevelTrace()) {
            log.trace("insertObstacle: " + obstacle);
        }
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)obstacle);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public List<Obstacle> findAllObstacles() {
        return this.findObstaclesInArea(null);
    }

    public List<Obstacle> findObstaclesInArea(GpsArea area) {
        ArrayList<Obstacle> obstacles = new ArrayList<Obstacle>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Obstacle.class);
        if (area != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
            c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            obstacles.add((Obstacle)it.next());
        }
        session.close();
        return obstacles;
    }

    public void deleteObstacles(Double minLat, Double minLon, Double maxLat, Double maxLon) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Obstacle.class);
        if (minLat != null) {
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)minLat));
        }
        if (maxLat != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)maxLat));
        }
        if (minLon != null) {
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)minLon));
        }
        if (maxLon != null) {
            c.add((Criterion)Restrictions.le((String)"lon", (Object)maxLon));
        }
        for (Obstacle o : c.list()) {
            log.debug("Deleting " + o);
            session.delete((Object)o);
        }
        session.flush();
        session.close();
    }
}

