/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class NavaidService
extends BaseService {
    private static final Logger log = Logger.getLogger(NavaidService.class);

    public NavaidService(DataSource dataSource) {
        super(dataSource);
    }

    public void insertNavaid(Navaid navaid) {
        this.insertNavaid(navaid, null);
    }

    public void insertNavaid(Navaid navaid, Session session) {
        boolean withSession;
        if (SettingsBean.getInstance().isLogLevelTrace()) {
            log.trace("insertNavaid: " + navaid);
        }
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)navaid);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public List<Navaid> findNavaidsByIdent(String ident, String type) {
        if (ident == null) {
            return null;
        }
        ArrayList<Navaid> resultsList = new ArrayList<Navaid>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Navaid.class);
        c.add((Criterion)Restrictions.eq((String)"ident", (Object)ident).ignoreCase());
        if (type != null) {
            c.add((Criterion)Restrictions.like((String)"type", (Object)("%" + type + "%")));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultsList.add((Navaid)it.next());
        }
        session.close();
        return resultsList;
    }

    public List<Navaid> findNavaids(String txt, String type, boolean sort) {
        ArrayList<Navaid> resultsList = new ArrayList<Navaid>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Navaid.class);
        if (txt != null) {
            c.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"name", (Object)("%" + txt + "%")).ignoreCase(), (Criterion)Restrictions.like((String)"ident", (Object)("%" + txt + "%")).ignoreCase()));
        }
        if (type != null) {
            c.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        if (sort) {
            c.addOrder(Order.asc((String)"ident"));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultsList.add((Navaid)it.next());
        }
        session.close();
        return resultsList;
    }

    public List<Navaid> findAllVors() {
        ArrayList<Navaid> resultsList = new ArrayList<Navaid>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Navaid.class);
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"type", (Object)"VOR"), (Criterion)Restrictions.eq((String)"type", (Object)"VOR-DME")));
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultsList.add((Navaid)it.next());
        }
        session.close();
        return resultsList;
    }

    public List<Navaid> findNavaidsInArea(GpsArea area, String type, boolean sort) {
        if (area == null) {
            return this.findNavaids(null, type, sort);
        }
        return this.findNavaidsInArea(area.getMinLat(), area.getMinLon(), area.getMaxLat(), area.getMaxLon(), type, sort);
    }

    public List<Navaid> findNavaidsInArea(double minLat, double minLon, double maxLat, double maxLon, String type, boolean sort) {
        ArrayList<Navaid> resultsList = new ArrayList<Navaid>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Navaid.class);
        c.add((Criterion)Restrictions.ge((String)"lat", (Object)minLat));
        c.add((Criterion)Restrictions.le((String)"lat", (Object)maxLat));
        c.add((Criterion)Restrictions.ge((String)"lon", (Object)minLon));
        c.add((Criterion)Restrictions.le((String)"lon", (Object)maxLon));
        if (type != null) {
            c.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        if (sort) {
            c.addOrder(Order.asc((String)"ident"));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultsList.add((Navaid)it.next());
        }
        session.close();
        return resultsList;
    }

    public void deleteNavaidById(int id) {
        this.deleteNavaidById(id, null);
    }

    public void deleteNavaidById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = session.createQuery("delete from Navaid n where id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        if (!withSession) {
            session.close();
        }
    }

    public void deleteNavaids(String ident, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Navaid.class);
        if (ident != null) {
            c.add((Criterion)Restrictions.eq((String)"ident", (Object)ident));
        }
        if (minLat != null) {
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)minLat));
        }
        if (maxLat != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)maxLat));
        }
        if (minLon != null) {
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)minLon));
        }
        if (maxLon != null) {
            c.add((Criterion)Restrictions.le((String)"lon", (Object)maxLon));
        }
        for (Navaid n : c.list()) {
            log.debug("Deleting " + n);
            session.delete((Object)n);
        }
        session.flush();
        session.close();
    }
}

