/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class IfrRouteService
extends BaseService {
    private static final Logger log = Logger.getLogger(IfrRouteService.class);

    public IfrRouteService(DataSource dataSource) {
        super(dataSource);
    }

    public List<Route> findIfrRoutesInArea(GpsArea area) {
        if (area == null) {
            return this.findIfrRoutes();
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        Session session = this.dataSource.getHibernateSession();
        String hql = "select r from Route r";
        Query query = session.createQuery(hql);
        for (Route r : query.list()) {
            GpsArea ar = r.getRectangleOver();
            if (!ar.isInside(area) && !area.isInside(ar)) continue;
            routes.add(r);
        }
        session.close();
        return routes;
    }

    public List<Route> findIfrRoutes() {
        ArrayList<Route> routes = new ArrayList<Route>();
        Session session = this.dataSource.getHibernateSession();
        String hql = "select r from Route r ";
        Query query = session.createQuery(hql);
        Iterator it = query.list().iterator();
        while (it.hasNext()) {
            routes.add((Route)it.next());
        }
        session.close();
        return routes;
    }

    public List<Waypoint> findIfrPoints(String txt, boolean sort) {
        ArrayList<Waypoint> resultList = new ArrayList<Waypoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Waypoint.class);
        if (txt != null) {
            c.add((Criterion)Restrictions.like((String)"ident", (Object)("%" + txt + "%")).ignoreCase());
        }
        if (sort) {
            c.addOrder(Order.asc((String)"ident"));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultList.add((Waypoint)it.next());
        }
        session.close();
        return resultList;
    }

    public List<Waypoint> findIfrPointsInArea(GpsArea area) {
        ArrayList<Waypoint> resultsList = new ArrayList<Waypoint>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Waypoint.class);
        if (area != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
            c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultsList.add((Waypoint)it.next());
        }
        session.close();
        return resultsList;
    }

    public void insertWaypoint(Waypoint waypoint, Session session) {
        boolean withSession;
        if (SettingsBean.getInstance().isLogLevelTrace()) {
            log.trace("insertWaypoint: " + waypoint);
        }
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)waypoint);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public void insertRoute(Route route, Session session) {
        boolean withSession;
        if (SettingsBean.getInstance().isLogLevelTrace()) {
            log.trace("insertRoute: " + route);
        }
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)route);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public void deleteIfrPoints(String ident, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Waypoint.class);
        if (ident != null) {
            c.add((Criterion)Restrictions.eq((String)"ident", (Object)ident));
        }
        if (minLat != null) {
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)minLat));
        }
        if (maxLat != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)maxLat));
        }
        if (minLon != null) {
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)minLon));
        }
        if (maxLon != null) {
            c.add((Criterion)Restrictions.le((String)"lon", (Object)maxLon));
        }
        for (Waypoint v : c.list()) {
            log.debug("Deleting " + v);
            session.delete((Object)v);
        }
        session.flush();
        session.close();
    }

    public List<Route> findIfrRoutes(String name) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Route.class);
        if (name != null) {
            c.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            routes.add((Route)it.next());
        }
        session.close();
        return routes;
    }

    public Route findIfrRouteById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Route route = (Route)session.get(Route.class, (Serializable)Integer.valueOf(id));
        if (!withSession) {
            session.close();
        }
        return route;
    }

    public void deleteIfrRouteById(int id) {
        Session session = this.dataSource.getHibernateSession();
        Query q = session.createQuery("delete from Route where id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        session.flush();
        session.close();
    }

    public boolean deleteIfrPointById(int id) {
        return this.deleteIfrPointById(id, null);
    }

    public boolean deleteIfrPointById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = session.createQuery("delete from Waypoint where id = :id");
        q.setParameter("id", (Object)id);
        int numDeleted = q.executeUpdate();
        if (!withSession) {
            session.close();
        }
        return numDeleted > 0;
    }
}

