/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ElevationService
extends BaseService {
    public ElevationService(DataSource dataSource) {
        super(dataSource);
    }

    public void insertElevation(Elevation elevation, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)elevation);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public void insertElevation(Elevation elevation) {
        this.insertElevation(elevation, null);
    }

    public List<Elevation> getAllElevations() {
        ArrayList<Elevation> resultsList = new ArrayList<Elevation>();
        Session session = this.dataSource.getHibernateSession();
        Iterator it = session.createCriteria(Elevation.class).list().iterator();
        while (it.hasNext()) {
            resultsList.add((Elevation)it.next());
        }
        session.close();
        return resultsList;
    }

    public List<Elevation> findElevationsInArea(GpsArea area) {
        ArrayList<Elevation> resultsList = new ArrayList<Elevation>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Elevation.class);
        c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
        c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
        c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
        c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            resultsList.add((Elevation)it.next());
        }
        session.close();
        return resultsList;
    }
}

