/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class CityService
extends BaseService {
    public CityService(DataSource dataSource) {
        super(dataSource);
    }

    public void insertCity(City city) {
        this.insertCity(city, null);
    }

    public void insertCity(City city, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)city);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public List<City> findCitiesInArea(GpsArea area, Short size) {
        ArrayList<City> cities = new ArrayList<City>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(City.class);
        if (area != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
            c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        }
        if (size != null) {
            c.add((Criterion)Restrictions.ge((String)"size", (Object)size));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            cities.add((City)it.next());
        }
        session.close();
        return cities;
    }

    public List<City> findCities(String txt, boolean sort) {
        ArrayList<City> cities = new ArrayList<City>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(City.class);
        if (txt != null) {
            c.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"name", (Object)("%" + txt + "%")).ignoreCase(), (Criterion)Restrictions.like((String)"altName", (Object)("%" + txt + "%")).ignoreCase()));
        }
        if (sort) {
            c.addOrder(Order.asc((String)"name"));
        }
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            cities.add((City)it.next());
        }
        session.close();
        return cities;
    }

    public boolean deleteCityById(int id) {
        return this.deleteCityById(id, null);
    }

    public boolean deleteCityById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = session.createQuery("delete from City where id = :id");
        q.setParameter("id", (Object)id);
        int numDeleted = q.executeUpdate();
        if (!withSession) {
            session.close();
        }
        return numDeleted > 0;
    }
}

