/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.filter.AirspaceFilter;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Order;

public class AirspaceService
extends BaseService {
    private static final Logger log = Logger.getLogger(AirspaceService.class);

    public AirspaceService(DataSource dataSource) {
        super(dataSource);
    }

    public void updateAirspace(AirspaceArea airspace, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.update((Object)airspace);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public void updateAirspaceArea(AirspaceArea area, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.update((Object)area);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public void insertAirspace(AirspaceArea airspace, Session session) {
        boolean withSession;
        if (SettingsBean.getInstance().isLogLevelTrace()) {
            log.trace("insertAirspace: " + airspace);
        }
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)airspace);
        int i = 0;
        for (AirspaceAreaVertex v : airspace.getVertices()) {
            v.setAirspaceArea(airspace);
            v.setIndex(i);
            session.save((Object)v);
            ++i;
        }
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public List<AirspaceArea> findAllAirspaces() {
        LinkedList<AirspaceArea> airspaces = new LinkedList<AirspaceArea>();
        Session session = this.dataSource.getHibernateSession();
        String hql = "select a from AirspaceArea a ";
        Query query = session.createQuery(hql);
        this.eagerLoadAirspaces(airspaces, query.list().iterator());
        session.close();
        return airspaces;
    }

    public void deleteAirspace(AirspaceArea area, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        for (AirspaceAreaVertex v : area.getVertices()) {
            session.delete((Object)v);
        }
        session.delete((Object)area);
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    public Integer getAirspaceRecentId() {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(AirspaceArea.class);
        c.addOrder(Order.desc((String)"id"));
        c.setMaxResults(1);
        AirspaceArea a = (AirspaceArea)c.uniqueResult();
        session.close();
        return a.getId();
    }

    public boolean changeAirspaceAreaParent(int areaId, int newParentId) {
        if (SqlConnector.getInstance().isServerRunning()) {
            String query = "UPDATE airspace_area SET  airspace_id = " + newParentId + " WHERE id = " + areaId;
            try {
                return SqlConnector.executeUpdate(this.dataSource.getSqlConnection(), query);
            }
            catch (SQLException e) {
                log.info("changeAirspaceAreaParent: " + areaId + "; " + newParentId);
                log.error("changeAirspaceAreaParent: " + query, e);
            }
        }
        return false;
    }

    public AirspaceArea findAirspaceById(int id) {
        return this.findAirspaceById(id, null);
    }

    public AirspaceArea findAirspaceById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        AirspaceArea airspace = (AirspaceArea)session.get(AirspaceArea.class, (Serializable)Integer.valueOf(id));
        airspace.eagerLoad();
        if (!withSession) {
            session.close();
        }
        return airspace;
    }

    public AirspaceArea findAirspaceAreaById(int id) {
        Session session = this.dataSource.getHibernateSession();
        AirspaceArea airspaceArea = (AirspaceArea)session.get(AirspaceArea.class, (Serializable)Integer.valueOf(id));
        airspaceArea.eagerLoad();
        session.close();
        return airspaceArea;
    }

    public void deleteAirspacesByType(AirspaceType type) {
        Session session = this.dataSource.getHibernateSession();
        String hql = "select a from AirspaceArea a where a.type = :type";
        Query q = session.createQuery(hql);
        q.setParameter("type", (Object)type);
        for (AirspaceArea a : q.list()) {
            this.deleteAirspaceAreaById(a.getId(), session);
        }
        session.close();
    }

    public void deleteAirspaceAreaById(int airspaceAreaId) {
        this.deleteAirspaceAreaById(airspaceAreaId, null);
    }

    public void deleteAirspaceAreaById(int airspaceAreaId, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = session.createQuery("delete AirspaceAreaVertex where airspaceArea.id = :id");
        q.setParameter("id", (Object)airspaceAreaId);
        q.executeUpdate();
        q = session.createQuery("delete AirspaceArea where id = :id");
        q.setParameter("id", (Object)airspaceAreaId);
        q.executeUpdate();
        if (!withSession) {
            session.close();
        }
    }

    public List<AirspaceArea> findAirspacesInArea(GpsArea area) {
        if (area == null) {
            return this.findAllAirspaces();
        }
        Session session = this.dataSource.getHibernateSession();
        String hql = "select a from AirspaceArea a ";
        Query query = session.createQuery(hql);
        Iterator it = query.list().iterator();
        LinkedList<AirspaceArea> airspaces = new LinkedList<AirspaceArea>();
        while (it.hasNext()) {
            AirspaceArea a = (AirspaceArea)it.next();
            if (!a.isInside(area)) continue;
            a.eagerLoad();
            airspaces.add(a);
        }
        session.close();
        return airspaces;
    }

    private void eagerLoadAirspaces(List<AirspaceArea> airspaces, Iterator<?> it) {
        while (it.hasNext()) {
            AirspaceArea a = (AirspaceArea)it.next();
            a.eagerLoad();
            airspaces.add(a);
        }
    }

    public List<AirspaceArea> findAirspaces(AirspaceFilter filter) {
        LinkedList<AirspaceArea> airspaces = new LinkedList<AirspaceArea>();
        Session session = this.dataSource.getHibernateSession();
        this.eagerLoadAirspaces(airspaces, filter.createCriteria(session.createCriteria(AirspaceArea.class)).list().iterator());
        session.close();
        return airspaces;
    }
}

