/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.service;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.ApronVertex;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.filter.AirportFilter;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.sql.service.BaseService;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hsqldb.HsqlException;

public class AirportService
extends BaseService {
    private static final Logger log = Logger.getLogger(AirportService.class);

    public AirportService(DataSource dataSource) {
        super(dataSource);
    }

    public void insertAirport(Airport airport) throws HsqlException {
        this.insertAirport(airport, null);
    }

    public void insertAirport(Airport airport, Session session) throws HsqlException {
        boolean withSession;
        if (SettingsBean.getInstance().isLogLevelTrace()) {
            log.trace("insertAirport: " + airport);
            for (Runway r : airport.getRunways()) {
                log.trace("insertAirport: [" + airport.getId() + "] " + r);
            }
            for (AirportFreq f : airport.getFrequencies()) {
                log.trace("insertAirport: [" + airport.getId() + "] " + f);
            }
            for (Taxiway t : airport.getTaxiways()) {
                log.trace("insertAirport: [" + airport.getId() + "] " + t);
            }
            for (TaxiName n : airport.getTaxiNames()) {
                log.trace("insertAirport: [" + airport.getId() + "] " + n);
            }
            for (Apron a : airport.getAprons()) {
                log.trace("insertAirport: [" + airport.getId() + "] " + a);
            }
            for (AirportStart s : airport.getStarts()) {
                log.trace("insertAirport: [" + airport.getId() + "] " + s);
            }
        }
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        session.save((Object)airport);
        for (Runway r : airport.getRunways()) {
            r.setAirport(airport);
            session.save((Object)r);
            for (Ils ils : r.getIls()) {
                ils.setRunway(r);
                ils.setAirportId(airport.getId());
                session.save((Object)ils);
            }
        }
        for (AirportFreq f : airport.getFrequencies()) {
            f.setAirport(airport);
            session.save((Object)f);
        }
        for (AirportStart s : airport.getStarts()) {
            s.setAirport(airport);
            session.save((Object)s);
        }
        for (Taxiway t : airport.getTaxiways()) {
            t.setAirport(airport);
            session.save((Object)t);
        }
        for (TaxiName n : airport.getTaxiNames()) {
            n.setAirport(airport);
            session.save((Object)n);
        }
        for (Apron a : airport.getAprons()) {
            a.setAirport(airport);
            session.save((Object)a);
            for (ApronVertex apronVertex : a.getVertices()) {
                apronVertex.setApron(a);
                session.save((Object)apronVertex);
            }
        }
        if (!withSession) {
            session.flush();
            session.close();
        }
    }

    private Integer getNextSequenceValue(String seqName) {
        Integer nextValue = null;
        if (SqlConnector.getInstance().isServerRunning()) {
            try {
                ResultSet rs = SqlConnector.executeQuery(this.dataSource.getSqlConnection(), "CALL NEXT VALUE FOR " + seqName);
                rs.next();
                nextValue = rs.getInt(1);
            }
            catch (SQLException e) {
                log.error("Couldn't query next " + seqName + " value", e);
            }
        }
        return nextValue;
    }

    public Integer getNextAirportsIdValue() {
        return this.getNextSequenceValue("airports_id_seq");
    }

    public Integer getNextAirportRunwaysIdValue() {
        return this.getNextSequenceValue("runways_id_seq");
    }

    public Integer getNextApronsIdValue() {
        return this.getNextSequenceValue("aprons_id_seq");
    }

    private boolean resetSequenceValue(String seqName) {
        if (SqlConnector.getInstance().isServerRunning()) {
            try {
                SqlConnector.execute(this.dataSource.getSqlConnection(), "ALTER SEQUENCE " + seqName + " RESTART WITH 1");
                return true;
            }
            catch (SQLException e) {
                log.error("Couldn't reset  " + seqName + " sequence", e);
            }
        }
        return false;
    }

    public boolean resetAirportsIdSequence() {
        return this.resetSequenceValue("airports_id_seq");
    }

    public boolean resetAirportRunwaysIdSequence() {
        return this.resetSequenceValue("runways_id_seq");
    }

    public boolean resetApronsIdSequence() {
        return this.resetSequenceValue("aprons_id_seq");
    }

    public List<Ils> findIlsInArea(GpsArea area) {
        ArrayList<Ils> ilsList = new ArrayList<Ils>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Ils.class);
        c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
        c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
        c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
        c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            ilsList.add((Ils)it.next());
        }
        session.close();
        return ilsList;
    }

    public List<Ils> getAllIls() {
        ArrayList<Ils> ilsList = new ArrayList<Ils>();
        Session session = this.dataSource.getHibernateSession();
        Iterator it = session.createCriteria(Ils.class).list().iterator();
        while (it.hasNext()) {
            ilsList.add((Ils)it.next());
        }
        session.close();
        return ilsList;
    }

    public List<Airport> findAirportsByCriteria(AirportFilter criteria) {
        return this.findAirportsByCriteria(criteria, false);
    }

    public List<Airport> findAirportsByCriteria(AirportFilter criteria, boolean withChildren) {
        ArrayList<Airport> airports = new ArrayList<Airport>();
        Session session = this.dataSource.getHibernateSession();
        for (Airport a : criteria.createCriteria(session.createCriteria(Airport.class)).list()) {
            if (withChildren) {
                a.eagerLoad();
            }
            airports.add(a);
        }
        session.close();
        return airports;
    }

    public List<Airport> findAirportsInArea(GpsArea area) {
        return this.findAirportsInArea(area, false);
    }

    public List<Airport> findAirportsInArea(GpsArea area, boolean eagerLoad) {
        if (area == null) {
            return this.findAirports(null, false, eagerLoad);
        }
        ArrayList<Airport> airports = new ArrayList<Airport>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Airport.class);
        c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
        c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
        c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
        c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        if (eagerLoad) {
            for (Airport a : c.list()) {
                a.eagerLoad();
                airports.add(a);
            }
        } else {
            Iterator it = c.list().iterator();
            while (it.hasNext()) {
                airports.add((Airport)it.next());
            }
        }
        session.close();
        return airports;
    }

    public void deleteAirportById(int id) {
        this.deleteAirportById(id, null);
    }

    public Airport findAirportById(int id) {
        return this.findAirportById(id, null);
    }

    public Airport findAirportById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Airport airport = (Airport)session.get(Airport.class, (Serializable)Integer.valueOf(id));
        airport.eagerLoad();
        if (!withSession) {
            session.close();
        }
        return airport;
    }

    public void deleteAirportById(int id, Session session) {
        boolean withSession;
        boolean bl = withSession = session != null;
        if (!withSession) {
            session = this.dataSource.getHibernateSession();
        }
        Query q = null;
        Airport a = this.findAirportById(id);
        q = session.createQuery("delete from AirportFreq where airport.id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        q = session.createQuery("delete from AirportStart where airport.id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        q = session.createQuery("delete from Taxiway where airport.id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        q = session.createQuery("delete from TaxiName where airport.id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        for (Apron ap : a.getAprons()) {
            q = session.createQuery("delete from ApronVertex where apron.id = :id");
            q.setParameter("id", (Object)ap.getId());
            q.executeUpdate();
        }
        q = session.createQuery("delete from Apron where airport.id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        for (Runway r : a.getRunways()) {
            q = session.createQuery("delete from Ils where runway.id = :id");
            q.setParameter("id", (Object)r.getId());
            q.executeUpdate();
        }
        q = session.createQuery("delete from Runway where airport.id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        q = session.createQuery("delete from Airport where id = :id");
        q.setParameter("id", (Object)id);
        q.executeUpdate();
        if (!withSession) {
            session.close();
        }
    }

    public List<Airport> findAirports(String txt, boolean sort) {
        return this.findAirports(txt, sort, false);
    }

    public List<Airport> findAirports(String txt, boolean sort, boolean eagerLoad) {
        ArrayList<Airport> airports = new ArrayList<Airport>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Airport.class);
        if (txt != null) {
            c.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"ident", (Object)("%" + txt + "%")).ignoreCase(), (Criterion)Restrictions.like((String)"name", (Object)("%" + txt + "%")).ignoreCase()));
        }
        if (sort) {
            c.addOrder(Order.asc((String)"ident"));
        }
        if (eagerLoad) {
            for (Airport a : c.list()) {
                a.eagerLoad();
                airports.add(a);
            }
        } else {
            Iterator it = c.list().iterator();
            while (it.hasNext()) {
                airports.add((Airport)it.next());
            }
        }
        session.close();
        return airports;
    }

    public List<Runway> getAllRunways() {
        ArrayList<Runway> runwaysList = new ArrayList<Runway>();
        Session session = this.dataSource.getHibernateSession();
        Iterator it = session.createCriteria(Runway.class).list().iterator();
        while (it.hasNext()) {
            runwaysList.add((Runway)it.next());
        }
        session.close();
        return runwaysList;
    }

    public List<Runway> findRunwaysInArea(GpsArea area) {
        ArrayList<Runway> runwaysList = new ArrayList<Runway>();
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Runway.class);
        c.add((Criterion)Restrictions.le((String)"lat", (Object)area.getMaxLat()));
        c.add((Criterion)Restrictions.ge((String)"lat", (Object)area.getMinLat()));
        c.add((Criterion)Restrictions.ge((String)"lon", (Object)area.getMinLon()));
        c.add((Criterion)Restrictions.le((String)"lon", (Object)area.getMaxLon()));
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            runwaysList.add((Runway)it.next());
        }
        session.close();
        return runwaysList;
    }

    public long countRunwaysWithNotNullPos() {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Runway.class);
        c.add(Restrictions.isNotNull((String)"lat"));
        c.add(Restrictions.isNotNull((String)"lon"));
        long total = c.list().size();
        session.clear();
        return total;
    }

    public void deleteAirports(String ident, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        Session session = this.dataSource.getHibernateSession();
        Criteria c = session.createCriteria(Airport.class);
        if (ident != null) {
            c.add((Criterion)Restrictions.eq((String)"ident", (Object)ident));
        }
        if (minLat != null) {
            c.add((Criterion)Restrictions.ge((String)"lat", (Object)minLat));
        }
        if (maxLat != null) {
            c.add((Criterion)Restrictions.le((String)"lat", (Object)maxLat));
        }
        if (minLon != null) {
            c.add((Criterion)Restrictions.ge((String)"lon", (Object)minLon));
        }
        if (maxLon != null) {
            c.add((Criterion)Restrictions.le((String)"lon", (Object)maxLon));
        }
        for (Airport a : c.list()) {
            log.debug("Deleting " + a);
            this.deleteAirportById(a.getId(), session);
        }
        session.flush();
        session.close();
    }

    public Set<String> findAllAirportsIdents() {
        Session session = this.dataSource.getHibernateSession();
        TreeSet<String> result = new TreeSet<String>();
        Criteria c = session.createCriteria(Airport.class);
        Iterator it = c.list().iterator();
        while (it.hasNext()) {
            String ident = ((Airport)it.next()).getIdent();
            if (ident == null) continue;
            result.add(ident);
        }
        session.close();
        return result;
    }
}

