/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.waypoint;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.core.sql.type.WaypointType;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.facade.xp.AbstractXPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class WaypointImportVer600_1100
extends AbstractXPlaneImport
implements XPlaneImport {
    private static final Logger log = Logger.getLogger(WaypointImportVer600_1100.class);

    public WaypointImportVer600_1100(String filename, XplaneImportBean importBean) {
        super(filename, importBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public boolean execute() {
        boolean bl;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            br.readLine();
            br.readLine();
            String line = null;
            while ((line = br.readLine()) != null) {
                WaypointRow r = new WaypointRow(line);
                if (!r.isValid()) continue;
                Waypoint w = new Waypoint();
                w.setType(WaypointType.ROUTE);
                w.setLat(r.getLat());
                w.setLon(r.getLon());
                w.setIdent(r.getIdent());
                w.setRegion(r.getRegion());
                this.importBean.getWaypoints().add(w);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't read file " + this.filename, e);
            IOUtil.closeQuietly(br);
        }
        catch (IOException e2) {
            log.error("Couldn't read file " + this.filename, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return bl;
        return false;
    }

    private class WaypointRow {
        private String ident;
        private String region;
        private Double lat;
        private Double lon;

        public WaypointRow(String row) {
            String[] tokens = row.trim().split("\\s+");
            if (tokens.length >= 3) {
                try {
                    this.lat = Double.valueOf(tokens[0]);
                    this.lon = Double.valueOf(tokens[1]);
                }
                catch (NumberFormatException e) {
                    log.error("Bad number for " + row, e);
                }
                this.ident = tokens[2];
                if (tokens.length >= 4) {
                    this.region = tokens[4];
                }
            }
        }

        public String getRegion() {
            return this.region;
        }

        public String getIdent() {
            return this.ident;
        }

        public Double getLat() {
            return this.lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public boolean isValid() {
            return this.lat != null && this.lon != null && this.ident != null;
        }
    }
}

