/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.row;

import main.java.guru.vfrflight.sql.facade.xp.row.RunwayRow;
import org.apache.log4j.Logger;

public class WaterRunwayRow
implements RunwayRow {
    private static final Logger log = Logger.getLogger(WaterRunwayRow.class);
    private String priNumber;
    private String secNumber;
    private Double priLat;
    private Double priLon;
    private Double secLat;
    private Double secLon;
    private Double width;

    public WaterRunwayRow(String row) {
        String[] tokens = row.trim().split("\\s+");
        if (tokens.length >= 9) {
            try {
                this.width = Double.valueOf(tokens[1]);
                this.priLat = Double.valueOf(tokens[4]);
                this.priLon = Double.valueOf(tokens[5]);
                this.secLat = Double.valueOf(tokens[7]);
                this.secLon = Double.valueOf(tokens[8]);
            }
            catch (NumberFormatException e) {
                log.error("Bad number for " + row, e);
            }
            this.priNumber = tokens[3];
            this.secNumber = tokens[6];
        }
    }

    @Override
    public String getPriNumber() {
        return this.priNumber;
    }

    @Override
    public String getSecNumber() {
        return this.secNumber;
    }

    @Override
    public Double getPriLat() {
        return this.priLat;
    }

    @Override
    public Double getPriLon() {
        return this.priLon;
    }

    @Override
    public Double getSecLat() {
        return this.secLat;
    }

    @Override
    public Double getSecLon() {
        return this.secLon;
    }

    @Override
    public Double getWidth() {
        return this.width;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LandRunwayRow [priNumber=");
        builder.append(this.priNumber);
        builder.append(", secNumber=");
        builder.append(this.secNumber);
        builder.append(", priLat=");
        builder.append(this.priLat);
        builder.append(", priLon=");
        builder.append(this.priLon);
        builder.append(", secLat=");
        builder.append(this.secLat);
        builder.append(", secLon=");
        builder.append(this.secLon);
        builder.append(", width=");
        builder.append(this.width);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isValid() {
        return this.secLat != null && this.secLon != null && this.priLat != null && this.priLon != null;
    }

    @Override
    public Integer getSurfaceType() {
        return 13;
    }
}

