/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.row;

import org.apache.log4j.Logger;

public class StartRow {
    private static final Logger log = Logger.getLogger(StartRow.class);
    private String name;
    private Double lat;
    private Double lon;
    private Double heading;

    public StartRow(String row) {
        String[] tokens = row.trim().split("\\s+");
        if (tokens.length >= 7) {
            try {
                this.lat = Double.valueOf(tokens[1]);
                this.lon = Double.valueOf(tokens[2]);
                this.heading = Double.valueOf(tokens[3]);
            }
            catch (NumberFormatException e) {
                log.error("Bad number for " + row, e);
            }
            if (tokens.length >= 7) {
                StringBuilder sb = new StringBuilder();
                for (int i = 6; i < tokens.length; ++i) {
                    sb.append(tokens[i]);
                    sb.append(" ");
                }
                this.name = sb.toString();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public Double getHeading() {
        return this.heading;
    }

    public boolean isValid() {
        return this.lat != null && this.lon != null && this.heading != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StartRow [name=");
        builder.append(this.name);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", heading=");
        builder.append(this.heading);
        builder.append("]");
        return builder.toString();
    }
}

