/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.row;

import main.java.guru.vfrflight.sql.facade.xp.row.RunwayRow;
import org.apache.log4j.Logger;

public class LandRunwayRow
implements RunwayRow {
    private static final Logger log = Logger.getLogger(LandRunwayRow.class);
    private String priNumber;
    private String secNumber;
    private Double priLat;
    private Double priLon;
    private Double secLat;
    private Double secLon;
    private Integer surfaceType;
    private Double width;
    private Double priDisplacedThreshold;
    private Double secDisplacedThreshold;

    public LandRunwayRow(String row) {
        String[] tokens = row.trim().split("\\s+");
        if (tokens.length >= 26) {
            try {
                this.width = Double.valueOf(tokens[1]);
                this.surfaceType = Integer.valueOf(tokens[2]);
                this.priLat = Double.valueOf(tokens[9]);
                this.priLon = Double.valueOf(tokens[10]);
                this.priDisplacedThreshold = Double.valueOf(tokens[11]);
                this.secLat = Double.valueOf(tokens[18]);
                this.secLon = Double.valueOf(tokens[19]);
                this.secDisplacedThreshold = Double.valueOf(tokens[20]);
            }
            catch (NumberFormatException e) {
                log.error("Bad number for " + row, e);
            }
            this.priNumber = tokens[8];
            this.secNumber = tokens[17];
        }
    }

    @Override
    public String getPriNumber() {
        return this.priNumber;
    }

    @Override
    public String getSecNumber() {
        return this.secNumber;
    }

    @Override
    public Double getPriLat() {
        return this.priLat;
    }

    @Override
    public Double getPriLon() {
        return this.priLon;
    }

    @Override
    public Double getSecLat() {
        return this.secLat;
    }

    @Override
    public Double getSecLon() {
        return this.secLon;
    }

    @Override
    public Integer getSurfaceType() {
        return this.surfaceType;
    }

    @Override
    public Double getWidth() {
        return this.width;
    }

    public Double getPriDisplacedThreshold() {
        return this.priDisplacedThreshold;
    }

    public Double getSecDisplacedThreshold() {
        return this.secDisplacedThreshold;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LandRunwayRow [priNumber=");
        builder.append(this.priNumber);
        builder.append(", secNumber=");
        builder.append(this.secNumber);
        builder.append(", priLat=");
        builder.append(this.priLat);
        builder.append(", priLon=");
        builder.append(this.priLon);
        builder.append(", secLat=");
        builder.append(this.secLat);
        builder.append(", secLon=");
        builder.append(this.secLon);
        builder.append(", surfaceType=");
        builder.append(this.surfaceType);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", priDisplacedThreshold=");
        builder.append(this.priDisplacedThreshold);
        builder.append(", secDisplacedThreshold=");
        builder.append(this.secDisplacedThreshold);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isValid() {
        return this.secLat != null && this.secLon != null && this.priLat != null && this.priLon != null;
    }
}

