/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.row;

import org.apache.log4j.Logger;

public class HelipadRow {
    private static final Logger log = Logger.getLogger(HelipadRow.class);
    private String designator;
    private Double lat;
    private Double lon;
    private Double trueHeading;
    private Double length;
    private Double width;
    private Integer surface;

    public HelipadRow(String row) {
        String[] tokens = row.trim().split("\\s+");
        if (tokens.length >= 12) {
            this.designator = tokens[1];
            try {
                this.lat = Double.valueOf(tokens[2]);
                this.lon = Double.valueOf(tokens[3]);
                this.trueHeading = Double.valueOf(tokens[4]);
                this.length = Double.valueOf(tokens[5]);
                this.width = Double.valueOf(tokens[6]);
                this.surface = Integer.valueOf(tokens[7]);
            }
            catch (NumberFormatException e) {
                log.error("Bad number for " + row, e);
            }
        }
    }

    public String getDesignator() {
        return this.designator;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public Double getTrueHeading() {
        return this.trueHeading;
    }

    public Double getLength() {
        return this.length;
    }

    public Double getWidth() {
        return this.width;
    }

    public Integer getSurface() {
        return this.surface;
    }

    public boolean isValid() {
        return this.lat != null && this.lon != null && this.trueHeading != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HelipadRow [designator=");
        builder.append(this.designator);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", trueHeading=");
        builder.append(this.trueHeading);
        builder.append(", length=");
        builder.append(this.length);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", surface=");
        builder.append(this.surface);
        builder.append("]");
        return builder.toString();
    }
}

