/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.row;

import org.apache.log4j.Logger;

public class CommRow {
    private static final Logger log = Logger.getLogger(CommRow.class);
    private String code;
    private String name;
    private Integer freq;

    public CommRow(String row) {
        String[] tokens = row.trim().split("\\s+");
        if (tokens.length >= 2) {
            try {
                this.freq = Integer.valueOf(tokens[1]);
            }
            catch (NumberFormatException e) {
                log.error("Bad number for " + row, e);
            }
            this.code = tokens[0];
            if (tokens.length > 2) {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < tokens.length; ++i) {
                    sb.append(tokens[i]);
                    sb.append(" ");
                }
                this.name = sb.toString();
            }
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getFreq() {
        return this.freq;
    }

    public boolean isValid() {
        return this.code != null && this.freq != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CommRow [code=");
        builder.append(this.code);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", freq=");
        builder.append(this.freq);
        builder.append("]");
        return builder.toString();
    }
}

