/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.row;

import org.apache.log4j.Logger;

public class AirportRow {
    private static final Logger log = Logger.getLogger(AirportRow.class);
    private String ident;
    private String name;
    private Integer elev;

    public AirportRow(String row) {
        String[] tokens = row.trim().split("\\s+");
        if (tokens.length >= 5) {
            try {
                this.elev = Integer.valueOf(tokens[1]);
            }
            catch (NumberFormatException e) {
                log.error("Bad number for " + row, e);
            }
            this.ident = tokens[4];
            if (tokens.length > 4) {
                StringBuilder sb = new StringBuilder();
                for (int i = 5; i < tokens.length; ++i) {
                    sb.append(tokens[i]);
                    sb.append(" ");
                }
                this.name = sb.toString();
            }
        }
    }

    public String getIdent() {
        return this.ident;
    }

    public Integer getElev() {
        return this.elev;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.ident != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AirportRow [ident=");
        builder.append(this.ident);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append("]");
        return builder.toString();
    }
}

