/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.navaid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.facade.xp.AbstractXPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImportUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class NavaidImportVer1100
extends AbstractXPlaneImport
implements XPlaneImport {
    private static final Logger log = Logger.getLogger(NavaidImportVer1100.class);

    public NavaidImportVer1100(String filename, XplaneImportBean importBean) {
        super(filename, importBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String line;
        if (!new File(this.filename).exists()) {
            log.error("Missing file: " + this.filename);
            return false;
        }
        LinkedList<DmeGsRow> gsList = new LinkedList<DmeGsRow>();
        LinkedList<DmeGsRow> dmeList = new LinkedList<DmeGsRow>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            br.readLine();
            br.readLine();
            line = null;
            while ((line = br.readLine()) != null) {
                if (!(line = line.trim()).startsWith("12 ") && !line.startsWith("6 ")) continue;
                DmeGsRow row = new DmeGsRow(line);
                if (line.startsWith("12 ")) {
                    dmeList.add(row);
                    continue;
                }
                gsList.add(row);
            }
        }
        catch (IOException e) {
            try {
                log.error("Couldn't read navaids file " + this.filename, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(br);
                throw throwable;
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            br.readLine();
            br.readLine();
            line = null;
            while ((line = br.readLine()) != null) {
                IlsRow ilsRow;
                NavaidRow r = new NavaidRow(line = line.trim());
                if (r.isValid() && r.isNavaid() && this.importBean.isImportNavaids()) {
                    Navaid n = new Navaid();
                    if (r.isNdb()) {
                        n.setType("NDB");
                    } else if (r.isVor()) {
                        n.setType("VOR");
                    } else if (r.isDme()) {
                        n.setType("DME");
                    }
                    n.setIdent(r.getIdent());
                    n.setName(r.getTail());
                    n.setLat(r.getLat());
                    n.setLon(r.getLon());
                    n.setAlt(r.getElev());
                    n.setFreq(r.getFreq() * 10);
                    n.setMagvar(r.getMagvar());
                    n.setRegion(r.getRegion());
                    boolean addNavaid = true;
                    Iterator<Navaid> iterator = this.importBean.getNavaids().iterator();
                    while (iterator.hasNext()) {
                        Navaid nv = iterator.next();
                        if (!this.sameNavaid(n, nv)) continue;
                        if (nv.isDme() && n.isVor() || nv.isVor() && n.isDme()) {
                            nv.setType("VOR-DME");
                            addNavaid = false;
                            break;
                        }
                        iterator.remove();
                        break;
                    }
                    if (!addNavaid) continue;
                    this.importBean.getNavaids().add(n);
                    continue;
                }
                if (!this.importBean.isImportIls() || !XPlaneImportUtil.isIls(line) || !(ilsRow = new IlsRow(line)).isValid()) continue;
                boolean foundAirport = false;
                String key = VfrUtil.getAirportsKey(ilsRow.getAirportIdent());
                if (this.importBean.getAirports().get(key) != null) {
                    for (int i = 0; i < this.importBean.getAirports().get(key).size(); ++i) {
                        Runway rwy = null;
                        Airport a = this.importBean.getAirports().get(key).get(i);
                        if (a.getIdent().equals(ilsRow.getAirportIdent())) {
                            int q;
                            for (q = 0; q < a.getRunways().size(); ++q) {
                                rwy = a.getRunways().get(q);
                                Object number = String.valueOf(rwy.getNumber());
                                if (rwy.getDesignator() != null) {
                                    number = (String)number + rwy.getDesignator().toString();
                                }
                                String secondaryNumber = String.valueOf(GpsUtil.getSecondaryRunwayNumber(rwy.getNumber()));
                                if (rwy.getSecondaryDesignator() != null) {
                                    secondaryNumber = secondaryNumber + rwy.getSecondaryDesignator().toString();
                                }
                                if (!ilsRow.getAirportNumber().equals(number) && !ilsRow.getAirportNumber().equals(secondaryNumber)) continue;
                                foundAirport = true;
                                break;
                            }
                            if (!foundAirport) {
                                for (q = 0; q < a.getRunways().size(); ++q) {
                                    rwy = a.getRunways().get(q);
                                    if (!(Math.abs(rwy.getHeading() + rwy.getMagvar() - ilsRow.getTrueHeading()) <= 30.0) && !(Math.abs(rwy.getSecondaryHeading() + rwy.getMagvar() - ilsRow.getTrueHeading()) <= 30.0)) continue;
                                    foundAirport = true;
                                    break;
                                }
                            }
                        }
                        if (!foundAirport) continue;
                        Ils ils = this.createIls(ilsRow, rwy);
                        for (DmeGsRow dme : dmeList) {
                            if (!dme.getIdent().equals(ils.getIdent()) || !dme.getParentIdent().equals(a.getIdent())) continue;
                            ils.setDme(true);
                            break;
                        }
                        for (DmeGsRow gs : gsList) {
                            if (!gs.getIdent().equals(ils.getIdent()) || !gs.getParentIdent().equals(a.getIdent())) continue;
                            ils.setPitch(gs.getPitch());
                            ils.setGs(true);
                            break;
                        }
                        Iterator<Ils> iterator = rwy.getIls().iterator();
                        while (iterator.hasNext()) {
                            Ils rwyIls = iterator.next();
                            if (!this.sameIls(ils, rwyIls)) continue;
                            iterator.remove();
                            break;
                        }
                        rwy.getIls().add(ils);
                        a.setIls(true);
                        break;
                    }
                }
                if (foundAirport) continue;
                log.debug("COULDN'T FIND AIRPORT FOR ILS " + line);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("Couldn't read navaids file " + this.filename, e);
        }
        finally {
            IOUtil.closeQuietly(br);
        }
        return false;
    }

    private boolean sameNavaid(Navaid n, Navaid nv) {
        double dist = GpsUtil.getDistance(n.getGpsPlace(), nv.getGpsPlace());
        if (dist <= 0.5) {
            if (Objects.equals(n.getType(), nv.getType())) {
                return true;
            }
            if (nv.getIdent().equals(n.getIdent()) && (nv.isDme() || nv.isVor()) && (n.isDme() || n.isVor())) {
                return true;
            }
        }
        return false;
    }

    private boolean sameIls(Ils first, Ils second) {
        if (Math.abs(first.getLat() - second.getLat()) >= 0.1) {
            return false;
        }
        if (Math.abs(first.getLon() - second.getLon()) >= 0.1) {
            return false;
        }
        return Objects.equals(first.getIdent(), second.getIdent()) || first.getHeading() != null && second.getHeading() != null && NumberUtil.doubleEqualsDouble(first.getHeading() / 10.0, second.getHeading() / 10.0, 0);
    }

    private Ils createIls(IlsRow ilsRow, Runway rwy) {
        Ils ils = new Ils();
        ils.setAlt(ilsRow.getElev());
        ils.setHeading(ilsRow.getTrueHeading());
        ils.setFrequency((double)ilsRow.getFreq().intValue() / 100.0);
        ils.setIdent(ilsRow.getIdent());
        ils.setMagvar(rwy.getMagvar());
        ils.setName(ilsRow.getIlsName());
        ils.setLat(ilsRow.getLat());
        ils.setLon(ilsRow.getLon());
        ils.setPitch(3.0);
        ils.setWidth(3.0);
        return ils;
    }

    private class DmeGsRow {
        private String code;
        private String ident;
        private String name;
        private String parentIdent;
        private String parentNumber;
        private Double lat;
        private Double lon;
        private Double range;
        private Double pitch;
        private Integer elev;
        private Integer freq;

        public DmeGsRow(String row) {
            String[] tokens = row.trim().split("\\s+");
            if (tokens.length >= 9) {
                this.code = tokens[0];
                try {
                    this.lat = Double.valueOf(tokens[1]);
                    this.lon = Double.valueOf(tokens[2]);
                    this.elev = Integer.valueOf(tokens[3]);
                    this.freq = Integer.valueOf(tokens[4]);
                    this.range = Double.valueOf(tokens[5]);
                    if (this.code.equals("6") && tokens[6] != null && tokens[6].length() >= 3) {
                        this.pitch = Double.valueOf(tokens[6].substring(0, 3)) / 100.0;
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Bad number for " + row, e);
                }
                this.ident = tokens[7];
                if (tokens.length >= 10) {
                    this.parentIdent = tokens[8];
                    this.parentNumber = tokens[9];
                    if (tokens.length > 12) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 11; i < tokens.length; ++i) {
                            sb.append(tokens[i]);
                            sb.append(" ");
                        }
                        this.name = sb.toString();
                    }
                } else if (tokens.length >= 11) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 10; i < tokens.length; ++i) {
                        sb.append(tokens[i]);
                        sb.append(" ");
                    }
                    this.name = sb.toString();
                }
            }
        }

        public Double getPitch() {
            return this.pitch;
        }

        public String getIdent() {
            return this.ident;
        }

        public String getParentIdent() {
            return this.parentIdent;
        }
    }

    private class NavaidRow {
        private String code;
        private String ident;
        private String tail;
        private String region;
        private Double lat;
        private Double lon;
        private Double magvar;
        private Double range;
        private Integer elev;
        private Integer freq;

        public NavaidRow(String row) {
            String[] tokens = row.trim().split("\\s+");
            if (tokens.length >= 8) {
                this.code = tokens[0];
                try {
                    this.lat = Double.valueOf(tokens[1]);
                    this.lon = Double.valueOf(tokens[2]);
                    this.elev = Integer.valueOf(tokens[3]);
                    this.freq = Integer.valueOf(tokens[4]);
                    if (!"6".equals(this.code)) {
                        this.range = Double.valueOf(tokens[5]);
                        if (!"----".equals(tokens[6])) {
                            this.magvar = Double.valueOf(tokens[6]);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Bad number for " + row, e);
                }
                this.ident = tokens[7];
                this.region = tokens[9];
                if (tokens.length > 10) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 10; i < tokens.length; ++i) {
                        sb.append(tokens[i]);
                        sb.append(" ");
                    }
                    this.tail = sb.toString();
                }
            }
        }

        public String getRegion() {
            return this.region;
        }

        public String getIdent() {
            return this.ident;
        }

        public Double getLat() {
            return this.lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public Double getMagvar() {
            return this.magvar;
        }

        public Integer getElev() {
            return this.elev;
        }

        public Integer getFreq() {
            return this.freq;
        }

        public String getTail() {
            return this.tail;
        }

        public boolean isNavaid() {
            return this.isNdb() || this.isVor() || this.isDme();
        }

        public boolean isNdb() {
            return "2".equals(this.code);
        }

        public boolean isVor() {
            return "3".equals(this.code);
        }

        public boolean isStandaloneDme() {
            return "13".equals(this.code);
        }

        public boolean isDme() {
            return "12".equals(this.code) || this.isStandaloneDme();
        }

        public boolean isValid() {
            return this.lat != null && this.lon != null && this.ident != null;
        }
    }

    private class IlsRow {
        private String code;
        private String ident;
        private String airportIdent;
        private String airportNumber;
        private String ilsName;
        private Double lat;
        private Double lon;
        private Double trueHeading;
        private Integer elev;
        private Integer freq;
        private Integer range;

        public IlsRow(String row) {
            String[] tokens = row.trim().split("\\s+");
            if (tokens.length >= 8) {
                this.code = tokens[0];
                try {
                    this.lat = Double.valueOf(tokens[1]);
                    this.lon = Double.valueOf(tokens[2]);
                    this.elev = Integer.valueOf(tokens[3]);
                    this.freq = Integer.valueOf(tokens[4]);
                    this.range = Integer.valueOf(tokens[5]);
                    this.trueHeading = Double.valueOf(tokens[6]);
                }
                catch (NumberFormatException e) {
                    log.error("Bad number for " + row, e);
                }
                this.ident = tokens[7];
                this.airportIdent = tokens[8];
                if (tokens[9] != null) {
                    this.airportNumber = tokens[9];
                    if (this.airportNumber.length() >= 2 && this.airportNumber.startsWith("0")) {
                        this.airportNumber = this.airportNumber.substring(1);
                    }
                }
                if (tokens.length > 10) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 10; i < tokens.length; ++i) {
                        sb.append(tokens[i]);
                        sb.append(" ");
                    }
                    this.ilsName = sb.toString();
                }
            }
        }

        public String getIdent() {
            return this.ident;
        }

        public Double getLat() {
            return this.lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public Integer getElev() {
            return this.elev;
        }

        public Integer getFreq() {
            return this.freq;
        }

        public String getAirportIdent() {
            return this.airportIdent;
        }

        public String getAirportNumber() {
            return this.airportNumber;
        }

        public String getIlsName() {
            return this.ilsName;
        }

        public Double getTrueHeading() {
            return this.trueHeading;
        }

        public boolean isValid() {
            return this.lat != null && this.lon != null && this.ident != null && this.trueHeading != null && this.airportIdent != null && this.airportNumber != null;
        }
    }
}

