/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.airport.route;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.facade.xp.AbstractXPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class RouteImportVer640
extends AbstractXPlaneImport
implements XPlaneImport {
    private static final Logger log = Logger.getLogger(RouteImportVer640.class);

    public RouteImportVer640(String filename, XplaneImportBean importBean) {
        super(filename, importBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public boolean execute() {
        boolean bl;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            br.readLine();
            br.readLine();
            String line = null;
            while ((line = br.readLine()) != null) {
                RouteRow r = new RouteRow(line);
                if (!r.isValid()) continue;
                Route rt = new Route();
                rt.setFromLat(r.getFromLat());
                rt.setFromLon(r.getFromLon());
                rt.setToLat(r.getToLat());
                rt.setToLon(r.getToLon());
                rt.setName(r.getName());
                this.importBean.getRoutes().add(rt);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't read file " + this.filename, e);
            IOUtil.closeQuietly(br);
        }
        catch (IOException e2) {
            log.error("Couldn't read file " + this.filename, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return bl;
        return false;
    }

    public class RouteRow {
        private String name;
        private Double fromLat;
        private Double fromLon;
        private Double toLat;
        private Double toLon;

        public RouteRow(String row) {
            String[] tokens = row.trim().split("\\s+");
            if (tokens.length >= 10) {
                try {
                    this.fromLat = Double.valueOf(tokens[1]);
                    this.fromLon = Double.valueOf(tokens[2]);
                    this.toLat = Double.valueOf(tokens[4]);
                    this.toLon = Double.valueOf(tokens[5]);
                }
                catch (NumberFormatException e) {
                    log.error("Bad number for " + row, e);
                }
                if (tokens.length >= 10) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 9; i < tokens.length; ++i) {
                        sb.append(tokens[i]);
                        sb.append(" ");
                    }
                    this.name = sb.toString();
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public Double getFromLat() {
            return this.fromLat;
        }

        public Double getFromLon() {
            return this.fromLon;
        }

        public Double getToLat() {
            return this.toLat;
        }

        public Double getToLon() {
            return this.toLon;
        }

        public boolean isValid() {
            return this.fromLat != null && this.fromLon != null && this.toLat != null && this.toLon != null && this.name != null;
        }
    }
}

