/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.airport.route;

import com.google.common.base.Objects;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.facade.xp.AbstractXPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;

public class RouteImportVer1100
extends AbstractXPlaneImport
implements XPlaneImport {
    private static final Logger log = Logger.getLogger(RouteImportVer1100.class);

    public RouteImportVer1100(String filename, XplaneImportBean importBean) {
        super(filename, importBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public boolean execute() {
        boolean bl;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            br.readLine();
            br.readLine();
            String line = null;
            while ((line = br.readLine()) != null) {
                RouteRow r = new RouteRow(line);
                if (!r.isValid()) continue;
                Route rt = new Route();
                GpsPlace from = this.resolveFix(r.getFromIdent(), r.getFromRegion(), r.getFromType());
                GpsPlace to = this.resolveFix(r.getToIdent(), r.getToRegion(), r.getToType());
                if (from == null || to == null) continue;
                rt.setFromLat(from.getLatVal());
                rt.setFromLon(from.getLonVal());
                rt.setToLat(to.getLatVal());
                rt.setToLon(to.getLonVal());
                rt.setName(r.getName());
                this.importBean.getRoutes().add(rt);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't read file " + this.filename, e);
            IOUtil.closeQuietly(br);
        }
        catch (IOException e2) {
            log.error("Couldn't read file " + this.filename, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return bl;
        return false;
    }

    private GpsPlace resolveFix(String ident, String region, int type) {
        if (type == 11) {
            for (Waypoint w : this.importBean.getWaypoints()) {
                if (!Objects.equal((Object)w.getIdent(), (Object)ident) || StringUtil.isEmpty(w.getRegion())) continue;
                return w.getGpsPlace();
            }
        } else {
            for (Navaid n : this.importBean.getNavaids()) {
                if (!Objects.equal((Object)n.getIdent(), (Object)ident) || !region.equals(n.getRegion()) || !this.correctNavaidType(n, type)) continue;
                return n.getGpsPlace();
            }
        }
        log.debug("Couldn't resolve fix: " + ident + "; " + region + "; " + type);
        return null;
    }

    private boolean correctNavaidType(Navaid n, int type) {
        return type == 2 && n.isNdb() || type == 3 && (n.isVor() || n.isTacan() || n.isDme());
    }

    public class RouteRow {
        private String name;
        private String fromIdent;
        private String fromRegion;
        private String toIdent;
        private String toRegion;
        private int fromType;
        private int toType;

        public RouteRow(String row) {
            String[] tokens = row.trim().split("\\s+");
            if (tokens.length >= 10) {
                this.fromIdent = tokens[0];
                this.fromRegion = tokens[1];
                this.toIdent = tokens[3];
                this.toRegion = tokens[4];
                try {
                    this.fromType = Integer.valueOf(tokens[2]);
                    this.toType = Integer.valueOf(tokens[5]);
                }
                catch (NumberFormatException e) {
                    log.error("Bad number for " + row, e);
                }
                if (tokens.length >= 11) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 10; i < tokens.length; ++i) {
                        sb.append(tokens[i]);
                        sb.append(" ");
                    }
                    this.name = sb.toString();
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFromIdent() {
            return this.fromIdent;
        }

        public String getFromRegion() {
            return this.fromRegion;
        }

        public String getToIdent() {
            return this.toIdent;
        }

        public String getToRegion() {
            return this.toRegion;
        }

        public int getFromType() {
            return this.fromType;
        }

        public int getToType() {
            return this.toType;
        }

        public boolean isValid() {
            return this.fromIdent != null && this.fromRegion != null && this.toIdent != null && this.toRegion != null && this.name != null;
        }
    }
}

