/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp.airport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.type.AirportFreqType;
import main.java.guru.vfrflight.core.sql.type.AirportType;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.core.sql.type.Surface;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.facade.xp.AbstractXPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImportUtil;
import main.java.guru.vfrflight.sql.facade.xp.row.AirportRow;
import main.java.guru.vfrflight.sql.facade.xp.row.CommRow;
import main.java.guru.vfrflight.sql.facade.xp.row.HelipadRow;
import main.java.guru.vfrflight.sql.facade.xp.row.LandRunwayRow;
import main.java.guru.vfrflight.sql.facade.xp.row.RunwayRow;
import main.java.guru.vfrflight.sql.facade.xp.row.StartRow;
import main.java.guru.vfrflight.sql.facade.xp.row.WaterRunwayRow;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.geo.DeclinationCalculator;
import main.java.guru.vfrflight.util.geo.RealWorldCalculator;
import org.apache.log4j.Logger;
import org.hsqldb.lib.StringUtil;

public class AirportImportVer1050_1100
extends AbstractXPlaneImport
implements XPlaneImport {
    private static final Logger log = Logger.getLogger(AirportImportVer1050_1100.class);
    private static final DeclinationCalculator declCalc = new RealWorldCalculator();
    private static final Map<String, AirportFreqType> COMM_TYPE_MAPPINGS;
    private static final Map<Integer, Surface> SURFACE_TYPE_MAPPINGS;

    public AirportImportVer1050_1100(String filename, XplaneImportBean importBean) {
        super(filename, importBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public boolean execute() {
        boolean bl;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            br.readLine();
            br.readLine();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line != null && !XPlaneImportUtil.isAirport(line)) {
                    while ((line = br.readLine()) != null && !XPlaneImportUtil.isAirport(line)) {
                    }
                }
                if (line == null) continue;
                AirportRow airportRow = new AirportRow(line);
                Airport a = new Airport();
                a.setElev(airportRow.getElev());
                a.setIdent(airportRow.getIdent());
                a.setName(airportRow.getName());
                if (XPlaneImportUtil.isHelipadAirport(line)) {
                    a.setType(AirportType.HELI_CIVIL);
                }
                do {
                    if (StringUtil.isEmpty(line = br.readLine())) continue;
                    if (XPlaneImportUtil.isRunway(line)) {
                        this.importRunway(line, a);
                        continue;
                    }
                    if (XPlaneImportUtil.isHelipad(line)) {
                        HelipadRow row = new HelipadRow(line);
                        if (!row.isValid()) continue;
                        if (this.importBean.isImportStarts()) {
                            AirportStart start = new AirportStart();
                            start.setLat(row.getLat());
                            start.setLon(row.getLon());
                            if (row.getTrueHeading() != null) {
                                start.setHeading(GpsUtil.normalizeCourse(row.getTrueHeading()));
                            }
                            start.setName(row.getDesignator());
                            a.getStarts().add(start);
                            a.setHeli(true);
                        }
                        if (!a.isHeli()) continue;
                        a.setLat(row.getLat());
                        a.setLon(row.getLon());
                        continue;
                    }
                    if (this.importBean.isImportFrequencies() && XPlaneImportUtil.isComm(line)) {
                        this.importComm(line, a);
                        continue;
                    }
                    if (!this.importBean.isImportStarts() || !XPlaneImportUtil.isStart(line)) continue;
                    this.importStarts(line, a);
                } while (!StringUtil.isEmpty(line));
                if (a.getRunways().size() == 1) {
                    a.setMainLength((int)Math.round(a.getRunways().get(0).getLength()));
                    a.setMainRwy((int)Math.round(a.getRunways().get(0).getHeading() + a.getRunways().get(0).getMagvar()) % 360);
                    a.setLat(a.getRunways().get(0).getLat());
                    a.setLon(a.getRunways().get(0).getLon());
                    a.setMagvar(a.getRunways().get(0).getMagvar());
                } else if (a.getRunways().size() > 1) {
                    int len = 0;
                    int rwy = 0;
                    double lat = 0.0;
                    double lon = 0.0;
                    Double magvar = null;
                    for (Runway r : a.getRunways()) {
                        if (!(r.getLength() >= (double)len)) continue;
                        magvar = r.getMagvar();
                        len = (int)Math.round(r.getLength());
                        rwy = (int)Math.round(r.getHeading() + magvar) % 360;
                        lat = r.getLat();
                        lon = r.getLon();
                    }
                    a.setMainLength(len);
                    a.setMainRwy(rwy);
                    a.setLat(lat);
                    a.setLon(lon);
                    a.setMagvar(magvar);
                }
                if (!this.importBean.isImportRunways()) {
                    a.getRunways().clear();
                }
                if (a.getLat() != null && a.getLon() != null) {
                    String key = VfrUtil.getAirportsKey(a.getIdent());
                    boolean airportExists = false;
                    if (this.importBean.getAirports().get(key) != null) {
                        for (Airport ar : this.importBean.getAirports().get(key)) {
                            double dist;
                            if (!ar.getIdent().equals(a.getIdent()) || !((dist = GpsUtil.getDistance(ar.getGpsPlace(), a.getGpsPlace())) <= 1.0)) continue;
                            airportExists = true;
                            log.debug("Airport " + a.getIdent() + " has been already imported");
                            break;
                        }
                    }
                    if (airportExists) continue;
                    List<Airport> airports = this.importBean.getAirports().get(key);
                    if (airports == null) {
                        airports = new ArrayList<Airport>();
                    }
                    airports.add(a);
                    this.importBean.getAirports().put(key, airports);
                    continue;
                }
                log.error("Error adding airport " + a.getIdent() + " => lat & lon are null!   " + airportRow);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't read file " + this.filename, e);
            IOUtil.closeQuietly(br);
        }
        catch (IOException e2) {
            log.error("Couldn't read file " + this.filename, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return bl;
        return false;
    }

    private void importStarts(String line, Airport a) {
        StartRow startRow = new StartRow(line);
        if (startRow.isValid()) {
            AirportStart start = new AirportStart();
            start.setLat(startRow.getLat());
            start.setLon(startRow.getLon());
            if (startRow.getHeading() != null) {
                start.setHeading(GpsUtil.normalizeCourse(startRow.getHeading()));
            }
            start.setName(startRow.getName());
            a.getStarts().add(start);
        }
    }

    private void importComm(String line, Airport a) {
        CommRow commRow = new CommRow(line);
        if (commRow.isValid()) {
            AirportFreq freq = new AirportFreq();
            freq.setFrequency((double)commRow.getFreq().intValue() / 100.0);
            freq.setName(commRow.getName());
            freq.setType(COMM_TYPE_MAPPINGS.get(commRow.getCode()));
            a.getFrequencies().add(freq);
        }
    }

    private void importRunway(String line, Airport a) {
        RunwayRow runwayRow;
        RunwayRow runwayRow2 = runwayRow = XPlaneImportUtil.isLandRunway(line) ? new LandRunwayRow(line) : new WaterRunwayRow(line);
        if (runwayRow.isValid()) {
            Runway r = new Runway();
            r.setElev(a.getElev());
            GpsPlace runwayStart = new GpsPlace(runwayRow.getPriLat(), runwayRow.getPriLon());
            GpsPlace runwayEnd = new GpsPlace(runwayRow.getSecLat(), runwayRow.getSecLon());
            LineSegment segment = GpsUtil.getLineSegment(runwayStart, runwayEnd);
            r.setLength(UnitUtil.recalculateDistance(segment.getDistance(), "nm", "m", false));
            r.setWidth(runwayRow.getWidth());
            double lat = (runwayRow.getPriLat() + runwayRow.getSecLat()) / 2.0;
            double lon = (runwayRow.getPriLon() + runwayRow.getSecLon()) / 2.0;
            r.setLat(lat);
            r.setLon(lon);
            r.setMagvar(declCalc.getMagneticDeclination(new GpsPlace(lat, lon)));
            r.setHeading(GpsUtil.normalizeCourse(segment.getCourse() - r.getMagvar()));
            if (runwayRow.getSurfaceType() != null && SURFACE_TYPE_MAPPINGS.get(runwayRow.getSurfaceType()) != null) {
                r.setSurface(SURFACE_TYPE_MAPPINGS.get(runwayRow.getSurfaceType()));
            }
            if (runwayRow.getPriNumber() != null && runwayRow.getPriNumber().matches("^([0-9]{1,2})$")) {
                r.setNumber(Integer.valueOf(runwayRow.getPriNumber()));
            } else if (runwayRow.getPriNumber() != null && runwayRow.getPriNumber().matches("^([0-9]{1,2}[A-Z]{1})$")) {
                r.setNumber(Integer.valueOf(runwayRow.getPriNumber().substring(0, runwayRow.getPriNumber().length() - 1)));
                try {
                    r.setDesignator(RunwayDesignator.valueOf(runwayRow.getPriNumber().substring(runwayRow.getPriNumber().length() - 1)));
                }
                catch (IllegalArgumentException e) {
                    log.error("Error parsing runway number " + runwayRow.getPriNumber(), e);
                }
            } else if (runwayRow.getPriNumber() != null) {
                log.error("Invalid runway number: " + runwayRow.getPriNumber());
            }
            if (runwayRow.getSecNumber() != null && runwayRow.getSecNumber().matches("^([0-9]{1,2}[A-Z]{1})$")) {
                try {
                    r.setSecondaryDesignator(RunwayDesignator.valueOf(runwayRow.getSecNumber().substring(runwayRow.getSecNumber().length() - 1)));
                }
                catch (IllegalArgumentException e) {
                    log.error("Error parsing runway number " + runwayRow.getSecNumber(), e);
                }
            }
            a.getRunways().add(r);
        }
    }

    static {
        HashMap<Object, Enum> mp = new HashMap<Object, Enum>();
        mp.put("50", AirportFreqType.ATIS);
        mp.put("51", AirportFreqType.UNICOM);
        mp.put("52", AirportFreqType.DELIVERY);
        mp.put("53", AirportFreqType.GROUND);
        mp.put("54", AirportFreqType.TOWER);
        mp.put("55", AirportFreqType.APPROACH);
        mp.put("56", AirportFreqType.DEPARTURE);
        COMM_TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
        mp = new HashMap();
        mp.put(1, Surface.ASPHALT);
        mp.put(2, Surface.CONCRETE);
        mp.put(3, Surface.GRASS);
        mp.put(4, Surface.DIRT);
        mp.put(5, Surface.GRAVEL);
        mp.put(12, Surface.SOIL);
        mp.put(13, Surface.WATER);
        mp.put(14, Surface.SNOW);
        mp.put(15, Surface.UNKNOWN);
        SURFACE_TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

