/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp;

import java.util.List;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.ImportFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImportFactory;
import main.java.guru.vfrflight.sql.service.AirportService;
import main.java.guru.vfrflight.sql.service.IfrRouteService;
import main.java.guru.vfrflight.sql.service.NavaidService;
import main.java.guru.vfrflight.util.HibernateUtil;
import main.java.guru.vfrflight.util.XplaneImportUtil;
import org.hibernate.Session;

public class XplaneImportFacade
extends ImportFacade {
    private final AirportService airportService;
    private final NavaidService navaidService;
    private final IfrRouteService ifrRouteService;

    public XplaneImportFacade(DataSource dataSource) {
        super(dataSource);
        this.airportService = new AirportService(dataSource);
        this.navaidService = new NavaidService(dataSource);
        this.ifrRouteService = new IfrRouteService(dataSource);
    }

    public int insertNavaids(XplaneImportBean importBean) {
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Navaid n : importBean.getNavaids()) {
            this.navaidService.insertNavaid(n, session);
            if (i % 100 == 0) {
                HibernateUtil.checkAvailableMemory();
            }
            ++i;
        }
        session.flush();
        session.close();
        return i;
    }

    public boolean importNavaids(String navaidsFile, XplaneImportBean importBean) {
        XPlaneImport xplaneImport;
        String fileVersion = XplaneImportUtil.getFileVersion(navaidsFile);
        if (fileVersion != null && (xplaneImport = XPlaneImportFactory.getNavaidImport(fileVersion, navaidsFile, importBean)) != null) {
            return xplaneImport.execute();
        }
        return false;
    }

    public boolean importRoutes(String file, XplaneImportBean importBean) {
        XPlaneImport xplaneImport;
        String fileVersion = XplaneImportUtil.getFileVersion(file);
        if (fileVersion != null && (xplaneImport = XPlaneImportFactory.getRouteImport(fileVersion, file, importBean)) != null) {
            return xplaneImport.execute();
        }
        return false;
    }

    public int insertRoutes(XplaneImportBean importBean) {
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Route r : importBean.getRoutes()) {
            this.ifrRouteService.insertRoute(r, session);
            if (i % 100 == 0) {
                HibernateUtil.checkAvailableMemory();
            }
            ++i;
        }
        session.flush();
        session.close();
        return i;
    }

    public boolean importAirports(String file, XplaneImportBean importBean) {
        XPlaneImport xplaneImport;
        String fileVersion = XplaneImportUtil.getFileVersion(file);
        if (fileVersion != null && (xplaneImport = XPlaneImportFactory.getAirportImport(fileVersion, file, importBean)) != null) {
            return xplaneImport.execute();
        }
        return false;
    }

    public int insertAirports(XplaneImportBean importBean) {
        MapFacade mapFacade = new MapFacade(this.dataSource);
        List<Airport> airports = importBean.getAirportsAsList();
        List<Elevation> elevations = mapFacade.findElevations(0);
        this.setMountanousAirports(airports, elevations);
        this.setHardenedAirports(airports);
        if (importBean.isImportNavaids()) {
            this.setNdbVorAirports(airports, importBean.getVors(), importBean.getNdbs());
        }
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Airport a : airports) {
            this.airportService.insertAirport(a, session);
            if (i % 100 == 0) {
                HibernateUtil.checkAvailableMemory();
            }
            ++i;
        }
        session.flush();
        session.close();
        return i;
    }

    public boolean importWaypoints(String file, XplaneImportBean importBean) {
        XPlaneImport xplaneImport;
        String fileVersion = XplaneImportUtil.getFileVersion(file);
        if (fileVersion != null && (xplaneImport = XPlaneImportFactory.getWaypointImport(fileVersion, file, importBean)) != null) {
            return xplaneImport.execute();
        }
        return false;
    }

    public int insertWaypoints(XplaneImportBean importBean) {
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Waypoint w : importBean.getWaypoints()) {
            this.ifrRouteService.insertWaypoint(w, session);
            if (i % 100 == 0) {
                HibernateUtil.checkAvailableMemory();
            }
            ++i;
        }
        session.flush();
        session.close();
        return i;
    }
}

