/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.xp;

import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.sql.facade.xp.XPlaneImport;
import main.java.guru.vfrflight.sql.facade.xp.airport.AirportImportVer1050_1100;
import main.java.guru.vfrflight.sql.facade.xp.airport.route.RouteImportVer1100;
import main.java.guru.vfrflight.sql.facade.xp.airport.route.RouteImportVer640;
import main.java.guru.vfrflight.sql.facade.xp.navaid.NavaidImportVer1100;
import main.java.guru.vfrflight.sql.facade.xp.navaid.NavaidImportVer810;
import main.java.guru.vfrflight.sql.facade.xp.waypoint.WaypointImportVer600_1100;
import org.apache.log4j.Logger;

public class XPlaneImportFactory {
    private static final Logger log = Logger.getLogger(XPlaneImportFactory.class);

    public static XPlaneImport getAirportImport(String versionLine, String filename, XplaneImportBean importBean) {
        if (versionLine.startsWith("10") || versionLine.startsWith("110")) {
            return new AirportImportVer1050_1100(filename, importBean);
        }
        log.error("Unsupported file version " + versionLine + " (" + filename + ")");
        return null;
    }

    public static XPlaneImport getNavaidImport(String versionLine, String filename, XplaneImportBean importBean) {
        if (versionLine.startsWith("810")) {
            return new NavaidImportVer810(filename, importBean);
        }
        if (versionLine.startsWith("110")) {
            return new NavaidImportVer1100(filename, importBean);
        }
        log.error("Unsupported file version " + versionLine + " (" + filename + ")");
        return null;
    }

    public static XPlaneImport getRouteImport(String versionLine, String filename, XplaneImportBean importBean) {
        if (versionLine.startsWith("640")) {
            return new RouteImportVer640(filename, importBean);
        }
        if (versionLine.startsWith("110")) {
            return new RouteImportVer1100(filename, importBean);
        }
        log.error("Unsupported file version " + versionLine + " (" + filename + ")");
        return null;
    }

    public static XPlaneImport getWaypointImport(String versionLine, String filename, XplaneImportBean importBean) {
        if (versionLine.startsWith("600") || versionLine.startsWith("110")) {
            return new WaypointImportVer600_1100(filename, importBean);
        }
        log.error("Unsupported file version " + versionLine + " (" + filename + ")");
        return null;
    }
}

