/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.sql.facade.callable.SetNdbVorAirportsCallable;
import org.apache.log4j.Logger;

public class SetNdbVorAirportsRunner {
    private static final Logger log = Logger.getLogger(SetNdbVorAirportsRunner.class);
    private List<Airport> airports;
    private List<GpsPlace> vors;
    private List<GpsPlace> ndbs;

    public SetNdbVorAirportsRunner(List<Airport> airports, List<GpsPlace> vors, List<GpsPlace> ndbs) {
        this.airports = airports;
        this.vors = vors;
        this.ndbs = ndbs;
    }

    public List<Airport> process() {
        String key;
        log.debug("START: " + this.airports.size() + "; " + this.vors.size() + "; " + this.ndbs.size());
        HashMap<String, DataBean> buckets = new HashMap<String, DataBean>();
        for (Airport a : this.airports) {
            key = this.getBucketsKey(a.getLon());
            if (!buckets.containsKey(key)) {
                buckets.put(key, new DataBean());
            }
            ((DataBean)buckets.get(key)).getAirports().add(a);
        }
        for (GpsPlace n : this.vors) {
            key = this.getBucketsKey(n.getLon().getValue());
            if (!buckets.containsKey(key)) continue;
            ((DataBean)buckets.get(key)).getVors().add(n);
        }
        for (GpsPlace n : this.ndbs) {
            key = this.getBucketsKey(n.getLon().getValue());
            if (!buckets.containsKey(key)) continue;
            ((DataBean)buckets.get(key)).getNdbs().add(n);
        }
        int tasksNum = buckets.keySet().size();
        log.debug(tasksNum + " buckets created.");
        ExecutorService pool = Executors.newFixedThreadPool(Constants.NTHREDS);
        ArrayList<Future<List<Airport>>> futureTasks = new ArrayList<Future<List<Airport>>>(tasksNum);
        for (Map.Entry pair : buckets.entrySet()) {
            futureTasks.add(pool.submit(new SetNdbVorAirportsCallable(((DataBean)pair.getValue()).getAirports(), ((DataBean)pair.getValue()).getVors(), ((DataBean)pair.getValue()).getNdbs())));
        }
        ArrayList<Airport> resultList = new ArrayList<Airport>(this.airports.size());
        for (Future future : futureTasks) {
            try {
                resultList.addAll((Collection)future.get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
        }
        pool.shutdown();
        log.debug("FINISH: " + resultList.size() + " vs. " + this.airports.size());
        return resultList;
    }

    private String getBucketsKey(double lon) {
        return String.valueOf((int)Math.round((lon + 180.0) / 10.0));
    }

    private class DataBean {
        private List<Airport> airports;
        private List<GpsPlace> vors;
        private List<GpsPlace> ndbs;

        private DataBean() {
        }

        public List<Airport> getAirports() {
            if (this.airports == null) {
                this.airports = new LinkedList<Airport>();
            }
            return this.airports;
        }

        public List<GpsPlace> getVors() {
            if (this.vors == null) {
                this.vors = new LinkedList<GpsPlace>();
            }
            return this.vors;
        }

        public List<GpsPlace> getNdbs() {
            if (this.ndbs == null) {
                this.ndbs = new LinkedList<GpsPlace>();
            }
            return this.ndbs;
        }
    }
}

