/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.sql.facade.callable.SetMountainousAirportsCallable;
import org.apache.log4j.Logger;

public class SetMountainousAirportsRunner {
    private static final Logger log = Logger.getLogger(SetMountainousAirportsRunner.class);
    private List<Airport> airports;
    private List<Elevation> elevations;

    public SetMountainousAirportsRunner(List<Airport> airports, List<Elevation> elevations) {
        this.airports = airports;
        this.elevations = elevations;
    }

    public List<Airport> process() {
        String key;
        log.debug("START: " + this.airports.size() + "; " + this.elevations.size());
        HashMap<String, DataBean> buckets = new HashMap<String, DataBean>();
        for (Airport a : this.airports) {
            key = this.getBucketsKey(a.getLon());
            if (!buckets.containsKey(key)) {
                buckets.put(key, new DataBean());
            }
            ((DataBean)buckets.get(key)).getAirports().add(a);
        }
        for (Elevation e : this.elevations) {
            key = this.getBucketsKey(e.getLon());
            if (!buckets.containsKey(key)) continue;
            ((DataBean)buckets.get(key)).getElevations().add(e);
        }
        int tasksNum = buckets.keySet().size();
        log.debug(tasksNum + " buckets created.");
        ExecutorService pool = Executors.newFixedThreadPool(Constants.NTHREDS);
        ArrayList<Future<List<Airport>>> futureTasks = new ArrayList<Future<List<Airport>>>(tasksNum);
        for (Map.Entry pair : buckets.entrySet()) {
            futureTasks.add(pool.submit(new SetMountainousAirportsCallable(((DataBean)pair.getValue()).getAirports(), ((DataBean)pair.getValue()).getElevations())));
        }
        ArrayList<Airport> resultList = new ArrayList<Airport>(this.airports.size());
        for (Future future : futureTasks) {
            try {
                resultList.addAll((Collection)future.get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
        }
        pool.shutdown();
        log.debug("FINISH: " + resultList.size() + " vs. " + this.airports.size());
        return resultList;
    }

    private String getBucketsKey(double lon) {
        return String.valueOf((int)Math.round((lon + 180.0) / 10.0));
    }

    private class DataBean {
        private List<Airport> airports;
        private List<Elevation> elevations;

        private DataBean() {
        }

        public List<Airport> getAirports() {
            if (this.airports == null) {
                this.airports = new LinkedList<Airport>();
            }
            return this.airports;
        }

        public List<Elevation> getElevations() {
            if (this.elevations == null) {
                this.elevations = new LinkedList<Elevation>();
            }
            return this.elevations;
        }
    }
}

